/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerClusterTasks {
    private static TraceComponent tc = Tr.register(ServerClusterTasks.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;
    private static String CLUSTER_CREATE_COMMAND = "createCluster";
    private static String CLUSTER_CONFIG_STEP = "clusterConfig";
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String PREFER_LOCAL_PARAM = "preferLocal";
    private static String REP_DOMAIN_STEP = "replicationDomain";
    private static String CREATE_DOMAIN_PARM = "createDomain";
    private static String CONVERT_SERVER_STEP = "convertServer";
    private static String SERVER_NODE_PARAM = "serverNode";
    private static String SERVER_NAME_PARAM = "serverName";
    private static String MEMBER_WEIGHT_PARAM = "memberWeight";
    private static String NODE_GROUP_PARAM = "nodeGroup";
    private static String REP_ENTRY_PARAM = "replicatorEntry";
    private static String MEMBER_CREATE_COMMAND = "createClusterMember";
    private static String MEMBER_DELETE_COMMAND = "deleteClusterMember";
    private static String MEMBER_CONFIG_STEP = "memberConfig";
    private static String MEMBER_NODE_PARAM = "memberNode";
    private static String MEMBER_NAME_PARAM = "memberName";
    private static String MEMBER_UUID_PARAM = "memberUUID";
    private static String GEN_UNIQUE_PORTS_PARAM = "genUniquePorts";
    private static String REPLICATOR_ENTRY_PARAM = "replicatorEntry";
    private static String FIRST_MEMBER_STEP = "firstMember";
    private static String TEMPLATE_NAME_PARAM = "templateName";
    private static String TEMPLATE_SERVER_NODE_PARAM = "templateServerNode";
    private static String TEMPLATE_SERVER_NAME_PARAM = "templateServerName";

    public ServerClusterTasks(ConfigService configService) {
        this.configService = configService;
    }

    public ObjectName createClusterMember(Session session, ObjectName objectName, AttributeList attributeList, ObjectName objectName2, ObjectName objectName3) throws ConfigServiceException, ConnectorException {
        Object object;
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", new Object[]{session, objectName, objectName2, attributeList, objectName3});
        }
        ObjectName objectName4 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
            if (!(string2 instanceof String)) {
                throw new InvalidAttributeValException("memberName");
            }
            string = string2;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RequiredAttributeNotFoundException("memberName");
        }
        try {
            Object object2 = ConfigServiceHelper.getAttributeValue(attributeList, "uniqueId");
            if (!(object2 instanceof String)) {
                throw new InvalidAttributeValException("uniqueId");
            }
            string2 = (String)object2;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            string2 = String.valueOf(System.currentTimeMillis());
            ConfigServiceHelper.setAttributeValue(attributeList, "uniqueId", string2);
        }
        boolean bl = true;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "adjustPort");
            if (object != null && object instanceof Boolean && !((Boolean)object).booleanValue()) {
                bl = (Boolean)object;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        object = ConfigServiceHelper.getDisplayName(objectName);
        String string3 = ConfigServiceHelper.getDisplayName(objectName2);
        String string4 = null;
        if (objectName3 != null) {
            string4 = ConfigServiceHelper.getDisplayName(objectName3);
        }
        Properties properties = null;
        String string5 = null;
        String string6 = null;
        if (objectName3 != null) {
            properties = ConfigServiceHelper.getObjectLocation(objectName3);
            string6 = properties.getProperty("node");
            string5 = properties.getProperty("server");
        }
        Integer n = null;
        try {
            Object object3 = ConfigServiceHelper.getAttributeValue(attributeList, "weight");
            if (!(object3 instanceof Integer)) {
                throw new InvalidAttributeValException("weight");
            }
            n = (Integer)object3;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        objectName4 = this.createClusterMember((String)object, string3, string, bl, string2, string6, string5, string4, session, n);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", objectName4);
        }
        return objectName4;
    }

    public ObjectName convertToCluster(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", new Object[]{session, objectName, string});
        }
        String string2 = (String)this.configService.getAttribute(session, objectName, "clusterName");
        String string3 = ConfigServiceHelper.getDisplayName(objectName);
        if (string2 != null) {
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0029W", new Object[]{string3, string2}, null);
            throw new ConfigServiceException(string4);
        }
        ObjectName objectName2 = this.configService.getRelationship(session, objectName, "parent")[0];
        String string5 = ConfigServiceHelper.getDisplayName(objectName2);
        ObjectName objectName3 = this.configService.getRelationship(session, objectName2, "parent")[0];
        ObjectName objectName4 = this.createCluster(string, string5, string3, session);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", objectName4);
        }
        return objectName4;
    }

    private ObjectName createCluster(String string, String string2, String string3, Session session) throws ConfigServiceException {
        try {
            Object object;
            CommandMgr commandMgr = null;
            try {
                commandMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception.getMessage());
            }
            TaskCommand taskCommand = (TaskCommand)commandMgr.createCommand(CLUSTER_CREATE_COMMAND);
            taskCommand.setConfigSession(session);
            CommandStep commandStep = taskCommand.getCommandStep(CLUSTER_CONFIG_STEP);
            commandStep.setParameter(CLUSTER_NAME_PARAM, string);
            if (string3 != null && string2 != null) {
                object = taskCommand.getCommandStep(CONVERT_SERVER_STEP);
                object.setParameter(SERVER_NODE_PARAM, string2);
                object.setParameter(SERVER_NAME_PARAM, string3);
            }
            taskCommand.execute();
            object = taskCommand.getCommandResult();
            if (!object.isSuccessful()) {
                Object object2 = object.getResult();
                if (object2 != null && object2 instanceof String) {
                    throw new ConfigServiceException(object.getException(), (String)object2);
                }
                throw new ConfigServiceException(object.getException());
            }
            return (ObjectName)object.getResult();
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception, exception.getMessage());
        }
    }

    private ObjectName createClusterMember(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, Session session, Integer n) throws ConfigServiceException {
        try {
            Object object;
            CommandMgr commandMgr = null;
            try {
                commandMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception.getMessage());
            }
            TaskCommand taskCommand = (TaskCommand)commandMgr.createCommand(MEMBER_CREATE_COMMAND);
            taskCommand.setConfigSession(session);
            taskCommand.setParameter(CLUSTER_NAME_PARAM, string);
            CommandStep commandStep = taskCommand.getCommandStep(MEMBER_CONFIG_STEP);
            commandStep.setParameter(MEMBER_NODE_PARAM, string2);
            commandStep.setParameter(MEMBER_NAME_PARAM, string3);
            commandStep.setParameter(MEMBER_UUID_PARAM, string4);
            commandStep.setParameter("genUniquePorts", new Boolean(bl));
            commandStep.setParameter(MEMBER_WEIGHT_PARAM, n);
            String string8 = "ServerCluster=" + string;
            ObjectName[] objectNameArray = this.configService.resolve(session, string8);
            ObjectName objectName = null;
            if (objectNameArray.length > 0) {
                objectName = objectNameArray[0];
            }
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(session, objectName, objectName2, null);
            if (string5 != null) {
                if (objectNameArray2.length == 0) {
                    object = taskCommand.getCommandStep(FIRST_MEMBER_STEP);
                    object.setParameter(TEMPLATE_SERVER_NODE_PARAM, string5);
                    object.setParameter(TEMPLATE_SERVER_NAME_PARAM, string6);
                } else {
                    Tr.warning(tc, "Template specified is ignored, since it is not a first cluster member");
                }
            } else if (string7 != null) {
                if (objectNameArray2.length == 0) {
                    object = taskCommand.getCommandStep(FIRST_MEMBER_STEP);
                    object.setParameter(TEMPLATE_NAME_PARAM, string7);
                } else {
                    Tr.warning(tc, "Template specified is ignored, since it is not a first cluster member");
                }
            }
            taskCommand.execute();
            object = taskCommand.getCommandResult();
            if (!object.isSuccessful()) {
                Object object2 = object.getResult();
                if (object2 != null && object2 instanceof String) {
                    throw new ConfigServiceException(object.getException(), (String)object2);
                }
                throw new ConfigServiceException(object.getException());
            }
            return (ObjectName)object.getResult();
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception, exception.getMessage());
        }
    }

    private void deleteClusterMember(String string, String string2, String string3, Session session) throws ConfigServiceException {
        try {
            CommandMgr commandMgr = null;
            try {
                commandMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception.getMessage());
            }
            TaskCommand taskCommand = (TaskCommand)commandMgr.createCommand(MEMBER_DELETE_COMMAND);
            taskCommand.setConfigSession(session);
            taskCommand.setParameter(CLUSTER_NAME_PARAM, string);
            taskCommand.setParameter(MEMBER_NODE_PARAM, string2);
            taskCommand.setParameter(MEMBER_NAME_PARAM, string3);
            taskCommand.execute();
            CommandResult commandResult = taskCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new ConfigServiceException(commandResult.getException(), (String)object);
                }
                throw new ConfigServiceException(commandResult.getException());
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception, exception.getMessage());
        }
    }

    private CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        CommandMgr commandMgr = null;
        commandMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getClientCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        return commandMgr;
    }
}

