/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.filetransfer.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.TempFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class FileUploadInputStream
extends RepositoryInputStream
implements Serializable {
    private static final long serialVersionUID = 6521346973672853614L;
    private static TraceComponent tc = Tr.register(FileUploadInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    boolean delete = true;

    public FileUploadInputStream() {
    }

    public FileUploadInputStream(String string) {
        this();
        this.setSrcPath(string);
    }

    public InputStream getStream() throws FileNotFoundException {
        if (this.remoteStream == null) {
            this.remoteStream = this.delete ? new TempFileInputStream(this.tempfile) : new FileInputStream(this.tempfile);
        }
        return this.remoteStream;
    }

    public void connect() throws IOException {
        if (this.remoteStream == null) {
            String string = null;
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            Properties properties = configRepository.getConfig();
            string = properties.getProperty("was.repository.temp");
            if (string == null) {
                throw new IOException("Repository Temporary Directory can not be determined.");
            }
            String string2 = string + File.separator + this.srcPath;
            string2 = File.separator.equals("/") ? string2.replace('\\', '/') : string2.replace('/', '\\');
            this.tempfile = new File(string2);
        }
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setDelete(boolean bl) {
        this.delete = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileUploadInputStream.writeObject", "239", this);
            Tr.service(tc, "ADFS0119", iOException);
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, AdminException {
        try {
            objectInputStream.defaultReadObject();
            this.connect();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileUploadInputStream.readObject", "252", this);
            Tr.service(tc, "ADFS0119", iOException);
            throw iOException;
        }
    }
}

