/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.taskconfig.validation;

import com.ibm.websphere.models.config.taskconfig.EmailNotifications;
import com.ibm.websphere.models.config.taskconfig.validation.NotificationValidationConstants;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import java.util.Iterator;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class NotificationValidator
extends WebSpherePlatformValidator
implements NotificationValidationConstants {
    public String getBundleId() {
        return "com.ibm.websphere.models.config.taskconfig.validation.notificationvalidationNLS";
    }

    public String getTraceName() {
        return "NotificationValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof EmailNotifications) {
            this.validateLocal((EmailNotifications)object);
            this.validateAcross((EmailNotifications)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(EmailNotifications emailNotifications) {
    }

    public void validateLocal(EmailNotifications emailNotifications) {
        String string;
        int n = emailNotifications.getPort();
        if (n < 1 || n > 64767) {
            this.addError("ERROR_PORT_NUMBER_OUTOFRANGE", new String[]{this.getCurrentFileName()}, emailNotifications);
        }
        if ((string = emailNotifications.getTransportHostName()) == null) {
            this.addError("ERROR_TRANSPORT_HOSTNAME_REQUIRED", new String[]{this.getCurrentFileName()}, emailNotifications);
        }
        EList eList = emailNotifications.getEmailAddresses();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            try {
                InternetAddress internetAddress = new InternetAddress((String)iterator.next());
            }
            catch (AddressException addressException) {
                this.addError("ERROR_ADDRESS_FORMAT_INVALID", new String[]{this.getCurrentFileName()}, emailNotifications);
            }
        }
    }
}

