/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.WsnOptimizedNaming.WsnBindingCategory;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnBinding;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NamingContext;

public class DumpNameSpace {
    public static final int SHORT = 1;
    public static final int LONG = 2;
    public static final int NORMAL_EXIT_STATUS = 0;
    public static final int BAD_EXIT_STATUS_NO_STARTING_CONTEXT = 1;
    public static final int BAD_EXIT_STATUS_WITH_ERROR = 2;
    public static final int BAD_EXIT_STATUS_WITH_BAD_OPTION = 3;
    private static final int NS_TYPE_GENERIC = -1;
    private static final int NS_TYPE_WS40 = 0;
    private static final int NS_TYPE_WS50 = 1;
    private static final int MODE_NOT_SET = 0;
    private static final int MODE_WS40 = 1;
    private static final int MODE_WS50 = 2;
    private static final String PARAM_PREFIX = "-";
    private static final String THIS_CONTEXT = "";
    private static final String BLANK_LINE = " ";
    private static final String INDENT_AMOUNT = "   ";
    private static final String COMPONENT_SEPARATOR = "/";
    public static final String BUNDLE_NAME = "com.ibm.websphere.naming.DumpNameSpaceMessages";
    private static ResourceBundle _msgs = null;
    private PrintStream _out;
    private int _reportFmt = 1;
    private String _topLabel;
    private long _seq;
    private String _seqNum;
    private Hashtable _visitedCxtNames;
    private Hashtable _visitedCxtUuids;
    private static int _mode = 0;
    private static boolean rootOpt = false;
    private static String rootProp = "cellroot";
    private static String rootMsg = "cell";

    public static void main(String[] stringArray) {
        DumpNameSpace.setResourceBundle();
        String string = "localhost";
        String string2 = "2809";
        String string3 = THIS_CONTEXT;
        String string4 = "com.ibm.websphere.naming.WsnInitialContextFactory";
        String string5 = THIS_CONTEXT;
        String string6 = "jndi";
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-host")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-port")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-url")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-factory")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-startAt")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-report")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    System.out.println(DumpNameSpace.fmtMsg("reportOptBad"));
                    continue;
                }
                if (stringArray[++i].equals("short")) {
                    n = 1;
                    continue;
                }
                if (stringArray[i].equals("long")) {
                    n = 2;
                    continue;
                }
                System.out.println(DumpNameSpace.fmtMsg("reportOptBad"));
                continue;
            }
            if (stringArray[i].equals("-mode")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX) || !stringArray[++i].equals("ws40")) continue;
                _mode = 1;
                continue;
            }
            if (stringArray[i].equals("-root")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    System.out.println(DumpNameSpace.fmtMsg("treeOptBad"));
                    rootOpt = false;
                    continue;
                }
                rootOpt = true;
                if (stringArray[++i].equals("tree")) {
                    rootProp = "treeinfrastructureroot";
                    rootMsg = "tree";
                    continue;
                }
                if (stringArray[i].equals("host")) {
                    rootProp = "bootstraphostroot";
                    rootMsg = "host";
                    continue;
                }
                if (stringArray[i].equals("legacy")) {
                    rootProp = "legacydomainroot";
                    rootMsg = "legacy";
                    continue;
                }
                if (stringArray[i].equals("node")) {
                    rootProp = "bootstraphostroot";
                    rootMsg = "node";
                    continue;
                }
                if (stringArray[i].equals("server")) {
                    rootProp = "bootstrapserverroot";
                    rootMsg = "server";
                    continue;
                }
                if (stringArray[i].equals("cell")) {
                    rootProp = "cellroot";
                    rootMsg = "cell";
                    continue;
                }
                if (stringArray[i].equals("default")) {
                    rootProp = "defaultroot";
                    rootMsg = "default";
                    continue;
                }
                System.out.println(DumpNameSpace.fmtMsg("treeOptBad"));
                rootOpt = false;
                continue;
            }
            if (stringArray[i].equals("-format")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    System.out.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                    continue;
                }
                if (stringArray[++i].equals("jndi") || stringArray[i].equals("ins")) {
                    string6 = stringArray[i];
                    continue;
                }
                System.out.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                continue;
            }
            if (stringArray[i].equals("-traceString")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                ManagerAdmin.configureClientTrace(stringArray[++i], "named file", "DumpNameSpaceTrace.out", false, "basic", false);
                continue;
            }
            if (stringArray[i].equals("-?") || stringArray[i].equals("?") || stringArray[i].equals("-help") || stringArray[i].equals("help")) {
                DumpNameSpace.printHelp();
                return;
            }
            System.out.println("\n" + DumpNameSpace.fmtMsg("optionBad") + stringArray[i]);
            n2 = 3;
            System.exit(n2);
        }
        if (string3.length() > 0) {
            rootMsg = BLANK_LINE;
        }
        if (_mode == 1 && (rootProp == "bootstrapserverroot" || rootProp == "cellroot")) {
            rootProp = "legacydomainroot";
            rootMsg = "legacy";
        }
        String string7 = DumpNameSpace.providerUrl(string, string2, string3);
        Context context = DumpNameSpace.getStartingContext(System.out, string7, string4, rootProp, string5, string6);
        try {
            try {
                string5 = context.getNameInNamespace();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            DumpNameSpace.printCmdLineHeader(System.out, string7, string4, rootMsg, string5, string6);
            DumpNameSpace dumpNameSpace = new DumpNameSpace(System.out, n);
            dumpNameSpace.doGenerateDump(context);
        }
        catch (Exception exception) {
            System.out.println(DumpNameSpace.fmtMsg("icErr"));
            System.out.println(DumpNameSpace.fmtMsg("xcptInfo", new String[]{exception.toString()}));
            exception.printStackTrace(System.out);
            n2 = 2;
        }
        System.exit(n2);
    }

    private static int getNameServerType(Context context) {
        CNContext cNContext;
        NamingContext namingContext;
        int n = -1;
        if (context instanceof CNContext && (namingContext = (cNContext = (CNContext)context).getCosContext()) instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            com.ibm.WsnOptimizedNaming.NamingContext namingContext2 = (com.ibm.WsnOptimizedNaming.NamingContext)namingContext;
            while (true) {
                try {
                    n = namingContext2.get_compatibility_level();
                }
                catch (TRANSIENT tRANSIENT) {
                    if (tRANSIENT.minor == 1229066306) continue;
                    throw tRANSIENT;
                }
                break;
            }
        }
        return n;
    }

    private static Context getStartingContext(PrintStream printStream, String string, String string2, String string3, String string4, String string5) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.factory.initial", string2);
        hashtable.put("com.ibm.websphere.naming.name.syntax", string5);
        hashtable.put("com.ibm.websphere.naming.namespaceroot", string3);
        hashtable.put("com.ibm.websphere.naming.namespace.connection", "eager");
        Context context = null;
        try {
            printStream.println(THIS_CONTEXT);
            printStream.println(DumpNameSpace.fmtMsg("gettingInitCtx"));
            InitialContext initialContext = new InitialContext(hashtable);
            printStream.println(DumpNameSpace.fmtMsg("gettingStartCtx"));
            Object object = initialContext.lookup(THIS_CONTEXT);
            if (_mode == 0) {
                int n = DumpNameSpace.getNameServerType((Context)object);
                switch (n) {
                    case -1: 
                    case 0: {
                        _mode = 1;
                        if (!rootOpt) {
                            rootProp = "legacydomainroot";
                            rootMsg = "legacy";
                        }
                        hashtable.put("com.ibm.websphere.naming.namespaceroot", rootProp);
                        initialContext = new InitialContext(hashtable);
                        break;
                    }
                    case 1: {
                        _mode = 2;
                    }
                }
            }
            object = initialContext.lookup(string4);
            context = (Context)object;
        }
        catch (Exception exception) {
            printStream.println(DumpNameSpace.fmtMsg("icErr"));
            printStream.println(DumpNameSpace.fmtMsg("xcptInfo", new String[]{exception.toString()}));
            exception.printStackTrace(printStream);
            System.exit(1);
        }
        return context;
    }

    private static String providerUrl(String string, String string2, String string3) {
        if (string3.length() > 0) {
            return string3;
        }
        if (string.indexOf(58) == -1) {
            return "corbaloc:iiop:" + string + ":" + string2;
        }
        return "corbaloc:iiop:[" + string + "]:" + string2;
    }

    private static void setResourceBundle() {
        if (_msgs == null) {
            _msgs = ResourceBundle.getBundle(BUNDLE_NAME);
        }
    }

    public DumpNameSpace() {
        this.init(System.out, 1);
    }

    public DumpNameSpace(PrintStream printStream, int n) {
        this.init(printStream, n);
    }

    private void init(PrintStream printStream, int n) {
        this._out = printStream != null ? printStream : System.out;
        this._reportFmt = n;
        if (this._reportFmt != 1 && this._reportFmt != 2) {
            this._reportFmt = 1;
        }
        DumpNameSpace.setResourceBundle();
        this._topLabel = DumpNameSpace.fmtMsg("top");
        this.initForEachDump();
    }

    private void initForEachDump() {
        this._visitedCxtNames = new Hashtable();
        this._visitedCxtUuids = new Hashtable();
        this._seq = 0L;
        this._seqNum = null;
    }

    public void generateDump(Context context) {
        this.printApiHeader(context);
        this.doGenerateDump(context);
    }

    private void doGenerateDump(Context context) {
        this.initForEachDump();
        this._out.println(BLANK_LINE);
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(DumpNameSpace.fmtMsg("startDump"));
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(BLANK_LINE);
        this.dumpContext(this._topLabel, context, THIS_CONTEXT, null, null, null);
        this._out.println(BLANK_LINE);
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(DumpNameSpace.fmtMsg("endDump"));
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(BLANK_LINE);
    }

    private static void printCmdLineHeader(PrintStream printStream, String string, String string2, String string3, String string4, String string5) {
        String string6 = INDENT_AMOUNT;
        printStream.println(BLANK_LINE);
        printStream.println(DumpNameSpace.fmtMsg("sepLine"));
        printStream.println(DumpNameSpace.fmtMsg("nsDump"));
        printStream.println(string6 + DumpNameSpace.fmtMsg("providerUrl", new String[]{string}));
        printStream.println(string6 + DumpNameSpace.fmtMsg("ctxFactory", new String[]{string2}));
        printStream.println(string6 + DumpNameSpace.fmtMsg("rootCtx", new String[]{string3}));
        if (string4.equals(THIS_CONTEXT)) {
            printStream.println(string6 + DumpNameSpace.fmtMsg("startingCtxRoot"));
        } else {
            printStream.println(string6 + DumpNameSpace.fmtMsg("startingCtx", new String[]{string4}));
        }
        printStream.println(string6 + DumpNameSpace.fmtMsg("fmtRules", new String[]{string5}));
        printStream.println(string6 + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        printStream.println(DumpNameSpace.fmtMsg("sepLine"));
        printStream.println(BLANK_LINE);
    }

    private void printApiHeader(Context context) {
        String string = INDENT_AMOUNT;
        this._out.println(BLANK_LINE);
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(DumpNameSpace.fmtMsg("nsDump"));
        String string2 = DumpNameSpace.fmtMsg("topNotAvail");
        try {
            string2 = context.getNameInNamespace();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this._out.println(string + DumpNameSpace.fmtMsg("startingCtx", new String[]{string2}));
        this._out.println(string + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        this._out.println(DumpNameSpace.fmtMsg("sepLine"));
        this._out.println(BLANK_LINE);
    }

    private void dumpContext(String string, Context context, String string2, String string3, BindingType bindingType, String string4) {
        CNContext cNContext;
        Object object;
        boolean bl = false;
        if (context instanceof CNContext && (object = (cNContext = (CNContext)context).getCosContext()) instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            try {
                if (CommonHelpers.isDistributedNC((NamingContext)object)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.printBinding(string, context, string2, string4, string3, BindingType.ncontext, null);
        boolean bl2 = this.contextWasAlreadyDumped(context, string);
        if (!bl2) {
            try {
                object = context.listBindings(THIS_CONTEXT);
                while (object.hasMore()) {
                    NameClassPair nameClassPair;
                    String string5;
                    Binding binding = null;
                    String string6 = null;
                    String string7 = null;
                    Object object2 = null;
                    bindingType = null;
                    WsnBinding wsnBinding = null;
                    int n = -1;
                    WsnBindingCategory wsnBindingCategory = null;
                    Reference reference = null;
                    string4 = null;
                    string3 = null;
                    try {
                        binding = (Binding)object.next();
                        string6 = binding.getName();
                        string7 = binding.getClassName();
                        object2 = binding.getObject();
                        if (binding instanceof WsnBinding) {
                            wsnBinding = (WsnBinding)binding;
                            bindingType = wsnBinding.getCorbaBindingType();
                            n = wsnBinding.getWsnContextBindingType();
                            reference = wsnBinding.getBoundReference();
                            if (bl) {
                                wsnBindingCategory = wsnBinding.getBindingCategory();
                                if (wsnBindingCategory == WsnBindingCategory.CONTEXT_LINKED && object2 instanceof Context) {
                                    string5 = ((Context)object2).getNameInNamespace();
                                    string3 = DumpNameSpace.fmtMsg("linkedto", new String[]{string5});
                                }
                                if (wsnBindingCategory == WsnBindingCategory.CONTEXT_URL) {
                                    string5 = wsnBinding.getBindingURL();
                                    string3 = DumpNameSpace.fmtMsg("linkedtourl", new String[]{string5});
                                }
                            }
                        }
                    }
                    catch (CannotInstantiateObjectException cannotInstantiateObjectException) {
                        if (this._reportFmt != 1) {
                            string4 = DumpNameSpace.fmtMsg("noInstErr");
                        }
                        if ((nameClassPair = cannotInstantiateObjectException.getNameClassPair()) != null) {
                            string6 = nameClassPair.getName();
                            string7 = nameClassPair.getClassName();
                        }
                        reference = cannotInstantiateObjectException.getReference();
                    }
                    catch (UnresolvedURLException unresolvedURLException) {
                        if (this._reportFmt == 1) {
                            string3 = DumpNameSpace.fmtMsg("linkedtourl", new String[]{unresolvedURLException.getURL()});
                        } else {
                            string4 = DumpNameSpace.fmtMsg("unresolvedURLErr", new String[]{unresolvedURLException.getURL(), string6});
                        }
                        nameClassPair = unresolvedURLException.getNameClassPair();
                        if (nameClassPair != null) {
                            string6 = nameClassPair.getName();
                            string7 = nameClassPair.getClassName();
                        }
                    }
                    catch (NamingException namingException) {
                        string4 = DumpNameSpace.fmtMsg("namingErr", new String[]{namingException.toString()});
                    }
                    string5 = null;
                    string5 = string6 != null ? string + COMPONENT_SEPARATOR + string6 : DumpNameSpace.fmtMsg("bindingNameNotAvail");
                    if (string7 == null || string7.length() == 0) {
                        string7 = DumpNameSpace.fmtMsg("classNameNotAvail");
                    }
                    if (object2 instanceof Context && ((bindingType == null || bindingType == BindingType.ncontext) && n != 1 || _mode == 1)) {
                        this.dumpContext(string5, (Context)object2, string7, string3, bindingType, string4);
                        continue;
                    }
                    this.printBinding(string5, object2, string7, string4, string3, bindingType, reference);
                }
            }
            catch (NamingException namingException) {
                this._out.println(DumpNameSpace.fmtMsg("listErr", new String[]{string, namingException.toString()}));
            }
        }
    }

    private boolean contextWasAlreadyDumped(Context context, String string) {
        if (string.endsWith("nodeSystemNameSpaceRoot")) {
            this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("nodeSNSRoot"));
            return true;
        }
        if (context instanceof UuidContext) {
            UuidContext uuidContext = (UuidContext)((Object)context);
            String string2 = ((Object)uuidContext.getContextID()).toString();
            Object v = this._visitedCxtUuids.get(string2);
            if (v == null) {
                ContextInfo contextInfo = new ContextInfo(this._seqNum, string);
                this._visitedCxtUuids.put(string2.toString(), contextInfo);
                return false;
            }
            ContextInfo contextInfo = (ContextInfo)v;
            this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
            this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{contextInfo._sequence, contextInfo._contextName}));
            return true;
        }
        String string3 = null;
        try {
            string3 = context.getNameInNamespace();
        }
        catch (Exception exception) {
            this._out.println(DumpNameSpace.fmtMsg("getNameErr", new String[]{exception.toString()}));
        }
        Object v = this._visitedCxtNames.get(string3);
        if (v == null) {
            ContextInfo contextInfo = new ContextInfo(this._seqNum, string);
            this._visitedCxtNames.put(string3, contextInfo);
            return false;
        }
        ContextInfo contextInfo = (ContextInfo)v;
        this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
        this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{contextInfo._sequence, contextInfo._contextName}));
        return true;
    }

    private void printBinding(String string, Object object, String string2, String string3, String string4, BindingType bindingType, Reference reference) {
        this._seqNum = this.getNextSeqNum();
        switch (this._reportFmt) {
            case 1: {
                String string5 = this.getPaddedString(string, 50);
                if (string5.length() <= 50) {
                    this._out.println(this._seqNum + string5 + BLANK_LINE + string2);
                } else {
                    this._out.println(this._seqNum + string5);
                    this._out.println(this._seqNum + this.getPaddedString(BLANK_LINE, 51) + string2);
                }
                if (string3 != null) {
                    this._out.println(this._seqNum + INDENT_AMOUNT + string3);
                }
                if (string4 == null || string4.length() <= 0) break;
                this._out.println(this._seqNum + INDENT_AMOUNT + string4);
                break;
            }
            case 2: {
                String string6;
                Object object2;
                String string7 = DumpNameSpace.fmtMsg("null");
                String string8 = THIS_CONTEXT;
                if (object != null) {
                    string7 = object.getClass().getName();
                    string8 = object.toString();
                }
                this._out.println(BLANK_LINE);
                this._out.println(this._seqNum + string);
                if (string3 != null) {
                    this._out.println(this._seqNum + INDENT_AMOUNT + string3);
                }
                if (string4 != null && string4.length() > 0) {
                    this._out.println(this._seqNum + INDENT_AMOUNT + string4);
                }
                this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("boundType", new String[]{string2}));
                this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("localType", new String[]{string7}));
                if (bindingType != null) {
                    object2 = null;
                    object2 = bindingType == BindingType.ncontext ? "org.omg.CosNaming.BindingType.ncontext" : "org.omg.CosNaming.BindingType.nobject";
                    this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("corbaType", new String[]{object2}));
                }
                if (object instanceof UuidContext) {
                    object2 = (UuidContext)object;
                    string6 = ((Object)object2.getContextID()).toString();
                    this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("ctxId", new String[]{string6}));
                }
                this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("objToString", new String[]{string8}));
                if (reference == null) break;
                this._out.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("srcObjIsRef"));
                object2 = reference.getFactoryClassName();
                if (object2 != null && ((String)object2).length() > 0) {
                    this._out.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactClass", new String[]{object2}));
                }
                if ((string6 = reference.getFactoryClassLocation()) != null && string6.length() > 0) {
                    this._out.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactLoc", new String[]{string6}));
                }
                Enumeration<RefAddr> enumeration = reference.getAll();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    RefAddr refAddr = enumeration.nextElement();
                    if (refAddr != null) {
                        this._out.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrString", new String[]{THIS_CONTEXT + n, refAddr.toString()}));
                    } else {
                        this._out.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrNull", new String[]{THIS_CONTEXT + n}));
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private String getNextSeqNum() {
        ++this._seq;
        if (this._seq > 99999L) {
            this._seq = 0L;
        }
        StringBuffer stringBuffer = new StringBuffer(6);
        stringBuffer.insert(0, BLANK_LINE);
        stringBuffer.insert(0, this._seq);
        while (stringBuffer.length() < 6) {
            stringBuffer.insert(0, BLANK_LINE);
        }
        return stringBuffer.toString();
    }

    private String getPaddedString(String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.insert(0, string);
        for (int i = n2; i < n; ++i) {
            stringBuffer.insert(i, BLANK_LINE);
        }
        return stringBuffer.toString();
    }

    private static String fmtMsg(String string) {
        String string2 = null;
        try {
            if (_msgs != null) {
                return MessageFormat.format(_msgs.getString(string), null);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static String fmtMsg(String string, String[] stringArray) {
        String string2 = null;
        try {
            if (_msgs != null) {
                return MessageFormat.format(_msgs.getString(string), stringArray);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static void printHelp() {
        System.out.println(BLANK_LINE);
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
        System.out.println(DumpNameSpace.fmtMsg("cmdLineUsage"));
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
    }

    private class ContextInfo {
        public String _contextName = null;
        public String _sequence = null;

        public ContextInfo(String string, String string2) {
            this._contextName = string2;
            this._sequence = string;
        }
    }
}

