/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.CommonHelpers;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class WsnInitialContextFactory
implements InitialContextFactory {
    private static final TraceComponent tc = Tr.register(WsnInitialContextFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static String _implClassName;
    private static Constructor _implClassCtor;
    private InitialContextFactory _icfInstance = null;

    public WsnInitialContextFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "com.ibm.websphere.naming.WsnInitialContextFactory");
        }
        this._icfInstance = null;
        Tr.exit(tc, "com.ibm.websphere.naming.WsnInitialContextFactory ");
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        Tr.entry(tc, "getInitialContext");
        CommonHelpers.mergeWsnJndiProperties(hashtable);
        if (this._icfInstance == null) {
            if (_implClassCtor == null) {
                this.init_implClassCtor(hashtable);
            }
            this.init_icfInstance();
        }
        Context context = this._icfInstance.getInitialContext(hashtable);
        Tr.exit(tc, "getInitialContext");
        return context;
    }

    private void init_icfInstance() throws NamingException {
        Tr.entry(tc, "init_icfInstance");
        try {
            this._icfInstance = (InitialContextFactory)_implClassCtor.newInstance(null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.naming.WsnInitialContextFactory.init_icfInstance", "97", this);
            this._icfInstance = null;
            String string = "Could not create an instance of the class " + _implClassName + ". ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, exception);
            }
            Tr.warning(tc, "cannotCreateObj", _implClassName);
            ConfigurationException configurationException = new ConfigurationException(string);
            configurationException.setRootCause(exception);
            throw configurationException;
        }
        Tr.exit(tc, "init_icfInstance");
    }

    private synchronized void init_implClassCtor(Hashtable hashtable) throws NamingException {
        Tr.entry(tc, "init_implClassCtor");
        if (_implClassCtor == null) {
            Serializable serializable;
            try {
                _implClassName = (String)hashtable.get("com.ibm.ws.naming.wsn.factory.initial");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Implementation Class=" + _implClassName);
                }
                if (_implClassName != null) {
                    serializable = Class.forName(_implClassName);
                    _implClassCtor = serializable.getConstructor(null);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Implementation Class Constructor=" + _implClassCtor);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.naming.WsnInitialContextFactory.init_implClassCtor", "129", this);
                _implClassCtor = null;
                String string = "Could not create an instance of the class " + _implClassName + ". ";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, exception);
                }
                Tr.warning(tc, "cannotCreateObj", _implClassName);
                ConfigurationException configurationException = new ConfigurationException(string);
                configurationException.setRootCause(exception);
                throw configurationException;
            }
            if (_implClassName == null) {
                Tr.warning(tc, "noInitCtxFactoryImpl");
                serializable = new ConfigurationException("The property com.ibm.ws.naming.wsn.factory.initial is not set. The most likely cause is that the jar which contains the file com/ibm/websphere/naming/jndiprovider.properties cannot be found by the class loader.");
                throw serializable;
            }
        }
        Tr.exit(tc, "init_implClassCtor");
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/WsnInitialContextFactory.java, WAS.naming, WAS61.SERV1, cf311012.09, ver. 1.16");
        }
        _implClassName = null;
        _implClassCtor = null;
    }
}

