/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.performance.tuning.notifications;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.leakProtoType_1.LeakRuleOutput;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class MemoryLeakNotificationFilter
implements NotificationFilter {
    private static final long serialVersionUID = 1L;
    private static TraceComponent tc = Tr.register(MemoryLeakNotificationFilter.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public boolean isNotificationEnabled(Notification notification) {
        String string = notification.getMessage();
        System.out.println();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MemoryLeakNotificationFilter : " + string);
        }
        try {
            HashMap hashMap = LeakRuleOutput.convertMessageToHashMap(string);
            if (hashMap.containsKey("IsMemoryLeak")) {
                Boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MemoryLeakNotificationFilter: leak rule output contains is leak");
                }
                if ((bl = new Boolean((String)hashMap.get("IsMemoryLeak"))).booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MemoryLeakNotificationFilter: is a memory leak");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MemoryLeakNotificationFilter: is not a memory leak");
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MemoryLeakNotificationFilter: rule output did not contain isLeak");
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

