/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.etools.portletapplication.PortletApplicationResource;
import com.ibm.etools.portletapplication.init.PortletApplicationInit;
import com.ibm.etools.portletapplicationext.PortletApplicationExtension;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appcfg.DeployedObjectConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.HTTPTunnelInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.pmirm.PMIRequestMetrics;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.webserver.LoadBalanceKind;
import com.ibm.websphere.models.config.webserver.LogLevelKind;
import com.ibm.websphere.models.config.webserver.PluginMethodKind;
import com.ibm.websphere.models.config.webserver.PluginPriorityKind;
import com.ibm.websphere.models.config.webserver.PluginProperties;
import com.ibm.websphere.models.config.webserver.PluginServerClusterProperties;
import com.ibm.websphere.models.config.webserver.PortPreferenceKind;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.models.config.webserver.WebserverPluginSettings;
import com.ibm.websphere.models.config.webserver.WebserverTypeKind;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.websphere.plugincfg.generator.PluginConfigHelperIntf;
import com.ibm.websphere.plugincfg.generator.VariableManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ConfigurationParser
extends ContainerImpl {
    protected static TraceComponent tc = Tr.register(ConfigurationParser.class);
    protected PMIRequestMetrics pmirm = null;
    public static final String CONFIGDIR = "config";
    public static final String CELLSDIR = "cells";
    public static final String CLUSTERSDIR = "clusters";
    public static final String NODESDIR = "nodes";
    public static final String SERVERSDIR = "servers";
    public static final String APPLICATIONSDIR = "applications";
    public static final String CLUSTERFILE = "cluster.xml";
    public static final String SERVERFILE = "server.xml";
    public static final String SERVERINDEX = "serverindex.xml";
    public static final String VIRTUALHOST = "virtualhosts.xml";
    public static final String DEPLOYMENT_XML = "deployment.xml";
    public static final String REQUEST_METRICS_FILE = "pmirm.xml";
    public static final String NOT_DEFINED = "notDefined";
    public static final String WEB_SERVER_TYPE = "WEB_SERVER";
    public static final String WORKPLACE_SERVER_TYPE = "WORKPLACE_SERVER";
    public static final String TUNNEL_SERVER_TYPE = "TUNNEL_SERVER";
    public static final String BUS_SERVER_TYPE = "BUS_TUNNEL_SERVER";
    public static final String ONDEMAND_ROUTER_TYPE = "ONDEMAND_ROUTER";
    public static final String PROXY_SERVER_TYPE = "PROXY_SERVER";
    public static final String SIB_ENGINES_FILE = "sib-engines.xml";
    public static final String SECURITY = "security.xml";
    private PluginConfigData _pluginConfigData = new PluginConfigData();
    private List _vHosts = new ArrayList();
    private List _vHostNames = new ArrayList();
    private List _clusters = new ArrayList();
    private List _serverRemoveList = new ArrayList();
    private List _foundCells = new ArrayList();
    private String _appServerRoot;
    private String _appServerConfigRoot;
    private String _cellName;
    private String _nodeNameList;
    private String _serverNameList;
    private String _clusterNameList;
    private String _webserverName = null;
    private String _configFileComment = "";
    private int listSize = 0;
    private int nbrOfClusters = 0;
    private boolean _dmgrFound = false;
    private HashMap _definedServers = new HashMap();
    private static VariableManager _vMgr = new VariableManager();
    private Class pluginCfgHelperClass = null;
    private Class lotusCfgHelperClass = null;
    private PluginConfigHelperIntf lotusCfgHelper = null;
    private Class tunnelCfgHelperClass = null;
    private HashMap _siToHostName = new HashMap();

    public ConfigurationParser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws PluginConfigException {
        this._appServerRoot = string;
        this._appServerConfigRoot = string2 != null ? string2 : string + CONFIGDIR;
        this._cellName = string3;
        this._clusterNameList = string4;
        this._nodeNameList = string5;
        this._serverNameList = string6;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_appServerRoot: " + this._appServerRoot + "_appServerConfigRoot: " + this._appServerConfigRoot + " _cellName: " + this._cellName + " _clusterNameList: " + this._clusterNameList + " _nodeNameList: " + this._nodeNameList + " _serverNameList: " + this._serverNameList + " destRoot: " + string7 + " destOS: " + string8);
        }
        try {
            Object var9_9 = null;
            Repository repository2 = null;
            ConfigRoot configRoot = null;
            repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._serverNameList);
            configRoot = repository2.getConfigRoot();
            _vMgr.setVariableMap(configRoot, 2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.init", "710", this);
        }
        this.setPluginConfigData(string8, string7);
        this._dmgrFound = ConfigurationParser.isNodeDMGR(this._appServerConfigRoot, string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DMgr is running locally " + this._dmgrFound);
        }
        PortletApplicationInit.init();
        this.parseConfiguration();
        this.setClusterServerData();
        this.setClusterDeployedModuleInfo(false);
        this.setConfigFileComment(false);
    }

    public ConfigurationParser(String string, String string2, String string3, String string4, String string5) throws PluginConfigException {
        this._appServerRoot = string;
        this._appServerConfigRoot = string2 != null ? string2 : string + CONFIGDIR;
        this._cellName = string3;
        this._nodeNameList = string4;
        this._webserverName = string5;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_appServerRoot: " + this._appServerRoot + " _appServerConfigRoot: " + this._appServerConfigRoot + " _cellName: " + this._cellName + " _nodeNameList: " + this._nodeNameList + " _webserverName: " + this._webserverName);
        }
        try {
            Object var6_6 = null;
            Repository repository2 = null;
            ConfigRoot configRoot = null;
            repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._serverNameList);
            configRoot = repository2.getConfigRoot();
            _vMgr.setVariableMap(configRoot, 2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.init", "710", this);
        }
        this.readPluginProperties();
        this._dmgrFound = ConfigurationParser.isNodeDMGR(this._appServerConfigRoot, string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DMgr is running locally " + this._dmgrFound);
        }
        PortletApplicationInit.init();
        this.parseDeployedModules();
        if (this._cellName != null) {
            this.readLotusConfiguration();
        }
        if (this._cellName != null) {
            this.pmirm = this.readPMIRMConfiguration(this._cellName);
        }
        this._foundCells.add(this._cellName);
        this.setVHosts();
        this.setClusterServerData();
        this.setClusterDeployedModuleInfo(true);
        this.setConfigFileComment(true);
    }

    public String getAppServerRoot() {
        return this._appServerRoot;
    }

    public String getAppServerConfigRoot() {
        return this._appServerConfigRoot;
    }

    public List getServerClusters() {
        return this._clusters;
    }

    public VirtualHost getVHost(String string) {
        Iterator iterator = this._vHosts.iterator();
        while (iterator.hasNext()) {
            VirtualHost virtualHost = (VirtualHost)iterator.next();
            String string2 = virtualHost.getName();
            if (!string2.equals(string)) continue;
            return virtualHost;
        }
        return null;
    }

    public List getVHostNames() {
        return this._vHostNames;
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getNodeName() {
        return this._nodeNameList;
    }

    public String getWebserverName() {
        return this._webserverName;
    }

    public PluginConfigData getPluginConfigData() {
        return this._pluginConfigData;
    }

    public String getConfigFileComment() {
        String string = this._configFileComment.replaceAll("--", "==");
        return string;
    }

    public List getLotusTransportList(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLotusTransportList for " + string2 + " on node: " + string);
        }
        List list = null;
        try {
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getTransportList(string, string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusTransportList", "1780", this);
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("error.reading.lotustransports"));
        }
        return list;
    }

    public List getLotusURIList() {
        List list = null;
        try {
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getURIList();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusURIList", "1805", this);
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("error.reading.lotusuris"));
        }
        return list;
    }

    public List getTunnelURIList(TransportData transportData) {
        List list = null;
        try {
            Class clazz = this.getTunnelCfgHelperClass();
            Class[] classArray = new Class[]{TransportData.class};
            if (clazz != null) {
                Method method2 = clazz.getMethod("getURIList", classArray);
                list = (List)method2.invoke(null, transportData);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getTunnelURIList", "358", this);
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("error.reading.tunneluris"));
        }
        return list;
    }

    private void setPluginConfigData(String string, String string2) throws PluginConfigException {
        if (string != null) {
            this._pluginConfigData.FileSeparator = string.equalsIgnoreCase("windows") ? "\\" : "/";
        }
        if (string2 != null) {
            this._pluginConfigData.PluginInstallRoot = string2;
        } else {
            if (string == null) {
                string = ConfigurationParser.getNodePlatform(this._appServerConfigRoot, this._cellName);
            }
            if (string.equals("os390")) {
                String string3 = this._appServerRoot;
                int n = this._appServerConfigRoot.indexOf(CONFIGDIR, 0);
                if (n > 0) {
                    string3 = this._appServerConfigRoot.substring(0, n - 1);
                }
                this._pluginConfigData.PluginInstallRoot = string3;
            } else {
                this._pluginConfigData.PluginInstallRoot = ConfigurationParser.getDefaultPluginInstallRoot(string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Plugin install root is : " + this._pluginConfigData.PluginInstallRoot);
        }
        if (!this._pluginConfigData.PluginInstallRoot.endsWith(this._pluginConfigData.FileSeparator)) {
            this._pluginConfigData.PluginInstallRoot = this._pluginConfigData.PluginInstallRoot + this._pluginConfigData.FileSeparator;
        }
        this._pluginConfigData.LogFile = this._pluginConfigData.PluginInstallRoot + "logs" + this._pluginConfigData.FileSeparator + "http_plugin.log";
        this._pluginConfigData.KeyringLocation = this._pluginConfigData.PluginInstallRoot + "etc" + this._pluginConfigData.FileSeparator + "plugin-key.kdb";
        this._pluginConfigData.StashfileLocation = this._pluginConfigData.PluginInstallRoot + "etc" + this._pluginConfigData.FileSeparator + "plugin-key.sth";
        this._pluginConfigData.FIPSEnable = ConfigurationParser.isFIPSEnabled(this._appServerConfigRoot, this._cellName);
        if (tc.isDebugEnabled()) {
            this._pluginConfigData.print(tc);
        }
    }

    private void parseConfiguration() throws PluginConfigException {
        String string;
        int n;
        StringTokenizer stringTokenizer;
        if (this._clusterNameList != null && this._cellName != null) {
            if (this._clusterNameList.equalsIgnoreCase("ALL")) {
                this.readCellConfiguration(this._cellName, true);
            } else {
                stringTokenizer = new StringTokenizer(this._clusterNameList, ",");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of clusters in the list - " + stringTokenizer.countTokens());
                }
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("gen.for.cluster") + " " + string + ".");
                    this.readClusterConfiguration(string, this._cellName);
                    ++n;
                }
            }
        }
        if (this._serverNameList != null) {
            StringTokenizer stringTokenizer2;
            stringTokenizer = new StringTokenizer(this._serverNameList, ",");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of servers in the list - " + stringTokenizer.countTokens());
            }
            if ((stringTokenizer2 = new StringTokenizer(this._nodeNameList, ",")).countTokens() > 1) {
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("morethan.one.node"));
            }
            string = stringTokenizer2.nextToken();
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                System.out.println("\n" + PluginConfigGenerator.nls.getString("single.server.gen") + " " + this._cellName + ", " + PluginConfigGenerator.nls.getString("string.node") + " " + string + ", " + PluginConfigGenerator.nls.getString("string.server") + " " + string2 + ".");
                this.addServer(string2, string, this._cellName, null);
                ++n2;
            }
            this._foundCells.add(this._cellName);
        } else if (this._nodeNameList != null) {
            stringTokenizer = new StringTokenizer(this._nodeNameList, ",");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of nodes in the list : " + stringTokenizer.countTokens());
            }
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("single.node.gen") + " " + this._cellName + ", " + PluginConfigGenerator.nls.getString("string.node") + " " + string + ".");
                this.readNodeConfiguration(string, this._cellName);
                ++n;
            }
            this._foundCells.add(this._cellName);
        } else if (this._cellName != null) {
            if (this._clusterNameList == null) {
                this.readCellConfiguration(this._cellName, false);
            }
            this._foundCells.add(this._cellName);
        } else {
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("no.cell.name"));
        }
        if (this._cellName != null) {
            this.readLotusConfiguration();
        }
        if (this._cellName != null) {
            this.pmirm = this.readPMIRMConfiguration(this._cellName);
        }
        this.setVHosts();
    }

    private void addServer(String string, String string2, String string3, String string4) throws PluginConfigException {
        this.addServer(null, string, string2, string3, string4, null);
    }

    private void addServer(String string, String string2, String string3, String string4, String string5, List list) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding server: " + string2 + " on node: " + string3 + " in cluster: " + string + " in cell: " + string4 + " with server type: " + string5);
        }
        ServerClusterData serverClusterData = null;
        boolean bl = true;
        if (string != null) {
            for (int i = 0; i < this.nbrOfClusters; ++i) {
                serverClusterData = (ServerClusterData)this._clusters.get(i);
                if (!serverClusterData.clusterName.equals(string)) continue;
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "The cluster " + string + " is already defined.");
                break;
            }
            if (bl) {
                serverClusterData = new ServerClusterData(string);
                serverClusterData.clusterServers = new ArrayList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cluster " + serverClusterData.clusterName + " is defined.");
                }
            }
        } else {
            serverClusterData = new ServerClusterData(string2 + "_" + string3 + "_Cluster");
            serverClusterData.clusterServers = new ArrayList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The cluster " + serverClusterData.clusterName + " is defined.");
            }
        }
        this.setServerClusterPropsFromConfig(serverClusterData);
        ServerData serverData = new ServerData(string2);
        serverData.nodeName = string3;
        serverData.cellName = string4;
        if (string5 == null) {
            serverClusterData.singleServerConfig = Boolean.TRUE;
            this.setServerType(serverData);
        } else {
            serverClusterData.singleServerConfig = Boolean.FALSE;
            serverData.serverType = string5;
        }
        this._definedServers.put(string2 + string3, string2 + string3);
        serverData.wlmWeight = new Integer(-1);
        if (list != null) {
            serverData.transports = list;
            this.setHostName(serverData);
        }
        serverClusterData.clusterServers.add(serverData);
        if (bl) {
            this._clusters.add(serverClusterData);
            ++this.nbrOfClusters;
        }
    }

    private void readNodeConfiguration(String string, String string2) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading node configuration for node: " + string + " in cell: " + string2);
        }
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(this._appServerConfigRoot, string2, string);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string3 = serverEntry.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType :" + string3);
            }
            if (!string3.equals("APPLICATION_SERVER") && !string3.equals("DEPLOYMENT_MANAGER")) continue;
            String string4 = serverEntry.getServerName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName :" + string4);
            }
            if (this._definedServers.get(string4 + string) != null) continue;
            this.addServer(string4, string, string2, string3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readCellConfiguration(String string, boolean bl) throws PluginConfigException {
        File[] fileArray;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading cell configuration for cell: " + string);
        }
        boolean bl2 = false;
        String string2 = this._appServerConfigRoot + File.separator + CELLSDIR + File.separator + string + File.separator + CLUSTERSDIR;
        File file = new File(string2);
        if (file.exists() && (fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.readClusterConfiguration(fileArray[i].getName(), string);
            }
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("gen.for.clusters") + " " + string + ".");
            bl2 = true;
        }
        if (bl) return;
        String string3 = this._appServerConfigRoot + File.separator + CELLSDIR + File.separator + string + File.separator + NODESDIR;
        File file2 = new File(string3);
        File[] fileArray2 = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray2 == null) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.defs.for.cell") + " " + string + ".");
        if (fileArray2.length <= 0) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.clusters.or.nodes"));
        for (int i = 0; i < fileArray2.length; ++i) {
            this.readNodeConfiguration(fileArray2[i].getName(), string);
        }
        if (bl2) return;
        System.out.println();
        System.out.println(PluginConfigGenerator.nls.getString("gen.for.all.cell.servers") + " " + string + ".");
    }

    private void readClusterConfiguration(String string, String string2) throws PluginConfigException {
        block9: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading cluster configuration for cluster: " + string + " in cell: " + string2);
            }
            try {
                Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, null, null);
                Resource resource = repository2.getConfigRoot().getResource(0, CLUSTERSDIR + File.separator + string + File.separator + CLUSTERFILE);
                EList eList = resource.getContents();
                if (eList.size() > 0) {
                    ServerCluster serverCluster = (ServerCluster)eList.get(0);
                    ServerClusterData serverClusterData = new ServerClusterData(serverCluster.getName());
                    this.setServerClusterPropsFromConfig(serverClusterData);
                    serverClusterData.backupClusters = serverCluster.getBackupClusters();
                    EList eList2 = serverCluster.getMembers();
                    this.listSize = eList2.size();
                    serverClusterData.clusterServers = new ArrayList();
                    ServerData serverData = null;
                    String string3 = null;
                    for (int i = 0; i < this.listSize; ++i) {
                        ClusterMember clusterMember = (ClusterMember)eList2.get(i);
                        if (clusterMember.getMemberName() == null) {
                            throw new PluginConfigException(PluginConfigGenerator.nls.getString("server.name.not.set") + " " + serverCluster.getName() + ".");
                        }
                        serverData = new ServerData(clusterMember.getMemberName());
                        serverData.wlmWeight = new Integer(clusterMember.getWeight());
                        serverData.serverID = clusterMember.getUniqueId() != null ? EncodeCloneID.encodeString((String)clusterMember.getUniqueId()) : "";
                        serverData.cellName = string2;
                        serverData.nodeName = clusterMember.getNodeName();
                        if (string3 == null) {
                            this.setServerType(serverData);
                            string3 = serverData.serverType;
                        } else {
                            serverData.serverType = string3;
                        }
                        List list = this.getBusListForClusterMember(string);
                        this.updateBusList(serverData, list);
                        serverClusterData.clusterServers.add(serverData);
                        this._definedServers.put(serverData.serverName + serverData.nodeName, serverData.serverName + serverData.nodeName);
                    }
                    this._clusters.add(serverClusterData);
                    ++this.nbrOfClusters;
                    break block9;
                }
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.parsing.cluster") + " " + string + " " + PluginConfigGenerator.nls.getString("in.cell.string") + " " + string2 + ".");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.readClusterConfiguration", "380", this);
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("exception.parsing.cluster") + " " + string + " " + PluginConfigGenerator.nls.getString("in.cell.string") + " " + string2 + ".");
                if (tc.isDebugEnabled()) {
                    throwable.printStackTrace();
                }
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("rerun.with.debug"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMIRequestMetrics readPMIRMConfiguration(String string) throws PluginConfigException {
        PMIRequestMetrics pMIRequestMetrics;
        block8: {
            pMIRequestMetrics = null;
            try {
                Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, null, null);
                Resource resource = repository2.getConfigRoot().getResource(0, REQUEST_METRICS_FILE);
                EList eList = resource.getContents();
                if (eList.size() > 0) {
                    pMIRequestMetrics = (PMIRequestMetrics)eList.get(0);
                }
                if (pMIRequestMetrics == null) {
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPMIRMConfig", "235", this);
                System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPMIRMConfig", "239", this);
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
                if (tc.isDebugEnabled()) {
                    throwable.printStackTrace();
                    break block8;
                }
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("rerun.with.debug"));
            }
        }
        return pMIRequestMetrics;
    }

    private void setClusterServerData() throws PluginConfigException {
        for (int i = 0; i < this.nbrOfClusters; ++i) {
            ServerClusterData serverClusterData = (ServerClusterData)this._clusters.get(i);
            int n = serverClusterData.clusterServers.size();
            for (int j = 0; j < n; ++j) {
                ServerData serverData = (ServerData)serverClusterData.clusterServers.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting the cluster server data for server: " + serverData.serverName + " on node: " + serverData.nodeName);
                }
                if (!(TUNNEL_SERVER_TYPE.equals(serverData.serverType) || BUS_SERVER_TYPE.equals(serverData.serverType) || ONDEMAND_ROUTER_TYPE.equals(serverData.serverType) || PROXY_SERVER_TYPE.equals(serverData.serverType))) {
                    Server server2 = this.getServerConfig(serverData);
                    if (server2 == null) {
                        if (serverClusterData.singleServerConfig.booleanValue()) {
                            throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("no.file.generated"));
                        }
                        this.removeClusterServer(serverClusterData, serverData.serverName, serverData.nodeName);
                        if (--n == 0) break;
                        --j;
                        continue;
                    }
                    this.setServerData(server2, serverData);
                    serverClusterData.fileServingEnabled = serverData.fileServingEnabled;
                    if (!serverData.disallowAllFileServing.equals(NOT_DEFINED) && !serverClusterData.disallowAllFileServing.equals("true")) {
                        serverClusterData.disallowAllFileServing = serverData.disallowAllFileServing;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "disallowAllFileServing has been set to: " + serverData.serverName + " of Type: " + serverData.serverType + " from Cluster: " + serverClusterData.clusterName);
                        }
                    }
                    serverClusterData.serveServletsByClassnameEnabled = serverData.serveServletsByClassnameEnabled;
                    if (serverData.cloneSeparator == null) continue;
                    serverClusterData.cloneSeparatorChange = new Boolean(serverData.cloneSeparator.equalsIgnoreCase("true"));
                    continue;
                }
                if (!ONDEMAND_ROUTER_TYPE.equals(serverData.serverType) && !PROXY_SERVER_TYPE.equals(serverData.serverType)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing Server Name: " + serverData.serverName + " of Type: " + serverData.serverType + " from Cluster: " + serverClusterData.clusterName);
                }
                this.removeClusterServer(serverClusterData, serverData.serverName, serverData.nodeName);
                if (--n == 0) break;
                --j;
            }
            if (n >= 1) continue;
            this._clusters.remove(i);
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("no.valid.servers.for.cluster") + " " + serverClusterData.clusterName + ".\n  " + PluginConfigGenerator.nls.getString("ignore.string"));
            --this.nbrOfClusters;
            if (this.nbrOfClusters < 1) {
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.for.any.cluster"));
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server getServerConfig(ServerData serverData) throws PluginConfigException {
        Server server2;
        block9: {
            Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
            server2 = null;
            try {
                EList eList;
                Resource resource = repository2.getConfigRoot().getResource(4, SERVERFILE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the server config for server: " + serverData.serverName + " on node " + serverData.nodeName + " in cell: " + serverData.cellName);
                }
                if ((eList = resource.getContents()).size() > 0) {
                    server2 = (Server)eList.get(0);
                }
                if (server2 == null) {
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getServerConfig", "551", this);
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getServerConfig", "556", this);
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("exception.reading.server") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
                if (tc.isDebugEnabled()) {
                    throwable.printStackTrace();
                    break block9;
                }
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("rerun.with.debug"));
            }
        }
        return server2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getBusListForServer(ServerData serverData) {
        Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
        EList eList = null;
        try {
            Resource resource = repository2.getConfigRoot().getResource(4, SIB_ENGINES_FILE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting bus list for server: " + serverData.serverName + " on node: " + serverData.nodeName);
            }
            eList = resource.getContents();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The sib resources are not available for the server " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".");
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error when reading sib resources for the server " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".");
            }
        }
        return this.getBusList((List)eList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getBusListForClusterMember(String string) {
        Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, null, null);
        EList eList = null;
        try {
            Resource resource = repository2.getConfigRoot().getResource(0, CLUSTERSDIR + File.separator + string + File.separator + SIB_ENGINES_FILE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Gettins bus list for cluster: " + string);
            }
            eList = resource.getContents();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The sib resources are not available for the cluster " + string + ".");
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error when reading sib resources for the cluster " + string + ".");
            }
        }
        return this.getBusList((List)eList);
    }

    private List getBusList(List list) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting bus list");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            int n = list.size();
            block0: for (int i = 0; i < n; ++i) {
                EObject eObject = (EObject)list.get(i);
                EClass eClass = eObject.eClass();
                String string = eClass.getName();
                if (!string.equals("SIBMessagingEngine")) continue;
                String string2 = "DefaultBus";
                StringTokenizer stringTokenizer = new StringTokenizer(eObject.toString(), " ,");
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    if (stringTokenizer.nextToken().equalsIgnoreCase("busName:")) {
                        string2 = stringTokenizer.nextToken();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bus " + string2 + " is added to the list.");
                        }
                        arrayList.add(string2);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    private void updateBusList(ServerData serverData, List list) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updating bus list for server: " + serverData.serverName + " on node: " + serverData.nodeName);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            boolean bl = false;
            int n2 = serverData.busList.size();
            for (int j = 0; j < n2; ++j) {
                if (!string.equalsIgnoreCase((String)serverData.busList.get(j))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            serverData.busList.add(string);
        }
    }

    private void setServerData(Server server2, ServerData serverData) throws PluginConfigException {
        int n;
        Object object;
        String string;
        ApplicationServer applicationServer;
        Object object2;
        WebContainer webContainer = null;
        EList eList = null;
        EClass eClass = server2.eClass();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting server data for server: " + serverData.serverName + " on node: " + serverData.nodeName + " with server type: " + serverData.serverType);
        }
        if (serverData.serverID == null || serverData.serverID.equals("")) {
            serverData.serverID = server2.getUniqueId() != null ? EncodeCloneID.encodeString((String)server2.getUniqueId()) : "";
        }
        try {
            String string2;
            object2 = server2.getComponents();
            this.listSize = object2.size();
            for (int i = 0; i < this.listSize; ++i) {
                EObject eObject = (EObject)object2.get(i);
                EClass eClass2 = eObject.eClass();
                string2 = eClass2.getName();
                if (!string2.equals("ApplicationServer")) continue;
                applicationServer = (ApplicationServer)eObject;
                serverData.appServerName = applicationServer.getName();
                string = applicationServer.getComponents();
                int n2 = string.size();
                for (int j = 0; j < n2; ++j) {
                    if (!(string.get(j) instanceof WebContainer)) continue;
                    webContainer = (WebContainer)string.get(j);
                }
                WebserverPluginSettings webserverPluginSettings = applicationServer.getWebserverPluginSettings();
                if (webserverPluginSettings == null) continue;
                this.setWebserverPluginSettings(serverData, webserverPluginSettings);
            }
            object = server2.getServices();
            int n3 = object.size();
            for (n = 0; n < n3; ++n) {
                string2 = (EObject)object.get(n);
                applicationServer = string2.eClass();
                string = applicationServer.getName();
                if (!string.equals("TransportChannelService")) continue;
                TransportChannelService transportChannelService = (TransportChannelService)string2;
                eList = transportChannelService.getChains();
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setServerData", "625", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.web.con") + " " + server2.getName() + ".", throwable);
        }
        object2 = this.getBusListForServer(serverData);
        this.updateBusList(serverData, (List)object2);
        object = new LinkedList();
        if (webContainer != null) {
            EList eList2;
            Chain chain;
            int n4;
            EList eList3 = webContainer.getTransports();
            n = eList3.size();
            for (n4 = 0; n4 < n; ++n4) {
                applicationServer = (Transport)eList3.get(n4);
                string = applicationServer.getAddress();
                object.add(new TransportData(string.getHost(), string.getPort(), applicationServer.isSslEnabled()));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding  HTTPTransport -> " + string.getHost() + " " + string.getPort() + " " + applicationServer.isSslEnabled() + ".");
            }
            if (eList != null) {
                n4 = eList.size();
                for (int i = 0; i < n4; ++i) {
                    Object object3;
                    Object object4;
                    Object object5;
                    int n5;
                    EList eList4;
                    int n6;
                    boolean bl = false;
                    String string3 = null;
                    int n7 = 9080;
                    chain = (Chain)eList.get(i);
                    if (!chain.isEnable() || (n6 = (eList4 = chain.getTransportChannels()).size()) <= 1) continue;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    for (n5 = 0; n5 < n6; ++n5) {
                        object5 = (TransportChannel)eList4.get(n5);
                        if (object5 instanceof WebContainerInboundChannel) {
                            bl2 = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WebContainerInboundChannel exists.");
                            }
                        }
                        if (!(object5 instanceof HTTPTunnelInboundChannel)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HTTPTunnelInboundChannel exists.");
                        }
                        if ((object4 = object5.getProperties()) == null) continue;
                        object3 = object4.listIterator();
                        Properties properties = new Properties();
                        while (object3.hasNext()) {
                            Property property = (Property)object3.next();
                            if (property.getName().equals("pluginConfigurable")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Custom property pluginConfigurable: " + property.getValue());
                                }
                                if (!new Boolean(property.getValue()).booleanValue()) continue;
                                bl3 = true;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "HTTPTunnelInboundChannel configured.");
                                continue;
                            }
                            if (!property.getName().equals("addToBuses")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property addToBuses: " + property.getValue());
                            }
                            if (!new Boolean(property.getValue()).booleanValue()) continue;
                            bl4 = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "HTTPTunnelInboundChannel configured for the buses.");
                        }
                    }
                    if (!bl2 && !bl3 && !bl4) continue;
                    for (n5 = 0; n5 < n6; ++n5) {
                        object5 = (TransportChannel)eList4.get(n5);
                        if (object5 instanceof TCPInboundChannel && (object3 = this.getNamedEndPoint(serverData, (String)(object4 = ((TCPInboundChannel)object5).getEndPointName()))) != null) {
                            string3 = object3.getHost();
                            n7 = object3.getPort();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "TCPInboundChannel exists.  Host : " + string3 + " Port : " + n7 + ".");
                            }
                        }
                        if (!(object5 instanceof SSLInboundChannel)) continue;
                        bl = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "SSLInboundChannel exists.");
                    }
                    if (string3 != null) {
                        string3 = ConfigurationParser.substituteVariable(string3);
                        TransportData transportData = new TransportData(string3, n7, bl);
                        if (bl2) {
                            object.add(transportData);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "For the chain " + chain.getName() + " adding the transport -> " + string3 + " " + n7 + " " + bl + ".");
                            continue;
                        }
                        if (bl3) {
                            object5 = new LinkedList();
                            object5.add(transportData);
                            object4 = chain.getName() + "_" + serverData.nodeName + "_Cluster";
                            this.addServer((String)object4, chain.getName(), serverData.nodeName, this._cellName, TUNNEL_SERVER_TYPE, (List)object5);
                        }
                        if (!bl4) continue;
                        this.listSize = serverData.busList.size();
                        for (int j = 0; j < this.listSize; ++j) {
                            object4 = (String)serverData.busList.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding HTTPTunnelInbound chain to the bus " + (String)object4 + ".");
                            }
                            object3 = new LinkedList();
                            object3.add(transportData);
                            this.addServer((String)object4, chain.getName(), serverData.nodeName, this._cellName, BUS_SERVER_TYPE, (List)object3);
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Transport not added for the chain " + chain.getName() + ".");
                }
            }
            serverData.transports = object;
            EList eList5 = webContainer.getServices();
            int n8 = eList5.size();
            for (int i = 0; i < n8; ++i) {
                Object e2 = eList5.get(i);
                if (!(e2 instanceof SessionManager)) continue;
                SessionManager sessionManager = (SessionManager)e2;
                serverData.sessionManagerCookieName = sessionManager.getDefaultCookieSettings().getName();
                break;
            }
            if ((eList2 = webContainer.getProperties()) != null) {
                ListIterator listIterator = eList2.listIterator();
                Properties properties = new Properties();
                while (listIterator.hasNext()) {
                    chain = (Property)listIterator.next();
                    if (chain.getName().equals("HttpSessionCloneId")) {
                        serverData.serverID = chain.getValue();
                        continue;
                    }
                    if (chain.getName().equals("SessionRewriteIdentifier")) {
                        serverData.sessionURLIdentifier = chain.getValue();
                        continue;
                    }
                    if (chain.getName().equals("CloneSeparatorChange")) {
                        serverData.cloneSeparator = chain.getValue();
                        continue;
                    }
                    if (chain.getName().equals("fileServingEnabled")) {
                        serverData.fileServingEnabled = chain.getValue();
                        continue;
                    }
                    if (chain.getName().equals("com.ibm.ws.webcontainer.disallowAllFileServing")) {
                        serverData.disallowAllFileServing = chain.getValue();
                        continue;
                    }
                    if (!chain.getName().equals("serveServletsByClassnameEnabled")) continue;
                    serverData.serveServletsByClassnameEnabled = chain.getValue();
                }
            }
        }
        if (WORKPLACE_SERVER_TYPE.equals(serverData.serverType)) {
            serverData.transports = this.getLotusTransportList(serverData.nodeName, serverData.serverName);
        }
    }

    private void setServerType(ServerData serverData) throws PluginConfigException {
        serverData.serverType = ConfigurationParser.getServerType(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
    }

    private EndPoint getNamedEndPoint(ServerData serverData, String string) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting named end point for end point: " + string);
        }
        if (!string.equals("WC_adminhost") && !string.equals("WC_adminhost_secure")) {
            ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(this._appServerConfigRoot, serverData.cellName, serverData.nodeName);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerName().equals(serverData.serverName)) continue;
                EList eList2 = serverEntry.getSpecialEndpoints();
                for (int j = 0; j < eList2.size(); ++j) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                    if (!namedEndPoint.getEndPointName().equals(string)) continue;
                    return namedEndPoint.getEndPoint();
                }
            }
        }
        return null;
    }

    private void removeClusterServer(ServerClusterData serverClusterData, String string, String string2) {
        int n = serverClusterData.clusterServers.size();
        for (int i = 0; i < n; ++i) {
            ServerData serverData = (ServerData)serverClusterData.clusterServers.get(i);
            if (!serverData.serverName.equals(string) || !serverData.nodeName.equals(string2)) continue;
            serverClusterData.clusterServers.remove(i);
            return;
        }
    }

    private void setClusterDeployedModuleInfo(boolean bl) throws PluginConfigException {
        for (int i = 0; i < this.nbrOfClusters; ++i) {
            ServerClusterData serverClusterData = (ServerClusterData)this._clusters.get(i);
            int n = serverClusterData.clusterServers.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of servers " + n);
                Tr.debug(tc, "Setting deployed module info for servers on cluster: " + serverClusterData.clusterName);
            }
            if (n > 0) {
                ServerData serverData = (ServerData)serverClusterData.clusterServers.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got the serverData for the first server ");
                }
                if (!serverData.serverType.equals("APPLICATION_SERVER") && !serverData.serverType.equals("DEPLOYMENT_MANAGER")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server type is App Server ");
                }
                if (bl) {
                    Iterator iterator = serverClusterData.deployedModules.iterator();
                    while (iterator.hasNext()) {
                        DeployedModuleData deployedModuleData = (DeployedModuleData)iterator.next();
                        if (deployedModuleData.cookieName == null) {
                            deployedModuleData.cookieName = serverData.sessionManagerCookieName;
                        }
                        deployedModuleData.urlCookieName = serverData.sessionURLIdentifier;
                    }
                } else {
                    serverClusterData.deployedModules = this.getDeployedModules(serverData, serverClusterData.clusterName);
                }
                serverData.hostName = ConfigurationParser.substituteVariable(serverData.hostName);
                if (serverData.hostName == null || serverData.hostName.equals("") || serverData.hostName.equals("*") || serverData.hostName.equalsIgnoreCase("localhost")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hostname not set for the server " + serverData.hostName);
                    }
                } else {
                    this._siToHostName.put(serverData.cellName + serverData.nodeName, serverData.hostName);
                }
                if (n <= 0) continue;
                for (int j = 0; j < n; ++j) {
                    serverData = (ServerData)serverClusterData.clusterServers.get(j);
                    serverData.hostName = (String)this._siToHostName.get(serverData.cellName + serverData.nodeName);
                    serverData.hostName = ConfigurationParser.substituteVariable(serverData.hostName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Current host name " + serverData.hostName);
                    }
                    if (serverData.hostName != null && !serverData.hostName.equals("") && !serverData.hostName.equals("*") && !serverData.hostName.equalsIgnoreCase("localhost")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set the host name for " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName);
                    }
                    this.setHostName(serverData);
                    ConfigurationParser.substituteVariable(serverData.hostName);
                    this._siToHostName.put(serverData.cellName + serverData.nodeName, serverData.hostName);
                }
                continue;
            }
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("no.valid.servers.for.cluster") + " " + serverClusterData.clusterName + ".");
        }
    }

    private List getDeployedModules(ServerData serverData, String string) throws PluginConfigException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting deployed modules for server: " + serverData.serverName + " on node: " + serverData.nodeName);
            }
            Resource resource = null;
            Repository repository2 = null;
            ConfigRoot configRoot = null;
            try {
                repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
                configRoot = repository2.getConfigRoot();
                resource = configRoot.getResource(3, SERVERINDEX);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "709", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".", throwable);
            }
            _vMgr.setVariableMap(configRoot, 2);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            String string2 = serverIndex.getHostName();
            string2 = ConfigurationParser.substituteVariable(string2);
            serverData.hostName = string2.equals("") || string2.equals("*") || string2.equalsIgnoreCase("localhost") ? "localhost" : string2;
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerName().equals(serverData.serverName)) continue;
                EList eList2 = serverEntry.getDeployedApplications();
                EARFile eARFile = null;
                for (int j = 0; j < eList2.size(); ++j) {
                    try {
                        File file;
                        Object object;
                        configRoot.setValue(1, (String)eList2.get(j));
                        resource = configRoot.getResource(1, DEPLOYMENT_XML);
                        Deployment deployment = (Deployment)resource.getContents().get(0);
                        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                        String string3 = null;
                        if (applicationDeployment.isUseMetadataFromBinaries()) {
                            if (this._dmgrFound) {
                                boolean bl = false;
                                object = null;
                                File file2 = new File(configRoot.getAbsolutePath(1, ""));
                                if (file2.exists() && (file = file2.getParentFile().getParentFile()).exists()) {
                                    object = file.getAbsolutePath() + File.separator + file.getName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "The EAR File within repository " + (String)object);
                                    }
                                    bl = new File((String)object).exists();
                                }
                                if (bl) {
                                    string3 = object;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Use the ear location in the config repository");
                                        Tr.debug(tc, "URL is  " + string3);
                                    }
                                } else {
                                    string3 = configRoot.getAbsolutePath(1, "");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Use the ear location that matches the deployment.xml location");
                                        Tr.debug(tc, "URL is  " + string3);
                                    }
                                }
                            } else {
                                string3 = applicationDeployment.getBinariesURL();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Use the ear location from the binaries url");
                                    Tr.debug(tc, "Before substitution : " + string3);
                                }
                                string3 = _vMgr.substitute(string3);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "After substitution : " + string3);
                                }
                            }
                        } else {
                            string3 = configRoot.getAbsolutePath(1, "");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Use the ear location that matches the deployment.xml location");
                                Tr.debug(tc, "URL is  " + string3);
                            }
                        }
                        eARFile = ConfigurationParser.getEAR(string3);
                        if (eARFile == null) continue;
                        Application application = eARFile.getDeploymentDescriptor();
                        object = applicationDeployment.getModules();
                        for (int k = 0; k < object.size(); ++k) {
                            Object object2;
                            Object object3;
                            Object object4;
                            file = (ModuleDeployment)object.get(k);
                            Module module = file.getAltDD() != null ? application.getModuleHavingAltDD(file.getAltDD()) : application.getModule(file.getUri());
                            boolean bl = false;
                            EList eList3 = file.getTargetMappings();
                            Iterator iterator = eList3.iterator();
                            while (iterator.hasNext()) {
                                object4 = (DeploymentTargetMapping)iterator.next();
                                object3 = object4.getTarget().getName();
                                if (!((String)object3).equals(string) && !((String)object3).equals(serverData.serverName)) continue;
                                bl = true;
                            }
                            if (module == null || !bl) continue;
                            if (module.isWebModule()) {
                                object4 = applicationDeployment.getBinariesURL() + ":" + file.getUri();
                                object3 = this.getDeployedModule(arrayList, (String)object4);
                                boolean bl2 = false;
                                if (object3 == null) {
                                    object3 = new DeployedModuleData();
                                    bl2 = true;
                                }
                                ((DeployedModuleData)object3).moduleUri = object4;
                                object2 = this.getWebServicesUrlPatterns(eARFile, (List)object, module);
                                if (!object2.isEmpty()) {
                                    ((DeployedModuleData)object3).additionalPatterns = object2;
                                }
                                ((DeployedModuleData)object3).deployedApplication = applicationDeployment;
                                ((DeployedModuleData)object3).deployedModule = file;
                                ((DeployedModuleData)object3).moduleConfig = (WebModule)module;
                                ((DeployedModuleData)object3).deploymentDescriptor = (WebApp)eARFile.getDeploymentDescriptor(module);
                                ((DeployedModuleData)object3).moduleBindings = (WebAppBinding)eARFile.getBindings(module);
                                ((DeployedModuleData)object3).moduleExtensions = (WebAppExtension)eARFile.getExtensions(module);
                                ((DeployedModuleData)object3).cookieName = this.getAppCookieName((WebModuleDeployment)file, serverEntry.getServerName());
                                if (((DeployedModuleData)object3).cookieName == null) {
                                    ((DeployedModuleData)object3).cookieName = this.getAppCookieName((WebModuleDeployment)file, string);
                                }
                                if (((DeployedModuleData)object3).cookieName == null) {
                                    ((DeployedModuleData)object3).cookieName = serverData.sessionManagerCookieName;
                                }
                                ((DeployedModuleData)object3).urlCookieName = serverData.sessionURLIdentifier;
                                ModuleRef moduleRef = (ModuleRef)eARFile.getModuleRef(module);
                                if (moduleRef != null) {
                                    ((DeployedModuleData)object3).portletApp = this.getPortletApp(moduleRef);
                                    if (((DeployedModuleData)object3).portletApp != null) {
                                        ((DeployedModuleData)object3).portletServingEnabled = this.isPortletServingEnabled(moduleRef);
                                    }
                                }
                                if (bl2) {
                                    arrayList.add(object3);
                                    if (tc.isDebugEnabled()) {
                                        ((DeployedModuleData)object3).print(tc);
                                    }
                                }
                                this.addVirtualHostName((DeployedModuleData)object3);
                                continue;
                            }
                            if (!module.isEjbModule()) continue;
                            object4 = this.getRouterModuleName(eARFile, (EjbModule)module);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Router module name is " + (String)object4);
                            }
                            if (object4 == null || (object3 = this.getWebServicesUrlPatterns(eARFile, (List)object, module)).isEmpty()) continue;
                            String string4 = applicationDeployment.getBinariesURL() + ":" + (String)object4;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "EJB Uri is " + string4);
                            }
                            object2 = this.getDeployedModule(arrayList, string4);
                            boolean bl3 = false;
                            if (object2 == null) {
                                object2 = new DeployedModuleData();
                                bl3 = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "First time EJB being added");
                                }
                            }
                            ((DeployedModuleData)object2).additionalPatterns = object3;
                            ((DeployedModuleData)object2).moduleUri = string4;
                            if (bl3) {
                                arrayList.add(object2);
                                if (tc.isDebugEnabled()) {
                                    ((DeployedModuleData)object2).print(tc);
                                }
                            }
                            this.addVirtualHostName((DeployedModuleData)object2);
                        }
                        eARFile.close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "770", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error when reading the application " + eList2.get(j));
                        }
                        System.out.println();
                        System.out.println(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".");
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "771", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".", throwable);
        }
        return arrayList;
    }

    private PortletApplication getPortletApp(ModuleRef moduleRef) {
        PortletApplication portletApplication;
        block8: {
            portletApplication = null;
            try {
                Resource resource = moduleRef.getModuleFile().getMofResource("WEB-INF/portlet.xml");
                if (resource != null) {
                    portletApplication = ((PortletApplicationResource)resource).getPortletApplication();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Module is a portlet application.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource WEB-INF/portlet.xml is not available");
                }
            }
            catch (ResourceLoadException resourceLoadException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received the exception : " + resourceLoadException.toString());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Module is NOT a portlet application. Received exception : " + exception.toString());
            }
        }
        return portletApplication;
    }

    private Boolean isPortletServingEnabled(ModuleRef moduleRef) {
        Boolean bl;
        block9: {
            bl = Boolean.TRUE;
            try {
                Resource resource = moduleRef.getModuleFile().getMofResource("WEB-INF/ibm-portlet-ext.xmi");
                if (resource != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The resource WEB-INF/ibm-portlet-ext.xmi is available.");
                    }
                    PortletApplicationExtension portletApplicationExtension = (PortletApplicationExtension)resource.getContents().get(0);
                    bl = new Boolean(portletApplicationExtension.isPortletServingEnabled());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Portlet serving is " + bl);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The resource WEB-INF/ibm-portlet-ext.xmi is not available.");
                }
            }
            catch (ResourceLoadException resourceLoadException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received the exception : " + resourceLoadException.toString());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Resource WEB-INF/ibm-portlet-ext.xmi is not available. Received exception : " + exception.toString());
            }
        }
        return bl;
    }

    private void setHostName(ServerData serverData) throws PluginConfigException {
        try {
            ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(this._appServerConfigRoot, serverData.cellName, serverData.nodeName);
            String string = serverIndex.getHostName();
            string = ConfigurationParser.substituteVariable(string);
            serverData.hostName = string.equals("") || string.equals("*") || string.equalsIgnoreCase("localhost") ? "localhost" : string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting host name for server: " + serverData.serverName + " to " + serverData.hostName);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setHostName", "771", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + serverData.cellName + "." + serverData.nodeName + "." + serverData.serverName + ".", throwable);
        }
    }

    private String getAppCookieName(WebModuleDeployment webModuleDeployment, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting the app cookie name");
        }
        String string2 = null;
        EList eList = webModuleDeployment.getTargetMappings();
        boolean bl = false;
        WebModuleConfig webModuleConfig = (WebModuleConfig)this.getConfig((List)eList, string);
        if (webModuleConfig != null) {
            if (webModuleConfig.getSessionManagement() != null) {
                bl = webModuleConfig.getSessionManagement().isEnable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Over-ride session management :" + bl);
                }
                if (bl) {
                    return webModuleConfig.getSessionManagement().getDefaultCookieSettings().getName();
                }
            }
        } else {
            ApplicationDeployment applicationDeployment = webModuleDeployment.getApplicationDeployment();
            eList = applicationDeployment.getTargetMappings();
            ApplicationConfig applicationConfig = (ApplicationConfig)this.getConfig((List)eList, string);
            if (applicationConfig != null && applicationConfig.getSessionManagement() != null) {
                bl = applicationConfig.getSessionManagement().isEnable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Over-ride session management :" + bl);
                }
                if (bl) {
                    return applicationConfig.getSessionManagement().getDefaultCookieSettings().getName();
                }
            }
        }
        return string2;
    }

    private void setVHosts() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the Virtual Hosts");
        }
        for (int i = 0; i < this._foundCells.size(); ++i) {
            Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, (String)this._foundCells.get(i), null, null);
            try {
                this.addVirtualHost(repository2.getConfigRoot().getResource(0, VIRTUALHOST));
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setVHosts", "865", this);
            }
        }
    }

    private void addVirtualHost(Resource resource) {
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            this._vHosts.add(eList.get(i));
        }
    }

    private void addVirtualHostName(DeployedModuleData deployedModuleData) {
        String string;
        if (deployedModuleData.moduleBindings != null && this._vHostNames.indexOf(string = deployedModuleData.moduleBindings.getVirtualHostName()) < 0) {
            this._vHostNames.add(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the Virtual Host name: " + string);
            }
        }
    }

    private DeployedObjectConfig getConfig(List list, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting config for server: " + string);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)iterator.next();
            if (deploymentTargetMapping == null) continue;
            DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
            String string2 = null;
            if (deploymentTarget != null) {
                string2 = deploymentTarget.getName();
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return deploymentTargetMapping.getConfig();
        }
        return null;
    }

    private DeployedModuleData getDeployedModule(List list, String string) {
        DeployedModuleData deployedModuleData = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DeployedModuleData deployedModuleData2 = (DeployedModuleData)iterator.next();
            if (!deployedModuleData2.moduleUri.equals(string)) continue;
            deployedModuleData = deployedModuleData2;
            break;
        }
        return deployedModuleData;
    }

    private Class getPluginCfgHelperClass() throws PluginConfigException {
        if (this.pluginCfgHelperClass == null) {
            try {
                this.pluginCfgHelperClass = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPluginCfgHelperClass", "1337", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.loading.plugincfghelper"), classNotFoundException);
            }
        }
        return this.pluginCfgHelperClass;
    }

    private String getRouterModuleName(EARFile eARFile, EjbModule ejbModule) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting router module name");
        }
        String string = null;
        try {
            Class clazz = this.getPluginCfgHelperClass();
            Class[] classArray = new Class[]{EARFile.class, EjbModule.class};
            Method method2 = clazz.getMethod("getRouterModuleName", classArray);
            string = (String)method2.invoke(null, eARFile, ejbModule);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getRouterModuleName", "1341", this);
            System.out.println(PluginConfigGenerator.nls.getString("error.reading.routermodule"));
        }
        return string;
    }

    private List getWebServicesUrlPatterns(EARFile eARFile, List list, Module module) throws PluginConfigException {
        List list2 = new ArrayList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting web services url patters");
        }
        try {
            Class clazz = this.getPluginCfgHelperClass();
            Class[] classArray = new Class[]{EARFile.class, List.class, Module.class};
            Method method2 = clazz.getMethod("getWebServicesUrlPatterns", classArray);
            list2 = (List)method2.invoke(null, eARFile, list, module);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getWebServicesUrlPatterns", "1359", this);
            System.out.println(PluginConfigGenerator.nls.getString("error.getting.urlpatterns"));
        }
        return list2;
    }

    private Class getLotusCfgHelperClass() {
        block3: {
            if (this.lotusCfgHelperClass == null) {
                try {
                    this.lotusCfgHelperClass = Class.forName("com.ibm.wkplc.generator.LotusCfgHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!PluginConfigGenerator._debugEnabled) break block3;
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("error.loading.lotuscfghelper"));
                }
            }
        }
        return this.lotusCfgHelperClass;
    }

    private void getLotusCfgHelper() {
        if (this.lotusCfgHelper == null) {
            try {
                Class clazz = this.getLotusCfgHelperClass();
                Class[] classArray = new Class[]{String.class, String.class, String.class, Boolean.class};
                if (clazz != null) {
                    Method method2 = clazz.getMethod("getInstance", classArray);
                    this.lotusCfgHelper = (PluginConfigHelperIntf)method2.invoke(null, this._appServerRoot, this._appServerConfigRoot, this._cellName, new Boolean(PluginConfigGenerator._debugEnabled));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusCfgHelper", "1748", this);
                if (PluginConfigGenerator._debugEnabled) {
                    exception.printStackTrace();
                    System.out.println("Exception is " + exception.toString());
                }
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("error.loading.lotuscfghelper"));
            }
        }
    }

    private void readLotusConfiguration() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading the Lotus configuration");
        }
        List list = null;
        try {
            this.getLotusCfgHelper();
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getClusterList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServerClusterData serverClusterData = (ServerClusterData)iterator.next();
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("gen.for.cluster") + " " + serverClusterData.clusterName + ".");
                    this._clusters.add(serverClusterData);
                    ++this.nbrOfClusters;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.readLotusConfiguration", "1756", this);
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("error.reading.lotusclusters"));
        }
    }

    private Class getTunnelCfgHelperClass() throws PluginConfigException {
        if (this.tunnelCfgHelperClass == null) {
            try {
                this.tunnelCfgHelperClass = Class.forName("com.ibm.ws.httptunnel.channel.WSHttpTunnelPluginConfigHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("error.loading.tunnelcfghelper"));
            }
        }
        return this.tunnelCfgHelperClass;
    }

    private void setConfigFileComment(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the config file comment");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss a zzz", Locale.US);
        Date date = new Date();
        this._configFileComment = bl ? "HTTP server plugin config file for the webserver " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + " generated on " + simpleDateFormat.format(date) : "HTTP server plugin config file for the cell " + this._cellName + " generated on " + simpleDateFormat.format(date);
    }

    private void readPluginProperties() throws PluginConfigException {
        PluginProperties pluginProperties = ConfigurationParser.getPluginProperties(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._webserverName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading the plugin properties");
        }
        if (pluginProperties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Plugin properties not found in the repository. Default used");
            }
            this._pluginConfigData.LogFile = this._appServerRoot + this._pluginConfigData.FileSeparator + "logs" + this._pluginConfigData.FileSeparator + this._webserverName + this._pluginConfigData.FileSeparator + "http_plugin.log";
            this._pluginConfigData.PluginInstallRoot = this._appServerRoot + this._pluginConfigData.FileSeparator;
            this._pluginConfigData.KeyringLocation = this._pluginConfigData.PluginInstallRoot + "etc" + this._pluginConfigData.FileSeparator + "plugin-key.kdb";
            this._pluginConfigData.StashfileLocation = this._pluginConfigData.PluginInstallRoot + "etc" + this._pluginConfigData.FileSeparator + "plugin-key.sth";
            this._pluginConfigData.FIPSEnable = ConfigurationParser.isFIPSEnabled(this._appServerConfigRoot, this._cellName);
            this._pluginConfigData.ESIEnableToPassCookies = new Boolean("false");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Plugin properties found in the repository");
            }
            try {
                File file;
                String string;
                Object object;
                Object object2;
                PluginMethodKind pluginMethodKind;
                PluginMethodKind pluginMethodKind2;
                block69: {
                    LogLevelKind logLevelKind;
                    String string2;
                    block68: {
                        Repository repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._webserverName);
                        ConfigRoot configRoot = repository2.getConfigRoot();
                        _vMgr.setVariableMap(configRoot, 2);
                        String string3 = ConfigurationParser.getNodePlatform(this._appServerConfigRoot, this._cellName, this._nodeNameList);
                        boolean bl = ConfigurationParser.isIHSWebServer(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._webserverName);
                        string2 = ConfigurationParser.getDefaultPluginInstallRoot(string3, bl);
                        if (string3.equals("os390")) {
                            string2 = this._appServerRoot;
                            int n = this._appServerConfigRoot.indexOf(CONFIGDIR, 0);
                            if (n > 0) {
                                string2 = this._appServerConfigRoot.substring(0, n - 1);
                            }
                        }
                        PortPreferenceKind portPreferenceKind = pluginProperties.getAppServerPortPreference();
                        PluginPriorityKind pluginPriorityKind = pluginProperties.getIISPluginPriority();
                        logLevelKind = pluginProperties.getLogLevel();
                        pluginMethodKind2 = pluginProperties.getPluginGeneration();
                        pluginMethodKind = pluginProperties.getPluginPropagation();
                        this._pluginConfigData.RefreshInterval = new Integer(pluginProperties.getRefreshInterval());
                        this._pluginConfigData.IgnoreDNSFailures = new Boolean(pluginProperties.isIgnoreDNSFailures());
                        this._pluginConfigData.ResponseChunkSize = new Integer(pluginProperties.getResponseChunkSize());
                        this._pluginConfigData.ASDisableNagle = new Boolean(pluginProperties.isASDisableNagle());
                        this._pluginConfigData.IISDisableNagle = new Boolean(pluginProperties.isIISDisableNagle());
                        this._pluginConfigData.FIPSEnable = ConfigurationParser.isFIPSEnabled(this._appServerConfigRoot, this._cellName);
                        this._pluginConfigData.AcceptAllContent = new Boolean(pluginProperties.isAcceptAllContent());
                        this._pluginConfigData.VHostMatchingCompat = new Boolean(pluginProperties.isVHostMatchingCompat());
                        this._pluginConfigData.AppServerPortPreference = portPreferenceKind.getValue() == 1 ? "HostHeader" : "WebserverPort";
                        this._pluginConfigData.ChunkedResponse = new Boolean(pluginProperties.isChunkedResponse());
                        switch (pluginPriorityKind.getValue()) {
                            case 0: {
                                this._pluginConfigData.IISPluginPriority = "High";
                                break;
                            }
                            case 1: {
                                this._pluginConfigData.IISPluginPriority = "Medium";
                                break;
                            }
                            case 2: {
                                this._pluginConfigData.IISPluginPriority = "low";
                                break;
                            }
                            default: {
                                this._pluginConfigData.IISPluginPriority = "High";
                            }
                        }
                        try {
                            this._pluginConfigData.FileSeparator = ConfigurationParser.getFileSeparator(this._appServerConfigRoot, this._cellName, this._nodeNameList);
                        }
                        catch (AdminException adminException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unable to get the file separator for the webserver. default is used.");
                            }
                            this._pluginConfigData.FileSeparator = File.separator;
                        }
                        String string4 = pluginProperties.getLogFilename();
                        try {
                            this._pluginConfigData.LogFile = _vMgr.substitute(string4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this._pluginConfigData.LogFile = string2 + this._pluginConfigData.FileSeparator + "logs" + this._pluginConfigData.FileSeparator + this._webserverName + this._pluginConfigData.FileSeparator + "http_plugin.log";
                            if (!tc.isDebugEnabled()) break block68;
                            Tr.debug(tc, "Using the default plugin install root");
                        }
                    }
                    switch (logLevelKind.getValue()) {
                        case 3: {
                            this._pluginConfigData.LogLevel = "Error";
                            break;
                        }
                        case 2: {
                            this._pluginConfigData.LogLevel = "Warn";
                            break;
                        }
                        case 1: {
                            this._pluginConfigData.LogLevel = "Stats";
                            break;
                        }
                        case 5: {
                            this._pluginConfigData.LogLevel = "Detail";
                            break;
                        }
                        case 4: {
                            this._pluginConfigData.LogLevel = "Debug";
                            break;
                        }
                        case 0: {
                            this._pluginConfigData.LogLevel = "Trace";
                            break;
                        }
                        default: {
                            this._pluginConfigData.LogLevel = "Error";
                        }
                    }
                    this._pluginConfigData.ESIEnable = new Boolean(pluginProperties.isESIEnable());
                    this._pluginConfigData.ESIMaxCacheSize = new Integer(pluginProperties.getESIMaxCacheSize());
                    this._pluginConfigData.ESIInvalidationMonitor = new Boolean(pluginProperties.isESIInvalidationMonitor());
                    String string5 = pluginProperties.getPluginInstallRoot() + this._pluginConfigData.FileSeparator;
                    try {
                        this._pluginConfigData.PluginInstallRoot = _vMgr.substitute(string5);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this._pluginConfigData.PluginInstallRoot = string2;
                        if (!tc.isDebugEnabled()) break block69;
                        Tr.debug(tc, "Using the default plugin install root");
                    }
                }
                this._pluginConfigData.PluginConfigFileName = pluginProperties.getConfigFilename();
                this._pluginConfigData.AutoGenerate = pluginMethodKind2.getValue() == 1 ? Boolean.FALSE : Boolean.TRUE;
                this._pluginConfigData.AutoPropagate = pluginMethodKind.getValue() == 1 ? Boolean.FALSE : Boolean.TRUE;
                PluginServerClusterProperties pluginServerClusterProperties = pluginProperties.getPluginServerClusterProperties();
                LoadBalanceKind loadBalanceKind = pluginServerClusterProperties.getLoadBalance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LoadbalanceKind -->" + loadBalanceKind.getValue());
                    Tr.debug(tc, "Log file name after substitution : " + this._pluginConfigData.LogFile);
                    Tr.debug(tc, "Plugin install root after substitution : " + this._pluginConfigData.PluginInstallRoot);
                }
                this._pluginConfigData.loadBalance = loadBalanceKind.getValue() == 0 ? "Round Robin" : "Random";
                this._pluginConfigData.retryInterval = new Integer(pluginServerClusterProperties.getRetryInterval());
                this._pluginConfigData.removeSpecialHeaders = new Boolean(pluginServerClusterProperties.isRemoveSpecialHeaders());
                this._pluginConfigData.cloneSeparatorChange = new Boolean(pluginServerClusterProperties.isCloneSeparatorChange());
                this._pluginConfigData.postSizeLimit = new Integer(pluginServerClusterProperties.getPostSizeLimit());
                this._pluginConfigData.postBufferSize = new Integer(pluginServerClusterProperties.getPostBufferSize());
                EList eList = pluginProperties.getProperties();
                if (eList != null) {
                    object2 = eList.listIterator();
                    while (object2.hasNext()) {
                        object = (Property)object2.next();
                        if (object.getName().equals("KeyringLocation")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property KeyringLocation: " + object.getValue());
                            }
                            this._pluginConfigData.KeyringLocation = object.getValue();
                            continue;
                        }
                        if (object.getName().equals("StashfileLocation")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property StashfileLocation: " + object.getValue());
                            }
                            this._pluginConfigData.StashfileLocation = object.getValue();
                            continue;
                        }
                        if (object.getName().equals("ServerIOTimeout")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property ServerIOTimeout: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.serverIOTimeout = new Integer(object.getValue());
                            continue;
                        }
                        if (object.getName().equals("PostBufferSize")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property PostBufferSize: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.postBufferSize = new Integer(object.getValue());
                            continue;
                        }
                        if (object.getName().equals("GetDWLMTable")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property GetDWLMTable: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.GetDWLMTable = new Boolean(object.getValue());
                            continue;
                        }
                        if (object.getName().equals("HTTPMaxHeaders")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property HTTPMaxHeaders: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.HTTPMaxHeaders = new Integer(object.getValue());
                            continue;
                        }
                        if (object.getName().equals("IgnoreAffinityRequests")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property IgnoreAffinityRequests: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.ignoreAffinityRequests = new Boolean(object.getValue());
                            continue;
                        }
                        if (object.getName().equals("CertLabel")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property CertLabel: " + object.getValue());
                            }
                            this._pluginConfigData.CertLabel = object.getValue();
                            continue;
                        }
                        if (object.getName().equalsIgnoreCase("esiEnableToPassCookies")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property esiEnableToPassCookies: " + object.getValue());
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.ESIEnableToPassCookies = new Boolean(object.getValue());
                            continue;
                        }
                        if (object.getName().equalsIgnoreCase("SSLPKCSDriver")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property SSLPKCSDriver: " + object.getValue());
                            }
                            this._pluginConfigData.SSLPKCSDriver = object.getValue();
                            continue;
                        }
                        if (object.getName().equalsIgnoreCase("SSLPKCSPassword")) {
                            this._pluginConfigData.SSLPKCSPassword = object.getValue();
                            continue;
                        }
                        if (object.getName().equalsIgnoreCase("SSLConsolidate")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property SSLConsolidate: " + new Boolean(object.getValue()));
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.SSLConsolidate = new Boolean(object.getValue());
                            continue;
                        }
                        if (object.getName().equalsIgnoreCase("TrustedProxyEnable")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom property TrustedProxyEnable: " + new Boolean(object.getValue()));
                            }
                            if (object.getValue().trim() == "") continue;
                            this._pluginConfigData.TrustedProxyEnable = new Boolean(object.getValue());
                            continue;
                        }
                        if (!object.getName().equalsIgnoreCase("TrustedProxyList")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Custom property TrustedProxyList: " + object.getValue());
                        }
                        if (object.getValue().trim() == "") continue;
                        this._pluginConfigData.TrustedProxyList = object.getValue();
                    }
                }
                if (this._pluginConfigData.KeyringLocation == null || this._pluginConfigData.KeyringLocation.trim() == "") {
                    int n;
                    object2 = pluginProperties.getKeyRingFilename();
                    object = pluginProperties.getRemoteKeyRingFilename();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Plugin KeyRing File name : " + (String)object2 + " Remote keyring file name : " + (String)object);
                    }
                    if ((n = ((String)object2).lastIndexOf(this._pluginConfigData.FileSeparator)) >= 0) {
                        this._pluginConfigData.KeyringLocation = object2;
                    } else {
                        this._pluginConfigData.KeyringLocation = object;
                        if (this._pluginConfigData.KeyringLocation == null || this._pluginConfigData.KeyringLocation.trim() == "") {
                            this._pluginConfigData.KeyringLocation = ConfigurationParser.isNodeVersion60(this._appServerConfigRoot, this._cellName, this._nodeNameList) ? this._pluginConfigData.PluginInstallRoot + "etc" + this._pluginConfigData.FileSeparator + (String)object2 : this._pluginConfigData.PluginInstallRoot + CONFIGDIR + this._pluginConfigData.FileSeparator + this._webserverName + this._pluginConfigData.FileSeparator + (String)object2;
                        }
                    }
                }
                if (this._pluginConfigData.StashfileLocation == null || this._pluginConfigData.StashfileLocation.trim() == "") {
                    int n = this._pluginConfigData.KeyringLocation.lastIndexOf(".");
                    this._pluginConfigData.StashfileLocation = n > 0 ? this._pluginConfigData.KeyringLocation.substring(0, n) + ".sth" : this._pluginConfigData.KeyringLocation + ".sth";
                }
                boolean bl = ConfigurationParser.isNodeLocal(this._appServerConfigRoot, this._cellName, this._nodeNameList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is webserver local: " + bl);
                }
                if (bl && (string = ((File)(object = new File(this._pluginConfigData.LogFile))).getParent()) != null && !(file = new File(string)).exists()) {
                    file.mkdirs();
                    PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                    if (platformHelper.isOS400()) {
                        PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QTMHHTTP", "*RWX");
                        PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QNOTES", "*RWX");
                        PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QEJBSVR", "*RWX");
                    }
                }
            }
            catch (Throwable throwable) {
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.server") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".", throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            this._pluginConfigData.print(tc);
        }
    }

    private void parseDeployedModules() throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing the deployed modules");
        }
        try {
            Resource resource = null;
            Repository repository2 = null;
            ConfigRoot configRoot = null;
            try {
                repository2 = RepositoryFactory.createRepository(this._appServerConfigRoot, this._cellName, this._nodeNameList, this._webserverName);
                configRoot = repository2.getConfigRoot();
                resource = configRoot.getResource(3, SERVERINDEX);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.parseDeployedApplications", "709", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".", throwable);
            }
            ConfigRoot configRoot2 = ConfigurationParser.getFirstAppServerConfigRoot(this._appServerConfigRoot, this._cellName);
            if (configRoot2 == null) {
                configRoot2 = configRoot;
            }
            _vMgr.setVariableMap(configRoot2, 2);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerName().equals(this._webserverName)) continue;
                EList eList2 = serverEntry.getDeployedApplications();
                EARFile eARFile = null;
                if (eList2.size() == 0) {
                    System.out.println();
                    System.out.println(PluginConfigGenerator.nls.getString("webserver.noapplications"));
                    continue;
                }
                for (int j = 0; j < eList2.size(); ++j) {
                    try {
                        File file;
                        Object object;
                        configRoot.setValue(1, (String)eList2.get(j));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Application location: " + eList2.get(j));
                        }
                        resource = configRoot.getResource(1, DEPLOYMENT_XML);
                        Deployment deployment = (Deployment)resource.getContents().get(0);
                        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                        String string = null;
                        if (applicationDeployment.isUseMetadataFromBinaries()) {
                            if (this._dmgrFound) {
                                boolean bl = false;
                                object = null;
                                File file2 = new File(configRoot.getAbsolutePath(1, ""));
                                if (file2.exists() && (file = file2.getParentFile().getParentFile()).exists()) {
                                    object = file.getAbsolutePath() + File.separator + file.getName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "The EAR File within repository " + (String)object);
                                    }
                                    bl = new File((String)object).exists();
                                }
                                if (bl) {
                                    string = object;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Use the ear location in the config repository");
                                        Tr.debug(tc, "URL is  " + string);
                                    }
                                } else {
                                    string = configRoot.getAbsolutePath(1, "");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Use the ear location that matches the deployment.xml location");
                                        Tr.debug(tc, "URL is  " + string);
                                    }
                                }
                            } else {
                                string = applicationDeployment.getBinariesURL();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Use the ear location from the binaries url");
                                    Tr.debug(tc, "Before substitution : " + string);
                                }
                                string = _vMgr.substitute(string);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "After substitution : " + string);
                                }
                            }
                        } else {
                            string = configRoot.getAbsolutePath(1, "");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Use the ear location that matches the deployment.xml location");
                                Tr.debug(tc, "URL is  " + string);
                            }
                        }
                        eARFile = ConfigurationParser.getEAR(string);
                        if (eARFile == null) continue;
                        Application application = eARFile.getDeploymentDescriptor();
                        object = applicationDeployment.getModules();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Number of deployed modules: " + object.size());
                        }
                        for (int k = 0; k < object.size(); ++k) {
                            Object object2;
                            String string2;
                            Module module;
                            file = (ModuleDeployment)object.get(k);
                            Module module2 = module = file.getAltDD() != null ? application.getModuleHavingAltDD(file.getAltDD()) : application.getModule(file.getUri());
                            if (module == null) continue;
                            DeployedModuleData deployedModuleData = new DeployedModuleData();
                            if (module.isWebModule()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "It is a web module ");
                                }
                                deployedModuleData.moduleUri = string2 = applicationDeployment.getBinariesURL() + ":" + file.getUri();
                                List list = this.getWebServicesUrlPatterns(eARFile, (List)object, module);
                                if (!list.isEmpty()) {
                                    deployedModuleData.additionalPatterns = list;
                                }
                                deployedModuleData.deployedApplication = applicationDeployment;
                                deployedModuleData.deployedModule = file;
                                deployedModuleData.moduleConfig = (WebModule)module;
                                deployedModuleData.deploymentDescriptor = (WebApp)eARFile.getDeploymentDescriptor(module);
                                deployedModuleData.moduleBindings = (WebAppBinding)eARFile.getBindings(module);
                                deployedModuleData.moduleExtensions = (WebAppExtension)eARFile.getExtensions(module);
                                object2 = (ModuleRef)eARFile.getModuleRef(module);
                                if (object2 != null) {
                                    deployedModuleData.portletApp = this.getPortletApp((ModuleRef)object2);
                                    if (deployedModuleData.portletApp != null) {
                                        deployedModuleData.portletServingEnabled = this.isPortletServingEnabled((ModuleRef)object2);
                                    }
                                }
                            } else if (module.isEjbModule()) {
                                List list;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "It is a ejb module ");
                                }
                                string2 = this.getRouterModuleName(eARFile, (EjbModule)module);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Router module name: " + string2);
                                }
                                if (string2 != null && !(list = this.getWebServicesUrlPatterns(eARFile, (List)object, module)).isEmpty()) {
                                    object2 = applicationDeployment.getBinariesURL() + ":" + string2;
                                    deployedModuleData.additionalPatterns = list;
                                    deployedModuleData.moduleUri = object2;
                                }
                            }
                            if (deployedModuleData.moduleUri != null) {
                                String string3;
                                String string4;
                                Object object3;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Deployed module URI is available");
                                }
                                string2 = file.getTargetMappings();
                                boolean bl = false;
                                object2 = string2.iterator();
                                while (object2.hasNext()) {
                                    object3 = (DeploymentTargetMapping)object2.next();
                                    if (!(object3.getTarget() instanceof ServerTarget)) continue;
                                    string4 = object3.getTarget().getName();
                                    string3 = ((ServerTarget)object3.getTarget()).getNodeName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Target name : " + string4 + " Node name : " + string3);
                                    }
                                    if (!string3.equals(this._nodeNameList) || !string4.equals(this._webserverName)) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "The webserver " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + " is mapped to the module " + deployedModuleData.moduleUri);
                                    }
                                    object3 = string2.iterator();
                                    while (object3.hasNext()) {
                                        string4 = (DeploymentTargetMapping)object3.next();
                                        string3 = string4.getTarget().getName();
                                        if (string4.getTarget() instanceof ClusteredTarget) {
                                            this.addDeployedModuleToCluster(string3, deployedModuleData);
                                            continue;
                                        }
                                        this.addDeployedModuleToSingleServer(string3, ((ServerTarget)string4.getTarget()).getNodeName(), deployedModuleData);
                                    }
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "The webserver " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + " is not mapped to the module " + deployedModuleData.moduleUri);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skipping the deployed module since URI is not available");
                        }
                        eARFile.close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "2220", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error when reading the application " + eList2.get(j));
                        }
                        System.out.println();
                        System.out.println(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".");
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.parseDeployedModules", "2225", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".", throwable);
        }
    }

    private void addDeployedModuleToCluster(String string, DeployedModuleData deployedModuleData) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding deployed module to cluster: " + string);
        }
        try {
            String string2 = string;
            boolean bl = this.addDeployedModule(string2, string, deployedModuleData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeployedModule added " + bl);
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the cluster defintion ");
                }
                this.readClusterConfiguration(string2, this._cellName);
                bl = this.addDeployedModule(string2, string, deployedModuleData);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DeployedModule added " + bl);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.parseDeployedModules", "2225", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".", throwable);
        }
    }

    private void addDeployedModuleToSingleServer(String string, String string2, DeployedModuleData deployedModuleData) throws PluginConfigException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding deployed module to Single server. Target: " + string + " nodeName: " + string2);
        }
        try {
            String string3 = ConfigurationParser.getServerType(this._appServerConfigRoot, this._cellName, string2, string);
            if (WEB_SERVER_TYPE.equals(string3)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target " + this._cellName + "." + string2 + "." + string + "is a webserver.");
                }
            } else {
                String string4 = string + "_" + string2 + "_Cluster";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Revised target name: " + string4);
                }
                boolean bl = this.addDeployedModule(string4, string, deployedModuleData);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DeployedModule added " + bl);
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the single server defintion ");
                    }
                    this.addServer(string, string2, this._cellName, null);
                    bl = this.addDeployedModule(string4, string, deployedModuleData);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DeployedModule added " + bl);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.parseDeployedModules", "2225", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + this._cellName + "." + this._nodeNameList + "." + this._webserverName + ".", throwable);
        }
    }

    private boolean addDeployedModule(String string, String string2, DeployedModuleData deployedModuleData) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether the cluster " + string + " exists.");
            Tr.debug(tc, "Number of existing ServerClusters: " + this.nbrOfClusters);
            Tr.debug(tc, "Deployed Module URI:" + deployedModuleData.moduleUri);
        }
        for (int i = 0; i < this.nbrOfClusters; ++i) {
            DeployedModuleData deployedModuleData2;
            ServerClusterData serverClusterData = (ServerClusterData)this._clusters.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the ServerCluster " + serverClusterData.clusterName);
            }
            if (!serverClusterData.clusterName.equals(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a match");
            }
            if ((deployedModuleData2 = this.getDeployedModule(serverClusterData.deployedModules, deployedModuleData.moduleUri)) == null) {
                deployedModuleData2 = new DeployedModuleData();
                deployedModuleData2.deployedApplication = deployedModuleData.deployedApplication;
                deployedModuleData2.deployedModule = deployedModuleData.deployedModule;
                deployedModuleData2.deploymentDescriptor = deployedModuleData.deploymentDescriptor;
                deployedModuleData2.moduleConfig = deployedModuleData.moduleConfig;
                deployedModuleData2.moduleExtensions = deployedModuleData.moduleExtensions;
                deployedModuleData2.moduleBindings = deployedModuleData.moduleBindings;
                deployedModuleData2.cookieName = deployedModuleData.cookieName;
                deployedModuleData2.urlCookieName = deployedModuleData.urlCookieName;
                deployedModuleData2.moduleUri = deployedModuleData.moduleUri;
                deployedModuleData2.additionalPatterns = deployedModuleData.additionalPatterns;
                deployedModuleData2.portletApp = deployedModuleData.portletApp;
                deployedModuleData2.portletServingEnabled = deployedModuleData.portletServingEnabled;
                if (deployedModuleData2.deployedModule != null) {
                    deployedModuleData2.cookieName = this.getAppCookieName((WebModuleDeployment)deployedModuleData2.deployedModule, string2);
                }
                serverClusterData.deployedModules.add(deployedModuleData2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the module to the ServerCluster");
                }
            } else {
                if (deployedModuleData.deployedApplication != null) {
                    deployedModuleData2.deployedApplication = deployedModuleData.deployedApplication;
                }
                if (deployedModuleData.deployedModule != null) {
                    deployedModuleData2.deployedModule = deployedModuleData.deployedModule;
                }
                if (deployedModuleData.deploymentDescriptor != null) {
                    deployedModuleData2.deploymentDescriptor = deployedModuleData.deploymentDescriptor;
                }
                if (deployedModuleData.moduleConfig != null) {
                    deployedModuleData2.moduleConfig = deployedModuleData.moduleConfig;
                }
                if (deployedModuleData.moduleExtensions != null) {
                    deployedModuleData2.moduleExtensions = deployedModuleData.moduleExtensions;
                }
                if (deployedModuleData.moduleBindings != null) {
                    deployedModuleData2.moduleBindings = deployedModuleData.moduleBindings;
                }
                if (deployedModuleData.cookieName != null) {
                    deployedModuleData2.cookieName = deployedModuleData.cookieName;
                }
                if (deployedModuleData.urlCookieName != null) {
                    deployedModuleData2.urlCookieName = deployedModuleData.urlCookieName;
                }
                if (deployedModuleData.additionalPatterns != null) {
                    deployedModuleData2.additionalPatterns = deployedModuleData.additionalPatterns;
                }
                if (deployedModuleData.portletApp != null) {
                    deployedModuleData2.portletApp = deployedModuleData.portletApp;
                }
                if (deployedModuleData.portletServingEnabled != null) {
                    deployedModuleData2.portletServingEnabled = deployedModuleData.portletServingEnabled;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updated the existing module");
                }
            }
            if (tc.isDebugEnabled()) {
                deployedModuleData2.print(tc);
            }
            this.addVirtualHostName(deployedModuleData2);
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerCluster defintion " + string + " doesn't exist");
        }
        return false;
    }

    private void setServerClusterPropsFromConfig(ServerClusterData serverClusterData) {
        serverClusterData.loadBalance = this._pluginConfigData.loadBalance;
        serverClusterData.retryInterval = this._pluginConfigData.retryInterval;
        serverClusterData.removeSpecialHeaders = this._pluginConfigData.removeSpecialHeaders;
        serverClusterData.cloneSeparatorChange = this._pluginConfigData.cloneSeparatorChange;
        serverClusterData.postSizeLimit = this._pluginConfigData.postSizeLimit;
        serverClusterData.postBufferSize = this._pluginConfigData.postBufferSize;
        serverClusterData.GetDWLMTable = this._pluginConfigData.GetDWLMTable;
    }

    private void setWebserverPluginSettings(ServerData serverData, WebserverPluginSettings webserverPluginSettings) {
        serverData.connectTimeout = new Integer(webserverPluginSettings.getConnectTimeout());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the webserver plugin settings for server: " + serverData.serverName + " on node: " + serverData.nodeName);
        }
        serverData.serverIOTimeout = this._pluginConfigData.serverIOTimeout == null ? new Integer(webserverPluginSettings.getServerIOTimeout()) : this._pluginConfigData.serverIOTimeout;
        serverData.waitForContinue = new Boolean(webserverPluginSettings.isWaitForContinue());
        serverData.maxConnections = new Integer(webserverPluginSettings.getMaxConnections());
        serverData.extendedHandshake = new Boolean(webserverPluginSettings.isExtendedHandshake());
        serverData.roleKind = webserverPluginSettings.getRole().getValue();
    }

    static ConfigRoot getFirstAppServerConfigRoot(String string, String string2) throws PluginConfigException {
        ConfigRoot configRoot = null;
        if (string2 == null) {
            return null;
        }
        String string3 = string + File.separator + CELLSDIR + File.separator + string2 + File.separator + NODESDIR;
        File file = new File(string3);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string4 = fileArray[i].getName();
                String string5 = ConfigurationParser.getFirstAppServerInNode(string, string2, string4);
                if (string5 == null) continue;
                try {
                    Repository repository2 = RepositoryFactory.createRepository(string, string2, string4, string5);
                    configRoot = repository2.getConfigRoot();
                    break;
                }
                catch (Throwable throwable) {
                    throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + string2 + "." + string4 + "." + string5 + ".", throwable);
                }
            }
        }
        return configRoot;
    }

    static String getFirstAppServerInNode(String string, String string2, String string3) throws PluginConfigException {
        String string4 = null;
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string5 = serverEntry.getServerType();
            if (!string5.equals("APPLICATION_SERVER")) continue;
            string4 = serverEntry.getServerName();
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFirstApplicationServerInNode: Node name - " + string3 + " Application server name - " + string4);
        }
        return string4;
    }

    public static String getServerType(String string, String string2, String string3, String string4) throws PluginConfigException {
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(string4)) continue;
            return serverEntry.getServerType();
        }
        return null;
    }

    public static List getNodes(String string, String string2) {
        String string3;
        File file;
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null && (fileArray = (file = new File(string3 = string + File.separator + CELLSDIR + File.separator + string2 + File.separator + NODESDIR)).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getName());
            }
        }
        return arrayList;
    }

    public static List getWebServers(String string, String string2, String string3) throws PluginConfigException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equals(WEB_SERVER_TYPE)) continue;
            arrayList.add(serverEntry.getServerName());
        }
        return arrayList;
    }

    public static EARFile getEAR(String string) throws PluginConfigException {
        if (!PluginConfigGenerator.nlsInit) {
            PluginConfigGenerator.nlsInitialize();
        }
        EARFile eARFile = null;
        try {
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            eARFile = commonarchiveFactory.openEARFile(archiveOptions, string);
            eARFile.getDeploymentDescriptor();
            eARFile.getBindings();
            eARFile.getExtensions();
        }
        catch (Throwable throwable) {
            if (eARFile != null) {
                eARFile.close();
            }
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("exception.reading.ear") + " " + string + ".");
        }
        return eARFile;
    }

    public static boolean isIHSWebServer(String string, String string2, String string3, String string4) throws PluginConfigException {
        int n = ConfigurationParser.getWebServerType(string, string2, string3, string4);
        return n == 0;
    }

    public static int getWebServerType(String string, String string2, String string3, String string4) throws PluginConfigException {
        int n = 0;
        WebServer webServer = ConfigurationParser.getWebServer(string, string2, string3, string4);
        if (webServer != null) {
            WebserverTypeKind webserverTypeKind = webServer.getWebserverType();
            n = webserverTypeKind.getValue();
        }
        return n;
    }

    public static PluginProperties getPluginProperties(String string, String string2, String string3, String string4) throws PluginConfigException {
        PluginProperties pluginProperties = null;
        WebServer webServer = ConfigurationParser.getWebServer(string, string2, string3, string4);
        if (webServer != null) {
            pluginProperties = (PluginProperties)webServer.getPluginProperties().get(0);
        }
        return pluginProperties;
    }

    public static WebServer getWebServer(String string, String string2, String string3, String string4) throws PluginConfigException {
        if (!PluginConfigGenerator.nlsInit) {
            PluginConfigGenerator.nlsInitialize();
        }
        Repository repository2 = RepositoryFactory.createRepository(string, string2, string3, string4);
        Server server2 = null;
        try {
            Resource resource = repository2.getConfigRoot().getResource(4, SERVERFILE);
            EList eList = resource.getContents();
            if (eList.size() > 0) {
                server2 = (Server)eList.get(0);
            }
            if (server2 == null) {
                System.out.println();
                System.out.println(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + string2 + "." + string3 + "." + string4 + ".");
            } else {
                EList eList2 = server2.getComponents();
                int n = eList2.size();
                for (int i = 0; i < n; ++i) {
                    EObject eObject = (EObject)eList2.get(i);
                    EClass eClass = eObject.eClass();
                    String string5 = eClass.getName();
                    if (!string5.equals("WebServer")) continue;
                    WebServer webServer = (WebServer)eObject;
                    return webServer;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + string2 + "." + string3 + "." + string4 + ".");
        }
        catch (Throwable throwable) {
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("exception.reading.server") + " " + string4 + ".");
            if (tc.isDebugEnabled()) {
                throwable.printStackTrace();
            }
            System.out.println();
            System.out.println(PluginConfigGenerator.nls.getString("rerun.with.debug"));
        }
        return null;
    }

    public static String getDefaultPluginInstallRoot(String string, boolean bl) {
        String string2 = null;
        string2 = bl ? (string.equals("windows") ? "c:\\Program Files\\IBM\\HTTPServer\\Plugins" : (string.equals("aix") ? "/usr/IBM/HTTPServer/Plugins" : (string.equals("os400") || string.equals("os390") ? System.getProperty("user.install.root") : "/opt/IBM/HTTPServer/Plugins"))) : ConfigurationParser.getDefaultPluginInstallRoot(string);
        return string2;
    }

    public static String getDefaultPluginInstallRoot(String string) {
        String string2 = null;
        string2 = string.equals("windows") ? "c:\\Program Files\\IBM\\WebSphere\\Plugins" : (string.equals("aix") ? "/usr/IBM/WebSphere/Plugins" : (string.equals("os400") || string.equals("os390") ? System.getProperty("user.install.root") : "/opt/IBM/WebSphere/Plugins"));
        return string2;
    }

    public static String getFileSeparator(String string, String string2, String string3) throws AdminException {
        String string4 = ConfigurationParser.getNodePlatform(string, string2, string3);
        if (string4.equals("windows")) {
            return "\\";
        }
        return "/";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNodePlatform(String string, String string2) throws PluginConfigException {
        String string3 = "windows";
        String string4 = string + File.separator + CELLSDIR + File.separator + string2 + File.separator + NODESDIR;
        File file = new File(string4);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray == null) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.defs.for.cell") + " " + string2 + ".");
        if (fileArray.length <= 0) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.clusters.or.nodes"));
        int n = 0;
        if (n >= fileArray.length) return string3;
        String string5 = fileArray[n].getName();
        if (!tc.isDebugEnabled()) return ConfigurationParser.getNodePlatform(string, string2, string5);
        Tr.debug(tc, "Retreiving the operating system for the node " + string5 + ".");
        return ConfigurationParser.getNodePlatform(string, string2, string5);
    }

    public static String getNodePlatform(String string, String string2, String string3) {
        String string4;
        block2: {
            string4 = "windows";
            try {
                Properties properties = new Properties();
                properties.setProperty("local.cell", string2);
                properties.setProperty("was.repository.root", string);
                ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
                string4 = managedObjectMetadataHelper.getNodePlatformOS(string3);
            }
            catch (AdminException adminException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Unable to get the operating system for the node " + string3 + ".");
                Tr.debug(tc, "Exception is :" + adminException.toString() + ".");
                Tr.debug(tc, "Using windows as the default operating system.");
            }
        }
        return string4;
    }

    public static boolean isNodeVersion60(String string, String string2, String string3) {
        boolean bl;
        block3: {
            bl = false;
            try {
                Properties properties = new Properties();
                properties.setProperty("local.cell", string2);
                properties.setProperty("was.repository.root", string);
                ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
                String string4 = managedObjectMetadataHelper.getNodeBaseProductVersion(string3);
                int n = string4.indexOf("6.0", 0);
                if (n >= 0) {
                    bl = true;
                }
            }
            catch (AdminException adminException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Unable to get the version  for the node " + string3 + ".");
                Tr.debug(tc, "Exception is :" + adminException.toString() + ".");
            }
        }
        return bl;
    }

    public static boolean isNodeManaged(String string, String string2, String string3) throws PluginConfigException {
        boolean bl = false;
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isNodeLocal(String string, String string2, String string3) throws PluginConfigException {
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        String string4 = serverIndex.getHostName();
        string4 = ConfigurationParser.substituteVariable(string4);
        return ConfigurationParser.isWebServerLocal(string4);
    }

    public static ServerIndex getServerIndexForGivenNode(String string, String string2, String string3) throws PluginConfigException {
        if (!PluginConfigGenerator.nlsInit) {
            PluginConfigGenerator.nlsInitialize();
        }
        Resource resource = null;
        Repository repository2 = null;
        try {
            repository2 = RepositoryFactory.createRepository(string, string2, string3, null);
            resource = repository2.getConfigRoot().getResource(3, SERVERINDEX);
        }
        catch (Throwable throwable) {
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + string3 + ".", throwable);
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        return serverIndex;
    }

    static boolean isNodeDMGR(String string, String string2) throws PluginConfigException {
        boolean bl = false;
        if (string2 == null) {
            return false;
        }
        String string3 = string + File.separator + CELLSDIR + File.separator + string2 + File.separator + NODESDIR;
        File file = new File(string3);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length && !(bl = ConfigurationParser.isNodeDMGR(string, string2, fileArray[i].getName())); ++i) {
            }
        }
        return bl;
    }

    static boolean isNodeDMGR(String string, String string2, String string3) throws PluginConfigException {
        int n;
        boolean bl = false;
        ServerIndex serverIndex = ConfigurationParser.getServerIndexForGivenNode(string, string2, string3);
        EList eList = serverIndex.getServerEntries();
        String string4 = "";
        Enumeration enumeration = ConfigurationParser.getAllLocalAddresses();
        try {
            string4 = InetAddress.getLocalHost().getHostName();
            string4 = ConfigurationParser.substituteVariable(string4);
            n = string4.indexOf(".");
            if (n > 0) {
                string4 = string4.substring(0, n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (n = 0; n < eList.size(); ++n) {
            InetAddress[] inetAddressArray;
            ServerEntry serverEntry = (ServerEntry)eList.get(n);
            String string5 = serverEntry.getServerType();
            if (!string5.equals("DEPLOYMENT_MANAGER")) continue;
            EList eList2 = serverEntry.getSpecialEndpoints();
            NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(1);
            String string6 = namedEndPoint.getEndPoint().getHost();
            int n2 = (string6 = ConfigurationParser.substituteVariable(string6)).indexOf(".");
            if (n2 > 0) {
                string6 = string6.substring(0, n2);
            }
            if (string6.equalsIgnoreCase(string4)) {
                bl = true;
                break;
            }
            if (enumeration == null) continue;
            InetAddress inetAddress = null;
            String string7 = "";
            String string8 = "";
            try {
                inetAddressArray = InetAddress.getAllByName(string6);
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unable to resolve " + string6);
                continue;
            }
            block5: for (int i = 0; i < inetAddressArray.length; ++i) {
                string7 = inetAddressArray[i].getHostAddress();
                while (enumeration.hasMoreElements()) {
                    inetAddress = (InetAddress)enumeration.nextElement();
                    string8 = inetAddress.getHostAddress();
                    if (!string7.equalsIgnoreCase(string8)) continue;
                    bl = true;
                    continue block5;
                }
            }
        }
        return bl;
    }

    public static boolean isWebServerLocal(String string) {
        boolean bl;
        block15: {
            bl = false;
            if (string.equalsIgnoreCase("localhost") || string.equalsIgnoreCase("127.0.0.1")) {
                bl = true;
            } else {
                int n;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                Enumeration enumeration = ConfigurationParser.getAllLocalAddresses();
                try {
                    string2 = InetAddress.getLocalHost().getHostName();
                    string2 = ConfigurationParser.substituteVariable(string2);
                    n = string2.indexOf(".");
                    if (n > 0) {
                        string3 = string2.substring(0, n);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                n = string.indexOf(".");
                if (n > 0) {
                    string4 = string.substring(0, n);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Local hostname      : " + string2);
                    Tr.debug(tc, "web server hostname : " + string);
                }
                if (string.equalsIgnoreCase(string2) || string4.trim() != "" && string4.equalsIgnoreCase(string3)) {
                    bl = true;
                } else if (enumeration != null) {
                    InetAddress inetAddress = null;
                    String string5 = "";
                    String string6 = "";
                    try {
                        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                        block4: for (int i = 0; i < inetAddressArray.length; ++i) {
                            string5 = inetAddressArray[i].getHostAddress();
                            while (enumeration.hasMoreElements()) {
                                inetAddress = (InetAddress)enumeration.nextElement();
                                string6 = inetAddress.getHostAddress();
                                if (!string5.equalsIgnoreCase(string6)) continue;
                                bl = true;
                                continue block4;
                            }
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "Unable to resolve " + string);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Is Local : " + bl);
        }
        return bl;
    }

    static Enumeration getAllLocalAddresses() {
        Enumeration<NetworkInterface> enumeration = null;
        Vector<InetAddress> vector = new Vector<InetAddress>(1, 1);
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in NetworkInterface.getNetworkInterfaces.  Continue.");
            }
            return null;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Interface Name: " + networkInterface.getName());
            }
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public static Boolean isFIPSEnabled(String string, String string2) {
        String string3;
        block4: {
            string3 = "false";
            Resource resource = null;
            Repository repository2 = null;
            try {
                repository2 = RepositoryFactory.createRepository(string, string2, null, null);
                resource = repository2.getConfigRoot().getResource(0, SECURITY);
                Security security2 = (Security)resource.getContents().get(0);
                EList eList = security2.getProperties();
                if (eList == null) break block4;
                ListIterator listIterator = eList.listIterator();
                while (listIterator.hasNext()) {
                    Property property = (Property)listIterator.next();
                    if (!property.getName().equals("com.ibm.security.useFIPS")) continue;
                    string3 = property.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Value of the property useFIPS: " + string3);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to retrieve values from security.xml.");
            }
        }
        return new Boolean(string3);
    }

    private static String substituteVariable(String string) {
        String string2;
        block2: {
            string2 = string;
            try {
                string2 = _vMgr.substitute(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "No substitution done for hostName " + string);
            }
        }
        return string2;
    }

    public static class DeployedModuleData {
        public ApplicationDeployment deployedApplication;
        public ModuleDeployment deployedModule;
        public WebApp deploymentDescriptor;
        public WebModule moduleConfig;
        public WebAppExtension moduleExtensions;
        public WebAppBinding moduleBindings;
        public String cookieName;
        public String urlCookieName;
        public String moduleUri;
        public List additionalPatterns;
        public PortletApplication portletApp;
        public Boolean portletServingEnabled = Boolean.FALSE;

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "DeploymentModuleData details:");
            Tr.debug(traceComponent, "   moduleUri            : " + this.moduleUri);
            Tr.debug(traceComponent, "   deployedApplication  : " + this.deployedApplication);
            Tr.debug(traceComponent, "   deployedModule       : " + this.deployedModule);
            Tr.debug(traceComponent, "   deploymentDescriptor : " + this.deploymentDescriptor);
            Tr.debug(traceComponent, "   moduleConfig         : " + this.moduleConfig);
            Tr.debug(traceComponent, "   moduleExtensions     : " + this.moduleExtensions);
            Tr.debug(traceComponent, "   moduleBindings       : " + this.moduleBindings);
            Tr.debug(traceComponent, "   cookieName           : " + this.cookieName);
            Tr.debug(traceComponent, "   urlCookieName        : " + this.urlCookieName);
            Tr.debug(traceComponent, "   additionalPatterns   : " + this.additionalPatterns);
            Tr.debug(traceComponent, "   portletApplication   : " + this.portletApp);
            Tr.debug(traceComponent, "   portletServingEnabled: " + this.portletServingEnabled);
        }
    }

    public static class TransportData {
        public String host;
        public int port;
        public boolean isSslEnabled;

        public TransportData(String string, int n, boolean bl) {
            this.host = string;
            this.port = n;
            this.isSslEnabled = bl;
        }

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "TransportData details:");
            Tr.debug(traceComponent, "   host        : " + this.host);
            Tr.debug(traceComponent, "   port        : " + this.port);
            Tr.debug(traceComponent, "   sslEnabled  : " + this.isSslEnabled);
        }
    }

    public static class ServerData {
        public String serverType;
        public String serverName;
        public String appServerName;
        public String serverID = "";
        public String cellName;
        public String nodeName;
        public String hostName;
        public List transports;
        public Integer wlmWeight;
        public Integer connectTimeout = new Integer(0);
        public Integer serverIOTimeout = new Integer(0);
        public Boolean waitForContinue = Boolean.FALSE;
        public Integer maxConnections = new Integer(-1);
        public Boolean extendedHandshake = Boolean.FALSE;
        public int roleKind = 0;
        public String sessionManagerCookieName = "JSESSIONID";
        public String sessionURLIdentifier = "jsessionid";
        public String cloneSeparator = null;
        public String fileServingEnabled = "notDefined";
        public String disallowAllFileServing = "notDefined";
        public String serveServletsByClassnameEnabled = "notDefined";
        public List busList = new ArrayList();

        public ServerData(String string) {
            this.serverName = string;
            this.nodeName = null;
        }

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "ServerData details:");
            Tr.debug(traceComponent, "   cellName                        : " + this.cellName);
            Tr.debug(traceComponent, "   nodeName                        : " + this.nodeName);
            Tr.debug(traceComponent, "   serverName                      : " + this.serverName);
            Tr.debug(traceComponent, "   serverType                      : " + this.serverType);
            Tr.debug(traceComponent, "   appServerName                   : " + this.appServerName);
            Tr.debug(traceComponent, "   serverID                        : " + this.serverID);
            Tr.debug(traceComponent, "   hostName                        : " + this.hostName);
            Tr.debug(traceComponent, "   transports                      : " + this.transports);
            Tr.debug(traceComponent, "   wlmWeight                       : " + this.wlmWeight);
            Tr.debug(traceComponent, "   connectTimeout                  : " + this.connectTimeout);
            Tr.debug(traceComponent, "   serverIOTimeout                 : " + this.serverIOTimeout);
            Tr.debug(traceComponent, "   waitForContinue                 : " + this.waitForContinue);
            Tr.debug(traceComponent, "   maxConnections                  : " + this.maxConnections);
            Tr.debug(traceComponent, "   extendedHandshake               : " + this.extendedHandshake);
            Tr.debug(traceComponent, "   roleKind                        : " + this.roleKind);
            Tr.debug(traceComponent, "   sessionManagerCookieName        : " + this.sessionManagerCookieName);
            Tr.debug(traceComponent, "   sessionURLIdentifier            : " + this.sessionURLIdentifier);
            Tr.debug(traceComponent, "   cloneSeparator                  : " + this.cloneSeparator);
            Tr.debug(traceComponent, "   fileServingEnabled              : " + this.fileServingEnabled);
            Tr.debug(traceComponent, "   disallowAllFileServing          : " + this.disallowAllFileServing);
            Tr.debug(traceComponent, "   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled);
            Tr.debug(traceComponent, "   SIBBus list                     : " + this.busList);
        }
    }

    public static class ServerClusterData {
        public String clusterName;
        public String loadBalance = "Round Robin";
        public Integer retryInterval = new Integer(60);
        public Boolean removeSpecialHeaders = Boolean.TRUE;
        public Boolean cloneSeparatorChange = Boolean.FALSE;
        public Integer postSizeLimit = new Integer(-1);
        public Integer postBufferSize = new Integer(64);
        public List backupClusters;
        public List clusterServers;
        public List primaryServers;
        public List backupServers;
        public List deployedModules = new ArrayList();
        public String fileServingEnabled = "notDefined";
        public String disallowAllFileServing = "notDefined";
        public String serveServletsByClassnameEnabled = "notDefined";
        public Boolean singleServerConfig = Boolean.FALSE;
        public Boolean GetDWLMTable = Boolean.FALSE;

        public ServerClusterData(String string) {
            this.clusterName = string;
        }

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "ServerClusterData details:");
            Tr.debug(traceComponent, "   clusterName                     : " + this.clusterName);
            Tr.debug(traceComponent, "   loadBalance                     : " + this.loadBalance);
            Tr.debug(traceComponent, "   retryInterval                   : " + this.retryInterval);
            Tr.debug(traceComponent, "   removeSpecialHeaders            : " + this.removeSpecialHeaders);
            Tr.debug(traceComponent, "   cloneSeparatorChange            : " + this.cloneSeparatorChange);
            Tr.debug(traceComponent, "   postSizeLimit                   : " + this.postSizeLimit);
            Tr.debug(traceComponent, "   postBufferSize                  : " + this.postBufferSize);
            Tr.debug(traceComponent, "   backupClusters                  : " + this.backupClusters);
            Tr.debug(traceComponent, "   clusterServers                  : " + this.clusterServers);
            Tr.debug(traceComponent, "   primaryServers                  : " + this.primaryServers);
            Tr.debug(traceComponent, "   backupServers                   : " + this.backupServers);
            Tr.debug(traceComponent, "   deployedModules                 : " + this.deployedModules);
            Tr.debug(traceComponent, "   fileServingEnabled              : " + this.fileServingEnabled);
            Tr.debug(traceComponent, "   disallowAllFileServing          : " + this.disallowAllFileServing);
            Tr.debug(traceComponent, "   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled);
            Tr.debug(traceComponent, "   singleServerConfig              : " + this.singleServerConfig);
            Tr.debug(traceComponent, "   getDWLMTable                    : " + this.GetDWLMTable);
        }
    }

    public static class PluginConfigData {
        public Integer RefreshInterval = new Integer(60);
        public Boolean IgnoreDNSFailures = Boolean.FALSE;
        public Integer ResponseChunkSize = new Integer(64);
        public Boolean ASDisableNagle = Boolean.FALSE;
        public Boolean IISDisableNagle = Boolean.FALSE;
        public Boolean AcceptAllContent = Boolean.FALSE;
        public Boolean VHostMatchingCompat = Boolean.FALSE;
        public String AppServerPortPreference = "HostHeader";
        public Boolean ChunkedResponse = Boolean.FALSE;
        public String IISPluginPriority = "High";
        public String LogFile = null;
        public String LogLevel = "Error";
        public Boolean ESIEnable = Boolean.TRUE;
        public Integer ESIMaxCacheSize = new Integer(1024);
        public Boolean ESIInvalidationMonitor = Boolean.FALSE;
        public Boolean ESIEnableToPassCookies = Boolean.FALSE;
        public String PluginInstallRoot = null;
        public String FileSeparator = File.separator;
        public String PluginConfigFileName = "plugin-cfg.xml";
        public Boolean AutoGenerate = Boolean.TRUE;
        public Boolean AutoPropagate = Boolean.TRUE;
        public String loadBalance = "Round Robin";
        public Boolean ignoreAffinityRequests = Boolean.TRUE;
        public Integer retryInterval = new Integer(60);
        public Boolean removeSpecialHeaders = Boolean.TRUE;
        public Boolean cloneSeparatorChange = Boolean.FALSE;
        public Integer postSizeLimit = new Integer(-1);
        public Integer postBufferSize = new Integer(64);
        public String KeyringLocation = null;
        public String StashfileLocation = null;
        public Integer serverIOTimeout = null;
        public Boolean FIPSEnable = Boolean.FALSE;
        public String CertLabel = null;
        public Boolean GetDWLMTable = Boolean.FALSE;
        public Integer HTTPMaxHeaders = new Integer(300);
        public String SSLPKCSDriver = null;
        public String SSLPKCSPassword = null;
        public Boolean SSLConsolidate = Boolean.FALSE;
        public Boolean TrustedProxyEnable = Boolean.FALSE;
        public String TrustedProxyList = null;

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "PluginConfigData details:");
            Tr.debug(traceComponent, "   RefreshInterval         : " + this.RefreshInterval);
            Tr.debug(traceComponent, "   IgnoreDNSFailures       : " + this.IgnoreDNSFailures);
            Tr.debug(traceComponent, "   ResponseChunkSize       : " + this.ResponseChunkSize);
            Tr.debug(traceComponent, "   ASDisableNagle          : " + this.ASDisableNagle);
            Tr.debug(traceComponent, "   IISDisableNagle         : " + this.IISDisableNagle);
            Tr.debug(traceComponent, "   AcceptAllContent        : " + this.AcceptAllContent);
            Tr.debug(traceComponent, "   VHostMatchingCompat     : " + this.VHostMatchingCompat);
            Tr.debug(traceComponent, "   AppServerPortPreference : " + this.AppServerPortPreference);
            Tr.debug(traceComponent, "   ChunkedResponse         : " + this.ChunkedResponse);
            Tr.debug(traceComponent, "   IISPluginPriority       : " + this.IISPluginPriority);
            Tr.debug(traceComponent, "   LogFile                 : " + this.LogFile);
            Tr.debug(traceComponent, "   LogLevel                : " + this.LogLevel);
            Tr.debug(traceComponent, "   ESIEnable               : " + this.ESIEnable);
            Tr.debug(traceComponent, "   ESIMaxCacheSize         : " + this.ESIMaxCacheSize);
            Tr.debug(traceComponent, "   ESIInvalidationMonitor  : " + this.ESIInvalidationMonitor);
            Tr.debug(traceComponent, "   ESIEnableToPassCookies  : " + this.ESIEnableToPassCookies);
            Tr.debug(traceComponent, "   PluginInstallRoot       : " + this.PluginInstallRoot);
            Tr.debug(traceComponent, "   FileSeparator           : " + this.FileSeparator);
            Tr.debug(traceComponent, "   PluginConfigFileName    : " + this.PluginConfigFileName);
            Tr.debug(traceComponent, "   AutoGenerate            : " + this.AutoGenerate);
            Tr.debug(traceComponent, "   AutoPropagate           : " + this.AutoPropagate);
            Tr.debug(traceComponent, "   loadBalance             : " + this.loadBalance);
            Tr.debug(traceComponent, "   IgnoreAffinityRequests  : " + this.ignoreAffinityRequests);
            Tr.debug(traceComponent, "   retryInterval           : " + this.retryInterval);
            Tr.debug(traceComponent, "   removeSpecialHeaders    : " + this.removeSpecialHeaders);
            Tr.debug(traceComponent, "   cloneSeparatorChange    : " + this.cloneSeparatorChange);
            Tr.debug(traceComponent, "   postSizeLimit           : " + this.postSizeLimit);
            Tr.debug(traceComponent, "   postBufferSize          : " + this.postBufferSize);
            Tr.debug(traceComponent, "   KeyringLocation         : " + this.KeyringLocation);
            Tr.debug(traceComponent, "   StashfileLocation       : " + this.StashfileLocation);
            Tr.debug(traceComponent, "   serverIOTimeout         : " + this.serverIOTimeout);
            Tr.debug(traceComponent, "   FIPSEnable              : " + this.FIPSEnable);
            Tr.debug(traceComponent, "   CertLabel               : " + this.CertLabel);
            Tr.debug(traceComponent, "   GetDWLMTable            : " + this.GetDWLMTable);
            Tr.debug(traceComponent, "   HTTPMaxHeaders          : " + this.HTTPMaxHeaders);
            Tr.debug(traceComponent, "   SSLPKCSDriver           : " + this.SSLPKCSDriver);
            Tr.debug(traceComponent, "   SSLPKCSPassword         : " + this.SSLPKCSPassword);
            Tr.debug(traceComponent, "   SSLConsolidate          : " + this.SSLPKCSDriver);
            Tr.debug(traceComponent, "   TrustedProxyEnable      : " + this.TrustedProxyEnable);
            Tr.debug(traceComponent, "   TrustedProxyList        : " + this.TrustedProxyList);
        }
    }
}

