/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.webserver.PluginProperties;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.webserver.WebServerControl;
import com.ibm.ws.management.webserver.WebServerControlFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import com.ibm.wsspi.profile.WSProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginConfigGenerator
extends RuntimeCollaborator
implements NotificationListener {
    protected static TraceComponent tc = Tr.register(PluginConfigGenerator.class);
    public static boolean _debugEnabled = false;
    public static TraceNLS nls;
    public static boolean nlsInit;
    public static AdminService adminService;
    public static final String GENERATE_INFO = "websphere.plugincfg.generate.info";
    public static final String GENERATE_COMPLETE = "websphere.plugincfg.generate.complete";
    public static final String GENERATE_FAILED = "websphere.plugincfg.generate.failed";
    public static final String PROPAGATE_INFO = "websphere.plugincfg.propagate.info";
    public static final String PROPAGATE_STARTED = "websphere.plugincfg.propagate.started";
    public static final String PROPAGATE_PLUGINCFG_STARTED = "websphere.plugincfg.propagate.started";
    public static final String PROPAGATE_PLUGINCFG_COMPLETE = "websphere.plugincfg.propagate.complete";
    public static final String PROPAGATE_PLUGINCFG_FAILED = "websphere.plugincfg.propagate.failed";
    public static final String PROPAGATE_KEYRING_STARTED = "websphere.plugincfg.keyring.propagate.started";
    public static final String PROPAGATE_KEYRING_COMPLETE = "websphere.plugincfg.keyring.propagate.complete";
    public static final String PROPAGATE_KEYRING_FAILED = "websphere.plugincfg.keyring.propagate.failed";
    public static final String PROPAGATE_STASHFILE_COMPLETE = "websphere.plugincfg.stashfile.propagate.complete";
    public static final String PROPAGATE_STASHFILE_FAILED = "websphere.plugincfg.stashfile.propagate.failed";
    public static final String FILETYPE_PLUGIN_CFG = "plugincfg";
    public static final String FILETYPE_PLUGIN_KEYRING = "pluginkdb";
    public static final String FILETYPE_PLUGIN_STASHFILE = "pluginsth";
    public static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:copy />                                                 \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";
    private int notifySeqNum;
    public boolean modelMBeanFound;

    public PluginConfigGenerator() throws PluginConfigException {
        block8: {
            this.notifySeqNum = 0;
            this.modelMBeanFound = true;
            String string = "PluginConfigGenerator(): ";
            if (this.getAdminService() != null) {
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType(PROPAGATE_INFO);
                notificationFilterSupport.enableType(PROPAGATE_PLUGINCFG_COMPLETE);
                notificationFilterSupport.enableType(PROPAGATE_PLUGINCFG_FAILED);
                notificationFilterSupport.enableType(PROPAGATE_KEYRING_COMPLETE);
                notificationFilterSupport.enableType(PROPAGATE_KEYRING_FAILED);
                notificationFilterSupport.enableType(PROPAGATE_STASHFILE_COMPLETE);
                notificationFilterSupport.enableType(PROPAGATE_STASHFILE_FAILED);
                try {
                    Set set;
                    String string2 = "WebSphere:*,type=NotificationService,process=" + this.getAdminService().getProcessName() + ",node=" + this.getAdminService().getNodeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "NTFY_MBEAN_NAME : " + string2);
                    }
                    if ((set = this.getAdminService().queryNames(new ObjectName(string2), null)).isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + " Error obtaining MBean by name " + string2);
                        }
                    } else {
                        ObjectName objectName = (ObjectName)set.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "notificationSvr : " + objectName.toString());
                        }
                        this.getAdminService().addNotificationListenerExtended(objectName, this, notificationFilterSupport, null);
                    }
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Unable to add a listener to the NotificationService");
                }
            }
        }
    }

    public static void nlsInitialize() throws PluginConfigException {
        try {
            nls = TraceNLS.getTraceNLS("com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator.main", "201");
            throw new PluginConfigException("Unable to Find NLS Resources: " + missingResourceException.getMessage());
        }
        nlsInit = true;
    }

    public void generate(String string, String string2, String string3, String string4, Boolean bl) throws PluginConfigException {
        this.generate(string, string2, string3, string4, bl, Boolean.FALSE);
    }

    public void generate(final String string, final String string2, final String string3, final String string4, final Boolean bl, final Boolean bl2) throws PluginConfigException {
        if (this.checkRoleSecurity() && SecurityContext.isSecurityEnabled()) {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    PluginConfigGenerator.this.generate6(string, string2, string3, string4, bl, bl2);
                    return null;
                }
            };
            try {
                SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new PluginConfigException("Applicaton centric generation did not complete successfully: " + privilegedActionException.getMessage());
            }
        } else {
            this.generate6(string, string2, string3, string4, bl, bl2);
        }
    }

    private void generate6(String string, String string2, String string3, String string4, Boolean bl, Boolean bl2) throws PluginConfigException {
        try {
            String string5;
            if (!nlsInit) {
                PluginConfigGenerator.nlsInitialize();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot: " + string + " cellName: " + string2 + " nodeName: " + string3 + " webserverName: " + string4 + " propagate: " + bl);
            }
            if ((string5 = System.getProperty("server.root")) == null) {
                string5 = System.getProperty("user.install.root");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appServerRoot: " + string5);
            }
            if (string == null) {
                if (!string5.endsWith(File.separator)) {
                    string5 = string5 + File.separator;
                }
                string = string5 + "config";
            } else {
                int n = string.indexOf("config", 0);
                if (n > 0) {
                    string5 = string.substring(0, n - 1);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appServerRoot: " + string5);
            }
            ConfigurationParser configurationParser = new ConfigurationParser(string5, string, string2, string3, string4);
            String string6 = ConfigurationParser.getNodePlatform(configurationParser.getAppServerConfigRoot(), string2, string3);
            String string7 = this.determineOutputFileName(string5, string, configurationParser.getPluginConfigData().PluginConfigFileName, configurationParser.getPluginConfigData().FileSeparator, string2, string3, string4);
            boolean bl3 = true;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isOS400()) {
                try {
                    bl3 = !new File(string7).exists();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.outputPluginConfigFile(configurationParser, string7, string5, string6);
            if (platformHelper.isOS400() && bl3) {
                this.correctOs400Authorities(string5, string7, configurationParser.getPluginConfigData().FileSeparator);
            }
        }
        catch (PluginConfigException pluginConfigException) {
            this.notifyMessage(GENERATE_INFO, pluginConfigException.getMessage());
            String string8 = nls.getString("generate.notcomplete") + " " + string2 + "." + string3 + "." + string4 + ".";
            this.notifyMessage(GENERATE_FAILED, string8);
            throw pluginConfigException;
        }
        if (bl.booleanValue()) {
            this.propagate(string, string2, string3, string4);
        }
        if (bl2.booleanValue()) {
            this.propagateKeyring(string, string2, string3, string4);
        }
    }

    public void propagate(final String string, final String string2, final String string3, final String string4) throws PluginConfigException {
        if (this.checkRoleSecurity() && SecurityContext.isSecurityEnabled()) {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    PluginConfigGenerator.this.propagate4(string, string2, string3, string4);
                    return null;
                }
            };
            try {
                SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new PluginConfigException("Applicaton centric propagation did not complete successfully: " + privilegedActionException.getMessage());
            }
        } else {
            this.propagate4(string, string2, string3, string4);
        }
    }

    public void propagate4(String string, String string2, String string3, String string4) throws PluginConfigException {
        if (!nlsInit) {
            PluginConfigGenerator.nlsInitialize();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configRoot: " + string + " cellName: " + string2 + " nodeName: " + string3 + " webserverName: " + string4);
        }
        if (string == null) {
            string = PluginConfigGenerator.getDefaultConfigRoot();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Revised configRoot: " + string);
            }
        }
        String string5 = null;
        String string6 = null;
        try {
            int n;
            String string7 = ConfigurationParser.getFileSeparator(string, string2, string3);
            PluginProperties pluginProperties = ConfigurationParser.getPluginProperties(string, string2, string3, string4);
            String string8 = pluginProperties.getPluginInstallRoot() + string7;
            String string9 = pluginProperties.getConfigFilename();
            String string10 = pluginProperties.getRemoteConfigFilename();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Plugin Config File name : " + string9 + " Remote config file name : " + string10 + " File separtor : " + string7);
            }
            if ((n = string9.lastIndexOf(string7)) >= 0) {
                string5 = string9;
                String string11 = string9.substring(n + 1);
                string6 = !string.endsWith(File.separator) ? string + File.separator + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string11 : string + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string11;
            } else {
                string5 = string10;
                if (string5 == null) {
                    string5 = string8 + "config" + string7 + string4 + string7 + string9;
                }
                string6 = !string.endsWith(File.separator) ? string + File.separator + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string9 : string + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string9;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PluginCfg --> Destination path : " + string5 + " Source path : " + string6);
            }
            this.startPropagation(string, string2, string3, string4, string6, string5, FILETYPE_PLUGIN_CFG);
        }
        catch (PluginConfigException pluginConfigException) {
            throw pluginConfigException;
        }
        catch (Throwable throwable) {
            String string12 = this.notifyPropagationResults(string2, string3, string4, string6, string5, FILETYPE_PLUGIN_CFG, false);
            throw new PluginConfigException(string12, throwable);
        }
    }

    public void propagateKeyring(String string, String string2, String string3, String string4) throws PluginConfigException {
        if (!nlsInit) {
            PluginConfigGenerator.nlsInitialize();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configRoot: " + string + " cellName: " + string2 + " nodeName: " + string3 + " webserverName: " + string4);
        }
        if (string == null) {
            string = PluginConfigGenerator.getDefaultConfigRoot();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Revised configRoot: " + string);
            }
        }
        String string5 = null;
        String string6 = null;
        String string7 = FILETYPE_PLUGIN_KEYRING;
        try {
            int n;
            String string8 = ConfigurationParser.getFileSeparator(string, string2, string3);
            PluginProperties pluginProperties = ConfigurationParser.getPluginProperties(string, string2, string3, string4);
            String string9 = pluginProperties.getPluginInstallRoot() + string8;
            String string10 = pluginProperties.getKeyRingFilename();
            String string11 = pluginProperties.getRemoteKeyRingFilename();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Plugin KeyRing File name : " + string10 + " Remote keyring file name : " + string11 + " File separtor : " + string8);
            }
            if ((n = string10.lastIndexOf(string8)) >= 0) {
                string5 = string10;
                String string12 = string10.substring(n + 1);
                string6 = !string.endsWith(File.separator) ? string + File.separator + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string12 : string + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string12;
            } else {
                string5 = string11;
                if (string5 == null) {
                    string5 = string9 + "config" + string8 + string4 + string8 + string10;
                }
                string6 = !string.endsWith(File.separator) ? string + File.separator + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string10 : string + "cells" + File.separator + string2 + File.separator + "nodes" + File.separator + string3 + File.separator + "servers" + File.separator + string4 + File.separator + string10;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyRing -> Destination path : " + string5 + " Source path : " + string6);
            }
            this.startPropagation(string, string2, string3, string4, string6, string5, string7);
            string7 = FILETYPE_PLUGIN_STASHFILE;
            int n2 = string6.lastIndexOf(".");
            string6 = n2 > 0 ? string6.substring(0, n2) + ".sth" : string6 + ".sth";
            n2 = string5.lastIndexOf(".");
            string5 = n2 > 0 ? string5.substring(0, n2) + ".sth" : string5 + ".sth";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StashFile -> Destination path : " + string5 + " Source path : " + string6);
            }
            this.startPropagation(string, string2, string3, string4, string6, string5, string7);
        }
        catch (PluginConfigException pluginConfigException) {
            throw pluginConfigException;
        }
        catch (Throwable throwable) {
            String string13 = this.notifyPropagationResults(string2, string3, string4, string6, string5, string7, false);
            throw new PluginConfigException(string13, throwable);
        }
    }

    public void generate(String string, String string2, String string3, String string4) throws PluginConfigException {
        String string5 = System.getProperty("server.root");
        if (string5 == null) {
            string5 = System.getProperty("user.install.root");
        }
        this.generate(string5, null, string, string2, string3, string4, null, null);
    }

    public void generate(String string, String string2, String string3, String string4, String string5, String string6) throws PluginConfigException {
        this.generate(string, string2, string3, null, string4, string5, string6, null, null);
    }

    public void generate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws PluginConfigException {
        this.generate(string, string2, string3, null, string4, string5, string6, string7, string8);
    }

    public void generate(final String string, final String string2, final String string3, final String string4, final String string5, final String string6, final String string7, final String string8, final String string9) throws PluginConfigException {
        if (this.checkRoleSecurity() && SecurityContext.isSecurityEnabled()) {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    PluginConfigGenerator.this.generate9(string, string2, string3, string4, string5, string6, string7, string8, string9);
                    return null;
                }
            };
            try {
                SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new PluginConfigException("Topology centric Generation did not complete successfully: " + privilegedActionException.getMessage());
            }
        } else {
            this.generate9(string, string2, string3, string4, string5, string6, string7, string8, string9);
        }
    }

    public void generate9(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws PluginConfigException {
        try {
            if (!nlsInit) {
                PluginConfigGenerator.nlsInitialize();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appServerRoot: " + string + " configRoot: " + string2 + " cellName: " + string3 + " clusterName: " + string4 + " nodeName: " + string5 + " serverName: " + string6 + " destRoot: " + string8 + " destOS: " + string9);
            }
            if (string != null) {
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
            } else {
                throw new PluginConfigException(nls.getString("app.server.root.missing"));
            }
            ConfigurationParser configurationParser = new ConfigurationParser(string, string2, string3, string4, string5, string6, string8, string9);
            String string10 = this.determineOutputFileName(string, string2, string7);
            boolean bl = true;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isOS400()) {
                try {
                    bl = !new File(string10).exists();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.outputPluginConfigFile(configurationParser, string10, string8, string9);
            if (platformHelper.isOS400() && bl) {
                this.correctOs400Authorities(string, string10, configurationParser.getPluginConfigData().FileSeparator);
            }
        }
        catch (PluginConfigException pluginConfigException) {
            this.notifyMessage(GENERATE_FAILED, pluginConfigException.getMessage());
            throw pluginConfigException;
        }
    }

    public void startPropagation(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws PluginConfigException {
        block21: {
            try {
                Object object;
                boolean bl = ConfigurationParser.isNodeLocal(string, string2, string3);
                boolean bl2 = ConfigurationParser.isNodeManaged(string, string2, string3);
                boolean bl3 = ConfigurationParser.isIHSWebServer(string, string2, string3, string4);
                if (!(bl || bl2 || bl3)) {
                    throw new PluginConfigException(nls.getString("propagate.notsupported") + " " + string2 + "." + string3 + "." + string4 + ".");
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Is webserver local: " + bl);
                    }
                    if (PluginConfigGenerator.startLocalTransfer(string5, string6)) {
                        this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, true);
                    } else {
                        String string8 = this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, false);
                        throw new PluginConfigException(string8);
                    }
                }
                if (bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Is webserver node managed: " + bl2);
                    }
                    if (string7.equals(FILETYPE_PLUGIN_CFG) || string7.equals(FILETYPE_PLUGIN_KEYRING)) {
                        if (this.isSynchronized(string2, string3, string4)) {
                            if (string7.equals(FILETYPE_PLUGIN_CFG)) {
                                object = nls.getString("node.in.sync.plugincfg") + " " + string2 + "." + string3 + ".";
                                this.notifyMessage(PROPAGATE_PLUGINCFG_COMPLETE, (String)object);
                            } else {
                                object = nls.getString("node.in.sync.stashfile") + " " + string2 + "." + string3 + ".";
                                this.notifyMessage(PROPAGATE_KEYRING_COMPLETE, (String)object);
                            }
                        } else if (this.startNodeSync(string2, string3, string4)) {
                            if (string7.equals(FILETYPE_PLUGIN_CFG)) {
                                object = nls.getString("nodesync.started") + " " + string2 + "." + string3 + ".";
                                this.notifyMessage("websphere.plugincfg.propagate.started", (String)object);
                            } else {
                                object = nls.getString("nodesync.keyring.started") + " " + string2 + "." + string3 + ".";
                                this.notifyMessage(PROPAGATE_KEYRING_STARTED, (String)object);
                            }
                        } else {
                            String string9 = this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, false);
                            throw new PluginConfigException(string9);
                        }
                    }
                }
                if (!bl3 || bl2 || bl) break block21;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is IHS webserver: " + bl3);
                }
                object = new FileInputStream(string5);
                WebServerControl webServerControl = WebServerControlFactory.getWebServerInstance(string, string2, string3, string4);
                if (webServerControl != null) {
                    webServerControl.uploadFile((InputStream)object, string6);
                    this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, true);
                    break block21;
                }
                String string10 = this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, false);
                throw new PluginConfigException(string10);
            }
            catch (PluginConfigException pluginConfigException) {
                throw pluginConfigException;
            }
            catch (Throwable throwable) {
                String string11 = this.notifyPropagationResults(string2, string3, string4, string5, string6, string7, false);
                throw new PluginConfigException(string11, throwable);
            }
        }
    }

    private String notifyPropagationResults(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        String string7 = null;
        if (bl) {
            if (string6.equals(FILETYPE_PLUGIN_CFG)) {
                string7 = PluginConfigGenerator.getFormattedMessage("propagate.location", new Object[]{string4, string5});
                this.notifyMessage(PROPAGATE_INFO, string7);
                string7 = nls.getString("propagate.complete") + " " + string + "." + string2 + "." + string3 + ".";
                this.notifyMessage(PROPAGATE_PLUGINCFG_COMPLETE, string7);
            } else if (string6.equals(FILETYPE_PLUGIN_KEYRING)) {
                string7 = PluginConfigGenerator.getFormattedMessage("propagate.keyring.location", new Object[]{string4, string5});
                this.notifyMessage(PROPAGATE_INFO, string7);
                string7 = nls.getString("propagate.keyring.complete") + " " + string + "." + string2 + "." + string3 + ".";
                this.notifyMessage(PROPAGATE_KEYRING_COMPLETE, string7);
            } else if (string6.equals(FILETYPE_PLUGIN_STASHFILE)) {
                string7 = PluginConfigGenerator.getFormattedMessage("propagate.stashfile.location", new Object[]{string4, string5});
                this.notifyMessage(PROPAGATE_INFO, string7);
                string7 = nls.getString("propagate.stashfile.complete") + " " + string + "." + string2 + "." + string3 + ".";
                this.notifyMessage(PROPAGATE_STASHFILE_COMPLETE, string7);
            }
        } else if (string6.equals(FILETYPE_PLUGIN_CFG)) {
            string7 = PluginConfigGenerator.getFormattedMessage("propagate.location.failed", new Object[]{string4, string5});
            this.notifyMessage(PROPAGATE_INFO, string7);
            string7 = nls.getString("propagate.failed") + " " + string + "." + string2 + "." + string3 + ".";
            this.notifyMessage(PROPAGATE_PLUGINCFG_FAILED, string7);
        } else if (string6.equals(FILETYPE_PLUGIN_KEYRING)) {
            string7 = PluginConfigGenerator.getFormattedMessage("propagate.keyring.location.failed", new Object[]{string4, string5});
            this.notifyMessage(PROPAGATE_INFO, string7);
            string7 = nls.getString("propagate.keyring.failed") + " " + string + "." + string2 + "." + string3 + ".";
            this.notifyMessage(PROPAGATE_KEYRING_FAILED, string7);
        } else if (string6.equals(FILETYPE_PLUGIN_STASHFILE)) {
            string7 = PluginConfigGenerator.getFormattedMessage("propagate.stashfile.location.failed", new Object[]{string4, string5});
            this.notifyMessage(PROPAGATE_INFO, string7);
            string7 = nls.getString("propagate.stashfile.failed") + " " + string + "." + string2 + "." + string3 + ".";
            this.notifyMessage(PROPAGATE_STASHFILE_FAILED, string7);
        }
        return string7;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            try {
                nls = TraceNLS.getTraceNLS("com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println();
                System.out.println("Unable to Find NLS Resources: " + missingResourceException.getMessage());
                System.exit(-1);
            }
            PluginConfigGenerator pluginConfigGenerator = new PluginConfigGenerator();
            String string = stringArray[1];
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            boolean bl = false;
            boolean bl2 = false;
            String string11 = "plugin-cfg.xml";
            if (stringArray.length > 4) {
                object2 = stringArray[4];
                ((String)object2).toLowerCase();
                if (((String)object2).indexOf("?") != -1 || ((String)object2).indexOf("help") != -1) {
                    PluginConfigGenerator.usage();
                    System.exit(0);
                }
                if (stringArray.length % 2 != 0) {
                    PluginConfigGenerator.usage();
                    System.exit(-1);
                } else {
                    int n = 4;
                    while (n < stringArray.length) {
                        if (((String)(object = stringArray[n++])).equalsIgnoreCase("-config.root")) {
                            string = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-wasprofile") || ((String)object).equalsIgnoreCase("-profileName")) {
                            string10 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-cell.name")) {
                            string2 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-cluster.name")) {
                            string3 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-node.name")) {
                            string4 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-webserver.name")) {
                            string6 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-server.name")) {
                            string5 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-output.file.name")) {
                            string7 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-destination.root")) {
                            string8 = stringArray[n++];
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-destination.operating.system")) {
                            int n2;
                            if (stringArray[n2 = n++].equalsIgnoreCase("windows")) {
                                string9 = "windows";
                                continue;
                            }
                            if (stringArray[n2].equalsIgnoreCase("zos") || stringArray[n2].equalsIgnoreCase("os390")) {
                                string9 = "os390";
                                continue;
                            }
                            string9 = "unix";
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-debug")) {
                            if (stringArray[n++].equalsIgnoreCase("yes")) {
                                _debugEnabled = true;
                                String string12 = stringArray[0];
                                int n3 = string.indexOf("config", 0);
                                if (n3 > 0) {
                                    string12 = string.substring(0, n3 - 1);
                                }
                                string11 = string6 != null ? string12 + File.separator + "logs" + File.separator + string6 + File.separator + "plugin-cfg.log" : string12 + File.separator + "logs" + File.separator + "plugin-cfg.log";
                                ManagerAdmin.configureClientTrace("com.ibm.websphere.plugincfg.*=all=enabled", "named file", string11, false, "basic", false);
                                continue;
                            }
                            _debugEnabled = false;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-propagate")) {
                            if (stringArray[n++].equalsIgnoreCase("yes")) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("-propagateKeyring")) {
                            if (stringArray[n++].equalsIgnoreCase("yes")) {
                                bl2 = true;
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        System.out.println();
                        System.out.println(nls.getString("unknown.parameter") + " " + (String)object);
                        PluginConfigGenerator.usage();
                        System.exit(-1);
                    }
                }
            }
            if (string2 == null) {
                string2 = stringArray[2];
            }
            if (string5 != null && string4 == null) {
                string4 = stringArray[3];
            }
            if (string6 != null && string4 == null) {
                string4 = stringArray[3];
            }
            PluginConfigGenerator.copyright();
            if (_debugEnabled) {
                System.out.println();
                System.out.println(nls.getString("debug.file.name") + " " + string11);
            }
            if (string10 != null) {
                object2 = PlatformHelperFactory.getPlatformHelper();
                String string13 = null;
                string13 = object2.isOS400() ? System.getProperty("was.profile.registry") + File.separator + "profileRegistry.xml" : stringArray[0] + File.separator + "properties" + File.separator + "profileRegistry.xml";
                object = WSProfile.getProfileLocation(string10, new File(string13));
                if (object != null) {
                    String string14 = ((File)object).getAbsolutePath();
                    if (string14 != null) {
                        string = string14 + File.separator + "config";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using profile " + string10 + " and the config location is: " + string + ".");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to get the path for the profile " + string10 + ".");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get the location for the profile " + string10 + ".");
                }
            }
            pluginConfigGenerator.modelMBeanFound = false;
            if (string6 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generating plugin config file in application centric method");
                }
                pluginConfigGenerator.generate(string, string2, string4, string6, new Boolean(bl), new Boolean(bl2));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generating plugin config file in toplology centric method");
                }
                pluginConfigGenerator.generate(stringArray[0], string, string2, string3, string4, string5, string7, string8, string9);
            }
        }
        catch (PluginConfigException pluginConfigException) {
            Throwable throwable;
            System.out.println();
            System.out.println("==========================================================================");
            System.out.println();
            System.out.println(nls.getString("exception.while.generating") + "\n\n" + pluginConfigException.getMessage());
            if (tc.isDebugEnabled()) {
                System.out.println();
                pluginConfigException.printStackTrace();
            }
            if ((throwable = pluginConfigException.getRootException()) != null) {
                System.out.println();
                System.out.println("==========================================================================");
                System.out.println();
                System.out.println(nls.getString("root.exception") + "\n " + throwable.getMessage());
                if (tc.isDebugEnabled()) {
                    System.out.println();
                    throwable.printStackTrace();
                }
            }
            System.out.println("\n==========================================================================");
            if (!tc.isDebugEnabled()) {
                System.out.println();
                System.out.println(nls.getString("rerun.with.debug"));
            }
            System.exit(-1);
        }
        catch (Throwable throwable) {
            System.out.println();
            System.out.println(nls.getString("runtime.exception.while.generating") + "\n   " + throwable.getMessage() + "\n");
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    private static void copyright() {
        System.out.println("\n" + nls.getString("product.header"));
        System.out.println(nls.getString("product.name"));
        System.out.println(nls.getString("ibm.copyright"));
    }

    private static void usage() {
        System.out.println();
        System.out.println(nls.getString("usage.1") + "\n");
        System.out.println(nls.getString("usage.2"));
        System.out.println(nls.getString("usage.separator") + "\n");
        System.out.println("     " + nls.getString("usage.3"));
        System.out.println("         " + nls.getString("usage.4"));
        System.out.println("     " + nls.getString("usage.26"));
        System.out.println("         " + nls.getString("usage.27"));
        System.out.println("     " + nls.getString("usage.5"));
        System.out.println("         " + nls.getString("usage.6"));
        System.out.println("     " + nls.getString("usage.7"));
        System.out.println("         " + nls.getString("usage.8"));
        System.out.println("     " + nls.getString("usage.9.0.1"));
        System.out.println("         " + nls.getString("usage.9.0.2"));
        System.out.println("     " + nls.getString("usage.9.0.3"));
        System.out.println("         " + nls.getString("usage.9.0.4"));
        System.out.println("         " + nls.getString("usage.9.0.5"));
        System.out.println("     " + nls.getString("usage.9.0.7"));
        System.out.println("         " + nls.getString("usage.9.0.4"));
        System.out.println("         " + nls.getString("usage.9.0.5"));
        System.out.println("     " + nls.getString("usage.9.1"));
        System.out.println("         " + nls.getString("usage.9.2"));
        System.out.println("         " + nls.getString("usage.9.0.6"));
        System.out.println("     " + nls.getString("usage.9.3"));
        System.out.println("         " + nls.getString("usage.9.4"));
        System.out.println("         " + nls.getString("usage.10"));
        System.out.println("         " + nls.getString("usage.9.0.6"));
        System.out.println("     " + nls.getString("usage.11"));
        System.out.println("         " + nls.getString("usage.12"));
        System.out.println("         " + nls.getString("usage.9.0.6"));
        System.out.println("     " + nls.getString("usage.20"));
        System.out.println("         " + nls.getString("usage.21"));
        System.out.println("         " + nls.getString("usage.9.0.6"));
        System.out.println("     " + nls.getString("usage.22"));
        System.out.println("         " + nls.getString("usage.23"));
        System.out.println("         " + nls.getString("usage.9.0.6"));
        System.out.println("     " + nls.getString("usage.13"));
        System.out.println("         " + nls.getString("usage.14") + "\n");
        System.out.println(nls.getString("usage.separator") + "\n");
        System.out.println(nls.getString("usage.15") + "\n");
        System.out.println("     " + nls.getString("usage.16"));
        System.out.println("        " + nls.getString("usage.17") + "\n");
        System.out.println("     " + nls.getString("usage.18"));
        System.out.println("        " + nls.getString("usage.19") + "\n");
        System.out.println("     " + nls.getString("usage.24"));
        System.out.println("        " + nls.getString("usage.25") + "\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void outputPluginConfigFile(ConfigurationParser configurationParser, String string, String string2, String string3) throws PluginConfigException {
        PluginDocumentGenerator pluginDocumentGenerator = new PluginDocumentGenerator();
        try {
            Object object;
            block25: {
                String string4;
                String string5;
                org.w3c.dom.Document document;
                block26: {
                    String[] stringArray;
                    String string6;
                    int n;
                    document = pluginDocumentGenerator.createPluginConfigDocument(configurationParser);
                    if (document == null) return;
                    string5 = RequestUtils.getEbcdicEncodingIfZos();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Encoding returned from RequestUtils.getEbcdicEncodingIfZos() : " + string5);
                    }
                    if (string5 != null) {
                        string5 = "iso-8859-1";
                    }
                    if ((string4 = string5) == null) {
                        string4 = SRTRequestUtils.getEncodingFromLocale((Locale)Locale.getDefault());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Local Encoding returned from SRTRequestUtils.getEncodingFromLocale() : " + string4);
                        }
                        if (string4 == null) {
                            string4 = "iso-8859-1";
                        }
                    }
                    if (string3 != null && string3.equals("os390")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Web server is running on z ");
                        }
                        string4 = string5 = "iso-8859-1";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "zOSEncoding is : " + string5);
                        Tr.debug(tc, "Encoding    is : " + string4);
                    }
                    if ((n = string.indexOf(string6 = "config" + File.separator + "cells" + File.separator, 0)) <= 0) break block26;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Plugin config file location is within repository.");
                    }
                    if (configurationParser.getWebserverName() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Existing values are retained.");
                        }
                        document = this.replaceOldValues(document, string, string2, string5);
                    }
                    object = string.substring(n + "config".length() + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Plugin config file doc name : " + (String)object);
                    }
                    Properties properties = new Properties();
                    properties.setProperty("location", "local");
                    properties.setProperty("was.repository.root", configurationParser.getAppServerConfigRoot());
                    ConfigRepository configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Local config repository client created ");
                    }
                    StringWriter stringWriter = new StringWriter();
                    this.outputPluginConfigFile(document, stringWriter, string4, string5);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringWriter.toString().getBytes(string4));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Document has been converted into String");
                    }
                    if ((stringArray = configRepository.listResourceNames((String)object, 1, 0)).length == 0) {
                        Document document2 = new Document((String)object);
                        document2.setOverwrite(true);
                        DocumentContentSource documentContentSource = new DocumentContentSource(document2, byteArrayInputStream);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Plugin config file doesn't exist");
                        }
                        configRepository.create(documentContentSource);
                        break block25;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Plugin config file already exists");
                        }
                        DocumentDigest documentDigest = configRepository.getDigest((String)object);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Current Digest :" + documentDigest);
                        }
                        Document document3 = new Document((String)object, documentDigest);
                        document3.setOverwrite(true);
                        DocumentContentSource documentContentSource = new DocumentContentSource(document3, byteArrayInputStream);
                        try {
                            configRepository.modify(documentContentSource);
                        }
                        catch (DocumentChangedException documentChangedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Plugin config file is already updated");
                            }
                            break block25;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Plugin config file location is not within repository.");
                }
                object = new File(string);
                document = this.replaceOldValues(document, string, string2, string5);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), string4));
                this.outputPluginConfigFile(document, bufferedWriter, string4, string5);
            }
            System.out.println();
            object = nls.getString("config.file.name") + " " + string;
            this.notifyMessage(GENERATE_INFO, (String)object);
            if (configurationParser.getWebserverName() == null) return;
            object = nls.getString("generate.complete") + " " + configurationParser.getCellName() + "." + configurationParser.getNodeName() + "." + configurationParser.getWebserverName() + ".";
            this.notifyMessage(GENERATE_COMPLETE, (String)object);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator.generatePluginConfigFile", "170", this);
            throw new PluginConfigException(nls.getString("doc.output.exception"), throwable);
        }
    }

    private void outputPluginConfigFile(org.w3c.dom.Document document, Writer writer, String string, String string2) throws PluginConfigException {
        try {
            StreamSource streamSource = new StreamSource(new StringReader(styleSheet));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            Properties properties = new Properties();
            properties.put("method", "xml");
            properties.put("omit-xml-declaration", "no");
            properties.put("version", "1.0");
            if (string2 == null) {
                properties.put("encoding", string);
            }
            properties.put("indent", "yes");
            transformer.setOutputProperties(properties);
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            writer.flush();
            writer.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator.generatePluginConfigFile", "170", this);
            throw new PluginConfigException(nls.getString("doc.output.exception"), throwable);
        }
    }

    private org.w3c.dom.Document replaceOldValues(org.w3c.dom.Document document, String string, String string2, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            return document;
        }
        org.w3c.dom.Document document2 = null;
        try {
            Object object;
            Node node;
            Element element;
            Node node2;
            int n;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            BufferedReader bufferedReader = null;
            bufferedReader = string3 == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string3));
            DocumentBuilder documentBuilder = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Object var10_14 = null;
            document2 = documentBuilder.parse(new InputSource(bufferedReader));
            bufferedReader.close();
            NodeList nodeList = document2.getElementsByTagName("Log");
            NodeList nodeList2 = document.getElementsByTagName("Log");
            if (nodeList.item(0) != null && nodeList2.item(0) != null) {
                object6 = (Element)nodeList.item(0);
                object5 = (Element)nodeList2.item(0);
                if (string2 == null && !object6.getAttribute("Name").equals("")) {
                    object5.setAttribute("Name", object6.getAttribute("Name"));
                }
                if (!object6.getAttribute("LogLevel").equals("")) {
                    object5.setAttribute("LogLevel", object6.getAttribute("LogLevel"));
                }
            }
            object6 = document2.getElementsByTagName("Config");
            object5 = document.getElementsByTagName("Config");
            Object object7 = null;
            Object object8 = null;
            if (object6.item(0) != null && object5.item(0) != null) {
                object7 = object4 = (Element)object6.item(0);
                object8 = object3 = (Element)object5.item(0);
                if (!object4.getAttribute("RefreshInterval").equals("")) {
                    object3.setAttribute("RefreshInterval", object4.getAttribute("RefreshInterval"));
                }
                if (!object4.getAttribute("IgnoreDNSFailures").equals("")) {
                    object3.setAttribute("IgnoreDNSFailures", object4.getAttribute("IgnoreDNSFailures"));
                }
                if (!object4.getAttribute("ResponseChunkSize").equals("")) {
                    object3.setAttribute("ResponseChunkSize", object4.getAttribute("ResponseChunkSize"));
                }
                if (!object4.getAttribute("ASDisableNagle").equals("")) {
                    object3.setAttribute("ASDisableNagle", object4.getAttribute("ASDisableNagle"));
                }
                if (!object4.getAttribute("IISDisableNagle").equals("")) {
                    object3.setAttribute("IISDisableNagle", object4.getAttribute("IISDisableNagle"));
                }
                if (!object4.getAttribute("AcceptAllContent").equals("")) {
                    object3.setAttribute("AcceptAllContent", object4.getAttribute("AcceptAllContent"));
                }
                if (!object4.getAttribute("VHostMatchingCompat").equals("")) {
                    object3.setAttribute("VHostMatchingCompat", object4.getAttribute("VHostMatchingCompat"));
                }
                if (!object4.getAttribute("AppServerPortPreference").equals("")) {
                    object3.setAttribute("AppServerPortPreference", object4.getAttribute("AppServerPortPreference"));
                }
                if (!object4.getAttribute("ChunkedResponse").equals("")) {
                    object3.setAttribute("ChunkedResponse", object4.getAttribute("ChunkedResponse"));
                }
                if (!object4.getAttribute("IISPluginPriority").equals("")) {
                    object3.setAttribute("IISPluginPriority", object4.getAttribute("IISPluginPriority"));
                }
                if (!object4.getAttribute("HTTPMaxHeaders").equals("")) {
                    object3.setAttribute("HTTPMaxHeaders", object4.getAttribute("HTTPMaxHeaders"));
                }
                if (!object4.getAttribute("SSLPKCSDriver").equals("")) {
                    object3.setAttribute("SSLPKCSDriver", object4.getAttribute("SSLPKCSDriver"));
                }
                if (!object4.getAttribute("SSLPKCSPassword").equals("")) {
                    object3.setAttribute("SSLPKCSPassword", object4.getAttribute("SSLPKCSPassword"));
                }
                if (!object4.getAttribute("SSLConsidate").equals("")) {
                    object3.setAttribute("SSLConsolidate", object4.getAttribute("SSLConsolidate"));
                }
                if (!object4.getAttribute("TrustedProxyEnable").equals("")) {
                    object3.setAttribute("TrustedProxyEnable", object4.getAttribute("TrustedProxyEnable"));
                }
            }
            object4 = document2.getElementsByTagName("Property");
            object3 = document.getElementsByTagName("Property");
            for (int i = 0; i < object4.getLength(); ++i) {
                if (object4.item(i) == null) continue;
                object2 = (Element)object4.item(i);
                if (object2.getParentNode() == object7) {
                    for (n = 0; n < object3.getLength(); ++n) {
                        Element element2 = (Element)object3.item(n);
                        if (!element2.getAttribute("Name").equals(object2.getAttribute("Name")) || object2.getAttribute("Value").equals("")) continue;
                        element2.setAttribute("Value", object2.getAttribute("Value"));
                    }
                    continue;
                }
                n = 0;
                for (int j = 0; j < object3.getLength(); ++j) {
                    String string4;
                    boolean bl;
                    Element element3 = (Element)object3.item(j);
                    node2 = element3.getParentNode();
                    Node node3 = object2.getParentNode();
                    if (node3 == null || node2 == null || node3.getNodeType() != 1 || node2.getNodeType() != 1) continue;
                    element = (Element)node3;
                    node = (Element)node2;
                    object = element.getAttribute("Hostname");
                    String string5 = element.getAttribute("Port");
                    String string6 = element.getAttribute("Protocol");
                    String string7 = node.getAttribute("Hostname");
                    String string8 = node.getAttribute("Port");
                    String string9 = node.getAttribute("Protocol");
                    boolean bl2 = bl = ((String)object).equals(string7) && string5.equals(string8) && string6.equals(string9);
                    if (!bl) continue;
                    String string10 = object2.getAttribute("name");
                    if (string10 == null || string10.equals("")) {
                        string10 = object2.getAttribute("Name");
                    }
                    if ((string4 = object2.getAttribute("value")) == null || string4.equals("")) {
                        string4 = object2.getAttribute("Value");
                    }
                    if (element3.getAttribute("Name").equals(string10)) {
                        if (string4 == null || string4.equals("")) continue;
                        boolean bl3 = true;
                        if (string2 != null && (string10.equals("keyring") || string10.equals("stashfile"))) {
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        element3.setAttribute("Value", string4);
                        continue;
                    }
                    if (!string10.equalsIgnoreCase("certLabel") || n != 0) continue;
                    n = 1;
                    Element element4 = document.createElement("Property");
                    element4.setAttribute("Name", "certLabel");
                    element4.setAttribute("Value", string4);
                    node.appendChild(element4);
                }
            }
            NodeList nodeList3 = document2.getElementsByTagName("ServerCluster");
            object2 = document.getElementsByTagName("ServerCluster");
            for (n = 0; n < object2.getLength(); ++n) {
                if (object2.item(n) == null) continue;
                Element element5 = (Element)object2.item(n);
                for (int i = 0; i < nodeList3.getLength(); ++i) {
                    if (nodeList3.item(i) == null) continue;
                    node2 = (Element)nodeList3.item(i);
                    if (!element5.getAttribute("Name").equals(node2.getAttribute("Name"))) continue;
                    if (!node2.getAttribute("LoadBalance").equals("")) {
                        element5.setAttribute("LoadBalance", node2.getAttribute("LoadBalance"));
                    }
                    if (!node2.getAttribute("RetryInterval").equals("")) {
                        element5.setAttribute("RetryInterval", node2.getAttribute("RetryInterval"));
                    }
                    if (!node2.getAttribute("IgnoreAffinityRequests").equals("")) {
                        element5.setAttribute("IgnoreAffinityRequests", node2.getAttribute("IgnoreAffinityRequests"));
                    }
                    if (!node2.getAttribute("RemoveSpecialHeaders").equals("")) {
                        element5.setAttribute("RemoveSpecialHeaders", node2.getAttribute("RemoveSpecialHeaders"));
                    }
                    if (!node2.getAttribute("PostSizeLimit").equals("")) {
                        element5.setAttribute("PostSizeLimit", node2.getAttribute("PostSizeLimit"));
                    }
                    if (!node2.getAttribute("PostBufferSize").equals("")) {
                        element5.setAttribute("PostBufferSize", node2.getAttribute("PostBufferSize"));
                    }
                    if (node2.getAttribute("GetDWLMTable").equals("")) continue;
                    element5.setAttribute("GetDWLMTable", node2.getAttribute("GetDWLMTable"));
                }
            }
            NodeList nodeList4 = document2.getElementsByTagName("Server");
            NodeList nodeList5 = document.getElementsByTagName("Server");
            for (int i = 0; i < nodeList5.getLength(); ++i) {
                if (nodeList5.item(i) == null) continue;
                node2 = (Element)nodeList5.item(i);
                for (int j = 0; j < nodeList4.getLength(); ++j) {
                    if (nodeList4.item(j) == null) continue;
                    element = (Element)nodeList4.item(j);
                    node = node2.getParentNode();
                    object = element.getParentNode();
                    if (!object.getNodeName().equals("ServerCluster") || !node.getNodeName().equals("ServerCluster") || !node2.getAttribute("Name").equals(element.getAttribute("Name"))) continue;
                    if (!element.getAttribute("WaitForContinue").equals("")) {
                        node2.setAttribute("WaitForContinue", element.getAttribute("WaitForContinue"));
                    }
                    if (!element.getAttribute("ConnectTimeout").equals("")) {
                        node2.setAttribute("ConnectTimeout", element.getAttribute("ConnectTimeout"));
                    }
                    if (!element.getAttribute("ServerIOTimeout").equals("")) {
                        node2.setAttribute("ServerIOTimeout", element.getAttribute("ServerIOTimeout"));
                    }
                    if (!element.getAttribute("MaxConnections").equals("")) {
                        node2.setAttribute("MaxConnections", element.getAttribute("MaxConnections"));
                    }
                    if (element.getAttribute("ExtendedHandshake").equals("")) continue;
                    node2.setAttribute("ExtendedHandshake", element.getAttribute("ExtendedHandshake"));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Tr.warning(tc, "Problem in replacing Old Values " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            Tr.warning(tc, "Problem in replacing Old Values " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            Tr.warning(tc, "Problem in replacing Old Values" + iOException.getMessage());
        }
        return document;
    }

    private String determineOutputFileName(String string, String string2, String string3) {
        return this.determineOutputFileName(string, string2, string3, null, null, null, null);
    }

    private String determineOutputFileName(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8;
        if (string3 == null) {
            string3 = "plugin-cfg.xml";
        }
        if (string7 != null) {
            int n = string3.lastIndexOf(string4);
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string8 = string + "config" + File.separator + "cells" + File.separator + string5 + File.separator + "nodes" + File.separator + string6 + File.separator + "servers" + File.separator + string7 + File.separator + string3;
        } else {
            if (string3.indexOf(File.separator) >= 0) {
                File file;
                File file2 = new File(string3);
                String string9 = file2.getParent();
                if (string9 != null && !(file = new File(string9)).exists()) {
                    file.mkdirs();
                }
                return string3;
            }
            String string10 = System.getProperty("user.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverRoot    --> " + string10);
            }
            if (string10 == null) {
                string10 = string;
                int n = string2.indexOf("config", 0);
                if (n > 0) {
                    string10 = string2.substring(0, n - 1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appServerRoot --> " + string);
                    Tr.debug(tc, "configRoot    --> " + string2);
                    Tr.debug(tc, "serverRoot    --> " + string10);
                }
            }
            if (!string10.endsWith(File.separator)) {
                string10 = string10 + File.separator;
            }
            string8 = string10 + "config" + File.separator + "cells" + File.separator + string3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "qualifiedOutputFileName --> " + string8);
            }
        }
        return string8;
    }

    private boolean isSynchronized(String string, String string2, String string3) {
        boolean bl;
        block10: {
            bl = false;
            try {
                if (this.getAdminService() != null) {
                    ObjectName objectName = null;
                    String string4 = "WebSphere:cell=" + string + ",type=NodeSync,node=" + string2 + ",process=nodeagent,*";
                    ObjectName objectName2 = new ObjectName(string4);
                    Iterator iterator = this.getAdminService().queryNames(objectName2, null).iterator();
                    if (iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        if (iterator.hasNext() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "More than one query string returned.");
                        }
                    }
                    if (objectName != null) {
                        Object object = this.getAdminService().invoke(objectName, "isNodeSynchronized", new Object[0], new String[0]);
                        bl = new Boolean(object.toString());
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NodeSync Mbean is not available. The node " + string2 + " is not started.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin service is not available.");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Node Sync is not started.");
            }
        }
        return bl;
    }

    private boolean startNodeSync(String string, String string2, String string3) {
        boolean bl;
        block10: {
            bl = false;
            try {
                if (this.getAdminService() != null) {
                    ObjectName objectName = null;
                    String string4 = "WebSphere:cell=" + string + ",type=NodeSync,node=" + string2 + ",process=nodeagent,*";
                    ObjectName objectName2 = new ObjectName(string4);
                    Iterator iterator = this.getAdminService().queryNames(objectName2, null).iterator();
                    if (iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        if (iterator.hasNext() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "More than one query string returned.");
                        }
                    }
                    if (objectName != null) {
                        this.getAdminService().invoke(objectName, "requestSync", new Object[0], new String[0]);
                        bl = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NodeSync Mbean is not available. The node " + string2 + " is not started.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin service is not available.");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Node Sync is not started.");
            }
        }
        return bl;
    }

    public static boolean startLocalTransfer(String string, String string2) throws IOException {
        Object object;
        boolean bl = false;
        if (string.equalsIgnoreCase(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The source and destination are same. No need do local file copy.");
            }
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The source file doesn't exist.");
            }
            return false;
        }
        File file2 = new File(string2);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
            object = PlatformHelperFactory.getPlatformHelper();
            if (object.isOS400()) {
                PluginConfigGenerator.grantOs400Authorities(file2.getParentFile().getAbsolutePath(), "QTMHHTTP", "*RWX");
                PluginConfigGenerator.grantOs400Authorities(file2.getParentFile().getAbsolutePath(), "QNOTES", "*RWX");
                PluginConfigGenerator.grantOs400Authorities(file2.getParentFile().getAbsolutePath(), "QEJBSVR", "*RWX");
            }
        }
        object = new FileInputStream(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2.getCanonicalPath(), false);
        int n = 8192;
        byte[] byArray = new byte[n];
        int n2 = ((FileInputStream)object).read(byArray);
        while (n2 != -1) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = ((FileInputStream)object).read(byArray);
        }
        ((FileInputStream)object).close();
        fileOutputStream.flush();
        fileOutputStream.close();
        object = null;
        fileOutputStream = null;
        bl = true;
        return bl;
    }

    private AdminService getAdminService() {
        if (adminService == null) {
            adminService = AdminServiceFactory.getAdminService();
        }
        return adminService;
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Recived Notification. Type: " + notification.getType() + "Message: " + notification.getMessage());
        }
        this.notifyMessage(notification.getType(), notification.getMessage());
    }

    public static String getDefaultConfigRoot() {
        String string = System.getProperty("server.root");
        if (string == null) {
            string = System.getProperty("user.install.root");
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + "config";
    }

    private void notifyMessage(String string, String string2) {
        try {
            System.out.println();
            System.out.println(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification type: " + string + "Message: " + string2);
            }
            if (this.modelMBeanFound) {
                Notification notification = new Notification(string, this, this.notifySeqNum++);
                notification.setUserData(string2);
                this.sendNotification(notification);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notification sent.");
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to notify message.");
            }
            this.modelMBeanFound = false;
        }
    }

    private void correctOs400Authorities(String string, String string2, String string3) {
        String string4 = System.getProperty("user.install.root");
        if (string4 == null) {
            string4 = string;
        }
        File file = new File(string4);
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(string4.length()), string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            file = new File(file, string5);
            PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QTMHHTTP", "*RX");
            PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QNOTES", "*RX");
            PluginConfigGenerator.grantOs400Authorities(file.getAbsolutePath(), "QEJBSVR", "*RWX");
        }
    }

    public static void grantOs400Authorities(String string, String string2, String string3) {
        try {
            String[] stringArray = new String[]{"system", "CHGAUT", "OBJ('" + string + "')", "USER(" + string2 + ")", "DTAAUT(" + string3 + ")", "OBJAUT(*OBJEXIST *OBJMGT *OBJALTER *OBJREF)"};
            Process process = Runtime.getRuntime().exec(stringArray);
            byte[] byArray = new byte[1024];
            InputStream inputStream = process.getInputStream();
            while (inputStream.read(byArray) > 0) {
            }
            inputStream = process.getErrorStream();
            while (inputStream.read(byArray) > 0) {
            }
        }
        catch (Exception exception) {
            System.out.println("NON-CRITICAL Exception during plugin file authority configuration:");
            exception.printStackTrace();
        }
    }

    public static String getFormattedMessage(String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = nls.getString(string);
            if (string2 != null) {
                string2 = MessageFormat.format(string2, objectArray);
            }
        }
        catch (MissingResourceException missingResourceException) {
            Tr.debug(tc, "Cannot find message key in resource bundle " + nls.toString());
        }
        catch (NullPointerException nullPointerException) {
            Tr.debug(tc, "Null pointer exception caught trying to find message key " + string + " in resource bundle " + nls.toString());
        }
        return string2;
    }

    private boolean checkRoleSecurity() {
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer != null) {
            if (adminAuthorizer.isCallerInRole("configurator") || adminAuthorizer.isCallerInRole("administrator") || adminAuthorizer.isCallerInRole("operator")) {
                return true;
            }
            if (adminAuthorizer.isCallerInRole("deployer")) {
                String string = System.getProperty("allowDeployerRoleGenPluginCfg");
                if (string == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "User is in deployer role; allowDeployerRoleGenPluginCfg is set to " + string);
                }
                if (string.equalsIgnoreCase("true")) {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        nlsInit = false;
        adminService = null;
    }
}

