/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.models.base.extensions.webappext.FileServingAttribute;
import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.pmirm.PMIRMFilter;
import com.ibm.websphere.models.config.pmirm.PMIRMFilterValue;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jsp.JSPPropertyGroup;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginDocumentGenerator {
    protected static TraceComponent tc = Tr.register(PluginDocumentGenerator.class);
    private Vector adminPorts = new Vector();
    private Document _pluginConfigDocument = null;

    public String getLabel() {
        return "Generate Plugin Configuration from WCCM Model";
    }

    public String getDescription() {
        return "Generate Plugin Configuration from WCCM Model";
    }

    public void redo() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Redo not Supported");
        }
    }

    public boolean canUndo() {
        return false;
    }

    public Document createPluginConfigDocument(ConfigurationParser configurationParser) throws PluginConfigException {
        String string = "createPluginConfigDocument(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        int n = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            EList eList;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            this._pluginConfigDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Comment comment = this._pluginConfigDocument.createComment(configurationParser.getConfigFileComment());
            this._pluginConfigDocument.appendChild(comment);
            ConfigurationParser.PluginConfigData pluginConfigData = configurationParser.getPluginConfigData();
            Element element = this._pluginConfigDocument.createElement("Config");
            element.setAttribute("RefreshInterval", pluginConfigData.RefreshInterval.toString());
            element.setAttribute("IgnoreDNSFailures", pluginConfigData.IgnoreDNSFailures.toString());
            element.setAttribute("ResponseChunkSize", pluginConfigData.ResponseChunkSize.toString());
            element.setAttribute("ASDisableNagle", pluginConfigData.ASDisableNagle.toString());
            element.setAttribute("IISDisableNagle", pluginConfigData.IISDisableNagle.toString());
            element.setAttribute("FIPSEnable", pluginConfigData.FIPSEnable.toString());
            element.setAttribute("AcceptAllContent", pluginConfigData.AcceptAllContent.toString());
            element.setAttribute("VHostMatchingCompat", pluginConfigData.VHostMatchingCompat.toString());
            element.setAttribute("AppServerPortPreference", pluginConfigData.AppServerPortPreference);
            element.setAttribute("ChunkedResponse", pluginConfigData.ChunkedResponse.toString());
            element.setAttribute("IISPluginPriority", pluginConfigData.IISPluginPriority);
            element.setAttribute("HTTPMaxHeaders", pluginConfigData.HTTPMaxHeaders.toString());
            if (pluginConfigData.SSLPKCSDriver != null) {
                element.setAttribute("SSLPKCSDriver", pluginConfigData.SSLPKCSDriver.toString());
            }
            if (pluginConfigData.SSLPKCSPassword != null) {
                element.setAttribute("SSLPKCSPassword", pluginConfigData.SSLPKCSPassword.toString());
            }
            if (pluginConfigData.SSLConsolidate != null) {
                element.setAttribute("SSLConsolidate", pluginConfigData.SSLConsolidate.toString());
            }
            element.setAttribute("TrustedProxyEnable", pluginConfigData.TrustedProxyEnable.toString());
            this._pluginConfigDocument.appendChild(element);
            Element element2 = this._pluginConfigDocument.createElement("Log");
            element2.setAttribute("Name", pluginConfigData.LogFile);
            element2.setAttribute("LogLevel", pluginConfigData.LogLevel);
            element.appendChild(element2);
            Element element3 = this._pluginConfigDocument.createElement("Property");
            element3.setAttribute("Name", "ESIEnable");
            element3.setAttribute("Value", pluginConfigData.ESIEnable.toString());
            element.appendChild(element3);
            Element element4 = this._pluginConfigDocument.createElement("Property");
            element4.setAttribute("Name", "ESIMaxCacheSize");
            element4.setAttribute("Value", pluginConfigData.ESIMaxCacheSize.toString());
            element.appendChild(element4);
            Element element5 = this._pluginConfigDocument.createElement("Property");
            element5.setAttribute("Name", "ESIInvalidationMonitor");
            element5.setAttribute("Value", pluginConfigData.ESIInvalidationMonitor.toString());
            element.appendChild(element5);
            Element element6 = this._pluginConfigDocument.createElement("Property");
            element6.setAttribute("Name", "ESIEnableToPassCookies");
            element6.setAttribute("Value", pluginConfigData.ESIEnableToPassCookies.toString());
            element.appendChild(element6);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the Log element");
            }
            HashMap<String, VirtualHost> hashMap2 = new HashMap<String, VirtualHost>();
            VirtualHost virtualHost = null;
            Iterator<Object> iterator = configurationParser.getVHostNames().iterator();
            while (iterator.hasNext()) {
                Object object11;
                object10 = (String)iterator.next();
                virtualHost = configurationParser.getVHost((String)object10);
                if (virtualHost == null) continue;
                if (((String)object10).equals("admin_host")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not including virtual host \"" + (String)object10 + "\" in plugin-cfg.xml");
                    }
                    object9 = virtualHost.getAliases().iterator();
                    while (object9.hasNext()) {
                        object8 = (HostAlias)object9.next();
                        object7 = object8.getHostname();
                        object11 = String.valueOf(object8.getPort());
                        this.adminPorts.addElement((String)object7 + ":" + (String)object11);
                    }
                    continue;
                }
                hashMap2.put(virtualHost.getName(), virtualHost);
                object9 = this._pluginConfigDocument.createElement("VirtualHostGroup");
                object9.setAttribute("Name", virtualHost.getName());
                element.appendChild((Node)object9);
                object8 = virtualHost.getAliases().iterator();
                while (object8.hasNext()) {
                    object7 = (HostAlias)object8.next();
                    object11 = this._pluginConfigDocument.createElement("VirtualHost");
                    if (object7.getHostname().indexOf(":") != object7.getHostname().lastIndexOf(":")) {
                        object11.setAttribute("Name", "[" + object7.getHostname() + "]:" + String.valueOf(object7.getPort()));
                    } else {
                        object11.setAttribute("Name", object7.getHostname() + ":" + String.valueOf(object7.getPort()));
                    }
                    object9.appendChild((Node)object11);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the VirtualHost element");
            }
            if (pluginConfigData.TrustedProxyList != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding custom property TrustedProxyGroup element and its associated proxy servers");
                }
                object10 = this._pluginConfigDocument.createElement("TrustedProxyGroup");
                element.appendChild((Node)object10);
                object9 = new StringTokenizer(pluginConfigData.TrustedProxyList, ",");
                object8 = null;
                while (((StringTokenizer)object9).hasMoreElements()) {
                    object8 = ((StringTokenizer)object9).nextElement().toString().trim();
                    object7 = this._pluginConfigDocument.createElement("TrustedProxy");
                    if (((String)object8).indexOf(":") != -1) {
                        object7.setAttribute("Name", "[" + (String)object8 + "]");
                    } else {
                        object7.setAttribute("Name", (String)object8);
                    }
                    object10.appendChild((Node)object7);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added proxy server " + (String)object8 + " TrustedProxyGroup element");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added custom property TrustedProxyGroup element");
            }
            object10 = configurationParser.getServerClusters().iterator();
            object9 = null;
            object8 = null;
            int n2 = 0;
            int n3 = 0;
            while (object10.hasNext()) {
                Object object12;
                String string2;
                Object object13;
                Object object14;
                object6 = (ConfigurationParser.ServerClusterData)object10.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the ServerCluster " + ((ConfigurationParser.ServerClusterData)object6).clusterName);
                    ((ConfigurationParser.ServerClusterData)object6).print(tc);
                }
                object5 = this._pluginConfigDocument.createElement("ServerCluster");
                object5.setAttribute("Name", ((ConfigurationParser.ServerClusterData)object6).clusterName);
                object5.setAttribute("LoadBalance", ((ConfigurationParser.ServerClusterData)object6).loadBalance);
                if (pluginConfigData.ignoreAffinityRequests != null) {
                    object5.setAttribute("IgnoreAffinityRequests", pluginConfigData.ignoreAffinityRequests.toString());
                }
                object5.setAttribute("RetryInterval", ((ConfigurationParser.ServerClusterData)object6).retryInterval.toString());
                object5.setAttribute("RemoveSpecialHeaders", ((ConfigurationParser.ServerClusterData)object6).removeSpecialHeaders.toString());
                object5.setAttribute("CloneSeparatorChange", ((ConfigurationParser.ServerClusterData)object6).cloneSeparatorChange.toString());
                object5.setAttribute("PostSizeLimit", ((ConfigurationParser.ServerClusterData)object6).postSizeLimit.toString());
                object5.setAttribute("PostBufferSize", ((ConfigurationParser.ServerClusterData)object6).postBufferSize.toString());
                object5.setAttribute("GetDWLMTable", ((ConfigurationParser.ServerClusterData)object6).GetDWLMTable.toString());
                if (!((ConfigurationParser.ServerClusterData)object6).singleServerConfig.booleanValue()) {
                    object9 = this._pluginConfigDocument.createElement("PrimaryServers");
                    object8 = this._pluginConfigDocument.createElement("BackupServers");
                }
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                object4 = null;
                boolean bl4 = false;
                n = ((ConfigurationParser.ServerClusterData)object6).clusterServers.size();
                for (int i = 0; i < n; ++i) {
                    eList = (ConfigurationParser.ServerData)((ConfigurationParser.ServerClusterData)object6).clusterServers.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the Server defintion " + eList.nodeName + "_" + eList.serverName);
                        eList.print(tc);
                    }
                    if ("WORKPLACE_SERVER".equals(eList.serverType)) {
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Lotus cluster found");
                        }
                    }
                    if ("BUS_TUNNEL_SERVER".equals(eList.serverType)) {
                        bl2 = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bus cluster found");
                        }
                    }
                    if ("TUNNEL_SERVER".equals(eList.serverType)) {
                        bl3 = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Tunnel cluster found");
                        }
                    }
                    object14 = this._pluginConfigDocument.createElement("Server");
                    object14.setAttribute("Name", eList.nodeName + "_" + eList.serverName);
                    if (eList.wlmWeight != -1) {
                        object14.setAttribute("LoadBalanceWeight", eList.wlmWeight.toString());
                    }
                    if (!eList.serverID.equals("")) {
                        object14.setAttribute("CloneID", eList.serverID);
                    }
                    object14.setAttribute("ConnectTimeout", eList.connectTimeout.toString());
                    object14.setAttribute("ServerIOTimeout", eList.serverIOTimeout.toString());
                    object14.setAttribute("WaitForContinue", eList.waitForContinue.toString());
                    object14.setAttribute("MaxConnections", eList.maxConnections.toString());
                    object14.setAttribute("ExtendedHandshake", eList.extendedHandshake.toString());
                    object5.appendChild((Node)object14);
                    if (eList.transports != null) {
                        iterator = eList.transports.iterator();
                        object3 = null;
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            if (object2 instanceof Transport) {
                                object13 = ((Transport)object2).getAddress();
                                object3 = new ConfigurationParser.TransportData(object13.getHost(), object13.getPort(), ((Transport)object2).isSslEnabled());
                            } else {
                                object3 = (ConfigurationParser.TransportData)object2;
                            }
                            if (bl3) {
                                object4 = object3;
                            }
                            object13 = this._pluginConfigDocument.createElement("Transport");
                            string2 = ((ConfigurationParser.TransportData)object3).host;
                            if (string2 == null || string2.equals("") || string2.equals("*") || string2.equalsIgnoreCase("localhost")) {
                                string2 = eList.hostName;
                            }
                            if (string2.equalsIgnoreCase("localhost")) {
                                Tr.warning(tc, "Using localhost as the host name for the transport for the server " + eList.nodeName + "." + eList.serverName + ". Request routing will work as long as web server and application server are collocated");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding the Transport defintion " + string2);
                                ((ConfigurationParser.TransportData)object3).print(tc);
                            }
                            object13.setAttribute("Hostname", string2);
                            String string3 = Integer.toString(((ConfigurationParser.TransportData)object3).port);
                            object13.setAttribute("Port", string3);
                            if (((ConfigurationParser.TransportData)object3).isSslEnabled) {
                                object13.setAttribute("Protocol", "https");
                                Element element7 = this._pluginConfigDocument.createElement("Property");
                                element7.setAttribute("Name", "keyring");
                                element7.setAttribute("Value", pluginConfigData.KeyringLocation);
                                object13.appendChild(element7);
                                Element element8 = this._pluginConfigDocument.createElement("Property");
                                element8.setAttribute("Name", "stashfile");
                                element8.setAttribute("Value", pluginConfigData.StashfileLocation);
                                object13.appendChild(element8);
                                if (pluginConfigData.CertLabel != null) {
                                    object12 = this._pluginConfigDocument.createElement("Property");
                                    object12.setAttribute("Name", "certLabel");
                                    object12.setAttribute("Value", pluginConfigData.CertLabel);
                                    object13.appendChild((Node)object12);
                                }
                            } else {
                                object13.setAttribute("Protocol", "http");
                            }
                            if (this.isAdminTransport(string3)) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Admin transport -->" + string2 + ": " + string3 + "<-- will not be added to plugin-cfg.xml");
                                continue;
                            }
                            object14.appendChild((Node)object13);
                        }
                    }
                    element.appendChild((Node)object5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added the Transports");
                    }
                    if (((ConfigurationParser.ServerClusterData)object6).singleServerConfig.booleanValue()) continue;
                    object3 = this._pluginConfigDocument.createElement("Server");
                    object3.setAttribute("Name", eList.nodeName + "_" + eList.serverName);
                    if (eList.roleKind == 0) {
                        object9.appendChild((Node)object3);
                        ++n2;
                        continue;
                    }
                    object8.appendChild((Node)object3);
                    ++n3;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of primary servers: " + n2 + " Number of backup servers: " + n3);
                }
                if (!((ConfigurationParser.ServerClusterData)object6).singleServerConfig.booleanValue()) {
                    if (n2 > 0) {
                        object5.appendChild((Node)object9);
                    }
                    if (n3 > 0) {
                        object5.appendChild((Node)object8);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added all Transports for cluster " + ((ConfigurationParser.ServerClusterData)object6).clusterName);
                }
                object = new HashMap();
                eList = new Vector();
                if (((ConfigurationParser.ServerClusterData)object6).deployedModules != null) {
                    iterator = ((ConfigurationParser.ServerClusterData)object6).deployedModules.iterator();
                    while (iterator.hasNext()) {
                        String string4;
                        Object object15;
                        String string5;
                        Object object16;
                        Object object17;
                        object14 = (ConfigurationParser.DeployedModuleData)iterator.next();
                        if (tc.isDebugEnabled()) {
                            ((ConfigurationParser.DeployedModuleData)object14).print(tc);
                        }
                        if (((ConfigurationParser.DeployedModuleData)object14).moduleConfig == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "moduleConfig not available");
                            continue;
                        }
                        object3 = ((ConfigurationParser.DeployedModuleData)object14).moduleConfig.getContextRoot();
                        if (!((String)object3).startsWith("/")) {
                            object3 = "/" + (String)object3;
                        }
                        if ((object2 = ((ConfigurationParser.DeployedModuleData)object14).moduleBindings.getVirtualHostName()) == null || ((String)object2).equals("")) {
                            object2 = "default_host";
                        }
                        if (!((HashMap)object).containsKey(object2)) {
                            ((HashMap)object).put(object2, new Vector());
                        }
                        object13 = (Vector)((HashMap)object).get(object2);
                        string2 = (String)object2 + (String)object3;
                        if (eList.contains(string2)) {
                            Tr.warning(tc, "duplicate.context.root", object3);
                        }
                        eList.addElement(string2);
                        boolean bl5 = true;
                        boolean bl6 = false;
                        if (((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.isSetFileServingEnabled()) {
                            bl5 = ((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.isFileServingEnabled();
                        } else if (!((ConfigurationParser.ServerClusterData)object6).fileServingEnabled.equals("notDefined")) {
                            bl5 = new Boolean(((ConfigurationParser.ServerClusterData)object6).fileServingEnabled);
                        }
                        if (!((ConfigurationParser.ServerClusterData)object6).disallowAllFileServing.equals("notDefined")) {
                            bl6 = new Boolean(((ConfigurationParser.ServerClusterData)object6).disallowAllFileServing);
                        }
                        if (bl6) {
                            bl5 = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "disallowAllFileServing detected.  fileservingEnabled will be deativated.");
                            }
                        }
                        boolean bl7 = false;
                        if (bl5) {
                            object12 = ((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.getFileServingAttributes();
                            object17 = object12.iterator();
                            while (object17.hasNext()) {
                                object16 = (FileServingAttribute)object17.next();
                                string5 = object16.getName();
                                object15 = object16.getValue();
                                if (string5 == null || !string5.equals("file.serving.patterns.allow")) continue;
                                StringTokenizer stringTokenizer = new StringTokenizer((String)object15, ": ;");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string4 = stringTokenizer.nextToken();
                                    if (string4 == null) continue;
                                    if (string4.equals("/")) {
                                        string4 = "/*";
                                    }
                                    ((Vector)object13).addElement(new URIData((String)object3 + string4, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                    bl7 = true;
                                }
                                if (!bl7) continue;
                                Tr.debug(tc, "File Serving Allowed patterns have been detected within application's ibm-web-ext.xmi. " + ((ConfigurationParser.DeployedModuleData)object14).moduleUri);
                            }
                        }
                        if (((ConfigurationParser.DeployedModuleData)object14).portletApp != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "It is a portlet application.");
                            }
                            if (((ConfigurationParser.DeployedModuleData)object14).portletServingEnabled.booleanValue()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Portlet serving is enabled.");
                                }
                                object12 = ((ConfigurationParser.DeployedModuleData)object14).portletApp.getPortlets().iterator();
                                object17 = null;
                                while (object12.hasNext()) {
                                    object16 = (Portlet)object12.next();
                                    string5 = object16.getPortletName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Portlet name " + string5);
                                    }
                                    if (((String)object3).endsWith("/")) {
                                        ((Vector)object13).addElement(new URIData((String)object3 + string5 + "/*", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                        continue;
                                    }
                                    ((Vector)object13).addElement(new URIData((String)object3 + "/" + string5 + "/*", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                }
                            }
                        }
                        if (!bl5) {
                            Object object18;
                            Object object19;
                            EList eList2;
                            if (((String)object3).equals("/")) {
                                object3 = "";
                            } else if (((String)object3).endsWith("/")) {
                                object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                            }
                            object12 = ((ConfigurationParser.DeployedModuleData)object14).deploymentDescriptor.getServletMappings().iterator();
                            while (object12.hasNext()) {
                                object17 = (ServletMapping)object12.next();
                                object16 = object17.getUrlPattern();
                                boolean bl8 = false;
                                boolean bl9 = ((String)object16).startsWith("/");
                                if (bl9) {
                                    bl8 = ((String)object16).equals("/");
                                }
                                if (bl8) {
                                    ((Vector)object13).addElement(new URIData((String)object3 + (String)object16 + "*", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                    continue;
                                }
                                if (bl9) {
                                    ((Vector)object13).addElement(new URIData((String)object3 + (String)object16, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                    continue;
                                }
                                ((Vector)object13).addElement(new URIData((String)object3 + "/" + (String)object16, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            }
                            object17 = ((ConfigurationParser.DeployedModuleData)object14).additionalPatterns;
                            if (object17 != null) {
                                object16 = object17.iterator();
                                while (object16.hasNext()) {
                                    String string6 = (String)object16.next();
                                    boolean bl10 = false;
                                    boolean bl11 = string6.startsWith("/");
                                    if (bl11) {
                                        bl10 = string6.equals("/");
                                    }
                                    if (bl10) {
                                        ((Vector)object13).addElement(new URIData((String)object3 + string6 + "*", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                        continue;
                                    }
                                    if (bl11) {
                                        ((Vector)object13).addElement(new URIData((String)object3 + string6, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                        continue;
                                    }
                                    ((Vector)object13).addElement(new URIData((String)object3 + "/" + string6, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                }
                            }
                            if (!((String)object3).equals("")) {
                                object3 = (String)object3 + "/";
                            }
                            ((Vector)object13).addElement(new URIData((String)object3 + "*.jsp", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            ((Vector)object13).addElement(new URIData((String)object3 + "*.jsv", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            ((Vector)object13).addElement(new URIData((String)object3 + "*.jsw", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            object16 = ((ConfigurationParser.DeployedModuleData)object14).deploymentDescriptor.getJspConfig();
                            if (object16 != null && (eList2 = object16.getPropertyGroups()) != null) {
                                Iterator iterator2 = eList2.iterator();
                                while (iterator2.hasNext()) {
                                    JSPPropertyGroup jSPPropertyGroup = (JSPPropertyGroup)iterator2.next();
                                    string4 = jSPPropertyGroup.getUrlPattern();
                                    object19 = string4.iterator();
                                    while (object19.hasNext()) {
                                        object18 = (String)object19.next();
                                        if (((String)object18).startsWith("/")) {
                                            object18 = ((String)object18).substring(1);
                                        }
                                        ((Vector)object13).addElement(new URIData((String)object3 + (String)object18, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                    }
                                }
                            }
                            string5 = ((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.getJspAttributes();
                            object15 = string5.iterator();
                            while (object15.hasNext()) {
                                JSPAttribute jSPAttribute = (JSPAttribute)object15.next();
                                string4 = jSPAttribute.getName();
                                object19 = jSPAttribute.getValue();
                                if (string4 == null || !string4.equals("jsp.file.extensions")) continue;
                                object18 = new StringTokenizer((String)object19, ": ;");
                                while (((StringTokenizer)object18).hasMoreTokens()) {
                                    String string7 = ((StringTokenizer)object18).nextToken();
                                    ((Vector)object13).addElement(new URIData((String)object3 + string7, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                                }
                            }
                            if (((String)object3).equals("")) {
                                object3 = (String)object3 + "/";
                            }
                            ((Vector)object13).addElement(new URIData((String)object3 + "j_security_check", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            ((Vector)object13).addElement(new URIData((String)object3 + "ibm_security_logout", ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            boolean bl12 = false;
                            if (((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.isSetServeServletsByClassnameEnabled()) {
                                bl12 = ((ConfigurationParser.DeployedModuleData)object14).moduleExtensions.isServeServletsByClassnameEnabled();
                            } else if (!((ConfigurationParser.ServerClusterData)object6).serveServletsByClassnameEnabled.equals("notDefined")) {
                                bl12 = new Boolean(((ConfigurationParser.ServerClusterData)object6).serveServletsByClassnameEnabled);
                            }
                            if (bl12) {
                                string4 = ((String)object3).endsWith("/") ? "servlet/*" : "/servlet/*";
                                ((Vector)object13).addElement(new URIData((String)object3 + string4, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            }
                        } else {
                            Tr.debug(tc, "FileServingEnabled has been set to true within the ibm-web-ext.xmi. " + ((ConfigurationParser.DeployedModuleData)object14).moduleUri);
                            bl4 = Boolean.parseBoolean(System.getProperty("deactivateWildCardURIMapping"));
                            if (!bl4 || !bl7) {
                                Tr.debug(tc, "deactivateWildCardURIMapping parameter setting is " + bl4 + " for " + ((ConfigurationParser.DeployedModuleData)object14).moduleUri);
                                object12 = this.appendWildCardString((String)object3);
                                ((Vector)object13).addElement(new URIData((String)object12, ((ConfigurationParser.DeployedModuleData)object14).cookieName, ((ConfigurationParser.DeployedModuleData)object14).urlCookieName));
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Computed URIs for the module " + ((ConfigurationParser.DeployedModuleData)object14).moduleUri);
                    }
                }
                if (bl) {
                    object14 = "default_host";
                    if (!((HashMap)object).containsKey(object14)) {
                        ((HashMap)object).put(object14, new Vector());
                    }
                    object3 = (Vector)((HashMap)object).get(object14);
                    object2 = configurationParser.getLotusURIList();
                    object13 = object2.iterator();
                    while (object13.hasNext()) {
                        ((Vector)object3).addElement((URIData)object13.next());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Computed the URIList for Lotus cluster");
                    }
                }
                if (bl2) {
                    object14 = "default_host";
                    if (!((HashMap)object).containsKey(object14)) {
                        ((HashMap)object).put(object14, new Vector());
                    }
                    object3 = (Vector)((HashMap)object).get(object14);
                    ((Vector)object3).addElement(new URIData("/IBM_HTTP_TUNNEL/" + ((ConfigurationParser.ServerClusterData)object6).clusterName + "/*", "JSESSIONID", "jsessionid"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Computed the URIList for Bus cluster");
                    }
                }
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compute the URIList for Tunnel cluster");
                    }
                    if (!((HashMap)object).containsKey(object14 = "default_host")) {
                        ((HashMap)object).put(object14, new Vector());
                    }
                    object3 = (Vector)((HashMap)object).get(object14);
                    object2 = configurationParser.getTunnelURIList((ConfigurationParser.TransportData)object4);
                    if (object2 != null) {
                        object13 = object2.iterator();
                        while (object13.hasNext()) {
                            ((Vector)object3).addElement((URIData)object13.next());
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Computed the URIList for Tunnel cluster");
                    }
                }
                hashMap.put(((ConfigurationParser.ServerClusterData)object6).clusterName, object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added all the ServerCluster elements");
            }
            object10 = hashMap.keySet().iterator();
            while (object10.hasNext()) {
                object6 = (String)object10.next();
                object5 = (HashMap)hashMap.get(object6);
                iterator = ((HashMap)object5).keySet().iterator();
                while (iterator.hasNext()) {
                    String string8 = (String)iterator.next();
                    if (configurationParser.getVHost(string8) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Module is referencing virtual host group " + string8 + " that is deleted");
                        continue;
                    }
                    if (string8.equals("admin_host")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Not adding admin_host uri information.");
                        continue;
                    }
                    Vector vector = (Vector)((HashMap)object5).get(string8);
                    Element element9 = this._pluginConfigDocument.createElement("UriGroup");
                    object4 = string8 + "_" + (String)object6 + "_URIs";
                    element9.setAttribute("Name", (String)object4);
                    element.appendChild(element9);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the URIGroup " + (String)object4);
                    }
                    if (vector == null) continue;
                    Iterator iterator3 = vector.iterator();
                    while (iterator3.hasNext()) {
                        object = (URIData)iterator3.next();
                        if (tc.isDebugEnabled()) {
                            ((URIData)object).print(tc);
                        }
                        eList = this._pluginConfigDocument.createElement("Uri");
                        eList.setAttribute("Name", ((URIData)object).uriName);
                        if (((URIData)object).cookieName != null && !((URIData)object).cookieName.equals("")) {
                            eList.setAttribute("AffinityCookie", ((URIData)object).cookieName);
                        }
                        eList.setAttribute("AffinityURLIdentifier", ((URIData)object).urlCookieName);
                        element9.appendChild((Node)eList);
                    }
                    object = this._pluginConfigDocument.createElement("Route");
                    object.setAttribute("VirtualHostGroup", string8);
                    object.setAttribute("UriGroup", string8 + "_" + (String)object6 + "_URIs");
                    object.setAttribute("ServerCluster", (String)object6);
                    element.appendChild((Node)object);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the VirtualHost element");
            }
            if ((object6 = configurationParser.pmirm) != null) {
                object5 = this._pluginConfigDocument.createElement("RequestMetrics");
                object5.setAttribute("armEnabled", object6.isEnableARM() ? "true" : "false");
                object5.setAttribute("rmEnabled", object6.isEnable() ? "true" : "false");
                object5.setAttribute("loggingEnabled", object6.isEnableLog() ? "true" : "false");
                object5.setAttribute("traceLevel", object6.getTraceLevel().toString());
                element.appendChild((Node)object5);
                EList eList3 = object6.getFilters();
                for (int i = 0; i < eList3.size(); ++i) {
                    PMIRMFilter pMIRMFilter = (PMIRMFilter)eList3.get(i);
                    object4 = pMIRMFilter.getType().getName();
                    Tr.debug(tc, "filter type: " + (String)object4);
                    if (((String)object4).equals("EJB")) continue;
                    boolean bl = pMIRMFilter.isEnable();
                    Tr.debug(tc, "\tenabled: " + bl);
                    object = this._pluginConfigDocument.createElement("filters");
                    object.setAttribute("enable", bl ? "true" : "false");
                    object.setAttribute("type", (String)object4);
                    object5.appendChild((Node)object);
                    eList = pMIRMFilter.getFilterValues();
                    for (int j = 0; j < eList.size(); ++j) {
                        object3 = (PMIRMFilterValue)eList.get(j);
                        object2 = this._pluginConfigDocument.createElement("filterValues");
                        object2.setAttribute("enable", object3.isEnable() ? "true" : "false");
                        object2.setAttribute("value", object3.getValue());
                        object.appendChild((Node)object2);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the RequestMetrics element");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator.createPluginConfigDocument", "378", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("doc.gen.exception"), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return this._pluginConfigDocument;
    }

    protected boolean prepare() {
        return true;
    }

    private boolean isAdminTransport(String string) {
        int n = this.adminPorts.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.adminPorts.elementAt(i);
            if (string2.indexOf(string) == -1) continue;
            return true;
        }
        return false;
    }

    private String appendWildCardString(String string) {
        if (!string.startsWith("*.")) {
            if (string.endsWith("/")) {
                string = string + "*";
            } else if (!string.endsWith("/*")) {
                string = string + "/*";
            }
        }
        return string;
    }

    public static class URIData {
        public String uriName;
        public String cookieName;
        public String urlCookieName;

        public URIData(String string, String string2, String string3) {
            this.uriName = string;
            this.cookieName = string2;
            this.urlCookieName = string3;
        }

        public void print(TraceComponent traceComponent) {
            Tr.debug(traceComponent, "URIData details:");
            Tr.debug(traceComponent, "   uriName       : " + this.uriName);
            Tr.debug(traceComponent, "   cookieName    : " + this.cookieName);
            Tr.debug(traceComponent, "   urlCookieName : " + this.urlCookieName);
        }
    }
}

