/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class VariableManager {
    protected static TraceComponent tc = Tr.register(VariableManager.class);
    public static final String VARIABLE_FILE = "variables.xml";
    public static final String EXTERNAL_MAP = "was.variable.map";
    public static final int CONFIG_LEVEL_CELL = 0;
    public static final int CONFIG_LEVEL_NODE = 1;
    public static final int CONFIG_LEVEL_SERVER = 2;
    private Map _masterMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariableMap(ConfigRoot configRoot, int n) throws Exception {
        Resource resource = null;
        try {
            resource = configRoot.getResource(0, VARIABLE_FILE);
            this.addMapEntries(resource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (n > 0) {
            try {
                resource = configRoot.getResource(3, VARIABLE_FILE);
                this.addMapEntries(resource);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (n > 1) {
            try {
                resource = configRoot.getResource(4, VARIABLE_FILE);
                this.addMapEntries(resource);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        String string = System.getProperty(EXTERNAL_MAP);
        FileInputStream fileInputStream = null;
        try {
            if (string != null) {
                Properties properties = new Properties();
                fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                this._masterMap.putAll(properties);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String substitute(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        return this.expand(string, 0, string.length(), this._masterMap, new HashMap());
    }

    private void addMapEntries(Resource resource) {
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            VariableMap variableMap = (VariableMap)eList.get(i);
            EList eList2 = variableMap.getEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList2.get(j);
                this._masterMap.put(variableSubstitutionEntry.getSymbolicName(), variableSubstitutionEntry.getValue());
            }
        }
    }

    private String expand(String string, int n, int n2, Map map, Map map2) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = n; i < n2; ++i) {
            int n3 = string.indexOf(36, i);
            this.append(stringBuffer, string, i, n3 - i);
            if (n3 == -1) break;
            i = n3 + 1;
            if (i >= n2) continue;
            switch (string.charAt(i)) {
                case '$': {
                    stringBuffer.append('$');
                    continue block4;
                }
                case '(': 
                case '{': {
                    char c = string.charAt(i);
                    char c2 = c == '(' ? (char)')' : '}';
                    int n4 = i + 1;
                    int n5 = string.indexOf(c2, n4);
                    if (n5 == -1) {
                        throw new IllegalArgumentException("unterminated variable reference");
                    }
                    i = this.indexOf(string, '$', n4, n5);
                    if (i != -1) {
                        n4 = i + 1;
                        int n6 = 0;
                        for (i = n4; i < string.length(); ++i) {
                            char c3 = string.charAt(i);
                            if (c3 == c) {
                                ++n6;
                                continue;
                            }
                            if (c3 == c2 && --n6 < 0) break;
                        }
                        if (n6 < 0) {
                            String string2 = this.expand(string, n4, i, map, map2);
                        }
                    } else {
                        i = n5;
                    }
                    this.referenceVariable(stringBuffer, string, n4, n5 - n4, map, map2);
                    continue block4;
                }
                default: {
                    char c = string.charAt(i);
                    if (Character.isWhitespace(c)) continue block4;
                    this.referenceVariable(stringBuffer, string, i, 1, map, map2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String expand(String string, Map map, Map map2) throws IllegalArgumentException {
        return this.expand(string, 0, string.length(), map, map2);
    }

    private void append(StringBuffer stringBuffer, String string, int n, int n2) {
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + n2);
        n2 += n;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(string.charAt(i));
        }
    }

    private void referenceVariable(StringBuffer stringBuffer, String string, int n, int n2, Map map, Map map2) throws IllegalArgumentException {
        String string2 = string.substring(n, n + n2);
        String string3 = (String)map.get(string2);
        if (string3 == null) {
            if (string2.equalsIgnoreCase("CONFIG_ROOT")) {
                map.put(string2, PluginConfigGenerator.getDefaultConfigRoot());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "undefined variable: " + string2);
                }
                throw new IllegalArgumentException("undefined variable: " + string2);
            }
        }
        String string4 = this.recursivelyExpand(string2, map, map2);
        stringBuffer.append(string4);
    }

    private String recursivelyExpand(String string, Map map, Map map2) throws IllegalArgumentException {
        if (map2.get(string) != null) {
            throw new IllegalArgumentException("Recursive variable: " + string);
        }
        map2.put(string, string);
        String string2 = (String)map.get(string);
        String string3 = this.expand(string2, map, map2);
        map2.remove(string);
        return string3;
    }

    private int indexOf(String string, char c, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

