/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.initializers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.initializers.PluginTask;
import com.ibm.websphere.plugincfg.initializers.SecurityChangePluginTask;
import com.ibm.websphere.plugincfg.initializers.ServerChangePluginTask;
import com.ibm.websphere.plugincfg.initializers.ServerDirChangePluginTask;
import com.ibm.websphere.plugincfg.initializers.ServerIndexChangePluginTask;
import com.ibm.websphere.plugincfg.initializers.VirtualHostChangePluginTask;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ThreadPool;
import java.util.ArrayList;
import java.util.Iterator;

public class PluginRepositoryListener
implements ConfigRepositoryListener {
    private static PluginRepositoryListener listener = null;
    private static TraceComponent tc = Tr.register(PluginRepositoryListener.class);
    private Repository repository;
    private VariableMap variableMap;
    private boolean cellManagerFound = false;
    private boolean wasNodeFound = false;
    private String repositoryRootURI;
    private ThreadPool threadPool = null;
    private String cellName = null;
    private String configRootPath = null;
    protected TraceNLS nls;
    private boolean origUseFIPS = false;
    private boolean currUseFIPS = false;

    private PluginRepositoryListener(Repository repository2, VariableMap variableMap, TraceNLS traceNLS, boolean bl, boolean bl2) {
        String string = "PluginRepositoryListener(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.repository = repository2;
        this.variableMap = variableMap;
        this.nls = traceNLS;
        this.cellManagerFound = bl;
        this.wasNodeFound = bl2;
        this.repositoryRootURI = repository2.getRootURI();
        this.threadPool = new ThreadPool("PluginConfigService", 5, 20);
        ConfigRepositoryFactory.getConfigRepository().addListener(this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Added a listener to the repository events");
        }
        this.cellName = repository2.getCellName();
        this.configRootPath = repository2.getConfigRoot().getConfigRootPath();
        this.origUseFIPS = ConfigurationParser.isFIPSEnabled(this.configRootPath, this.cellName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public static synchronized void createInstance(Repository repository2, VariableMap variableMap, TraceNLS traceNLS, Boolean bl, Boolean bl2) {
        String string = "createInstance(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (listener == null) {
            listener = new PluginRepositoryListener(repository2, variableMap, traceNLS, bl, bl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        Object object;
        String string = "onChangeCompletion(): ";
        ArrayList<ConfigChangeNotifier> arrayList = new ArrayList<ConfigChangeNotifier>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "Number of changes: " + configChangeNotifierArray.length);
        }
        boolean bl = false;
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            int n = configChangeNotifierArray[i].getChangeType();
            String string2 = configChangeNotifierArray[i].getUri();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Changetype : " + n + "ChangeURI  : " + string2);
            }
            if (this.wasNodeFound) {
                if (string2.indexOf("/nodes", 0) <= 0 || string2.indexOf("/servers", 0) <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Files under servers directory has changed.");
                }
                if (n != 0 && n != 2) continue;
                object = new ServerDirChangePluginTask(this.configRootPath, this.cellName, this.nls);
                ((PluginTask)object).setTaskData(string2, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "ServerFileChangePluginTask is started for the server file " + string2 + ".");
                }
                try {
                    this.threadPool.execute((Runnable)object);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (string2.endsWith("deployment.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Deployment.xml has changed.");
                }
                bl = true;
                continue;
            }
            if (string2.endsWith("serverindex.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "ServerIndex.xml has changed.");
                }
                arrayList.add(configChangeNotifierArray[i]);
                continue;
            }
            if (string2.endsWith("server.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Server.xml has changed.");
                }
                if (n != 0 && n != 2) continue;
                object = new ServerChangePluginTask(this.configRootPath, this.cellName, this.nls);
                ((PluginTask)object).setTaskData(string2, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "ServerChangePluginTask is started for the server " + string2 + ".");
                }
                try {
                    this.threadPool.execute((Runnable)object);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (string2.endsWith("virtualhosts.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Virtualhosts.xml has changed.");
                }
                if (n != 2) continue;
                object = new VirtualHostChangePluginTask(this.configRootPath, this.cellName, this.nls);
                ((PluginTask)object).setTaskData(string2, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "VirtualHostChangePluginTask is started.");
                }
                try {
                    this.threadPool.execute((Runnable)object);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!string2.endsWith("security.xml")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "security.xml has changed.");
            }
            if (n != 2) continue;
            this.currUseFIPS = ConfigurationParser.isFIPSEnabled(this.configRootPath, this.cellName);
            if (this.currUseFIPS == this.origUseFIPS) continue;
            this.origUseFIPS = this.currUseFIPS;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "FIPS setting has changed.");
            }
            object = new SecurityChangePluginTask(this.configRootPath, this.cellName, this.nls);
            ((PluginTask)object).setTaskData(string2, n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "SecurityChangePluginTask is started.");
            }
            try {
                this.threadPool.execute((Runnable)object);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ConfigChangeNotifier configChangeNotifier = (ConfigChangeNotifier)iterator.next();
                int n = configChangeNotifier.getChangeType();
                object = configChangeNotifier.getUri();
                if (n != 0 && n != 2) continue;
                ServerIndexChangePluginTask serverIndexChangePluginTask = new ServerIndexChangePluginTask(this.configRootPath, this.cellName, this.nls);
                serverIndexChangePluginTask.setTaskData((String)object, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "ServerIndexChangePluginTask is started for the node " + (String)object + ".");
                }
                try {
                    this.threadPool.execute(serverIndexChangePluginTask);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void onRepositoryEpochRefresh() {
    }
}

