/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.initializers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.webserver.PluginMethodKind;
import com.ibm.websphere.models.config.webserver.PluginProperties;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.security.core.SecurityContext;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class PluginTask
implements Runnable {
    private static TraceComponent tc = Tr.register(PluginTask.class);
    protected String configRootPath = null;
    protected String cellName = null;
    protected String changedURI = null;
    protected int changeType = 0;
    protected static TraceNLS nls = null;
    public static AdminService adminService = null;
    public static AdminClient dmgrAdminClient = null;
    public static ObjectName notificationService = null;

    public PluginTask(String string, String string2, TraceNLS traceNLS) {
        String string3 = "PluginTask(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        this.configRootPath = string;
        this.cellName = string2;
        nls = traceNLS;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configRootPath: " + string + " cellName: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
    }

    public void run() {
    }

    public void setTaskData(String string, int n) {
        String string2 = "setTaskData(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        this.changedURI = string;
        this.changeType = n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "changedURI: " + string + " changeType: " + n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    protected void startGenerateForAllWebServers() {
        String string;
        block7: {
            string = "startGenerateForAllWebServers(): ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            String string2 = null;
            try {
                List list = this.getNodes(this.configRootPath, this.cellName);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Get the list of webserver for the node: " + string2);
                    }
                    List list2 = this.getWebServers(this.configRootPath, this.cellName, string2);
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        this.startGeneratePluginConfig(string2, (String)iterator2.next());
                    }
                }
            }
            catch (Throwable throwable) {
                String string3 = nls.getString("webserverlist.unknown") + " " + this.cellName + "." + string2 + ".";
                System.out.println(string3);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, string + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    protected void startGeneratePluginConfig(String string, String string2) {
        String string3;
        block8: {
            string3 = "startGeneratePluginConfig(): ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string3);
            }
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            try {
                PluginProperties pluginProperties = this.getPluginProperties(this.configRootPath, this.cellName, string, string2);
                PluginMethodKind pluginMethodKind = pluginProperties.getPluginGeneration();
                PluginMethodKind pluginMethodKind2 = pluginProperties.getPluginPropagation();
                if (pluginMethodKind.getValue() == 1) {
                    bl = false;
                }
                if (pluginMethodKind2.getValue() == 1) {
                    bl2 = false;
                }
                if (bl2 && this.isNodeManaged(this.configRootPath, this.cellName, string)) {
                    bl2 = false;
                    bl3 = false;
                }
                if (bl) {
                    this.GeneratePluginConfig(this.configRootPath, this.cellName, string, string2, bl2, bl3);
                }
            }
            catch (Throwable throwable) {
                String string4 = nls.getString("nopluginproperties.found") + " " + this.cellName + "." + string + "." + string2 + ".";
                System.out.println(string4);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, string3 + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
    }

    protected void notifyMessage(String string, String string2) throws PrivilegedActionException {
        String string3 = "notifyMessage(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        if (SecurityContext.isSecurityEnabled()) {
            final String string4 = string;
            final String string5 = string2;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() {
                    PluginTask.this.NotifyMessage(string4, string5);
                    return null;
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            this.NotifyMessage(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
    }

    protected void NotifyMessage(String string, String string2) {
        String string3;
        block11: {
            string3 = "NotifyMessage(): ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string3);
            }
            try {
                System.out.println();
                System.out.println(string2);
                if (PluginTask.getDMgrAdminClient() != null) {
                    if (PluginTask.getNotificationService() != null) {
                        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
                        PluginTask.getDMgrAdminClient().invoke(PluginTask.getNotificationService(), "emitNotification", new Object[]{string, string2, null}, stringArray);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string3 + "Notification sent for the message : " + string2);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string3 + "Notification service not available. ");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3 + "DMger Admin client is not available. ");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Unable to notify message." + throwable.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
    }

    protected boolean startLocalTransfer(String string, String string2) throws IOException, PrivilegedActionException {
        String string3 = "startLocalTransfer(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        boolean bl = false;
        if (SecurityContext.isSecurityEnabled()) {
            final String string4 = string;
            final String string5 = string2;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Boolean(PluginConfigGenerator.startLocalTransfer(string4, string5));
                }
            };
            bl = (Boolean)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            bl = PluginConfigGenerator.startLocalTransfer(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
        return bl;
    }

    protected PluginProperties getPluginProperties(String string, String string2, String string3, String string4) throws PluginConfigException, PrivilegedActionException {
        String string5 = "getPluginProperties(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string5);
        }
        PluginProperties pluginProperties = null;
        if (SecurityContext.isSecurityEnabled()) {
            final String string6 = string;
            final String string7 = string2;
            final String string8 = string3;
            final String string9 = string4;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    return ConfigurationParser.getPluginProperties(string6, string7, string8, string9);
                }
            };
            pluginProperties = (PluginProperties)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            pluginProperties = ConfigurationParser.getPluginProperties(string, string2, string3, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string5);
        }
        return pluginProperties;
    }

    protected String getFileSeparator(String string, String string2, String string3) throws AdminException, PrivilegedActionException {
        String string4 = "getFileSeparator(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string4);
        }
        String string5 = File.separator;
        if (SecurityContext.isSecurityEnabled()) {
            final String string6 = string;
            final String string7 = string2;
            final String string8 = string3;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws AdminException {
                    return ConfigurationParser.getFileSeparator(string6, string7, string8);
                }
            };
            string5 = (String)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            string5 = ConfigurationParser.getFileSeparator(string, string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string4);
        }
        return string5;
    }

    protected boolean isNodeManaged(String string, String string2, String string3) throws PluginConfigException, PrivilegedActionException {
        String string4 = "isNodeManaged(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string4);
        }
        boolean bl = false;
        if (SecurityContext.isSecurityEnabled()) {
            final String string5 = string;
            final String string6 = string2;
            final String string7 = string3;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    return new Boolean(ConfigurationParser.isNodeManaged(string5, string6, string7));
                }
            };
            bl = (Boolean)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            bl = ConfigurationParser.isNodeManaged(string, string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string4);
        }
        return bl;
    }

    protected String getServerType(String string, String string2, String string3, String string4) throws PluginConfigException, PrivilegedActionException {
        String string5 = "getServerType(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string5);
        }
        String string6 = "";
        if (SecurityContext.isSecurityEnabled()) {
            final String string7 = string;
            final String string8 = string2;
            final String string9 = string3;
            final String string10 = string4;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    return ConfigurationParser.getServerType(string7, string8, string9, string10);
                }
            };
            string6 = (String)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            string6 = ConfigurationParser.getServerType(string, string2, string3, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string5);
        }
        return string6;
    }

    protected List getNodes(String string, String string2) throws PluginConfigException, PrivilegedActionException {
        String string3 = "getNodes(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        List list = new ArrayList();
        if (SecurityContext.isSecurityEnabled()) {
            final String string4 = string;
            final String string5 = string2;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    return ConfigurationParser.getNodes(string4, string5);
                }
            };
            list = (List)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            list = ConfigurationParser.getNodes(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
        return list;
    }

    protected List getWebServers(String string, String string2, String string3) throws PluginConfigException, PrivilegedActionException {
        String string4 = "getWebservers(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string4);
        }
        List list = new ArrayList();
        if (SecurityContext.isSecurityEnabled()) {
            final String string5 = string;
            final String string6 = string2;
            final String string7 = string3;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    return ConfigurationParser.getWebServers(string5, string6, string7);
                }
            };
            list = (List)SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            list = ConfigurationParser.getWebServers(string, string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string4);
        }
        return list;
    }

    protected void GeneratePluginConfig(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws PluginConfigException, PrivilegedActionException {
        String string5 = "GeneratePluginConfig(): ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string5);
        }
        if (SecurityContext.isSecurityEnabled()) {
            final String string6 = string;
            final String string7 = string2;
            final String string8 = string3;
            final String string9 = string4;
            final boolean bl3 = bl;
            final boolean bl4 = bl2;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws PluginConfigException {
                    PluginTask.generatePluginConfig(string6, string7, string8, string9, bl3, bl4);
                    return null;
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
        } else {
            PluginTask.generatePluginConfig(string, string2, string3, string4, bl, bl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string5);
        }
    }

    static void generatePluginConfig(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        String string5;
        block12: {
            string5 = "generatePluginConfig(): ";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string5);
            }
            String string6 = string2 + "." + string3 + "." + string4;
            System.out.println(nls.getString("generate.started") + " " + string6 + ".");
            try {
                if (PluginTask.getAdminService() != null) {
                    ObjectName objectName = null;
                    String string7 = "WebSphere:cell=" + string2 + ",type=PluginCfgGenerator,*";
                    ObjectName objectName2 = new ObjectName(string7);
                    Iterator iterator = PluginTask.getAdminService().queryNames(objectName2, null).iterator();
                    if (iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        if (iterator.hasNext() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "More than one query string returned.");
                        }
                    }
                    if (objectName != null) {
                        PluginTask.getAdminService().invoke(objectName, "generate", new Object[]{string, string2, string3, string4, new Boolean(bl), new Boolean(bl2)}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.class.getName(), Boolean.class.getName()});
                        System.out.println(nls.getString("generate.complete") + " " + string6 + ".");
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "PluginCfgGenerator Mbean is not available.");
                        }
                        System.out.println(nls.getString("generate.notcomplete") + " " + string6 + ".");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Admin service is not available.");
                    }
                    System.out.println(nls.getString("generate.notcomplete") + " " + string6 + ".");
                }
            }
            catch (Throwable throwable) {
                String string8 = nls.getString("generate.notcomplete") + " " + string6 + ".";
                System.out.println(string8);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, string5 + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string5);
        }
    }

    protected static AdminService getAdminService() {
        if (adminService == null) {
            adminService = AdminServiceFactory.getAdminService();
        }
        return adminService;
    }

    protected static AdminClient getDMgrAdminClient() {
        block3: {
            if (dmgrAdminClient == null) {
                try {
                    dmgrAdminClient = Utils.getDmgrAdminClient();
                }
                catch (ConnectorException connectorException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "getDMgrAdminClient: Received exception " + connectorException.getMessage());
                }
            }
        }
        return dmgrAdminClient;
    }

    protected static ObjectName getNotificationService() throws PrivilegedActionException {
        block7: {
            if (notificationService == null && PluginTask.getDMgrAdminClient() != null) {
                try {
                    String string = "WebSphere:*,type=NotificationService,process=" + PluginTask.getNetmgrName(dmgrAdminClient);
                    Set set = PluginTask.getDMgrAdminClient().queryNames(new ObjectName(string), null);
                    if (!set.isEmpty()) {
                        notificationService = (ObjectName)set.iterator().next();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getNotificationService: " + notificationService.toString());
                    }
                }
                catch (ConnectorException connectorException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getNotificationService: Received exception " + connectorException.getMessage());
                    }
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "getNotificationService: Received exception " + malformedObjectNameException.getMessage());
                }
            }
        }
        return notificationService;
    }

    protected static String getNetmgrName(AdminClient adminClient) {
        String string;
        ObjectName objectName;
        block3: {
            objectName = null;
            string = "dmgr";
            try {
                objectName = adminClient.getServerMBean();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "getNetmgrName: Received exception " + exception.getMessage());
            }
        }
        if (objectName != null) {
            string = ObjectNameHelper.getProcessName(objectName);
        }
        return string;
    }

    public static String getFormattedMessage(String string, Object[] objectArray) {
        String string2;
        block5: {
            string2 = null;
            try {
                string2 = nls.getString(string);
                if (string2 != null) {
                    string2 = MessageFormat.format(string2, objectArray);
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find message key in resource bundle " + nls.toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Null pointer exception caught trying to find message key " + string + " in resource bundle " + nls.toString());
            }
        }
        return string2;
    }
}

