/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.ws.pmi.server.ModuleConfigParser;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.ObjectName;

public class PerfModules
implements PmiConstants {
    public static final String[] moduleIDs50;
    public static final String[] moduleIDs40;
    public static String[] moduleIDs;
    private static String modulePrefix;
    private static HashMap moduleConfigs;
    private static ModuleConfigParser parser;
    static final int MODULE_INDEX = 1;
    static final int SUBMODULE_INDEX = 3;
    static final int METHOD_PATH = 5;
    private static final TraceComponent tc;
    private static Exception parseException;
    private static Method mGetPmiModuleConfigMethod;
    private static boolean bEnableStatsTemplateLookup;
    private static ArrayList lookupList;
    private static String ENABLE_PARSING_FLAG;

    private static synchronized void initConfigs() {
        for (int i = 0; i < moduleIDs.length; ++i) {
            PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(modulePrefix + moduleIDs[i]), true, false);
        }
    }

    public static PmiModuleConfig getConfig(String string) {
        int n;
        if (string == null) {
            return null;
        }
        PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)moduleConfigs.get(string);
        if (pmiModuleConfig == null && (n = string.indexOf(46)) == -1) {
            String string2 = "com.ibm.websphere.pmi.xml." + string;
            pmiModuleConfig = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(string2), true, false);
        }
        if (pmiModuleConfig == null) {
            pmiModuleConfig = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(string), true, true);
        }
        return pmiModuleConfig;
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            if (!pmiModuleConfigArray[i].getUID().equals(string)) continue;
            return pmiModuleConfigArray[i];
        }
        return null;
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        String string = objectName.getKeyProperty("type");
        if (string.equals("Servlet")) {
            string = "WebModule";
        } else if (string.equals("EntityBean") || string.equals("StatefulSessionBean") || string.equals("StatelessSessionBean") || string.equals("MessageDrivenBean")) {
            string = "EJBModule";
        }
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            String string2 = pmiModuleConfigArray[i].getMbeanType();
            if (string2 == null || !string2.equals(string)) continue;
            return pmiModuleConfigArray[i];
        }
        return null;
    }

    public static synchronized PmiModuleConfig getConfigFromXMLFile(String string, boolean bl, boolean n) {
        int n2;
        PmiModuleConfig pmiModuleConfig = null;
        String string2 = PerfModules.getModuleUID(string);
        pmiModuleConfig = (PmiModuleConfig)moduleConfigs.get(string2);
        if (bl) {
            if (pmiModuleConfig != null) {
                return pmiModuleConfig;
            }
        } else if (pmiModuleConfig != null) {
            return pmiModuleConfig.copy();
        }
        if (bEnableStatsTemplateLookup) {
            int n3 = lookupList.size();
            for (n2 = 0; !(n2 >= n3 || (pmiModuleConfig = ((StatsTemplateLookup)lookupList.get(n2)).getTemplate(string2)) != null || string2.startsWith("com.ibm.websphere.pmi.xml.") && (pmiModuleConfig = ((StatsTemplateLookup)lookupList.get(n2)).getTemplate(string2.substring(26))) != null); ++n2) {
            }
            if (pmiModuleConfig != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StatsTemplateLookup available for: " + string);
                }
                pmiModuleConfig.setMbeanType("");
                moduleConfigs.put(pmiModuleConfig.getUID(), pmiModuleConfig);
                if (!bl) {
                    return pmiModuleConfig.copy();
                }
                return pmiModuleConfig;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StatsTemplateLookup NOT available for: " + string);
            }
        }
        final String string3 = string;
        n2 = n;
        parseException = null;
        try {
            pmiModuleConfig = (PmiModuleConfig)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(n2 != 0){
                private final /* synthetic */ boolean val$_bDTDValidation;
                {
                    this.val$_bDTDValidation = bl;
                }

                public Object run() throws Exception {
                    return parser.parse(string3, this.val$_bDTDValidation);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            parseException = privilegedActionException.getException();
        }
        if (pmiModuleConfig != null) {
            if (bl) {
                pmiModuleConfig.setMbeanType("");
                moduleConfigs.put(pmiModuleConfig.getUID(), pmiModuleConfig);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read PMI config for stats type: " + pmiModuleConfig.getUID());
                }
                return pmiModuleConfig;
            }
            return pmiModuleConfig.copy();
        }
        return pmiModuleConfig;
    }

    public static PmiModuleConfig getConfigFromXMLFile(String string) {
        return PerfModules.getConfigFromXMLFile(string, true, true);
    }

    public static PmiModuleConfig[] getConfigs40() {
        int n = modulePrefix.indexOf("xml.");
        if (n > 0) {
            moduleIDs = moduleIDs40;
            modulePrefix = modulePrefix.substring(0, n);
            moduleConfigs = new HashMap();
        }
        PerfModules.initConfigs();
        return PerfModules.getConfigs();
    }

    public static String getDataName(String string, int n) {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfig(string);
        if (pmiModuleConfig == null) {
            return null;
        }
        PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
        if (pmiDataInfo == null) {
            return null;
        }
        return pmiDataInfo.getName();
    }

    public static int getDataId(String string, String string2) {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfig(string);
        if (string2.indexOf(46) < 0) {
            string2 = string + "." + string2;
        }
        if (pmiModuleConfig != null) {
            return pmiModuleConfig.getDataId(string2);
        }
        return -1;
    }

    public static PmiModuleConfig[] getConfigs() {
        if (moduleConfigs.size() == 0) {
            PerfModules.initConfigs();
        }
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[moduleConfigs.size()];
        Object[] objectArray = moduleConfigs.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            pmiModuleConfigArray[i] = (PmiModuleConfig)objectArray[i];
        }
        return pmiModuleConfigArray;
    }

    public static synchronized PmiModuleConfig addModuleInfo(String string) {
        return null;
    }

    public static String getGroupName(PerfLevelSpec perfLevelSpec) {
        if (perfLevelSpec == null) {
            return null;
        }
        String string = perfLevelSpec.getModuleName();
        String[] stringArray = perfLevelSpec.getPath();
        if (stringArray != null && stringArray.length > 5 && stringArray[5].equals("beanModule.methods")) {
            return stringArray[5];
        }
        if (stringArray != null && stringArray.length >= 3) {
            if (string.equals("cacheModule") || string.equals("orbPerfModule") || string.equals("wlmModule")) {
                return stringArray[2];
            }
            if (stringArray.length > 3) {
                return stringArray[3];
            }
        }
        return null;
    }

    public static String getXmlFileName(String string) {
        String string2 = "/" + string.replace('.', '/') + ".xml";
        return string2;
    }

    public static String getModuleUID(String string) {
        String string2 = string.replace('/', '.');
        if (string2.charAt(0) == '.') {
            string2 = string2.substring(1);
        }
        return string2.substring(0, string2.length() - 4);
    }

    public static String getParseExceptionMsg() {
        if (parseException != null) {
            return parseException.getMessage();
        }
        return null;
    }

    public static void registerTemplateLookupClass(StatsTemplateLookup statsTemplateLookup) {
        lookupList.add(statsTemplateLookup);
    }

    static {
        block6: {
            moduleIDs50 = new String[]{"beanModule", "cacheModule", "connectionPoolModule", "j2cModule", "jvmRuntimeModule", "orbPerfModule", "systemModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule", "wlmModule", "webServicesModule", "wsgwModule"};
            moduleIDs40 = new String[]{"beanModule", "connectionPoolModule", "jvmRuntimeModule", "jvmpiModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule"};
            moduleIDs = moduleIDs50;
            modulePrefix = "com.ibm.websphere.pmi.xml.";
            moduleConfigs = new HashMap();
            parser = new ModuleConfigParser();
            tc = Tr.register(PerfModules.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
            bEnableStatsTemplateLookup = true;
            lookupList = new ArrayList(3);
            ENABLE_PARSING_FLAG = "com.ibm.websphere.pmi.enableModuleConfigParsing";
            String string = System.getProperty(ENABLE_PARSING_FLAG);
            if (string != null && string.equalsIgnoreCase("true")) {
                bEnableStatsTemplateLookup = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "com.ibm.websphere.pmi.enableModuleConfigParsing is enabled. Disabling StatsTemplateLookup.");
                }
            } else {
                bEnableStatsTemplateLookup = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enabling StatsTemplateLookup.");
                }
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.pmi.preprocess.pmi_StatsTemplateLookup");
                    StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)clazz.newInstance());
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "PMI StatsTemplateLookup class not found.");
                }
            }
        }
    }
}

