/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.extutils.AdminUtilSrvImpl;
import com.ibm.websphere.pmi.extutils.MultipleObjectNamesExistException;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import javax.management.ObjectName;

public class PmiJmxMapper
implements PmiConstants {
    private AdminUtil adminUtil = null;
    public static final char seperator = '+';
    public static final String ALLCHILDREN = "ALLCHILDREN";
    private static HashMap mbeanTypeToPmiModuleName = new HashMap();
    private static HashMap PmiModuleNameToMbeanType = new HashMap();
    private static HashMap moduleOnlyMap = new HashMap(20);
    private static HashMap submoduleTable = new HashMap(20);
    private static HashMap beanMap = new HashMap();
    private static final TraceComponent tc = Tr.register(PmiJmxMapper.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    static final int SUBMODULE_LENGTH = 4;

    public PmiJmxMapper(String string, String string2, boolean bl) throws Exception {
        this(null, bl, false);
    }

    public PmiJmxMapper(Properties properties, boolean bl, boolean bl2) throws Exception {
        try {
            if (tc.isDebugEnabled() && properties != null) {
                Tr.debug(tc, "PmiJmxMapper: Properties : username =" + properties.getProperty("username") + ",port =" + properties.getProperty("port") + ",type =" + properties.getProperty("type") + ",host =" + properties.getProperty("host") + ",securityEnabled =" + properties.getProperty("securityEnabled") + ",inserver=" + bl + ",useAdminClient=" + bl2);
            }
            if (bl2) {
                Class<?> clazz = Class.forName("com.ibm.websphere.pmi.extutils.AdminUtilClntImpl");
                Class[] classArray = new Class[]{Properties.class, Boolean.TYPE};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{properties, new Boolean(bl)};
                this.adminUtil = (AdminUtil)constructor.newInstance(objectArray);
            } else {
                this.adminUtil = new AdminUtilSrvImpl();
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.pmi.PmiJmxMapper", "63", this);
            if (properties != null) {
                Tr.warning(tc, "PMI0004W", "PmiJmxMapper: Properties : username =" + properties.getProperty("username") + ",port =" + properties.getProperty("port") + ",type =" + properties.getProperty("type") + ",host =" + properties.getProperty("host") + ",securityEnabled =" + properties.getProperty("securityEnabled") + ",inserver=" + bl + ",useAdminClient=" + bl2 + "\n" + stringWriter.toString());
            }
            this.adminUtil = null;
            throw exception;
        }
    }

    public void setMapping(String string, String string2) {
        this.setMapping(string, null, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String string, String string2, String string3, String string4) {
        HashMap hashMap;
        if (string == null || string4 == null) {
            Tr.warning(tc, "PMI0005W", "setMapping");
        }
        String string5 = null;
        if (string3 == null) {
            string5 = string;
        } else {
            string5 = string + '+' + string3;
            submoduleTable.put(string3, string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PmiJmxMapping.setMapping: pmiName=" + string5 + ", mbeanType=" + string4);
        }
        if (!PmiModuleNameToMbeanType.containsKey(string5)) {
            hashMap = PmiModuleNameToMbeanType;
            synchronized (hashMap) {
                PmiModuleNameToMbeanType.put(string5, string4);
            }
        }
        if (!mbeanTypeToPmiModuleName.containsKey(string4)) {
            hashMap = mbeanTypeToPmiModuleName;
            synchronized (hashMap) {
                mbeanTypeToPmiModuleName.put(string4, string5);
            }
        }
    }

    public String getPmiModuleName(ObjectName objectName) {
        return this.getPmiModuleName(objectName, false);
    }

    public String getPmiModuleName(ObjectName objectName, boolean bl) {
        String string;
        if (objectName == null) {
            return null;
        }
        String string2 = objectName.getKeyProperty("type");
        if (string2.equals("JSP")) {
            string2 = "Servlet";
        }
        if ((string = (String)mbeanTypeToPmiModuleName.get(string2)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString());
            }
            return null;
        }
        String[] stringArray = StrUtils.split(string, 43);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPmiModuleName mName=" + objectName.toString() + ", moduleName=" + stringArray[0]);
        }
        if (!bl) {
            return stringArray[0];
        }
        if (stringArray.length >= 2) {
            return stringArray[1];
        }
        return null;
    }

    public String getMBeanType(String string) {
        String string2 = (String)PmiModuleNameToMbeanType.get(string);
        if (string2 == null) {
            Tr.warning(tc, "PMI0006W", string);
        }
        return string2;
    }

    public String getMBeanType(String[] stringArray) {
        String string;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = stringArray[0];
        if (stringArray.length >= 4 && submoduleTable.get(stringArray[2]) != null) {
            string2 = string2 + '+' + stringArray[2];
        }
        if ((string = (String)PmiModuleNameToMbeanType.get(string2)) == null) {
            Tr.warning(tc, "PMI0006W", PmiJmxMapper.StringArrayToString(stringArray));
        }
        return string;
    }

    public DataDescriptor getDataDescriptor(ObjectName objectName, StatDescriptor statDescriptor) {
        return this.getDataDescriptor(new MBeanStatDescriptor(objectName, statDescriptor));
    }

    public DataDescriptor getDataDescriptor(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor == null || mBeanStatDescriptor.getObjectName() == null) {
            return null;
        }
        DataDescriptor dataDescriptor = this.adminUtil.mBeanDescToPmiDesc_get(mBeanStatDescriptor);
        if (dataDescriptor != null) {
            return dataDescriptor;
        }
        ObjectName objectName = mBeanStatDescriptor.getObjectName();
        StatDescriptor statDescriptor = mBeanStatDescriptor.getStatDescriptor();
        String string = objectName.getKeyProperty("type");
        String string2 = objectName.getKeyProperty("name");
        String string3 = this.getPmiModuleName(objectName);
        String string4 = this.getPmiModuleName(objectName, true);
        if (string3 == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString());
            }
            return null;
        }
        String string5 = string2;
        if (string.equals("EJBModule") || string.equals("WebModule")) {
            string5 = objectName.getKeyProperty("Application") + "#" + string2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbean=" + objectName.toString() + ",moduleName=" + string3 + ", instanceName=" + string5);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleName=" + string3 + ", instanceName=" + string5);
        }
        if (string.equals("Server")) {
            dataDescriptor = this.getServerDataDescriptor(statDescriptor);
            this.setMapping(null, null, dataDescriptor, mBeanStatDescriptor);
            return dataDescriptor;
        }
        if (string4 != null) {
            String string6 = objectName.getKeyProperty("mbeanIdentifier");
            int n = string6.lastIndexOf(35);
            String string7 = null;
            string7 = n > 0 ? string6.substring(0, n) : "unknown";
            dataDescriptor = new DataDescriptor(new String[]{string3, string7, string4, string2});
        } else {
            dataDescriptor = this.isModuleOnlyMapping(string3) ? new DataDescriptor(new String[]{string3}) : new DataDescriptor(new String[]{string3, string5});
        }
        if (statDescriptor == null || statDescriptor.getPath() == null || statDescriptor.getPath().length == 0) {
            this.setMapping(null, null, dataDescriptor, mBeanStatDescriptor);
            return dataDescriptor;
        }
        int n = dataDescriptor.getPath().length;
        String[] stringArray = new String[n + statDescriptor.getPath().length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < n) {
                stringArray[i] = dataDescriptor.getPath()[i];
                continue;
            }
            if (i < n) continue;
            stringArray[i] = statDescriptor.getPath()[i - n];
        }
        dataDescriptor = new DataDescriptor(stringArray);
        this.setMapping(null, null, dataDescriptor, mBeanStatDescriptor);
        return dataDescriptor;
    }

    private DataDescriptor getServerDataDescriptor(StatDescriptor statDescriptor) {
        if (statDescriptor == null) {
            return new DataDescriptor(new String[]{"pmi"});
        }
        String[] stringArray = statDescriptor.getPath();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return new DataDescriptor(stringArray);
    }

    public DataDescriptor[] getDataDescriptors(ObjectName[] objectNameArray, StatDescriptor[] statDescriptorArray) {
        if (objectNameArray == null) {
            return null;
        }
        int n = 0;
        if (statDescriptorArray != null) {
            n = statDescriptorArray.length;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            dataDescriptorArray[i] = i < n ? this.getDataDescriptor(objectNameArray[i], statDescriptorArray[i]) : this.getDataDescriptor(objectNameArray[i], null);
        }
        return dataDescriptorArray;
    }

    public DataDescriptor[] getDataDescriptors(MBeanStatDescriptor[] mBeanStatDescriptorArray) {
        if (mBeanStatDescriptorArray == null || mBeanStatDescriptorArray.length == 0) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[mBeanStatDescriptorArray.length];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            dataDescriptorArray[i] = mBeanStatDescriptorArray[i] == null ? null : this.getDataDescriptor(mBeanStatDescriptorArray[i]);
        }
        return dataDescriptorArray;
    }

    private ObjectName descToObjectNameMapping(DataDescriptor dataDescriptor, String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "descToObjectNameMapping");
        }
        if (dataDescriptor == null) {
            return null;
        }
        String string3 = this.getMBeanType(dataDescriptor.getPath());
        String string4 = dataDescriptor.getModuleName();
        String[] stringArray = dataDescriptor.getPath();
        String string5 = dataDescriptor.getName();
        if (stringArray.length >= 2) {
            string5 = stringArray[1];
        }
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "descToObjectNameMapping: moduleName=" + string4 + ", mbeanType is " + string3);
        }
        if (stringArray.length >= 4 && submoduleTable.get(stringArray[2]) != null) {
            bl = true;
        }
        if (string4.equals("beanModule")) {
            if (stringArray.length > 1) {
                object = stringArray[1];
                int n = ((String)object).indexOf(35);
                string5 = ((String)object).substring(n + 1);
            }
        } else if (string4.equals("connectionPoolModule") || string4.equals("j2cModule")) {
            if (stringArray != null && stringArray.length >= 2) {
                string5 = stringArray[1];
            }
            if (string5.equals("jmsConnections")) {
                ObjectName objectName = this.findObjectName(null, "Server", string, string2);
                return objectName;
            }
        }
        object = null;
        if (this.isModuleOnlyMapping(string4)) {
            object = this.findObjectName(null, string3, string, string2);
        } else if (dataDescriptor.getType() == 13) {
            object = this.findObjectName(null, "Server", string, string2);
        } else if (string3 == null) {
            object = this.findObjectName(string5, null, string, string2);
        } else if (string3.equals("Servlet") || string3.equals("EntityBean") || string3.equals("StatefulSessionBean") || string3.equals("StatelessSessionBean") || string3.equals("MessageDrivenBean")) {
            object = this.findObjectName(stringArray[1] + "#" + stringArray[3], string, string2);
            if (object == null) {
                string3 = string3.equals("Servlet") ? "WebModule" : "EJBModule";
                object = this.findObjectName(string5, string3, string, string2);
            }
        } else {
            object = bl ? this.findObjectName(stringArray[3], string3, string, string2) : this.findObjectName(string5, string3, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "descToObjectNameMapping");
        }
        return object;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(DataDescriptor dataDescriptor) {
        return this.getMBeanStatDescriptor(dataDescriptor, null, null);
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(DataDescriptor dataDescriptor, String string, String string2) {
        MBeanStatDescriptor mBeanStatDescriptor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanStatDescriptor(dd, ...)");
        }
        DataDescriptor dataDescriptor2 = dataDescriptor;
        if (dataDescriptor == null) {
            ObjectName objectName = this.findObjectName(null, "Server", string, string2);
            dataDescriptor2 = this.getServerDataDescriptor(null);
            MBeanStatDescriptor mBeanStatDescriptor2 = new MBeanStatDescriptor(objectName, null);
            this.setMapping(string, string2, dataDescriptor2, mBeanStatDescriptor2);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMBeanStatDescriptor(dd, ...) - server DD");
            }
            return mBeanStatDescriptor2;
        }
        if (dataDescriptor.getDataIds() != null) {
            dataDescriptor2 = new DataDescriptor(dataDescriptor.getPath());
        }
        if ((mBeanStatDescriptor = this.adminUtil.pmiDescToMBeanDesc_get(string, string2, dataDescriptor2)) != null) {
            return mBeanStatDescriptor;
        }
        ObjectName objectName = this.descToObjectNameMapping(dataDescriptor2, string, string2);
        if (objectName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find ObjectName for dd=" + dataDescriptor2.toString());
            }
            return null;
        }
        MBeanStatDescriptor mBeanStatDescriptor3 = this.getMBeanStatDescriptor(objectName, dataDescriptor2, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanStatDescriptor(dd, ...) - not in hashmap");
        }
        return mBeanStatDescriptor3;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(ObjectName objectName, DataDescriptor dataDescriptor) {
        return this.getMBeanStatDescriptor(objectName, dataDescriptor, null, null);
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(ObjectName objectName, DataDescriptor dataDescriptor, String string, String string2) {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanStatDescriptor(ObjectName, dd, ...)");
        }
        if (objectName == null) {
            objectName = this.descToObjectNameMapping(dataDescriptor, string, string2);
        }
        if (objectName == null) {
            Tr.warning(tc, "PMI0006W", dataDescriptor.toString());
            return null;
        }
        if (dataDescriptor == null || dataDescriptor.getPath() == null || dataDescriptor.getPath().length == 0) {
            return new MBeanStatDescriptor(objectName, null);
        }
        String[] stringArray2 = dataDescriptor.getPath();
        if (stringArray2.length == 1 && stringArray2[0].equals("pmi")) {
            return new MBeanStatDescriptor(objectName, null);
        }
        MBeanStatDescriptor mBeanStatDescriptor = this.adminUtil.pmiDescToMBeanDesc_get(string, string2, dataDescriptor);
        if (mBeanStatDescriptor != null) {
            return mBeanStatDescriptor;
        }
        String string3 = objectName.getKeyProperty("type");
        String string4 = dataDescriptor.getModuleName();
        StatDescriptor statDescriptor = null;
        DataDescriptor dataDescriptor2 = this.getDataDescriptor(objectName, null);
        if (dataDescriptor2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No PMI Module mapping found for mbean type: " + objectName.getKeyProperty("type"));
            }
            return null;
        }
        String[] stringArray3 = dataDescriptor2.getPath();
        if (stringArray3 == null || stringArray3.length == 0 || stringArray3[0].equals("pmi")) {
            statDescriptor = new StatDescriptor(stringArray2);
        } else if (stringArray3.length == stringArray2.length) {
            statDescriptor = null;
        } else if (stringArray2 == null || stringArray2.length == 0) {
            Tr.warning(tc, "PMI0001W", "getMBeanStatDescriptor");
        } else {
            stringArray = new String[stringArray2.length - stringArray3.length];
            System.arraycopy(stringArray2, stringArray3.length, stringArray, 0, stringArray.length);
            statDescriptor = new StatDescriptor(stringArray);
        }
        stringArray = new MBeanStatDescriptor(objectName, statDescriptor);
        this.setMapping(string, string2, dataDescriptor, (MBeanStatDescriptor)stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanStatDescriptor(ObjectName, dd, ...)");
        }
        return stringArray;
    }

    public MBeanStatDescriptor[] getMBeanStatDescriptors(DataDescriptor[] dataDescriptorArray) {
        return this.getMBeanStatDescriptors(dataDescriptorArray, null, null);
    }

    public MBeanStatDescriptor[] getMBeanStatDescriptors(DataDescriptor[] dataDescriptorArray, String string, String string2) {
        if (dataDescriptorArray == null) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[dataDescriptorArray.length];
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            mBeanStatDescriptorArray[i] = this.getMBeanStatDescriptor(dataDescriptorArray[i], string, string2);
        }
        return mBeanStatDescriptorArray;
    }

    public synchronized void setBeanMapping(String string, String string2) {
        beanMap.put(string, string2);
    }

    public String getBeanType(String string) {
        return (String)beanMap.get(string);
    }

    public MBeanLevelSpec getMBeanLevelSpec(PerfLevelDescriptor perfLevelDescriptor) {
        return this.getMBeanLevelSpec(perfLevelDescriptor, null, null);
    }

    public MBeanLevelSpec getMBeanLevelSpec(PerfLevelDescriptor perfLevelDescriptor, String string, String string2) {
        Object object;
        if (perfLevelDescriptor == null) {
            return null;
        }
        String[] stringArray = perfLevelDescriptor.getPath();
        DataDescriptor dataDescriptor = null;
        if (!stringArray[0].equals("pmi")) {
            dataDescriptor = new DataDescriptor(stringArray);
        } else if (stringArray.length > 1) {
            object = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, object, 0, ((Object)object).length);
            dataDescriptor = new DataDescriptor((String[])object);
        }
        object = this.getMBeanStatDescriptor(dataDescriptor, string, string2);
        return new MBeanLevelSpec(((MBeanStatDescriptor)object).getObjectName(), ((MBeanStatDescriptor)object).getStatDescriptor(), perfLevelDescriptor.getLevel());
    }

    public PerfLevelDescriptor getPerfLevelDescriptor(MBeanLevelSpec mBeanLevelSpec) {
        DataDescriptor dataDescriptor = this.getDataDescriptor(mBeanLevelSpec.getObjectName(), mBeanLevelSpec.getStatDescriptor());
        if (dataDescriptor == null) {
            return null;
        }
        return new PerfLevelDescriptor(dataDescriptor.getPath(), mBeanLevelSpec.getLevel());
    }

    public ObjectName findObjectName(String string, String string2, String string3, String string4) {
        if (this.adminUtil == null) {
            return null;
        }
        try {
            return this.adminUtil.findObjectName(string, string2, string3, string4);
        }
        catch (MultipleObjectNamesExistException multipleObjectNamesExistException) {
            FFDCFilter.processException((Throwable)multipleObjectNamesExistException, "com.ibm.websphere.pmi.findObjectName", "462", this);
            Tr.error(tc, "PMI0003W", "type=" + string2 + ",name=" + string);
            return null;
        }
    }

    public ObjectName findObjectName(String string, String string2, String string3) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.findObjectName(string, string2, string3);
    }

    public ObjectName[] findObjectNames(String string, String string2, String string3, String string4) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.findObjectNames(string, string2, string3, string4);
    }

    public Object getAttribute(ObjectName objectName, String string) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.getAttribute(objectName, string);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        return this.adminUtil.invoke(objectName, string, objectArray, stringArray);
    }

    public AdminUtil getAdminUtil() {
        return this.adminUtil;
    }

    public static String StringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(31);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModuleOnlyMapping(String string, String string2) {
        if (string == null || string2 == null) {
            Tr.warning(tc, "PMI0005W", "setModuleOnlyMapping");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "moduleOnlyMapping: module=" + string + ", mbean=" + string2);
            }
            HashMap hashMap = moduleOnlyMap;
            synchronized (hashMap) {
                moduleOnlyMap.put(string, string2);
            }
        }
    }

    public boolean isModuleOnlyMapping(String string) {
        return moduleOnlyMap.containsKey(string);
    }

    private String getEJBModuleName(String string) {
        int n = string.lastIndexOf(35);
        return string.substring(0, n);
    }

    public void setMapping(String string, String string2, DataDescriptor dataDescriptor, MBeanStatDescriptor mBeanStatDescriptor) {
        this.adminUtil.setMapping(string, string2, dataDescriptor, mBeanStatDescriptor);
    }

    static {
        beanMap.put("EntityBean", "ejb.entity");
        beanMap.put("StatefulSessionBean", "ejb.stateful");
        beanMap.put("StatelessSessionBean", "ejb.stateless");
        beanMap.put("MessageDrivenBean", "ejb.messageDriven");
    }
}

