/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.statistics.BoundedRangeStatistic;
import com.ibm.websphere.management.statistics.CountStatistic;
import com.ibm.websphere.management.statistics.JVMStats;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.websphere.pmi.stat.WSStats;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class PmiJmxTest
implements PmiConstants {
    private AdminClient ac = null;
    private ObjectName perfOName = null;
    private ObjectName serverOName = null;
    private ObjectName wlmOName = null;
    private ObjectName jvmOName = null;
    private ObjectName orbtpOName = null;
    private boolean failed = false;
    private PmiModuleConfig[] configs = null;

    public static void main(String[] stringArray) {
        boolean bl;
        PmiJmxTest pmiJmxTest = new PmiJmxTest();
        pmiJmxTest.init(stringArray);
        pmiJmxTest.getObjectNames();
        boolean bl2 = bl = new Boolean(System.getProperty("websphereV5Statistics")) == false;
        if (bl) {
            pmiJmxTest.doTestV6();
        } else {
            pmiJmxTest.doTest();
            pmiJmxTest.testEJB();
            pmiJmxTest.testJSR77Stats();
        }
    }

    public void init(String[] stringArray) {
        try {
            String string = null;
            String string2 = "8880";
            String string3 = "SOAP";
            if (stringArray.length < 1) {
                System.err.println("ERROR: Usage: PmiJmxTest <host> [<port>] [<connector>]");
                System.exit(2);
            } else {
                string = stringArray[0];
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                }
                if (stringArray.length > 2) {
                    string3 = stringArray[2];
                }
            }
            if (string == null) {
                string = "localhost";
            }
            if (string2 == null) {
                string2 = "2809";
            }
            if (string3 == null) {
                string3 = "SOAP";
            }
            System.out.println("host=" + string + " , port=" + string2 + ", connector=" + string3);
            System.out.println("main: create the adminclient");
            this.ac = this.getAdminClient(string, string2, string3);
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
        }
    }

    public AdminClient getAdminClient(String string, String string2, String string3) {
        System.out.println("getAdminClient: host=" + string + " , portStr=" + string2);
        AdminClient adminClient = null;
        Properties properties = new Properties();
        properties.put("type", string3);
        properties.put("host", string);
        properties.put("port", string2);
        try {
            adminClient = AdminClientFactory.createAdminClient(properties);
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            System.out.println("getAdminClient: exception");
        }
        return adminClient;
    }

    public void getObjectNames() {
        try {
            ObjectName objectName = new ObjectName("WebSphere:*");
            Set set = this.ac.queryNames(objectName, null);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    objectName = (ObjectName)iterator.next();
                    String string = objectName.getKeyProperty("type");
                    if (string != null && string.equals("Perf")) {
                        System.out.println("\nMBean: perf =" + objectName.toString());
                        this.perfOName = objectName;
                    }
                    if (string != null && string.equals("Server")) {
                        System.out.println("\nMBean: Server =" + objectName.toString());
                        this.serverOName = objectName;
                    }
                    if (string != null && string.equals("JVM")) {
                        System.out.println("\nMBean: jvm =" + objectName.toString());
                        this.jvmOName = objectName;
                    }
                    if (string != null && string.equals("WLMAppServer")) {
                        System.out.println("\nmain: WLM =" + objectName.toString());
                        this.wlmOName = objectName;
                    }
                    if (string == null || !string.equals("ThreadPool")) continue;
                    String string2 = objectName.getKeyProperty("name");
                    if (string2.equals("ORB.thread.pool")) {
                        System.out.println("\nMBean: ORB ThreadPool =" + objectName.toString());
                    }
                    this.orbtpOName = objectName;
                }
            } else {
                System.err.println("main: ERROR: no object names found");
                System.exit(2);
            }
            if (this.perfOName == null) {
                System.err.println("main: cannot get PerfMBean. Make sure PMI is enabled");
                System.exit(3);
            }
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
        }
    }

    public void doTestV6() {
        System.out.println("\ndoTestV6() output:\n");
        String string = System.setProperty("websphereV5Statistics", "false");
        try {
            System.out.println("\nCurrent statistic set: " + this.ac.invoke(this.perfOName, "getStatisticSet", null, null));
            System.out.println("\nGet all statistics in PMI tree");
            String[] stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatDescriptor;", "java.lang.Boolean"};
            Object[] objectArray = new Object[]{new StatDescriptor[]{new StatDescriptor(null)}, new Boolean(true)};
            WSStats[] wSStatsArray = (WSStats[])this.ac.invoke(this.perfOName, "getStatsArray", objectArray, stringArray);
            System.out.println(((Object)wSStatsArray[0]).toString());
            System.out.println("\nGet JVM statistics using JVM MBean");
            javax.management.j2ee.statistics.Stats stats = (javax.management.j2ee.statistics.Stats)this.ac.getAttribute(this.jvmOName, "stats");
            System.out.println(stats.toString());
            System.out.println("\nGet statistics for a specific thread pool");
            stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatDescriptor;", "java.lang.Boolean"};
            StatDescriptor statDescriptor = new StatDescriptor(new String[]{"threadPoolModule", "WebContainer"});
            objectArray = new Object[]{new StatDescriptor[]{statDescriptor}, new Boolean(true)};
            wSStatsArray = (WSStats[])this.ac.invoke(this.perfOName, "getStatsArray", objectArray, stringArray);
            System.out.println(((Object)wSStatsArray[0]).toString());
            System.out.println("\nSet monitoring to statistic set 'Extended'");
            stringArray = new String[]{"java.lang.String"};
            objectArray = new Object[]{"extended"};
            this.ac.invoke(this.perfOName, "setStatisticSet", objectArray, stringArray);
            System.out.println("\nCurrent statistic set: " + this.ac.invoke(this.perfOName, "getStatisticSet", null, null));
            System.out.println("\nSelectively enable statistics (ActiveCount and PoolSize statistics) for thread pool -- fine grained control");
            StatDescriptor statDescriptor2 = new StatDescriptor(new String[]{"threadPoolModule"});
            StatLevelSpec[] statLevelSpecArray = new StatLevelSpec[]{new StatLevelSpec(statDescriptor2.getPath(), new int[]{3, 4})};
            stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatLevelSpec;", "java.lang.Boolean"};
            objectArray = new Object[]{statLevelSpecArray, new Boolean(true)};
            this.ac.invoke(this.perfOName, "setInstrumentationLevel", objectArray, stringArray);
            System.out.println("\nCurrent statistic set: " + this.ac.invoke(this.perfOName, "getStatisticSet", null, null));
            System.out.println("\nGet statistics from all thread pools");
            stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.StatDescriptor;", "java.lang.Boolean"};
            objectArray = new Object[]{new StatDescriptor[]{statDescriptor2}, new Boolean(true)};
            wSStatsArray = (WSStats[])this.ac.invoke(this.perfOName, "getStatsArray", objectArray, stringArray);
            System.out.println(((Object)wSStatsArray[0]).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.setProperty("websphereV5Statistics", string);
    }

    public void doTest() {
        try {
            this.configs = (PmiModuleConfig[])this.ac.invoke(this.perfOName, "getConfigs", null, null);
            for (int i = 0; i < this.configs.length; ++i) {
                System.out.println("config: moduleName=" + this.configs[i].getShortName() + ", mbeanType=" + this.configs[i].getMbeanType());
            }
            this.setInstrumentationLevel(this.serverOName, null, 7);
            StatDescriptor statDescriptor = new StatDescriptor(new String[]{"wlmModule.server"});
            this.setInstrumentationLevel(this.wlmOName, statDescriptor, 7);
            MBeanLevelSpec[] mBeanLevelSpecArray = this.getInstrumentationLevel(this.wlmOName, statDescriptor, true);
            Stats stats = this.getStatsObject(this.serverOName, true);
            System.out.println(((Object)stats).toString());
            stats = this.getStatsObject(this.wlmOName, statDescriptor, true);
            if (stats == null) {
                System.out.println("Cannot get Stats for WLM data");
            } else {
                System.out.println(((Object)stats).toString());
            }
            stats = this.getStatsObject(this.jvmOName, true);
            this.processStats(stats);
            ObjectName[] objectNameArray = new ObjectName[]{this.orbtpOName, this.jvmOName};
            Object[] objectArray = new Object[]{objectNameArray, new Boolean(true)};
            String[] stringArray = new String[]{"[Ljavax.management.ObjectName;", "java.lang.Boolean"};
            Stats[] statsArray = (Stats[])this.ac.invoke(this.perfOName, "getStatsArray", objectArray, stringArray);
            if (!this.failed) {
                System.out.println("All tests passed");
            } else {
                System.out.println("Some tests failed");
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
        }
    }

    protected MBeanLevelSpec[] getInstrumentationLevel(ObjectName objectName, StatDescriptor statDescriptor, boolean bl) {
        if (statDescriptor == null) {
            return this.getInstrumentationLevel(objectName, bl);
        }
        System.out.println("\ntest getInstrumentationLevel\n");
        try {
            Object[] objectArray = new Object[]{new MBeanStatDescriptor(objectName, statDescriptor), new Boolean(bl)};
            String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor", "java.lang.Boolean"};
            MBeanLevelSpec[] mBeanLevelSpecArray = (MBeanLevelSpec[])this.ac.invoke(this.perfOName, "getInstrumentationLevel", objectArray, stringArray);
            return mBeanLevelSpecArray;
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            System.out.println("getInstrumentationLevel: Exception Thrown");
            return null;
        }
    }

    protected MBeanLevelSpec[] getInstrumentationLevel(ObjectName objectName, boolean bl) {
        if (objectName == null) {
            return null;
        }
        System.out.println("\ntest getInstrumentationLevel\n");
        try {
            Object[] objectArray = new Object[]{objectName, new Boolean(bl)};
            String[] stringArray = new String[]{"javax.management.ObjectName", "java.lang.Boolean"};
            MBeanLevelSpec[] mBeanLevelSpecArray = (MBeanLevelSpec[])this.ac.invoke(this.perfOName, "getInstrumentationLevel", objectArray, stringArray);
            return mBeanLevelSpecArray;
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            this.failed = true;
            System.out.println("getInstrumentationLevel: Exception Thrown");
            return null;
        }
    }

    protected void setInstrumentationLevel(ObjectName objectName, StatDescriptor statDescriptor, int n) {
        System.out.println("\ntest setInstrumentationLevel\n");
        try {
            Object[] objectArray = new Object[2];
            String[] stringArray = null;
            Object var6_7 = null;
            objectArray[0] = new MBeanLevelSpec(objectName, statDescriptor, n);
            objectArray[1] = new Boolean(true);
            stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanLevelSpec", "java.lang.Boolean"};
            this.ac.invoke(this.perfOName, "setInstrumentationLevel", objectArray, stringArray);
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            System.out.println("setInstrumentationLevel: FAILED: Exception Thrown");
        }
    }

    public Stats getStatsObject(ObjectName objectName, StatDescriptor statDescriptor, boolean bl) {
        if (statDescriptor == null) {
            return this.getStatsObject(objectName, bl);
        }
        System.out.println("\ntest getStatsObject\n");
        try {
            Object[] objectArray = new Object[]{new MBeanStatDescriptor(objectName, statDescriptor), new Boolean(bl)};
            String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor", "java.lang.Boolean"};
            Stats stats = (Stats)this.ac.invoke(this.perfOName, "getStatsObject", objectArray, stringArray);
            if (stats == null) {
                return null;
            }
            String string = objectName.getKeyProperty("type");
            if (string.equals("Server")) {
                this.setServerConfig(stats);
            } else {
                stats.setConfig(PmiClient.findConfig(this.configs, objectName));
            }
            return stats;
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            System.out.println("getStatsObject: Exception Thrown");
            return null;
        }
    }

    public Stats getStatsObject(ObjectName objectName, boolean bl) {
        if (objectName == null) {
            return null;
        }
        System.out.println("\ntest getStatsObject\n");
        try {
            Object[] objectArray = new Object[]{objectName, new Boolean(bl)};
            String[] stringArray = new String[]{"javax.management.ObjectName", "java.lang.Boolean"};
            Stats stats = (Stats)this.ac.invoke(this.perfOName, "getStatsObject", objectArray, stringArray);
            String string = objectName.getKeyProperty("type");
            if (string.equals("Server")) {
                this.setServerConfig(stats);
            } else {
                stats.setConfig(PmiClient.findConfig(this.configs, objectName));
            }
            return stats;
        }
        catch (Exception exception) {
            this.failed = true;
            new AdminException(exception).printStackTrace();
            System.out.println("getStatsObject: Exception Thrown");
            return null;
        }
    }

    private void processStats(Stats stats) {
        this.processStats(stats, "");
    }

    private void processStats(Stats stats, String string) {
        Stats[] statsArray;
        if (stats == null) {
            return;
        }
        System.out.println("\n\n");
        String string2 = stats.getName();
        System.out.println(string + "stats name=" + string2);
        String[] stringArray = stats.getStatisticNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(string + "    " + "data name=" + stringArray[i]);
        }
        System.out.println("");
        Statistic[] statisticArray = stats.listStatistics();
        if (statisticArray != null) {
            for (int i = 0; i < statisticArray.length; ++i) {
                StatisticImpl statisticImpl;
                System.out.print(string + "    " + "data name=" + PmiClient.getNLSValue(statisticArray[i].getName()) + ", description=" + PmiClient.getNLSValue(statisticArray[i].getDescription()) + ", startTime=" + statisticArray[i].getStartTime() + ", lastSampleTime=" + statisticArray[i].getLastSampleTime());
                if (statisticArray[i].getDataInfo().getType() == 2) {
                    System.out.println(", count=" + ((CountStatisticImpl)statisticArray[i]).getCount());
                    continue;
                }
                if (statisticArray[i].getDataInfo().getType() == 4) {
                    statisticImpl = (TimeStatisticImpl)statisticArray[i];
                    System.out.println(", count=" + ((TimeStatisticImpl)statisticImpl).getCount() + ", total=" + ((TimeStatisticImpl)statisticImpl).getTotal() + ", mean=" + ((TimeStatisticImpl)statisticImpl).getMean() + ", min=" + ((TimeStatisticImpl)statisticImpl).getMin() + ", max=" + ((TimeStatisticImpl)statisticImpl).getMax());
                    continue;
                }
                if (statisticArray[i].getDataInfo().getType() != 5) continue;
                statisticImpl = (RangeStatisticImpl)statisticArray[i];
                System.out.println(", current=" + ((RangeStatisticImpl)statisticImpl).getCurrent() + ", integral=" + ((RangeStatisticImpl)statisticImpl).getIntegral() + ", avg=" + ((RangeStatisticImpl)statisticImpl).getMean() + ", lowWaterMark=" + ((RangeStatisticImpl)statisticImpl).getLowWaterMark() + ", highWaterMark=" + ((RangeStatisticImpl)statisticImpl).getHighWaterMark());
            }
        }
        if ((statsArray = stats.getSubStats()) == null || statsArray.length == 0) {
            return;
        }
        for (int i = 0; i < statsArray.length; ++i) {
            this.processStats(statsArray[i], string + "    ");
        }
    }

    public void setServerConfig(Stats stats) {
        if (stats == null) {
            return;
        }
        if (stats.getType() != 12) {
            return;
        }
        PmiModuleConfig pmiModuleConfig = null;
        Stats[] statsArray = stats.getSubStats();
        if (statsArray == null || statsArray.length == 0) {
            return;
        }
        Stats stats2 = null;
        for (int i = 0; i < statsArray.length; ++i) {
            stats2 = statsArray[i];
            if (stats2 == null) continue;
            pmiModuleConfig = PmiClient.findConfig(this.configs, stats2.getStatsType());
            if (pmiModuleConfig != null) {
                stats2.setConfig(pmiModuleConfig);
                continue;
            }
            pmiModuleConfig = this.getStatsConfig(stats2.getStatsType());
            if (pmiModuleConfig != null) {
                stats2.setConfig(pmiModuleConfig);
                continue;
            }
            System.out.println("Error: get null config for " + stats2.getStatsType());
        }
    }

    public MBeanStatDescriptor getStatDescriptor(ObjectName objectName, String string) {
        try {
            Object[] objectArray = new Object[]{this.serverOName};
            String[] stringArray = new String[]{"javax.management.ObjectName"};
            MBeanStatDescriptor[] mBeanStatDescriptorArray = (MBeanStatDescriptor[])this.ac.invoke(this.perfOName, "listStatMembers", objectArray, stringArray);
            if (mBeanStatDescriptorArray == null) {
                return null;
            }
            for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
                if (!mBeanStatDescriptorArray[i].getName().equals(string)) continue;
                return mBeanStatDescriptorArray[i];
            }
            return null;
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            System.out.println("listStatMembers: Exception Thrown");
            return null;
        }
    }

    public MBeanStatDescriptor[] listStatMembers(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        try {
            Object[] objectArray = new Object[]{objectName};
            String[] stringArray = new String[]{"javax.management.ObjectName"};
            MBeanStatDescriptor[] mBeanStatDescriptorArray = (MBeanStatDescriptor[])this.ac.invoke(this.perfOName, "listStatMembers", objectArray, stringArray);
            if (mBeanStatDescriptorArray == null) {
                return null;
            }
            for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
                MBeanStatDescriptor[] mBeanStatDescriptorArray2 = this.listStatMembers(mBeanStatDescriptorArray[i]);
            }
            return null;
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            System.out.println("listStatMembers: Exception Thrown");
            return null;
        }
    }

    public MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        try {
            Object[] objectArray = new Object[]{mBeanStatDescriptor};
            String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor"};
            MBeanStatDescriptor[] mBeanStatDescriptorArray = (MBeanStatDescriptor[])this.ac.invoke(this.perfOName, "listStatMembers", objectArray, stringArray);
            if (mBeanStatDescriptorArray == null) {
                return null;
            }
            for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
                MBeanStatDescriptor[] mBeanStatDescriptorArray2 = this.listStatMembers(mBeanStatDescriptorArray[i]);
            }
            return mBeanStatDescriptorArray;
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            System.out.println("listStatMembers: Exception Thrown");
            return null;
        }
    }

    public void testEJB() {
        MBeanStatDescriptor mBeanStatDescriptor = this.getStatDescriptor(this.serverOName, "beanModule");
        if (mBeanStatDescriptor == null) {
            System.out.println("Error: cannot find beanModule");
        }
        Stats stats = this.getStatsObject(mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor(), false);
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)stats.getStatistic(12);
        System.out.println("rt is " + timeStatisticImpl.getMean());
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Stats stats2 = this.getStatsObject(mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor(), false);
        TimeStatisticImpl timeStatisticImpl2 = (TimeStatisticImpl)stats2.getStatistic(12);
        System.out.println("rt2 is " + timeStatisticImpl2.getMean());
        TimeStatisticImpl timeStatisticImpl3 = (TimeStatisticImpl)timeStatisticImpl2.delta(timeStatisticImpl);
        System.out.println("deltaRt is " + timeStatisticImpl.getMean());
    }

    public void testJSR77Stats() {
        try {
            JVMStats jVMStats = (JVMStats)this.ac.invoke(this.jvmOName, "getStats", null, null);
            System.out.println("\n get data from JVM MBean");
            if (jVMStats == null) {
                System.out.println("WARNING: getStats on JVM MBean returns null");
            } else {
                ((Stats)((Object)jVMStats)).setConfig(PmiClient.findConfig(this.configs, this.jvmOName));
                this.processStats((Stats)((Object)jVMStats));
                CountStatistic countStatistic = jVMStats.getUpTime();
                BoundedRangeStatistic boundedRangeStatistic = jVMStats.getHeapSize();
                if (countStatistic != null) {
                    System.out.println("\nJVM up time is " + countStatistic.getCount());
                }
                if (boundedRangeStatistic != null) {
                    System.out.println("\nheapSize is " + boundedRangeStatistic.getCurrent());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new AdminException(exception).printStackTrace();
        }
    }

    public PmiModuleConfig getStatsConfig(String string) {
        try {
            return (PmiModuleConfig)this.ac.invoke(this.perfOName, "getConfig", new String[]{string}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public PmiModuleConfig findConfig(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        String string = objectName.getKeyProperty("type");
        System.out.println("findConfig: mbean type =" + string);
        for (int i = 0; i < this.configs.length; ++i) {
            if (!this.configs[i].getMbeanType().equals(string)) continue;
            return this.configs[i];
        }
        System.out.println("Error: cannot find the config");
        return null;
    }

    public PmiModuleConfig findConfig(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.configs.length; ++i) {
            if (!this.configs[i].getShortName().equals(string)) continue;
            return this.configs[i];
        }
        System.out.println("Error: cannot find the config");
        return null;
    }
}

