/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.client;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiException;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.CpdData;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PerfDescriptorList;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.websphere.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.DoubleStatisticImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.websphere.pmi.stat.WSStatsHelper;
import com.ibm.ws.pmi.client.CpdCollectionImpl;
import com.ibm.ws.pmi.client.CpdDataImpl;
import com.ibm.ws.pmi.client.CpdLoadImpl;
import com.ibm.ws.pmi.client.CpdStatImpl;
import com.ibm.ws.pmi.client.CpdValueImpl;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.perfServer.Collector;
import com.ibm.ws.pmi.perfServer.CollectorEPM;
import com.ibm.ws.pmi.perfServer.CollectorJMX;
import com.ibm.ws.pmi.perfServer.DataCache;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.ws.pmi.wire.WpdDouble;
import com.ibm.ws.pmi.wire.WpdInt;
import com.ibm.ws.pmi.wire.WpdLoad;
import com.ibm.ws.pmi.wire.WpdLong;
import com.ibm.ws.pmi.wire.WpdStat;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class PmiClient
implements PmiConstants {
    public static final String COPYRIGHT = "Product 5630-A36,  (C) COPYRIGHT International Business Machines Corp., 1997, 2002\nAll Rights Reserved * Licensed Materials - Property of IBM\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private InitialContext ic = null;
    private String hostName = null;
    private static HashMap staticConfigs = new HashMap();
    private HashMap configs = null;
    private static final String MULTIPLE_DATA = "MULTIPLE_DATA";
    private int errCode = 0;
    private String errMsg = "No Error";
    public static final String VERSION_AE = "AE";
    public static final String VERSION_AES = "AES";
    public static final String VERSION_EPM = "EPM";
    public static final String VERSION_WAS50 = "WAS50";
    public static final String VERSION_WAS50ND = "WAS50ND";
    public static final int NO_ERROR = 0;
    public static final int FAILED_TO_GET_INITIAL_CONTEXT = 1;
    public static final int FAILED_TO_CREATE_PMISERVICE_BEAN_OBJECT = 2;
    public static final int FAILED_TO_LIST_NODES = 3;
    public static final int FAILED_TO_LIST_SERVERS = 4;
    public static final int FAILED_TO_LIST_MEMBERS = 5;
    public static final int FAILED_TO_ENABLE_DATA = 6;
    public static final int FAILED_TO_DISABLE_DATA = 7;
    public static final int FAILED_TO_SET_LEVEL = 8;
    public static final int FAILED_TO_GET_LEVEL = 9;
    public static final int FAILED_TO_GET_DATA = 10;
    public static final int FAILED_TO_GET_ADMIN_STATE = 11;
    public static final int SERVER_STOPPED = 12;
    public static final int NO_COLLECTOR_FOUND = 13;
    public static final int NO_SUCH_A_NODE = 14;
    public static final int NO_SUCH_A_SERVER = 15;
    public static final int NO_PERFMBEAN_FOUND = 16;
    public static final String SEPERATOR50 = ",";
    public static final String SEPERATOR40 = "/";
    public static final String DEFAULT_CONNECTOR_TYPE = "SOAP";
    public static final String DEFAULT_CONNECTOR_PORT = "8880";
    private static int timeUnit = 1;
    private static int timeUnitSquare = timeUnit * timeUnit;
    private PerfDescriptorList thisPdList = new PerfDescriptorList();
    private Collector collector = null;
    private boolean debug = false;
    public static final NLS pmiNLS = new NLS("com.ibm.ws.pmi.properties.PMIText", true);
    public static HashMap moduleNLSMap = new HashMap();
    public static HashMap prefixNLSMap = new HashMap();

    public PmiClient() throws RemoteException {
        this(null, null, VERSION_WAS50, false, null);
    }

    public PmiClient(boolean bl) throws RemoteException {
        this(null, null, VERSION_WAS50, bl, null);
    }

    public PmiClient(String string, String string2) throws RemoteException {
        this(string, string2, VERSION_WAS50, false, null);
    }

    public PmiClient(String string, String string2, String string3) throws RemoteException {
        this(string, string2, string3, false, null);
    }

    public PmiClient(String string, String string2, String string3, String string4) throws RemoteException {
        DataCache.setNodeName(string2);
        this.init(string, string3, string4, false, null);
    }

    public PmiClient(String string, String string2, String string3, boolean bl, String string4) throws RemoteException {
        this.init(string, string2, string3, bl, string4);
    }

    public PmiClient(Properties properties, String string) throws RemoteException {
        if (properties == null) {
            throw new RemoteException("PmiClientcannot connect to server: null props is passed");
        }
        String string2 = (String)properties.get("host");
        String string3 = (String)properties.get("port");
        String string4 = (String)properties.get("type");
        this.init(string2, string3, string, false, string4, properties);
    }

    private void init(String string, String string2, String string3, boolean bl, String string4) throws RemoteException {
        this.init(string, string2, string3, bl, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string, String string2, String string3, boolean bl, String string4, Properties properties) throws RemoteException {
        if (string3.equalsIgnoreCase(VERSION_AE) || string3.equalsIgnoreCase(VERSION_AES) || string3.equalsIgnoreCase(VERSION_EPM)) {
            PmiModuleConfig[] pmiModuleConfigArray = PerfModules.getConfigs40();
            this.configs = new HashMap();
            HashMap hashMap = this.configs;
            synchronized (hashMap) {
                for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
                    this.configs.put(pmiModuleConfigArray[i].getUID(), pmiModuleConfigArray[i]);
                }
            }
            staticConfigs = this.configs;
        } else {
            this.configs = staticConfigs;
        }
        try {
            if (string == null || string.equals("localhost")) {
                string = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Cannot get local host name", exception);
        }
        this.collector = DataCache.createCollector(string, string2, string3, bl, string4, properties);
        if (this.collector == null) {
            throw new RemoteException("Cannot create collector for node " + string);
        }
        this.collector.setPmiClient(this);
        this.hostName = string;
    }

    public String getConnectedHost() {
        return this.hostName;
    }

    public static CpdData createCpdData(PmiModuleConfig pmiModuleConfig, PerfDescriptor perfDescriptor, WpdData wpdData) {
        if (pmiModuleConfig == null) {
            System.out.println("WRONG: PmiClient.createCpdData: null moduleConfig");
            return null;
        }
        if (wpdData == null) {
            System.out.println("WRONG: PmiClient.createCpdData: null wData");
            return null;
        }
        if (perfDescriptor == null) {
            System.out.println("WRONG: PmiClient.createCpdData: null parent pd");
            return null;
        }
        int n = wpdData.getId();
        PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
        if (pmiDataInfo == null) {
            System.out.println("[PmiClient] Error: wrong dataId :" + n);
            return null;
        }
        String string = pmiDataInfo.getDescription();
        int n2 = pmiDataInfo.getType();
        PerfDescriptor perfDescriptor2 = PmiClient.createPerfDescriptor(perfDescriptor, pmiDataInfo.getId());
        CpdDataImpl cpdDataImpl = null;
        CpdValue cpdValue = null;
        double d = wpdData.getTime();
        if (timeUnit > 1) {
            d = d * 1.0 / (double)timeUnit;
        }
        try {
            switch (n2) {
                case 1: {
                    WpdInt wpdInt = (WpdInt)wpdData;
                    cpdValue = new CpdValueImpl(wpdInt.getIntValue(), d);
                    cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                    break;
                }
                case 2: {
                    WpdLong wpdLong = (WpdLong)wpdData;
                    cpdValue = new CpdValueImpl(wpdLong.getLongValue(), d);
                    cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                    break;
                }
                case 3: {
                    WpdDouble wpdDouble = (WpdDouble)wpdData;
                    cpdValue = new CpdValueImpl(wpdDouble.getDoubleValue(), d);
                    cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                    break;
                }
                case 4: 
                case 6: {
                    WpdStat wpdStat = (WpdStat)wpdData;
                    cpdValue = new CpdStatImpl(wpdStat.getTotal() / (double)timeUnit, wpdStat.getCount(), wpdStat.getSumOfSquares() / (double)timeUnitSquare, d);
                    cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                    break;
                }
                case 5: 
                case 7: {
                    WpdLoad wpdLoad = (WpdLoad)wpdData;
                    double d2 = d - (double)wpdLoad.getCreateTime() * 1.0 / (double)timeUnit;
                    cpdValue = new CpdLoadImpl(wpdLoad.getIntegral() / (double)timeUnit, wpdLoad.getLastValue(), d, d2);
                    cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                    break;
                }
                default: {
                    cpdDataImpl = null;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("[PmiClient] Exception: expected type=" + n2 + ", got " + wpdData.toString());
        }
        return cpdDataImpl;
    }

    public CpdCollection createCpdCollection(PerfDescriptor perfDescriptor, WpdCollection wpdCollection) {
        Serializable serializable;
        if (wpdCollection == null || perfDescriptor == null) {
            return null;
        }
        if (wpdCollection instanceof Stats) {
            return this.statsToCpdCollection(perfDescriptor, (Stats)((Object)wpdCollection));
        }
        PerfDescriptor perfDescriptor2 = PmiClient.getTopLevelPd(perfDescriptor, wpdCollection.getType());
        PmiModuleConfig pmiModuleConfig = this.getConfig(perfDescriptor2);
        ArrayList arrayList = wpdCollection.dataMembers();
        ArrayList<CpdData> arrayList2 = null;
        if (arrayList != null && arrayList.size() > 0) {
            if (pmiModuleConfig == null) {
                return null;
            }
            arrayList2 = new ArrayList<CpdData>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                serializable = (WpdData)arrayList.get(i);
                if (serializable == null) {
                    if (!this.debug) continue;
                    System.out.println("[PmiClient] WARNING: PmiClient.createCpdCollection: wData is null");
                    continue;
                }
                CpdData cpdData = PmiClient.createCpdData(pmiModuleConfig, perfDescriptor2, serializable);
                if (cpdData == null) continue;
                arrayList2.add(cpdData);
            }
        }
        ArrayList arrayList3 = wpdCollection.subCollections();
        serializable = null;
        if (arrayList3 != null) {
            serializable = new ArrayList(arrayList3.size());
            for (int i = 0; i < arrayList3.size(); ++i) {
                WpdCollection wpdCollection2 = (WpdCollection)arrayList3.get(i);
                PerfDescriptor perfDescriptor3 = PmiClient.createPerfDescriptor(perfDescriptor2, wpdCollection2.getName());
                ((ArrayList)serializable).add(this.createCpdCollection(perfDescriptor3, wpdCollection2));
            }
        }
        String string = null;
        string = perfDescriptor2.getType() == 11 ? "a node" : (perfDescriptor2.getType() == 12 ? "a server" : (perfDescriptor2.getType() == 13 ? pmiModuleConfig.getDescription() : pmiModuleConfig.getDescription() + ".col"));
        return new CpdCollectionImpl(perfDescriptor2, string, arrayList2, (ArrayList)serializable, wpdCollection.getLevel());
    }

    private static PerfDescriptor getTopLevelPd(PerfDescriptor perfDescriptor, int n) {
        if (perfDescriptor.getServerName() == null && perfDescriptor.getDataDescriptor() != null) {
            return PmiClient.createPerfDescriptor(new String[]{perfDescriptor.getNodeName()});
        }
        if (perfDescriptor.getType() != 18) {
            return perfDescriptor;
        }
        return PmiClient.createPerfDescriptor(perfDescriptor.getPath());
    }

    public static CpdCollection createRootCollection() {
        PerfDescriptor perfDescriptor = PmiClient.createPerfDescriptor();
        String string = "pmiroot.desc";
        CpdCollectionImpl cpdCollectionImpl = new CpdCollectionImpl(perfDescriptor, string, null, null, -1);
        return cpdCollectionImpl;
    }

    public PerfDescriptor[] listNodes() throws PmiException {
        try {
            PerfDescriptor[] perfDescriptorArray = DataCache.listNodes(this.collector);
            if (perfDescriptorArray == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] ERROR: no node from listNodes()");
                }
                return null;
            }
            for (int i = 0; i < perfDescriptorArray.length; ++i) {
                perfDescriptorArray[i].postInit();
            }
            return perfDescriptorArray;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] Exception to listNodes: " + exception.toString());
            }
            throw new PmiException("Exception to listNodes\n" + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getConfigFromServer(String string, String string2) {
        PmiModuleConfig[] pmiModuleConfigArray;
        if (this.debug) {
            System.out.println("[PmiClient] Getting stats config from server");
        }
        if ((pmiModuleConfigArray = this.collector.getConfigs(string, string2)) != null) {
            WSStatsHelper.initTextInfo(pmiModuleConfigArray, null);
            HashMap hashMap = this.configs;
            synchronized (hashMap) {
                for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
                    this.configs.put(pmiModuleConfigArray[i].getUID(), pmiModuleConfigArray[i]);
                    PmiClient._loadCustomNLS(pmiModuleConfigArray[i]);
                }
            }
        }
    }

    private static void _loadCustomNLS(PmiModuleConfig pmiModuleConfig) {
        NLS nLS;
        String string = pmiModuleConfig.getResourceBundle();
        if (string != null && (nLS = new NLS(string, true)) != null) {
            moduleNLSMap.put(pmiModuleConfig.getUID(), nLS);
        }
    }

    public PerfDescriptor[] listServers(String string) throws PmiException {
        try {
            PerfDescriptor[] perfDescriptorArray = DataCache.listServers(this.collector, string);
            if (perfDescriptorArray == null) {
                if (this.debug) {
                    System.out.println("PmiClient: no server from listServers()");
                }
                return null;
            }
            for (int i = 0; i < perfDescriptorArray.length; ++i) {
                perfDescriptorArray[i].postInit();
                this._getConfigFromServer(perfDescriptorArray[i].getNodeName(), perfDescriptorArray[i].getServerName());
            }
            return perfDescriptorArray;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] listServers exception");
            }
            throw new PmiException("Exception to listServers\n" + exception.toString());
        }
    }

    public PerfDescriptor[] listServers(PerfDescriptor perfDescriptor) throws PmiException {
        if (perfDescriptor == null) {
            return null;
        }
        return this.listServers(perfDescriptor.getNodeName());
    }

    public PerfDescriptor[] listMembers(PerfDescriptor perfDescriptor) throws PmiException {
        try {
            PerfDescriptor[] perfDescriptorArray = DataCache.listMembers(this.collector, perfDescriptor);
            if (perfDescriptorArray == null) {
                return null;
            }
            for (int i = 0; i < perfDescriptorArray.length; ++i) {
                if (perfDescriptorArray[i].getType() == 18) {
                    DataDescriptor dataDescriptor = perfDescriptorArray[i].getDataDescriptor();
                    String string = this.getDataName(dataDescriptor.getModuleName(), dataDescriptor.getDataId());
                    perfDescriptorArray[i].postInit(string);
                    continue;
                }
                perfDescriptorArray[i].postInit();
            }
            return perfDescriptorArray;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] listMembers exception");
            }
            throw new PmiException("Exception to listMembers\n" + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PmiModuleConfig[] getConfigs() {
        if (this.configs.size() == 0) {
            PmiModuleConfig[] pmiModuleConfigArray = PerfModules.getConfigs();
            HashMap hashMap = this.configs;
            synchronized (hashMap) {
                for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
                    this.configs.put(pmiModuleConfigArray[i].getUID(), pmiModuleConfigArray[i]);
                }
            }
            WSStatsHelper.initTextInfo(pmiModuleConfigArray, null);
            return pmiModuleConfigArray;
        }
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[this.configs.size()];
        Object[] objectArray = this.configs.values().toArray();
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            pmiModuleConfigArray[i] = (PmiModuleConfig)objectArray[i];
        }
        WSStatsHelper.initTextInfo(pmiModuleConfigArray, null);
        return pmiModuleConfigArray;
    }

    public synchronized void refreshModuleConfig(String string, String string2) {
        this._getConfigFromServer(string, string2);
    }

    public PmiModuleConfig getConfig(String string) {
        PmiModuleConfig pmiModuleConfig;
        try {
            if (this.configs.size() == 0) {
                this.getConfigs();
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] Exception to getConfig for " + string + ": " + exception.toString());
            }
            return null;
        }
        int n = string.indexOf(35);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((pmiModuleConfig = (PmiModuleConfig)this.configs.get(string)) == null) {
            return null;
        }
        return pmiModuleConfig;
    }

    private PmiModuleConfig getConfig(PerfDescriptor perfDescriptor) {
        PmiModuleConfig pmiModuleConfig = null;
        if (perfDescriptor.getDataDescriptor() != null && perfDescriptor.getModuleName() != null && (pmiModuleConfig = this.getConfig(perfDescriptor.getModuleName())) == null) {
            this._getConfigFromServer(perfDescriptor.getNodeName(), perfDescriptor.getServerName());
            pmiModuleConfig = this.getConfig(perfDescriptor.getModuleName());
            if (pmiModuleConfig == null) {
                String string = perfDescriptor.getModuleName();
                if (string.indexOf(44) != -1 && (pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(string)) != null) {
                    this.configs.put(string, pmiModuleConfig);
                }
                if (this.debug && pmiModuleConfig == null) {
                    System.out.println("[PmiClient] Error: config is null - " + perfDescriptor.getModuleName());
                }
            }
        }
        return pmiModuleConfig;
    }

    public CpdCollection get(PerfDescriptor perfDescriptor, boolean bl) throws PmiException {
        try {
            if (perfDescriptor == null) {
                return null;
            }
            WpdCollection wpdCollection = DataCache.get(this.collector, perfDescriptor, bl, 0);
            return this.createCpdCollection(perfDescriptor, wpdCollection);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] get(pd) exception");
            }
            throw new PmiException("Exception to get PMI data\n" + exception.toString());
        }
    }

    public CpdCollection[] gets(boolean bl) throws PmiException {
        return this.gets(this.thisPdList, bl);
    }

    public CpdCollection[] gets(PerfDescriptor[] perfDescriptorArray, boolean bl) throws PmiException {
        try {
            if (perfDescriptorArray == null || perfDescriptorArray.length == 0) {
                return null;
            }
            WpdCollection[] wpdCollectionArray = DataCache.gets(this.collector, perfDescriptorArray, bl, 0);
            if (wpdCollectionArray == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Null PMI data - server is not up or PMI is not enabled");
                }
                return null;
            }
            CpdCollection[] cpdCollectionArray = new CpdCollectionImpl[wpdCollectionArray.length];
            for (int i = 0; i < wpdCollectionArray.length; ++i) {
                cpdCollectionArray[i] = this.createCpdCollection(perfDescriptorArray[i], wpdCollectionArray[i]);
            }
            return cpdCollectionArray;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] gets(pds, recursive) exception");
                exception.printStackTrace();
            }
            throw new PmiException("Exception to get PMI data\n" + exception.toString());
        }
    }

    public CpdCollection[] gets(PerfDescriptorList perfDescriptorList, boolean bl) throws PmiException {
        return this.gets(perfDescriptorList.getDescriptors(), bl);
    }

    public int getAdminState(String string) throws PmiException {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector for the node " + string);
            }
            this.errCode = 13;
            this.errMsg = "No collector is found";
            return -1;
        }
        return this.collector.getAdminState(string);
    }

    public int getAdminState(String string, String string2) throws PmiException {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector for the node " + string);
            }
            this.errCode = 13;
            this.errMsg = "No collector is found";
            return -1;
        }
        return this.collector.getAdminState(string, string2);
    }

    public int getErrorCode() {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] WARNING: no collector found. please give a node name to specify a collector");
            }
            return 13;
        }
        return this.collector.getErrCode();
    }

    public String getErrorMessage() {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] WARNING: no collector found. Please give a node name to specify a collector");
            }
            return "No collector found";
        }
        return this.collector.getErrMsg();
    }

    public int getErrorCode(String string) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector for the node " + string);
            }
            return 13;
        }
        return this.collector.getErrCode();
    }

    public String getErrorMessage(String string) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector for the node " + string);
            }
            return "No collector is found";
        }
        return this.collector.getErrMsg();
    }

    public void add(PerfDescriptor perfDescriptor) {
        this.thisPdList.addDescriptor(perfDescriptor);
    }

    public static String[] stringToArray(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = string.indexOf(SEPERATOR50) > 0 ? new StringTokenizer(string, SEPERATOR50) : new StringTokenizer(string, SEPERATOR40);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static PerfDescriptor createPerfDescriptor() {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl();
        perfDescriptorImpl.postInit();
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(String[] stringArray) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(stringArray);
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        perfDescriptorImpl.postInit();
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(String string) {
        return PmiClient.createPerfDescriptor(PmiClient.stringToArray(string));
    }

    public static PerfDescriptor createPerfDescriptor(String[] stringArray, int n) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(stringArray, n);
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        String string = PmiClient.getStaticDataName(perfDescriptorImpl.getModuleName(), n);
        if (string == null) {
            return null;
        }
        perfDescriptorImpl.postInit(string);
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(String string, int n) {
        return PmiClient.createPerfDescriptor(PmiClient.stringToArray(string), n);
    }

    public static PerfDescriptor createPerfDescriptor(String[] stringArray, int[] nArray) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(stringArray, nArray);
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        perfDescriptorImpl.postInit(MULTIPLE_DATA);
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(String string, int[] nArray) {
        return PmiClient.createPerfDescriptor(PmiClient.stringToArray(string), nArray);
    }

    public static PerfDescriptor createPerfDescriptor(PerfDescriptor perfDescriptor, String string) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(perfDescriptor, string);
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        perfDescriptorImpl.postInit();
        perfDescriptorImpl.setModuleName(perfDescriptor.getModuleName());
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(PerfDescriptor perfDescriptor, int n) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(perfDescriptor, n);
        perfDescriptorImpl.setModuleName(perfDescriptor.getModuleName());
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        String string = PmiClient.getStaticDataName(perfDescriptorImpl.getModuleName(), n);
        if (string == null) {
            return null;
        }
        perfDescriptorImpl.postInit(string);
        perfDescriptorImpl.setModuleName(perfDescriptor.getModuleName());
        return perfDescriptorImpl;
    }

    public static PerfDescriptor createPerfDescriptor(PerfDescriptor perfDescriptor, int[] nArray) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(perfDescriptor, nArray);
        if (perfDescriptorImpl.getType() == -1) {
            return null;
        }
        perfDescriptorImpl.postInit(MULTIPLE_DATA);
        perfDescriptorImpl.setModuleName(perfDescriptor.getModuleName());
        return perfDescriptorImpl;
    }

    public PerfLevelSpec createPerfLevelSpec(String[] stringArray, int n) {
        return new PerfLevelDescriptor(stringArray, n);
    }

    public PerfLevelSpec createPerfLevelSpec(int n) {
        return new PerfLevelDescriptor(null, n);
    }

    private static String getStaticDataName(String string, int n) {
        PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)staticConfigs.get(string);
        if (pmiModuleConfig == null) {
            return null;
        }
        PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
        if (pmiDataInfo == null) {
            return null;
        }
        return pmiDataInfo.getName();
    }

    public String getDataName(String string, int n) {
        PmiModuleConfig pmiModuleConfig = this.getConfig(string);
        if (pmiModuleConfig == null) {
            return null;
        }
        PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
        if (pmiDataInfo == null) {
            return null;
        }
        return pmiDataInfo.getName();
    }

    public int getDataId(String string, String string2) {
        PmiModuleConfig pmiModuleConfig = this.getConfig(string);
        if (string2.indexOf(46) < 0) {
            string2 = string + "." + string2;
        }
        if (pmiModuleConfig != null) {
            return pmiModuleConfig.getDataId(string2);
        }
        return -1;
    }

    public PerfLevelSpec[] getInstrumentationLevel(String string, String string2) throws PmiException {
        try {
            if (this.collector == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Cannot find Collector for the node " + string);
                }
                return null;
            }
            PerfLevelSpec[] perfLevelSpecArray = this.collector.getInstrumentationLevel(string, string2);
            return perfLevelSpecArray;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] getInstrumentationLevel exception");
            }
            throw new PmiException("Exception to getInstrumentationLevel\n" + exception.toString());
        }
    }

    public void setInstrumentationLevel(String string, String string2, PerfLevelSpec[] perfLevelSpecArray, boolean bl) throws PmiException {
        try {
            if (perfLevelSpecArray == null) {
                return;
            }
            PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[perfLevelSpecArray.length];
            for (int i = 0; i < perfLevelSpecArray.length; ++i) {
                perfLevelDescriptorArray[i] = (PerfLevelDescriptor)perfLevelSpecArray[i];
            }
            if (this.collector == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Cannot find Collector for the node " + string);
                }
                return;
            }
            this.collector.setInstrumentationLevel(string, string2, perfLevelDescriptorArray, bl);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] setInstrumentationLevel exception");
            }
            throw new PmiException("Exception to setInstrumentationLevel\n" + exception.toString());
        }
    }

    private CpdCollection statsToCpdCollection(PerfDescriptor perfDescriptor, Stats stats) {
        Object object;
        if (stats == null || perfDescriptor == null) {
            return null;
        }
        String string = ((StatsImpl)stats).getStatsType();
        if (string != null) {
            ((PerfDescriptorImpl)perfDescriptor).setModuleName(string);
        }
        long l = stats.getTime();
        PerfDescriptor perfDescriptor2 = PmiClient.getTopLevelPd(perfDescriptor, stats.getType());
        if (string != null) {
            ((PerfDescriptorImpl)perfDescriptor2).setModuleName(string);
        }
        PmiModuleConfig pmiModuleConfig = this.getConfig(perfDescriptor2);
        DataDescriptor dataDescriptor = perfDescriptor.getDataDescriptor();
        int[] nArray = null;
        boolean bl = false;
        if (dataDescriptor != null && (nArray = dataDescriptor.getDataIds()) != null && nArray.length != 0) {
            bl = true;
        }
        Statistic[] statisticArray = stats.listStatistics();
        ArrayList<CpdData> arrayList = null;
        if (statisticArray != null && statisticArray.length > 0) {
            if (pmiModuleConfig == null) {
                return null;
            }
            arrayList = new ArrayList<CpdData>(statisticArray.length);
            for (int i = 0; i < statisticArray.length; ++i) {
                CpdData cpdData;
                object = statisticArray[i];
                if (object == null) {
                    if (!this.debug) continue;
                    System.out.println("[PmiClient] WARNING: PmiClient.createCpdCollection: wData is null");
                    continue;
                }
                if (bl) {
                    boolean bl2 = false;
                    int n = object.getId();
                    for (int j = 0; j < nArray.length; ++j) {
                        if (n != nArray[j]) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                }
                if ((cpdData = this.statisticToCpdData(l, pmiModuleConfig, perfDescriptor2, (Statistic)object)) == null) continue;
                arrayList.add(cpdData);
            }
        }
        Stats[] statsArray = stats.listSubStats();
        object = null;
        if (statsArray != null) {
            object = new ArrayList(statsArray.length);
            for (int i = 0; i < statsArray.length; ++i) {
                Stats stats2 = statsArray[i];
                PerfDescriptor perfDescriptor3 = PmiClient.createPerfDescriptor(perfDescriptor2, stats2.getName());
                if (bl) {
                    perfDescriptor3 = PmiClient.createPerfDescriptor(perfDescriptor3, nArray);
                }
                ((ArrayList)object).add(this.statsToCpdCollection(perfDescriptor3, stats2));
            }
        }
        String string2 = null;
        if (perfDescriptor2.getType() == 11) {
            string2 = "a node";
        } else if (perfDescriptor2.getType() == 12) {
            string2 = "a server";
        } else if (perfDescriptor2.getType() == 13) {
            if (null == pmiModuleConfig) {
                if (this.debug) {
                    System.out.println("[PmiClient] WARNING: PmiClient.statsToCpdCollection: could not get description.  config is null for " + perfDescriptor2.getFullName());
                }
            } else {
                string2 = pmiModuleConfig.getDescription();
            }
        } else if (null == pmiModuleConfig) {
            if (this.debug) {
                System.out.println("[PmiClient] WARNING: PmiClient.statsToCpdCollection: could not get description.  config is null for " + perfDescriptor2.getFullName());
            }
        } else {
            string2 = pmiModuleConfig.getDescription() + ".col";
        }
        return new CpdCollectionImpl(perfDescriptor2, string2, arrayList, (ArrayList)object, stats.getLevel());
    }

    private CpdData statisticToCpdData(long l, PmiModuleConfig pmiModuleConfig, PerfDescriptor perfDescriptor, Statistic statistic) {
        CpdDataImpl cpdDataImpl;
        block22: {
            if (pmiModuleConfig == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] WRONG: PmiClient.createCpdData: null moduleConfig");
                }
                return null;
            }
            if (statistic == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] WRONG: PmiClient.createCpdData: null wData");
                }
                return null;
            }
            if (perfDescriptor == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] WRONG: PmiClient.createCpdData: null parent pd");
                }
                return null;
            }
            int n = statistic.getId();
            PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
            if (pmiDataInfo == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Error: wrong dataId :" + n + " in " + pmiModuleConfig.getUID());
                }
                return null;
            }
            int n2 = pmiDataInfo.getType();
            PerfDescriptor perfDescriptor2 = PmiClient.createPerfDescriptor(perfDescriptor, pmiDataInfo.getId());
            cpdDataImpl = null;
            CpdValue cpdValue = null;
            double d = l;
            double d2 = statistic.getLastSampleTime();
            if (timeUnit > 1) {
                d2 = d2 * 1.0 / (double)timeUnit;
            }
            double d3 = statistic.getStartTime();
            if (timeUnit > 1) {
                d3 = d3 * 1.0 / (double)timeUnit;
            }
            try {
                switch (n2) {
                    case 2: {
                        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statistic;
                        cpdValue = new CpdValueImpl(countStatisticImpl.getCount(), d, d3);
                        cpdValue.setLastSampleTime(d2);
                        cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                        break;
                    }
                    case 3: {
                        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)statistic;
                        cpdValue = new CpdValueImpl(doubleStatisticImpl.getDouble(), d, d3);
                        cpdValue.setLastSampleTime(d2);
                        cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                        break;
                    }
                    case 4: 
                    case 6: {
                        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statistic;
                        cpdValue = new CpdStatImpl(timeStatisticImpl.getTotal() / (long)timeUnit, timeStatisticImpl.getCount(), timeStatisticImpl.getSumOfSquares() / (long)timeUnitSquare, d, d3, timeStatisticImpl.getMinTime(), timeStatisticImpl.getMaxTime());
                        cpdValue.setLastSampleTime(d2);
                        cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                        break;
                    }
                    case 5: 
                    case 7: {
                        BoundedRangeStatisticImpl boundedRangeStatisticImpl = (BoundedRangeStatisticImpl)statistic;
                        double d4 = d - d3;
                        cpdValue = new CpdLoadImpl(boundedRangeStatisticImpl.getIntegral() / (long)timeUnit, boundedRangeStatisticImpl.getCurrent(), d, d4, d3, boundedRangeStatisticImpl.getLowWaterMark(), boundedRangeStatisticImpl.getHighWaterMark(), boundedRangeStatisticImpl.getLowerBound(), boundedRangeStatisticImpl.getUpperBound());
                        cpdValue.setLastSampleTime(d2);
                        cpdDataImpl = new CpdDataImpl(pmiDataInfo, perfDescriptor2, cpdValue);
                        break;
                    }
                    default: {
                        cpdDataImpl = null;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block22;
                System.out.println("\n\n exception in statisticToCpdData, dataId=" + n + ", module=" + pmiModuleConfig.getUID() + ", type=" + n2);
                if (statistic instanceof CountStatisticImpl) {
                    System.out.println("should be CountStatistic");
                }
                if (statistic instanceof DoubleStatisticImpl) {
                    System.out.println("should be DoubleStatistic");
                }
                if (statistic instanceof TimeStatisticImpl) {
                    System.out.println("should be TimeStatistic");
                }
                if (statistic instanceof BoundedRangeStatisticImpl) {
                    System.out.println("should be BoundedRangeStatistic");
                }
                if (!(statistic instanceof BoundedRangeStatisticImpl)) break block22;
                System.out.println("should be RangeStatistic");
            }
        }
        return cpdDataImpl;
    }

    private void setServerConfig(String string, String string2, Stats stats) {
        if (stats == null) {
            return;
        }
        if (stats.getType() == 11) {
            return;
        }
        PmiModuleConfig pmiModuleConfig = null;
        Stats[] statsArray = stats.getSubStats();
        if (statsArray == null || statsArray.length == 0) {
            return;
        }
        Stats stats2 = null;
        for (int i = 0; i < statsArray.length; ++i) {
            stats2 = statsArray[i];
            if (stats2 == null) continue;
            pmiModuleConfig = (PmiModuleConfig)this.configs.get(stats2.getName());
            if (pmiModuleConfig == null && (pmiModuleConfig = this.getConfig(string, string2, stats2.getName())) != null) {
                this.configs.put(stats2.getName(), pmiModuleConfig);
                if (pmiModuleConfig.getMbeanType() != null) {
                    this.configs.put(pmiModuleConfig.getMbeanType(), pmiModuleConfig);
                }
            }
            if (pmiModuleConfig == null) continue;
            stats2.setConfig(pmiModuleConfig);
        }
    }

    public void setPerfConfigInfo(String string, String string2, ObjectName objectName, Stats stats) {
        this.setPerfConfigInfo(string, string2, objectName, null, stats);
    }

    public void setPerfConfigInfo(String string, String string2, ObjectName objectName, StatDescriptor statDescriptor, Stats stats) {
        if (stats == null) {
            return;
        }
        if (objectName.getKeyProperty("type").equals("Server")) {
            if (statDescriptor == null) {
                this.setServerConfig(string, string2, stats);
            } else {
                String string3 = statDescriptor.getPath()[0];
                PmiModuleConfig pmiModuleConfig = this.getConfig(string3);
                if (pmiModuleConfig != null) {
                    stats.setConfig(pmiModuleConfig);
                }
            }
        } else {
            PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)this.configs.get(objectName.getKeyProperty("type"));
            if (pmiModuleConfig == null && (pmiModuleConfig = this.getConfig(string, string2, objectName)) != null) {
                this.configs.put(objectName.getKeyProperty("type"), pmiModuleConfig);
            }
            if (pmiModuleConfig != null) {
                stats.setConfig(pmiModuleConfig);
            }
        }
    }

    public Stats getStats(String string, String string2, ObjectName objectName, boolean bl) throws PmiException {
        return this.getStats(string, string2, new MBeanStatDescriptor(objectName), bl);
    }

    public Stats getStats(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor, boolean bl) throws PmiException {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        Stats stats = null;
        try {
            if (this.collector == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Cannot find Collector in PmiClient");
                }
                return null;
            }
            if (!this.collector.getType().equals(VERSION_WAS50)) {
                return null;
            }
            stats = ((CollectorJMX)this.collector).getStats(string, string2, mBeanStatDescriptor, bl);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] getStats exception");
            }
            throw new PmiException("Exception to getStats\n" + exception.toString());
        }
        this.setPerfConfigInfo(string, string2, mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor(), stats);
        return stats;
    }

    public Stats[] getStats(String string, String string2, ObjectName[] objectNameArray, boolean bl) throws PmiException {
        if (objectNameArray == null || objectNameArray.length == 0) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[objectNameArray.length];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            mBeanStatDescriptorArray[i] = new MBeanStatDescriptor(objectNameArray[i]);
        }
        return this.getStats(string, string2, mBeanStatDescriptorArray, bl);
    }

    public Stats[] getStats(String string, String string2, MBeanStatDescriptor[] mBeanStatDescriptorArray, boolean bl) throws PmiException {
        if (mBeanStatDescriptorArray == null || mBeanStatDescriptorArray.length == 0) {
            return null;
        }
        Stats[] statsArray = null;
        try {
            if (this.collector == null) {
                if (this.debug) {
                    System.out.println("[PmiClient] Cannot find Collector");
                }
                return null;
            }
            if (!this.collector.getType().equals(VERSION_WAS50)) {
                return null;
            }
            statsArray = ((CollectorJMX)this.collector).getStats(string, string2, mBeanStatDescriptorArray, bl);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("[PmiClient] getStats exception");
            }
            throw new PmiException("Exception to getStats\n" + exception.toString());
        }
        if (statsArray == null) {
            if (this.debug) {
                System.out.println("[PmiClient] null ret from CollectorJMX.getStats(pds,recursive)");
            }
            return null;
        }
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            if (mBeanStatDescriptorArray[i] == null || statsArray[i] == null) continue;
            this.setPerfConfigInfo(string, string2, mBeanStatDescriptorArray[i].getObjectName(), mBeanStatDescriptorArray[i].getStatDescriptor(), statsArray[i]);
        }
        return statsArray;
    }

    public ObjectName[] listMBeans(String string, String string2) {
        return ((CollectorJMX)this.collector).listMBeans(string, string2);
    }

    public MBeanStatDescriptor[] listStatMembers(String string, String string2, ObjectName objectName) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
        } else {
            if (this.collector.getType().equals(VERSION_WAS50)) {
                return ((CollectorJMX)this.collector).listStatMembers(string, string2, objectName);
            }
            if (this.debug) {
                System.out.println("[PmiClient] The Collector does not support this method");
            }
        }
        return null;
    }

    public MBeanStatDescriptor[] listStatMembers(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
        } else {
            if (this.collector.getType().equals(VERSION_WAS50)) {
                return ((CollectorJMX)this.collector).listStatMembers(string, string2, mBeanStatDescriptor);
            }
            if (this.debug) {
                System.out.println("[PmiClient] Collector does not support this method");
            }
        }
        return null;
    }

    public PmiModuleConfig[] getConfigs(String string, String string2) {
        return this.getConfigs();
    }

    public PmiModuleConfig getConfig(String string, String string2, ObjectName objectName) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
            return null;
        }
        return ((CollectorJMX)this.collector).getConfig(string, string2, objectName);
    }

    public PmiModuleConfig getConfig(String string, String string2, String string3) {
        return this.getConfig(string3);
    }

    public void setStatLevel(String string, String string2, MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (this.collector == null) {
            if (this.debug && this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
        } else if (this.collector.getType().equals(VERSION_WAS50)) {
            ((CollectorJMX)this.collector).setInstrumentationLevel(string, string2, mBeanLevelSpec, bl);
        } else if (this.debug) {
            System.out.println("[PmiClient] Collector does not support this method");
        }
    }

    public void setStatLevel(String string, String string2, MBeanLevelSpec[] mBeanLevelSpecArray, boolean bl) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
        } else if (this.collector.getType().equals(VERSION_WAS50)) {
            ((CollectorJMX)this.collector).setInstrumentationLevel(string, string2, mBeanLevelSpecArray, bl);
        } else if (this.debug) {
            System.out.println("[PmiClient] Collector does not support this method");
        }
    }

    public MBeanLevelSpec[] getStatLevel(String string, String string2, ObjectName objectName, boolean bl) {
        return this.getStatLevel(string, string2, new MBeanStatDescriptor(objectName), bl);
    }

    public MBeanLevelSpec[] getStatLevel(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor, boolean bl) {
        if (this.collector == null) {
            if (this.debug) {
                System.out.println("[PmiClient] Cannot find Collector");
            }
        } else {
            if (this.collector.getType().equals(VERSION_WAS50)) {
                return ((CollectorJMX)this.collector).getInstrumentationLevel(string, string2, mBeanStatDescriptor, bl);
            }
            if (this.debug) {
                System.out.println("[PmiClient]  Collector does not support this method");
            }
        }
        return null;
    }

    public static MBeanLevelSpec createMBeanLevelSpec(ObjectName objectName, int n) {
        return PmiClient.createMBeanLevelSpec(objectName, null, n);
    }

    public static MBeanLevelSpec createMBeanLevelSpec(ObjectName objectName, StatDescriptor statDescriptor, int n) {
        if (objectName == null) {
            return null;
        }
        return new MBeanLevelSpec(objectName, statDescriptor, n);
    }

    public void end() {
        if (this.collector instanceof CollectorEPM) {
            ((CollectorEPM)this.collector).remove();
        }
    }

    public static String getNLSValue(String string) {
        try {
            String string2 = pmiNLS.getString(string, null);
            if (string2 == null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) {
                    return string;
                }
                Object v = prefixNLSMap.get(string3);
                if (v != null) {
                    NLS nLS = (NLS)v;
                    string2 = nLS.getString(string, string);
                } else {
                    NLS nLS = new NLS("com.ibm.websphere.pmi.property." + string3, true);
                    if (nLS != null) {
                        prefixNLSMap.put(string3, nLS);
                        string2 = nLS.getString(string, string);
                    }
                }
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getNLSValue(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return PmiClient.getNLSValue(string);
        }
        Object v = moduleNLSMap.get(string2);
        if (v != null) {
            NLS nLS = (NLS)v;
            return nLS.getString(string, string);
        }
        return PmiClient.getNLSValue(string);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.collector.setDebug(bl);
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, String string) {
        return PerfModules.findConfig(pmiModuleConfigArray, string);
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] pmiModuleConfigArray, ObjectName objectName) {
        return PerfModules.findConfig(pmiModuleConfigArray, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HashMap hashMap = staticConfigs;
        synchronized (hashMap) {
            if (staticConfigs.size() == 0) {
                PmiModuleConfig[] pmiModuleConfigArray = PerfModules.getConfigs();
                for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
                    staticConfigs.put(pmiModuleConfigArray[i].getUID(), pmiModuleConfigArray[i]);
                }
            }
        }
    }
}

