/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.extutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.extutils.MultipleObjectNamesExistException;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class AdminUtilClntImpl
implements AdminUtil {
    private AdminClient ac;
    private HashMap pmiDescToMbeanDesc;
    private HashMap mbeanDescToPmiDesc;
    private boolean debug;
    private static HashMap objectNameCache = new HashMap();
    private static HashMap objectNamesCache = new HashMap();
    private static final int BUFFER_LENGTH = 64;
    private static final TraceComponent tc = Tr.register(AdminUtilClntImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public AdminUtilClntImpl(Properties properties, boolean bl) throws Exception {
        block10: {
            this.ac = null;
            this.pmiDescToMbeanDesc = new HashMap();
            this.mbeanDescToPmiDesc = new HashMap();
            this.debug = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AdminUtilImpl: props=" + properties.toString());
            }
            boolean bl2 = false;
            if (bl) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AdminUtilClntImpl: call Utils.getDmgrAdminClient");
                    }
                    this.ac = Utils.getDmgrAdminClient();
                    if (tc.isDebugEnabled()) {
                        if (this.ac != null) {
                            Tr.debug(tc, "AdminUtilClntImpl: get adminclient from getDmgrAdminClient");
                        } else {
                            Tr.debug(tc, "AdminUtilClntImpl: returns null");
                        }
                    }
                }
                catch (Exception exception) {
                    this.ac = null;
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "AdminUtilImpl: exception to getDmgrAdminClient - may not be ND");
                }
            }
        }
        if (this.ac == null) {
            this.ac = AdminClientFactory.createAdminClient(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminUtilImpl(String host,String port,boolean inAppServer, String connectorType)");
        }
    }

    public ObjectName findObjectName(String string, String string2, String string3, String string4) throws MultipleObjectNamesExistException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectName(String name,String type, String node, String process)");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*");
        if (string != null) {
            stringBuffer.append(",name=").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(",type=").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(",node=").append(string3);
        }
        if (string4 != null) {
            stringBuffer.append(",process=").append(string4);
        }
        ObjectName objectName = this.queryName(stringBuffer.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findObjectName(String name,String type, String node, String process)");
        }
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName findObjectName(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectName(String mbeanIdentifier)");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*,mbeanIdentifier=").append(string);
        if (string2 != null) {
            stringBuffer.append(",node=").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(",process=").append(string3);
        }
        try {
            ObjectName objectName;
            ObjectName objectName2 = objectName = this.queryName(stringBuffer.toString());
            return objectName2;
        }
        catch (MultipleObjectNamesExistException multipleObjectNamesExistException) {
            ObjectName objectName = null;
            return objectName;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findObjectName(String mbeanIdentifier)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName queryName(String string) throws MultipleObjectNamesExistException {
        if (string == null) {
            return null;
        }
        ObjectName objectName = (ObjectName)objectNameCache.get(string);
        if (objectName == null) {
            Set set = null;
            set = this.findObjectNamesInClient(string);
            if (set == null || set.size() == 0) {
                if (this.debug) {
                    System.out.println("AdminUtilClntImpl: cannot find ObjectName for " + string);
                }
                Tr.warning(tc, "PMI0018W", string);
                return null;
            }
            if (set.size() > 1) {
                throw new MultipleObjectNamesExistException("AdminUtilImpl:findObjectName - Supplied parameters were insuffient to make the ObjectName unique: query string=" + string);
            }
            objectName = (ObjectName)set.iterator().next();
            if (objectName != null) {
                HashMap hashMap = objectNameCache;
                synchronized (hashMap) {
                    objectNameCache.put(string, objectName);
                }
            } else {
                if (this.debug) {
                    System.out.println("AdminUtilClntImpl: cannot find ObjectName for " + string);
                }
                Tr.warning(tc, "PMI0018W", string);
            }
        }
        return objectName;
    }

    private Set findObjectNamesInClient(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectNamesInClient(StringBuffer oName)");
        }
        Set set = null;
        try {
            if (this.ac != null) {
                set = this.ac.queryNames(new ObjectName(string), null);
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "findObjectNamesInClient(StringBuffer oName)");
                }
                return set;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (this.debug) {
                malformedObjectNameException.printStackTrace();
            }
            Tr.error(tc, "PMI0016W", malformedObjectNameException);
        }
        catch (ConnectorException connectorException) {
            if (this.debug) {
                connectorException.printStackTrace();
            }
            Tr.error(tc, "PMI0016W", connectorException);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            Tr.error(tc, "PMI0016W", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectNamesInClient(StringBuffer oName)");
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] findObjectNames(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findObjectNames(String name,String type,String node,String process)");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("WebSphere:*");
        if (string != null) {
            stringBuffer.append(",name=").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(",type=").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append(",node=").append(string3);
        }
        if (string4 != null) {
            stringBuffer.append(",process=").append(string4);
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])objectNamesCache.get(stringBuffer.toString());
        if (objectNameArray == null) {
            Set set = null;
            set = this.findObjectNamesInClient(stringBuffer.toString());
            if (set == null || set.size() == 0) {
                if (this.debug) {
                    System.out.println("AdminUtilClntImpl: cannot find ObjectName for " + stringBuffer.toString());
                }
                Tr.warning(tc, "PMI0018W", stringBuffer.toString());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findObjectNames(String name,String type,String node,String process)");
                }
                return null;
            }
            objectNameArray = new ObjectName[set.size()];
            int n = 0;
            Object object = set.iterator();
            while (object.hasNext()) {
                objectNameArray[n] = (ObjectName)object.next();
                ++n;
            }
            object = objectNamesCache;
            synchronized (object) {
                objectNamesCache.put(stringBuffer.toString(), objectNameArray);
            }
            for (n = 0; n < objectNameArray.length; ++n) {
                stringBuffer = new StringBuffer(64);
                stringBuffer.append("WebSphere:*name=");
                if (string == null) {
                    stringBuffer.append(objectNameArray[n].getKeyProperty("name"));
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append(",type=");
                if (string2 == null) {
                    stringBuffer.append(objectNameArray[n].getKeyProperty("type"));
                } else {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(",node=");
                if (string3 == null) {
                    stringBuffer.append(objectNameArray[n].getKeyProperty("node"));
                } else {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(",process=");
                if (string4 == null) {
                    stringBuffer.append(objectNameArray[n].getKeyProperty("process"));
                } else {
                    stringBuffer.append(string4);
                }
                if (objectNameCache.containsKey(stringBuffer.toString())) continue;
                object = objectNameCache;
                synchronized (object) {
                    objectNameCache.put(stringBuffer.toString(), objectNameArray[n]);
                    continue;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findObjectNames(String name,String type,String node,String process)");
        }
        return objectNameArray;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        if (this.ac == null) {
            return null;
        }
        try {
            return this.ac.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
                Tr.error(tc, "PMI0017W", exception);
            }
            try {
                this.ac.isAlive();
                return this.ac.invoke(objectName, string, objectArray, stringArray);
            }
            catch (Exception exception2) {
                if (this.debug) {
                    System.out.println("Failed to invoke or reconnect");
                    exception2.printStackTrace();
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName objectName, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute (ObjectName oName, String attributeName )");
        }
        Object object = null;
        try {
            object = this.ac.getAttribute(objectName, string);
        }
        catch (ConnectorException connectorException) {
            Tr.error(tc, "ConnectorException = " + connectorException, connectorException);
        }
        catch (MBeanException mBeanException) {
            Tr.error(tc, "MBeanException = " + mBeanException, mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Tr.error(tc, "AtributeNotFoundException for Attribute = " + string, attributeNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Tr.error(tc, "InstanceNotFoundException = " + instanceNotFoundException, instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Tr.error(tc, "ReflectionException = " + reflectionException, reflectionException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttribute (ObjectName oName, String attributeName )");
            }
        }
        return object;
    }

    public AdminClient getAdminClient() {
        return this.ac;
    }

    public AdminService getAdminService() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String string, String string2, DataDescriptor dataDescriptor, MBeanStatDescriptor mBeanStatDescriptor) {
        if (dataDescriptor == null || mBeanStatDescriptor == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMapping: dd.toString()=" + dataDescriptor.toString() + ", msd.toString=" + mBeanStatDescriptor.toString());
        }
        if (string == null) {
            string = mBeanStatDescriptor.getObjectName().getKeyProperty("node");
        }
        if (string2 == null) {
            string = mBeanStatDescriptor.getObjectName().getKeyProperty("process");
        }
        String string3 = PmiJmxMapper.StringArrayToString(dataDescriptor.getPath());
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string).append("/").append(string2).append("/").append(string3);
        Object object = this.pmiDescToMbeanDesc;
        synchronized (object) {
            this.pmiDescToMbeanDesc.put(stringBuffer.toString(), mBeanStatDescriptor);
        }
        object = mBeanStatDescriptor.getIdentifier();
        HashMap hashMap = this.mbeanDescToPmiDesc;
        synchronized (hashMap) {
            this.mbeanDescToPmiDesc.put(object, dataDescriptor);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMapping: dd=" + dataDescriptor.toString() + ", mBeanKey=" + (String)object);
        }
    }

    public DataDescriptor mBeanDescToPmiDesc_get(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        String string = mBeanStatDescriptor.getIdentifier();
        DataDescriptor dataDescriptor = (DataDescriptor)this.mbeanDescToPmiDesc.get(string);
        if (dataDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache HIT 1 msd=" + string);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MISS, msd=" + string);
        }
        return dataDescriptor;
    }

    public MBeanStatDescriptor pmiDescToMBeanDesc_get(String string, String string2, DataDescriptor dataDescriptor) {
        if (dataDescriptor == null) {
            return null;
        }
        String string3 = PmiJmxMapper.StringArrayToString(dataDescriptor.getPath());
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string).append("/").append(string2).append("/").append(string3);
        MBeanStatDescriptor mBeanStatDescriptor = (MBeanStatDescriptor)this.pmiDescToMbeanDesc.get(stringBuffer.toString());
        if (mBeanStatDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cache HIT 1 dd=" + stringBuffer.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MISS, dd=" + stringBuffer.toString());
        }
        return mBeanStatDescriptor;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

