/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsXfc;
import java.util.ArrayList;
import java.util.Properties;

public class PmiReqMetrics {
    public static final String IDENTITY = "identity";
    public static final int EJB_COMPONENT_ID = 0;
    public static final int SERVLET_COMPONENT_ID = 1;
    public static final int JDBC_COMPONENT_ID = 2;
    public static final int WEB_SERVICES_PROVIDER_ID = 3;
    public static final int WEB_SERVICES_REQUESTOR_ID = 4;
    public static final int ASYNC_BEANS_COMPONENT_ID = 5;
    public static final int NAMING_COMPONENT_ID = 6;
    public static final int SERVLETFILTER_COMPONENT_ID = 7;
    public static final int JMS_MDB_ID = 8;
    public static final int JMS_SEND_RECEIVE_ID = 9;
    public static final int WEB_SERVICES_COMPONENT_ID = 3;
    public static final int JMS_COMPONENT_ID = 8;
    public static final String[] COMP_NAMES = new String[]{"EJB", "URI", "JDBC", "Web Services", "Web Services", "AsyncBeans", "JNDI", "Servlet Filter", "JMS", "JMS"};
    private static final String[] ejb_ctxnames = new String[]{"EJBName", "ApplicationName", "ModuleName", "EJB name"};
    private static final String[] uri_ctxnames = new String[]{"URI", "Port", "QueryString"};
    private static final String[] webservices_provider_ctxnames = new String[]{"WsdlPort", "Operation", "Transport", "NameSpace", "InputMessage"};
    private static final String[] webservices_requestor_ctxnames = new String[]{"WsdlPort", "Operation", "Transport", "Parameters"};
    private static final String[] asyncbeans_ctxnames = new String[]{"Type", "ClassName"};
    private static final String[] naming_ctxnames = new String[]{"JNDIName"};
    private static final String[] servletfilter_ctxnames = new String[]{"FilterName"};
    private static final String[] jms_mdb_ctxnames = new String[]{"DestinationName", "MessageSelector", "Provider"};
    private static final String[] jms_send_receive_ctxnames = new String[]{"ClassName", "MethodName"};
    public static final int ASYNC_BEANS_NOTHING = -1;
    public static final int ASYNC_BEANS_WORK = 0;
    public static final int ASYNC_BEANS_ALARM = 1;
    public static final int ASYNC_BEANS_DEFERRED_EXECUTION = 2;
    public static final int ASYNC_BEANS_DAEMON = 3;
    public static final int INBOUND = 1;
    public static final int OUTBOUND = 2;
    public static final int INPROCESS = 3;
    public static final int BLOCKED = 4;
    public static final int BINDTHREAD = 5;
    public static final int INBOUND_ONTHREAD = 10;
    public static final int TRAN_DETAIL_LEVEL_NONE = 0;
    public static final int TRAN_DETAIL_LEVEL_PERF = 1;
    public static final int TRAN_DETAIL_LEVEL_BASIC = 2;
    public static final int TRAN_DETAIL_LEVEL_EXTENDED = 3;
    public static final int TRAN_DETAIL_LEVEL_UNKNOWN = -1;
    public static final int RM_ARM_GOOD = 0;
    public static final int RM_ARM_ABORT = 1;
    public static final int RM_ARM_FAILED = 2;
    public static final int RM_ARM_UNKNOWN = -1;
    public static final String URI_FILTER_TYPE = "URI";
    public static final String SOURCE_IP_FILTER_TYPE = "SOURCE_IP";
    public static final String EJB_FILTER_TYPE = "EJB";
    public static final String JMS_FILTER_TYPE = "JMS";
    public static final String WEB_SREVICES_FILTER_TYPE = "WEB_SERVICES";
    private static final TraceComponent tc = Tr.register(PmiReqMetrics.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static PmiReqMetricsXfc _instance = null;
    private static boolean _rmEnabled = false;
    private static boolean _rmReadyToEnable = false;
    private static ArrayList compRegistration = new ArrayList();

    public static Object updateBegin(int n, String string, String string2) {
        return PmiReqMetrics.reqStart(null, n, 2, new String[]{string2});
    }

    public static Object updateBegin(Object object, int n, String string, String string2) {
        return PmiReqMetrics.reqStart(object, n, 2, new String[]{string2});
    }

    public static void updateEnd(Object object, int n, int n2) {
        PmiReqMetrics.reqStop(object, n, 2, n2);
    }

    public static Object setInboundCorrelators(int n, String[] stringArray) {
        return PmiReqMetrics.setInboundCorrelators(null, n, stringArray, true);
    }

    public static Object setInboundCorrelators(Object object, int n, String[] stringArray, boolean bl) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setInboundCorrelators: context=" + object + ", regId=" + n + ", correlators=" + stringArray);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug(tc, "setInboundCorrelators " + i + ": " + stringArray[i]);
                }
            }
        }
        if (n < 0 || n >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setInboundCorrelators, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
            }
            return null;
        }
        return _instance.setInboundCorrelators(object, n, stringArray, bl);
    }

    public static Object reqStart(int n, String string, String string2) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
            return null;
        }
        if (_instance.isComponentEnabled(n)) {
            return _instance.reqStart(null, n, 1, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reqStart: this component " + n + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static Object reqStart(int n, int n2, String string, String[] stringArray) {
        return PmiReqMetrics.reqStart(null, n, n2, stringArray);
    }

    public static Object reqStart(Object object, int n, int n2, String string, String[] stringArray, String[] stringArray2) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (stringArray2 != null) {
            object = PmiReqMetrics.setInboundCorrelators(n, stringArray2);
        }
        return PmiReqMetrics.reqStart(object, n, n2, stringArray);
    }

    public static Object reqStart(int n, int n2, String[] stringArray) {
        return PmiReqMetrics.reqStart(null, n, n2, stringArray);
    }

    public static Object reqStart(Object object, int n, int n2, String[] stringArray) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (n < 0 || n >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since registration id " + n + " is unknown");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append(",");
                }
            }
            Tr.debug(tc, "reqStart, context=" + object + ", regId=" + n + ", reqScope=" + n2 + ", contextData=" + stringBuffer.toString());
        }
        try {
            if (n2 == 10) {
                n2 = 1;
            }
            return _instance.reqStart(object, n, n2, stringArray);
        }
        catch (Exception exception) {
            Tr.warning(tc, "PMRM0108E", new Object[]{"reqStop"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static Object setArrivalTime(int n) {
        return null;
    }

    public static Object setArrivalTime(Object object, int n) {
        return object;
    }

    public static void reqStop(Object object, int n, int n2) {
        PmiReqMetrics.reqStop(object, n, 1, n2, null);
    }

    public static void reqStop(Object object, int n, int n2, int n3) {
        PmiReqMetrics.reqStop(object, n, n2, n3, null);
    }

    public static void reqStop(Object object, int n, int n2, int n3, Properties properties) {
        block9: {
            if (!_rmEnabled || _instance == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (properties != null) {
                    Tr.debug(tc, "reqStop, context=" + object + ", regId=" + n + ", reqScope=" + n2 + ", status=" + n3 + ", detailInfo=" + properties.toString());
                } else {
                    Tr.debug(tc, "reqStop, context=" + object + ", regId=" + n + ", reqScope=" + n2 + ", status=" + n3 + ", detailInfo=null");
                }
            }
            if (n < 0 || n >= compRegistration.size()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "reqStop, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
                }
                return;
            }
            try {
                if (n2 == 10) {
                    n2 = 1;
                }
                _instance.reqStop(object, n, n2, n3, properties);
            }
            catch (Exception exception) {
                Tr.warning(tc, "PMRM0108E", new Object[]{"reqStop"});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                exception.printStackTrace();
            }
        }
    }

    public static Object bindThread(int n, String string, String string2) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: regId=" + n + ", type=" + string + ", detail=" + string2);
        }
        if (n < 0 || n >= compRegistration.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "bindThread, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
            }
            return null;
        }
        if (_instance.isComponentEnabled(n)) {
            return _instance.bindThread(n, string, string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: this component " + n + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static Object bindThread(Object object, int n, String string, String string2) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: regId=" + n + ", type=" + string + ", detail=" + string2);
        }
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "bindThread, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
            return null;
        }
        if (_instance.isComponentEnabled(n)) {
            return _instance.bindThread(object, n, string, string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bindThread: this component " + n + " is disabled for request metrics instrumentation");
        }
        return null;
    }

    public static void unbindThread(Object object, int n, int n2) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "unbindThread, request metrics cannot instrument this transaction since the component id" + n + " is unknown");
            return;
        }
        if (!_instance.isComponentEnabled(n)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unbindThread: this component " + n + " is disabled for request metrics instrumentation");
            }
            return;
        }
        _instance.unbindThread(object, n, n2);
    }

    public static byte[] getArmCorrelator() {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        byte[] byArray = null;
        if (_instance != null) {
            byArray = _instance.getArmCorrelator(null);
        }
        return byArray;
    }

    public static byte[] getArmCorrelator(Object object) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        byte[] byArray = null;
        if (_instance != null) {
            byArray = _instance.getArmCorrelator(object);
        }
        return byArray;
    }

    public static String getArmCorrelatorInString(Object object) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        String string = null;
        if (_instance != null) {
            string = _instance.getArmCorrelatorInString(object);
        }
        return string;
    }

    public static String[] getCorrelatorsInString(Object object) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        return _instance.getCorrelatorsInString(object);
    }

    public static boolean isReadyToEnable() {
        return _rmReadyToEnable;
    }

    public static boolean isEnabled() {
        return _rmEnabled;
    }

    public static boolean isARMEnabled() {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        return _instance.isARMEnabled();
    }

    public static int getTraceLevel() {
        boolean bl = false;
        if (!_rmEnabled || _instance == null) {
            return 0;
        }
        return _instance.getTraceLevel();
    }

    public static int getTranDetailLevel(int n) {
        if (!_rmEnabled || _instance == null) {
            return 0;
        }
        return PmiReqMetrics.getTranDetailLevel(null, n);
    }

    public static int getTranDetailLevel(Object object, int n) {
        if (!_rmEnabled) {
            return 0;
        }
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "reqStart, request metrics cannot instrument this transaction since registration id " + n + " is unknown");
            return 0;
        }
        if (_instance == null) {
            return 0;
        }
        return _instance.getTranDetailLevel(object, n);
    }

    public static boolean isComponentEnabled(int n) {
        if (!_rmEnabled) {
            return false;
        }
        if (_instance == null) {
            return false;
        }
        return _instance.isComponentEnabled(n);
    }

    public static boolean isComponentEnabled(int n, int n2) {
        if (!_rmEnabled) {
            return false;
        }
        if (_instance == null) {
            return false;
        }
        if (n2 == 10) {
            n2 = 1;
        }
        return _instance.isComponentEnabled(n, n2);
    }

    public static boolean isPassCorrelatorToDB() {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        return _instance.isPassCorrelatorToDB();
    }

    public static synchronized void setInstance(Object object) {
        if (object == null || !(object instanceof PmiReqMetricsXfc)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setInstance: null or wrong instance is passed");
            }
            return;
        }
        _instance = (PmiReqMetricsXfc)object;
        _rmReadyToEnable = true;
        for (int i = 0; i < compRegistration.size(); ++i) {
            ComponentInfo componentInfo = (ComponentInfo)compRegistration.get(i);
            _instance.register(componentInfo.componentName, componentInfo.identity, componentInfo.contextNames);
        }
    }

    public static synchronized void setEnable(boolean bl) {
        _rmEnabled = bl;
    }

    public static synchronized int register(String string, Properties properties, String[] stringArray) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuffer)object).append(stringArray[i]).append(",");
                }
            }
            Tr.debug(tc, "register: compName=" + string + ", identity=" + properties + ", contextNames=" + ((StringBuffer)object).toString());
        }
        if (_instance != null) {
            int n = _instance.register(string, properties, stringArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "register (done), new compName=" + string + ", regId=" + n);
            }
            if (n == compRegistration.size()) {
                compRegistration.add(new ComponentInfo(string, properties, stringArray));
            }
            return n;
        }
        object = new ComponentInfo(string, properties, stringArray);
        compRegistration.add(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "register (to be done): compName=" + string + ", regId=" + (compRegistration.size() - 1));
        }
        return compRegistration.size() - 1;
    }

    public static synchronized int registerComponent(String string, String[] stringArray) {
        return PmiReqMetrics.register(string, null, stringArray);
    }

    public static Object getRMContext(boolean bl) {
        if (!_rmEnabled || _instance == null) {
            return null;
        }
        Object object = _instance.getRMContext(bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRMContext useCurrent=" + bl + ", ctx=" + object);
        }
        return object;
    }

    public static void setRMContext(Object object) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRMContext contextObj=" + object);
        }
        _instance.setRMContext(object);
    }

    public static void setRMContextPoolSize(int n, int n2) {
        if (!_rmEnabled || _instance == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRMContextPoolSize minSize=" + n + ", maxSize=" + n2);
        }
        _instance.setRMContextPoolSize(n, n2);
    }

    public static boolean isFilterPassed(String string, String string2) {
        if (!_rmEnabled || _instance == null) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isFilterPassed, filterType=" + string + ", valueToCheck=" + string2);
        }
        return _instance.isFilterPassed(string, string2);
    }

    static {
        PmiReqMetrics.register(COMP_NAMES[0], null, ejb_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[1], null, uri_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[2], null, null);
        Properties properties = new Properties();
        properties.put(IDENTITY, "Provider");
        PmiReqMetrics.register(COMP_NAMES[3], properties, webservices_provider_ctxnames);
        Properties properties2 = new Properties();
        properties2.put(IDENTITY, "Requestor");
        PmiReqMetrics.register(COMP_NAMES[4], properties2, webservices_requestor_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[5], null, asyncbeans_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[6], null, naming_ctxnames);
        PmiReqMetrics.register(COMP_NAMES[7], null, servletfilter_ctxnames);
        Properties properties3 = new Properties();
        properties3.put(IDENTITY, "");
        PmiReqMetrics.register(COMP_NAMES[8], properties3, jms_mdb_ctxnames);
        Properties properties4 = new Properties();
        properties4.put(IDENTITY, "send/receive");
        PmiReqMetrics.register(COMP_NAMES[9], properties4, jms_send_receive_ctxnames);
    }

    static class ComponentInfo {
        String componentName;
        Properties identity;
        String[] contextNames;

        ComponentInfo(String string, Properties properties, String[] stringArray) {
            this.componentName = string;
            this.identity = properties;
            this.contextNames = stringArray;
        }
    }
}

