/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdDouble;
import com.ibm.websphere.pmi.server.SpdGroup;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdDoubleAggregate;
import com.ibm.ws.pmi.server.data.SpdDoubleImpl;
import com.ibm.ws.pmi.server.data.SpdLoadAggregate;
import com.ibm.ws.pmi.server.data.SpdLoadImpl;
import com.ibm.ws.pmi.server.data.SpdLongAggregate;
import com.ibm.ws.pmi.server.data.SpdLongImpl;
import com.ibm.ws.pmi.server.data.SpdStatAggregate;
import com.ibm.ws.pmi.server.data.SpdStatImpl;
import com.ibm.ws.pmi.server.data.SpdStatisticAggregate;
import com.ibm.ws.pmi.server.data.SpdStatisticExternal;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.ObjectName;

public abstract class PmiAbstractModule
implements PmiModule,
PmiConstants {
    protected String name = null;
    protected String instanceName = null;
    protected String submoduleName = null;
    protected String subinstanceName = null;
    protected String categoryName = null;
    protected ObjectName mbeanName = null;
    protected StatDescriptor msd_sd = null;
    protected StatDescriptor sd60 = null;
    public PmiModuleConfig moduleConfig = null;
    protected int type = 14;
    protected int currentLevel = -1;
    protected boolean aggregateModule = false;
    protected PmiCallback callback = null;
    protected int[] enabled = new int[0];
    protected int[] enabledSync = new int[0];
    protected StatisticActions statisticActionLsnr = null;
    protected boolean bStandaloneTree = false;
    protected HashMap nameDataTable = null;
    protected Map dataTable = new TreeMap();
    private ArrayList dataList = new ArrayList(3);
    protected boolean bAllCountersDisabled = true;
    private static final TraceComponent tc = Tr.register(PmiAbstractModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static int SET = 1;
    public static int INCREMENT = 2;
    public static int DECREMENT = 3;

    public PmiAbstractModule(String string, String string2) {
        this(null, string, string2, null);
    }

    public PmiAbstractModule(String string, String string2, PmiCallback pmiCallback) {
        this(null, string, string2, pmiCallback);
    }

    public boolean isStandaloneTree() {
        return this.bStandaloneTree;
    }

    public PmiAbstractModule(ObjectName objectName, String string, String string2, PmiCallback pmiCallback) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = string2;
            this.callback = pmiCallback;
            this.mbeanName = objectName;
            this.moduleConfig = PerfModules.getConfig(string);
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", string);
            }
        }
    }

    public PmiAbstractModule(PmiModuleConfig pmiModuleConfig, String string, StatisticActions statisticActions) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = string;
            this.moduleConfig = pmiModuleConfig;
            this.statisticActionLsnr = statisticActions;
        }
    }

    public PmiAbstractModule() {
    }

    public void init(Object[] objectArray) {
    }

    protected void registerModule(PmiModule pmiModule) {
        if (this.moduleConfig != null) {
            PmiRegistry.registerModule(pmiModule);
        }
    }

    protected void unregisterModule(PmiModule pmiModule) {
        this.dataTable = null;
        PmiRegistry.unregisterModule(pmiModule);
    }

    protected boolean longCreated(SpdLong spdLong) {
        return false;
    }

    protected boolean doubleCreated(SpdDouble spdDouble) {
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        return false;
    }

    protected void counterStateChanged(boolean bl) {
    }

    protected boolean externalStatisticCreated(StatisticImpl statisticImpl) {
        return false;
    }

    protected void callbackRuntime(int n) {
    }

    protected void initializeMe(int n) {
    }

    protected void initializeFG(int n) {
        RangeStatisticImpl rangeStatisticImpl;
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData != null && spdData instanceof SpdLoadImpl && (rangeStatisticImpl = (RangeStatisticImpl)spdData.getStatistic()) != null && rangeStatisticImpl.getCurrent() < 0L) {
            rangeStatisticImpl.setLastValue(0L);
        }
    }

    protected synchronized void putToTable(SpdData spdData) {
        if (spdData == null) {
            return;
        }
        this.dataTable.put(new Integer(spdData.getId()), spdData);
        spdData.setDataInfo(this.moduleConfig);
        if (spdData.isEnabled()) {
            this.addStatToEnabledArray(spdData.getId());
        }
    }

    private void addStatToEnabledArray(int n) {
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] != n) continue;
            return;
        }
        int[] nArray = new int[this.enabled.length + 1];
        for (int i = 0; i < this.enabled.length; ++i) {
            nArray[i] = this.enabled[i];
        }
        nArray[this.enabled.length] = n;
        this.enabled = nArray;
    }

    private void removeStatFromEnabledArray(int n) {
        int n2 = this.enabled.length;
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] != n) continue;
            --n2;
        }
        if (this.enabled.length == n2) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] == n) continue;
            nArray[n3++] = this.enabled[i];
        }
        this.enabled = nArray;
    }

    protected synchronized void removeFromTable(SpdData spdData) {
        if (spdData == null) {
            return;
        }
        this.dataTable.remove(new Integer(spdData.getId()));
        this.removeStatFromEnabledArray(spdData.getId());
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        String[] stringArray;
        if (pmiDataInfo == null || pmiDataInfo.getLevel() == 1000) {
            return null;
        }
        if (!pmiDataInfo.isAvailableInPlatform(PmiRegistry.PLATFORM)) {
            return null;
        }
        if (pmiDataInfo.getSubmoduleName() != null && this.type != 13 && this.type != 15 && this.type != 16) {
            return null;
        }
        if (this.type == 15 || this.type == 16) {
            if (pmiDataInfo.getSubmoduleName() == null) {
                return null;
            }
            if (!pmiDataInfo.getSubmoduleName().equals(this.submoduleName)) {
                return null;
            }
        }
        if ((stringArray = this.getPath())[0].equals("beanModule") && stringArray.length == 1 && pmiDataInfo.getId() >= 50) {
            return null;
        }
        if (!pmiDataInfo.getCategory().equals("all") && !this.isInCategory(this.categoryName, pmiDataInfo.getCategory())) {
            return null;
        }
        if (this.aggregateModule) {
            return this.createAggregateData(pmiDataInfo);
        }
        if (pmiDataInfo.getType() == 15) {
            return null;
        }
        if (!this.aggregateModule && this.type == 13 && pmiDataInfo.getSubmoduleName() != null) {
            return null;
        }
        int n = pmiDataInfo.getId();
        if (pmiDataInfo.isUpdateOnRequest()) {
            SpdStatisticExternal spdStatisticExternal = null;
            if (this.statisticActionLsnr != null) {
                spdStatisticExternal = new SpdStatisticExternal(pmiDataInfo, this.statisticActionLsnr);
                this.externalStatisticCreated(spdStatisticExternal.getStatisticRef());
            }
            return spdStatisticExternal;
        }
        switch (pmiDataInfo.getType()) {
            case 2: {
                SpdLongImpl spdLongImpl = new SpdLongImpl(n);
                this.longCreated(spdLongImpl);
                return spdLongImpl;
            }
            case 3: {
                SpdDoubleImpl spdDoubleImpl = new SpdDoubleImpl(n);
                this.doubleCreated(spdDoubleImpl);
                return spdDoubleImpl;
            }
            case 4: {
                SpdStatImpl spdStatImpl = new SpdStatImpl(n);
                this.statCreated(spdStatImpl);
                return spdStatImpl;
            }
            case 6: {
                SpdStatImpl spdStatImpl = new SpdStatImpl(6, n);
                this.statCreated(spdStatImpl);
                return spdStatImpl;
            }
            case 5: {
                SpdLoadImpl spdLoadImpl = new SpdLoadImpl(n);
                this.loadCreated(spdLoadImpl);
                return spdLoadImpl;
            }
            case 7: {
                SpdLoadImpl spdLoadImpl = new SpdLoadImpl(7, n);
                this.loadCreated(spdLoadImpl);
                return spdLoadImpl;
            }
        }
        return null;
    }

    private boolean isInCategory(String string, String string2) {
        if (string == null) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    protected SpdData createAggregateData(PmiDataInfo pmiDataInfo) {
        if (!pmiDataInfo.isAggregatable()) {
            return null;
        }
        int n = pmiDataInfo.getId();
        if (pmiDataInfo.isUpdateOnRequest()) {
            return new SpdStatisticAggregate(pmiDataInfo);
        }
        switch (pmiDataInfo.getType()) {
            case 2: {
                SpdLongAggregate spdLongAggregate = new SpdLongAggregate(n);
                return spdLongAggregate;
            }
            case 3: {
                SpdDoubleAggregate spdDoubleAggregate = new SpdDoubleAggregate(n);
                return spdDoubleAggregate;
            }
            case 4: {
                SpdStatAggregate spdStatAggregate = new SpdStatAggregate(n);
                return spdStatAggregate;
            }
            case 5: {
                SpdLoadAggregate spdLoadAggregate = new SpdLoadAggregate(n);
                return spdLoadAggregate;
            }
            case 7: {
                SpdLoadAggregate spdLoadAggregate = new SpdLoadAggregate(7, n);
                return spdLoadAggregate;
            }
            case 6: {
                SpdStatAggregate spdStatAggregate = new SpdStatAggregate(6, n);
                return spdStatAggregate;
            }
        }
        return null;
    }

    protected void createData(PmiModuleConfig pmiModuleConfig, int n) {
        if (pmiModuleConfig == null) {
            return;
        }
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig.listData(this.submoduleName);
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            if (pmiDataInfoArray[i].getLevel() > n && (pmiDataInfoArray[i].getType() != 5 && pmiDataInfoArray[i].getType() != 7 || pmiDataInfoArray[i].getLevel() != 7)) continue;
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(pmiDataInfoArray[i].getId()));
            if (spdData != null && pmiDataInfoArray[i].getLevel() <= n) {
                spdData.enable(n);
                continue;
            }
            if (spdData != null || (spdData = this.createOneData(pmiDataInfoArray[i])) == null) continue;
            this.putToTable(spdData);
            if (pmiDataInfoArray[i].getLevel() <= n) {
                spdData.enable(n);
                continue;
            }
            spdData.disable();
        }
    }

    protected synchronized void removeData(int n) {
        if (this.dataTable == null) {
            return;
        }
        Iterator iterator = this.dataTable.values().iterator();
        while (iterator.hasNext()) {
            SpdData spdData = (SpdData)iterator.next();
            PmiDataInfo pmiDataInfo = this.moduleConfig.getDataInfo(spdData.getId());
            if (pmiDataInfo != null) {
                if (pmiDataInfo.getLevel() <= n) continue;
                spdData.disable();
                continue;
            }
            spdData.disable();
        }
    }

    protected synchronized void createNameDataTable() {
        if (this.moduleConfig == null) {
            Tr.warning(tc, "PMI0007W", this.getModuleID());
            return;
        }
        if (this.nameDataTable != null) {
            return;
        }
        PmiDataInfo[] pmiDataInfoArray = this.moduleConfig.listAllData();
        this.nameDataTable = new HashMap(pmiDataInfoArray.length * 2);
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            this.nameDataTable.put(pmiDataInfoArray[i].getName(), new Integer(pmiDataInfoArray[i].getId()));
        }
    }

    public abstract int getDefaultLevel();

    public abstract String getModuleID();

    public ObjectName getMBeanName() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.mbeanName;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return new MBeanStatDescriptor(this.mbeanName, this.msd_sd);
    }

    public StatDescriptor getMSD_StatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.msd_sd;
    }

    public StatDescriptor get60_StatDescriptor() {
        if (this.sd60 == null) {
            this.sd60 = new StatDescriptor(this.getPath());
        }
        return this.sd60;
    }

    public void setMBeanName(ObjectName objectName) {
        this.mbeanName = objectName;
    }

    public void setMBeanName(ObjectName objectName, StatDescriptor statDescriptor) {
        this.mbeanName = objectName;
        this.msd_sd = statDescriptor;
    }

    private void _findMBean() {
        if (this.isCustomModule() || this.mbeanName != null) {
            return;
        }
        MBeanStatDescriptor mBeanStatDescriptor = PmiRegistry.jmxMapper.getMBeanStatDescriptor(null, new DataDescriptor(this.getPath()));
        if (mBeanStatDescriptor != null) {
            this.mbeanName = mBeanStatDescriptor.getObjectName();
            this.msd_sd = mBeanStatDescriptor.getStatDescriptor();
        } else {
            this.msd_sd = new StatDescriptor(this.getPath());
            Tr.warning(tc, "PMI0006W", this.getModuleID() + "," + this.getName());
        }
    }

    public MBeanStatDescriptor[] listStatMembers() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String[] stringArray = this.getPath();
        this.name = stringArray == null || stringArray.length == 0 ? null : stringArray[stringArray.length - 1];
        return this.name;
    }

    public String[] getPath() {
        String[] stringArray = null;
        if (this.type == 13) {
            stringArray = new String[]{this.getModuleID()};
        } else if (this.categoryName == null) {
            if (this.type == 14) {
                stringArray = new String[]{this.getModuleID(), this.instanceName};
            } else if (this.type == 15) {
                stringArray = new String[]{this.getModuleID(), this.instanceName, this.submoduleName};
            } else if (this.type == 16) {
                stringArray = new String[]{this.getModuleID(), this.instanceName, this.submoduleName, this.subinstanceName};
            }
        } else if (this.type == 19) {
            stringArray = new String[]{this.getModuleID(), this.categoryName};
        } else if (this.type == 14) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName};
        } else if (this.type == 15) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName};
        } else if (this.type == 16) {
            stringArray = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName, this.subinstanceName};
        }
        return stringArray;
    }

    public int getType() {
        return this.type;
    }

    public int getInstrumentationLevel() {
        if (this.currentLevel == 2) {
            return 0;
        }
        return this.currentLevel;
    }

    public int[] getEnabled() {
        return this.enabled;
    }

    public int[] getEnabledSync() {
        return this.enabledSync;
    }

    public synchronized void setInstrumentationLevel(int n) {
        try {
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", this.getModuleID());
                return;
            }
            if (n == -1) {
                return;
            }
            if (n == this.currentLevel) {
                return;
            }
            if (this.currentLevel == -2 || n < this.currentLevel) {
                this.createData(this.moduleConfig, n);
                this.removeData(n);
            } else if (n > this.currentLevel) {
                this.createData(this.moduleConfig, n);
                this.initializeMe(n);
            }
            this.currentLevel = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateDataList();
        this.updateEnabledByLevel();
    }

    public void setInstrumentationBySet(String string) {
        if (this.moduleConfig != null) {
            this.setFineGrainedInstrumentation(this.getStatisticIDBySet(string), new int[0]);
        }
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
        int n;
        Object object;
        Object object2;
        if (this.moduleConfig == null) {
            Tr.warning(tc, "PMI0007W", this.getModuleID());
            return false;
        }
        this.currentLevel = -2;
        if (nArray.length == 0) {
            this.enabled = nArray;
            this.enabledSync = nArray2;
            this.disableAll();
            this.updateDataList();
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (nArray.length == 1 && nArray[0] == -3) {
            this.enabled = nArray;
            this.enableAll(false);
            bl2 = true;
        } else {
            object2 = new ArrayList(2);
            bl = true;
            if (this.dataTable == null) {
                this.dataTable = new TreeMap();
            }
            for (int i = 0; i < nArray.length; ++i) {
                SpdData spdData = (SpdData)this.dataTable.get(new Integer(nArray[i]));
                if (spdData == null) {
                    PmiDataInfo pmiDataInfo = this.moduleConfig.getDataInfo(nArray[i]);
                    if (pmiDataInfo != null) {
                        spdData = this.createOneData(pmiDataInfo);
                    }
                    if (spdData == null) continue;
                    this.putToTable(spdData);
                    ((ArrayList)object2).add(new Integer(nArray[i]));
                    continue;
                }
                if (!spdData.isEnabled()) {
                    this.initializeFG(nArray[i]);
                }
                spdData.enable(1);
                ((ArrayList)object2).add(new Integer(nArray[i]));
            }
            object = new int[((ArrayList)object2).size()];
            for (n = 0; n < ((int[])object).length; ++n) {
                object[n] = (Integer)((ArrayList)object2).get(n);
            }
            this.enabled = object;
        }
        if (!bl2 && bl) {
            object2 = this.dataTable.values().iterator();
            while (object2.hasNext()) {
                int n2;
                object = (SpdData)object2.next();
                n = object.getId();
                boolean bl3 = false;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (n != nArray[n2]) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    if (n != nArray2[n2]) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                object.disable();
            }
        }
        this.enableDependencies();
        this.updateDataList();
        return true;
    }

    protected void setStatisticEnabled(int n, boolean bl, boolean bl2) {
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (bl) {
            if (spdData == null) {
                if (bl2 && (spdData = this.createOneData(this.moduleConfig.getDataInfo(n))) != null) {
                    this.putToTable(spdData);
                }
            } else if (!spdData.isEnabled()) {
                this.initializeFG(n);
                spdData.enable(1);
            }
        } else if (spdData != null) {
            spdData.disable();
        }
    }

    private void enableDependencies() {
        int[] nArray = this.moduleConfig.listStatisticsWithDependents();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList arrayList;
            if (!this.isEnabled(nArray[i]) || (arrayList = this.moduleConfig.getDataInfo(nArray[i]).getDependency()) == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                this.setStatisticEnabled((Integer)arrayList.get(j), true, true);
            }
        }
    }

    protected String[] getCustomSubModuleList() {
        return null;
    }

    private void enableAll(boolean bl) {
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        this._enableAllInModule(this.moduleConfig, bl);
        String[] stringArray = this.getCustomSubModuleList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                PmiModuleConfig pmiModuleConfig = PerfModules.getConfig(stringArray[i]);
                if (pmiModuleConfig == null) continue;
                this._enableAllInModule(pmiModuleConfig, bl);
            }
        }
    }

    private void _enableAllInModule(PmiModuleConfig pmiModuleConfig, boolean bl) {
        PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig.listData(this.submoduleName);
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(pmiDataInfoArray[i].getId()));
            if (spdData == null && (spdData = this.createOneData(pmiDataInfoArray[i])) != null) {
                this.putToTable(spdData);
            }
            if (spdData != null) {
                if (!spdData.isEnabled()) {
                    this.initializeFG(pmiDataInfoArray[i].getId());
                }
                if (bl) {
                    spdData.enable(15);
                    continue;
                }
                spdData.enable(1);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "enableAll: cannot create data: " + pmiModuleConfig.getUID() + "; " + pmiDataInfoArray[i].getId());
        }
    }

    private void disableAll() {
        if (this.dataTable != null) {
            Iterator iterator = this.dataTable.values().iterator();
            while (iterator.hasNext()) {
                ((SpdData)iterator.next()).disable();
            }
        }
    }

    public synchronized void enableData(int n) {
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        if (this.moduleConfig == null) {
            return;
        }
        if (n == -3) {
            this.setInstrumentationLevel(7);
            return;
        }
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData != null) {
            spdData.enable(this.currentLevel);
        } else {
            PmiDataInfo[] pmiDataInfoArray = this.moduleConfig.listAllData();
            PmiDataInfo pmiDataInfo = null;
            for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                if (pmiDataInfoArray[i].getId() != n) continue;
                pmiDataInfo = pmiDataInfoArray[i];
                break;
            }
            if (pmiDataInfo == null) {
                return;
            }
            if (this.currentLevel == 0) {
                this.currentLevel = 2;
            }
            if ((spdData = this.createOneData(pmiDataInfo)) != null) {
                this.putToTable(spdData);
            }
        }
    }

    public synchronized void disableData(int n) {
        if (this.dataTable == null) {
            return;
        }
        if (n == -3) {
            this.setInstrumentationLevel(0);
        } else {
            SpdData[] spdDataArray;
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
            if (spdData != null) {
                spdData.disable();
            }
            if (((spdDataArray = this.listData()) == null || spdDataArray.length == 0) && this.type != 13 && this.type != 15) {
                this.currentLevel = 0;
            }
        }
    }

    public SpdData[] listData() {
        SpdData[] spdDataArray;
        if (this.dataTable == null) {
            return null;
        }
        Iterator iterator = this.dataTable.values().iterator();
        ArrayList<SpdData[]> arrayList = new ArrayList<SpdData[]>();
        while (iterator.hasNext()) {
            spdDataArray = (SpdData[])iterator.next();
            if (!spdDataArray.isEnabled()) continue;
            arrayList.add(spdDataArray);
        }
        spdDataArray = new SpdData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            spdDataArray[i] = (SpdData)arrayList.get(i);
        }
        return spdDataArray;
    }

    public SpdData listData(int n) {
        if (this.dataTable == null) {
            return null;
        }
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData != null && spdData.isEnabled()) {
            return spdData;
        }
        return null;
    }

    public SpdData[] listData(int[] nArray) {
        if (this.dataTable == null) {
            return null;
        }
        if (nArray == null) {
            return this.listData();
        }
        ArrayList<SpdData> arrayList = new ArrayList<SpdData>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            SpdData spdData = (SpdData)this.dataTable.get(new Integer(nArray[i]));
            if (spdData == null || !spdData.isEnabled()) continue;
            arrayList.add(spdData);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SpdData[] spdDataArray = new SpdData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            spdDataArray[i] = (SpdData)arrayList.get(i);
        }
        return spdDataArray;
    }

    public void updateDataList() {
        this.dataList.clear();
        Iterator iterator = this.dataTable.values().iterator();
        while (iterator.hasNext()) {
            SpdData spdData = (SpdData)iterator.next();
            if (!spdData.isEnabled()) continue;
            StatisticImpl statisticImpl = spdData.getStatistic();
            if (statisticImpl == null) {
                Tr.warning(tc, "PMI9999E", "PmiAbstractModule.updateDataList: " + this.getModuleID() + ", " + this.getName());
                Tr.warning(tc, "PMI9999E", new Exception().fillInStackTrace());
                continue;
            }
            this.dataList.add(statisticImpl);
        }
        if (this.dataList.size() > 0) {
            if (this.bAllCountersDisabled) {
                this.bAllCountersDisabled = false;
                this.counterStateChanged(false);
            }
        } else if (!this.bAllCountersDisabled) {
            this.bAllCountersDisabled = true;
            this.counterStateChanged(true);
        }
    }

    public boolean isAllDisabled() {
        return this.bAllCountersDisabled;
    }

    protected void update() {
        Iterator iterator = this.dataTable.values().iterator();
        while (iterator.hasNext()) {
            SpdData spdData = (SpdData)iterator.next();
            if (!spdData.isEnabled()) continue;
            if (spdData.isExternal()) {
                spdData.updateExternal();
                continue;
            }
            if (!spdData.isAggregate()) continue;
            ((SpdGroup)spdData).updateAggregate();
        }
    }

    public void updateStatistics() {
        this.update();
    }

    public ArrayList listStatistics() {
        this.update();
        return this.dataList;
    }

    public StatsImpl getStats(ArrayList arrayList, ArrayList arrayList2) {
        StatsImpl statsImpl = new StatsImpl(this.getName(), this.type, this.currentLevel, arrayList, arrayList2);
        statsImpl.setStatsType(this.getWCCMStatsType());
        return statsImpl;
    }

    public void updateData(int n, int n2, double d) {
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        this.updateData(spdData, n2, d);
    }

    public void updateData(String string, int n, double d) {
        if (this.nameDataTable == null) {
            this.createNameDataTable();
            if (this.nameDataTable == null) {
                return;
            }
        }
        Integer n2 = (Integer)this.nameDataTable.get(string);
        SpdData spdData = (SpdData)this.dataTable.get(n2);
        this.updateData(spdData, n, d);
    }

    public void updateData(SpdData spdData, int n, double d) {
        if (spdData == null) {
            Tr.warning(tc, "PMI0005W", "PmiAbstractModule.updateData, moduleID=" + this.getModuleID());
            return;
        }
        if (spdData instanceof SpdLong) {
            if (n == SET) {
                ((SpdLong)spdData).set((long)d);
            } else if (n == INCREMENT) {
                ((SpdLong)spdData).increment((long)d);
            } else if (n == DECREMENT) {
                ((SpdLong)spdData).decrement((long)d);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else if (spdData instanceof SpdLoad) {
            if (n == SET) {
                ((SpdLoad)spdData).add(d);
            } else if (n == INCREMENT) {
                ((SpdLoad)spdData).increment(d);
            } else if (n == DECREMENT) {
                ((SpdLoad)spdData).decrement(d);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else if (spdData instanceof SpdStat) {
            if (n == SET) {
                ((SpdStat)spdData).add(d);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else {
            Tr.warning(tc, "PMI0009W", "dataType");
        }
    }

    public void cleanup() {
        if (this.mbeanName != null) {
            PmiRegistry.removeMBeanToModuleMap(new MBeanStatDescriptor(this.mbeanName, this.msd_sd));
        }
        if (this.isCustomModule()) {
            StatsFactoryUtil.deactivateMBean(this.mbeanName);
        }
        if (this.dataTable != null) {
            this.dataTable.clear();
            this.dataTable = null;
        }
        if (this.nameDataTable != null) {
            this.nameDataTable.clear();
            this.nameDataTable = null;
        }
        this.instanceName = null;
        this.subinstanceName = null;
        this.categoryName = null;
        this.mbeanName = null;
        this.msd_sd = null;
        this.moduleConfig = null;
        this.callback = null;
    }

    public void unregister() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unregister " + this.getModuleID() + ", " + this.getName());
        }
        PmiRegistry.unregisterModule(this);
        this.currentLevel = 0;
        this.cleanup();
    }

    public boolean isCustomModule() {
        return false;
    }

    public PmiModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public StatsImpl getJSR77Stats(ModuleItem moduleItem) {
        return moduleItem.getStats(false);
    }

    public String getWCCMStatsType() {
        StringBuffer stringBuffer = new StringBuffer(this.getModuleID());
        if (this.type == 13) {
            return stringBuffer.toString();
        }
        if (this.type == 15 || this.type == 16) {
            return stringBuffer.append("#").append(this.submoduleName).toString();
        }
        if (this.type == 14) {
            if (this.moduleConfig.hasSubModule()) {
                stringBuffer.append("#");
            }
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    public boolean isEnabled(int n) {
        SpdData spdData = (SpdData)this.dataTable.get(new Integer(n));
        if (spdData == null) {
            return false;
        }
        return spdData.isEnabled();
    }

    public boolean isJ2EEStatisticProvider() {
        return this.dataList != null && this.dataList.size() > 0;
    }

    public int[] getStatisticIDBySet(String string) {
        if (this.moduleConfig != null) {
            return this.moduleConfig.listStatisticsBySet(string);
        }
        return new int[0];
    }

    public void setSyncEnabled(boolean bl) {
        if (this.dataTable != null) {
            Iterator iterator = this.dataTable.values().iterator();
            while (iterator.hasNext()) {
                SpdData spdData = (SpdData)iterator.next();
                if (!spdData.isEnabled()) continue;
                if (bl) {
                    spdData.enable(15);
                    continue;
                }
                spdData.enable(1);
            }
        }
    }

    public void updateEnabledByLevel() {
        if (this.currentLevel == -2) {
            return;
        }
        if (this.dataTable != null) {
            Iterator iterator = this.dataTable.values().iterator();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (iterator.hasNext()) {
                SpdData spdData = (SpdData)iterator.next();
                if (!spdData.isEnabled()) continue;
                arrayList.add(new Integer(spdData.getId()));
            }
            this.enabled = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.enabled[i] = (Integer)arrayList.get(i);
            }
        }
    }
}

