/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.formatters;

import com.ibm.websphere.product.formatters.TextPrintFormatter;
import java.util.Iterator;
import java.util.Vector;

public class HTMLPrintFormatter
extends TextPrintFormatter {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "9/3/02";
    public static final int BASE_TEXT_SIZE = 3;
    public static final int INDENT_PERCENTAGE = 10;

    protected String fontPrefix(int n) {
        int n2 = 3 - n;
        if (n2 < 0) {
            n2 = 0;
        }
        return "<FONT SIZE=\"+" + n2 + "\">";
    }

    protected String fontPostfix(int n) {
        return "</FONT>";
    }

    protected void writeTablePrefix(int n) {
        this.out.println("<TABLE WIDTH=\"100%\">");
        this.out.println("<TR><TD WIDTH=\"" + (n *= 10) + "%\"></TD>");
        this.out.print("    <TD WIDTH=\"" + (100 - n) + "%\">");
    }

    protected void writeTablePostfix(int n) {
        this.out.println("</TD>");
        this.out.println("</TR>");
        this.out.println("</TABLE>");
    }

    public String embolden(String string) {
        return "<B>" + string + "</B>";
    }

    public void println(String string, int n) {
        this.writeTablePrefix(n);
        this.out.println(string);
        this.writeTablePostfix(n);
    }

    public void blankLine() {
        this.out.println("<BR>");
    }

    public void printHeader(String string) {
        this.out.println("<HTML>");
        this.out.println("<HEAD>");
        this.out.println("<TITLE>" + string + "</TITLE>");
        this.out.println("</HEAD>");
        this.out.println("");
        this.out.println("<BODY>");
        this.out.println("<H1>" + string + "</H1>");
        this.out.println("<HR>");
    }

    public void printFooter(String string) {
        this.out.println("");
        this.out.println("<HR>");
        this.out.println("<H1>" + string + "</H1>");
        this.out.println("</BODY>");
        this.out.println("</HTML>");
    }

    public void printList(Iterator iterator, int n) {
        this.writeTablePrefix(n);
        this.out.println("");
        this.out.println("        <UL>");
        while (iterator.hasNext()) {
            this.out.println("            <LI>" + iterator.next() + "</LI>");
        }
        this.out.println("        </UL>");
        this.out.print("    ");
        this.writeTablePostfix(n);
    }

    public void printTable(Vector vector, Vector vector2, int n) {
        this.writeTablePrefix(n);
        this.out.println("");
        this.out.println("        <TABLE WIDTH=\"100%\">");
        Iterator iterator = vector.iterator();
        Iterator iterator2 = vector2.iterator();
        int[] nArray = null;
        while (iterator2.hasNext()) {
            if (iterator.hasNext()) {
                nArray = (int[])iterator.next();
            }
            Object[] objectArray = (Object[])iterator2.next();
            this.out.println("            <TR>");
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n2 = nArray[i];
                this.out.println("                <TD WIDTH=\"" + n2 + "%\">" + object + "</TD>");
            }
            this.out.println("            </TR>");
        }
        this.out.println("        </TABLE>");
        this.out.print("    ");
        this.writeTablePostfix(n);
    }
}

