/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class EventHistoryInfo {
    private Document m_documentEventHistory = null;
    private SimpleXMLParser m_sxpEventHistory = null;
    private HashSet m_hashsetInstalledMaintenanceId = new HashSet();
    private static String S_NODE_PATH_UPDATE_EVENT_PTF = "event-history/update-event";
    private static String S_UPDATE_EVENT_PTF_ID = "id";
    private static String S_UPDATE_EVENT_PTF_UPDATE_ACTION = "update-action";
    private static String S_UPDATE_EVENT_PTF_RESULT = "result";
    private static String S_UPDATE_ACTION_INSTALL = "install";
    private static String S_UPDATE_ACTION_UNINSTALL = "uninstall";
    private static String S_RESULT_FAILURE = "failure";

    public EventHistoryInfo(File file, String string) {
        if (file != null && file.exists() && string != null) {
            try {
                String string2 = WASProduct.getDTDDirName(string);
                HistoryInfoEntityResolver historyInfoEntityResolver = new HistoryInfoEntityResolver(string2);
                this.m_sxpEventHistory = new SimpleXMLParser(file, true, (EntityResolver)historyInfoEntityResolver);
                this.m_documentEventHistory = this.m_sxpEventHistory.getDocument();
                if (this.m_documentEventHistory.getDocumentElement().hasChildNodes()) {
                    this.parseEventHistoryFromDocument();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public HashSet getInstalledMaintenanceSet() {
        return this.m_hashsetInstalledMaintenanceId;
    }

    private void parseEventHistoryFromDocument() {
        Vector vector = this.m_sxpEventHistory.getNodes(S_NODE_PATH_UPDATE_EVENT_PTF);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string = SimpleXMLParser.getNodeAttributeValue(node, S_UPDATE_EVENT_PTF_ID);
            if (string == null) continue;
            String string2 = SimpleXMLParser.getNodeAttributeValue(node, S_UPDATE_EVENT_PTF_UPDATE_ACTION);
            String string3 = SimpleXMLParser.getNodeAttributeValue(node, S_UPDATE_EVENT_PTF_RESULT);
            if (string2.equals(S_UPDATE_ACTION_INSTALL) && !string3.equals(S_RESULT_FAILURE)) {
                this.m_hashsetInstalledMaintenanceId.add(string);
                continue;
            }
            if (!string2.equals(S_UPDATE_ACTION_UNINSTALL) || string3.equals(S_RESULT_FAILURE)) continue;
            this.m_hashsetInstalledMaintenanceId.remove(string);
        }
    }
}

