/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.filters.PTFFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFDriverFilenameFilter;
import com.ibm.websphere.product.utils.EventHistoryInfo;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class HistoryInfoGenerator {
    public static final int N_XSL_ID_MAINTENANCE_HISTORY = 10;
    public static final int N_XSL_ID_MAINTENANCE_DRIVER = 20;
    public static final int N_XSL_ID_MAINTENANCE_APPLIED = 30;
    public static final int N_XSL_ID_MAINTENANCE_ID = 40;
    private static String S_BACKUP_DIR_PATH = null;
    private static String S_UPDATE_LOG_DIR_PATH = null;
    private static final String S_XSL_LIB = "xsl_lib";
    private static final String S_XSl_SELECTED = "XSL selected: ";
    private static final String S_SLASH = "/";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_EMPTY = "";
    private static final String S_FILENAME_MAINTENANCE_HISTORY = "MAINTENANCE_HISTORY.xsl";
    private static final String S_FILENAME_MAINTENANCE_DRIVER = "MAINTENANCE_DRIVER.xsl";
    private static final String S_FILENAME_MAINTENANCE_APPLIED = "MAINTENANCE_APPLIED.xsl";
    private static final String S_FILENAME_MAINTENANCE_ID = "MAINTENANCE_ID.xsl";
    private static final String S_DOT = ".";
    private static final String S_MAINTENANCE_DRIVER_FILE_EXT = "ptfDriver";
    private static final String S_MAINTENANCE_DRIVER_ELEMENT_NAME = "ptf-driver";
    private static final String S_MAINTENANCE_ID_NAME = "id";
    private static final String S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME = "applied.dtd";
    private static final String S_MAINTENANCE_ID_DTD_FILENAME = "update.dtd";
    private static final String S_MAINTENANCE_APPLIED_FILE_EXT = "ptfApplied";
    private static final String S_MAINTENANCE_APPLIED_ELEMENT_NAME = "ptf-applied";
    private static final String S_MAINTENANCE_APPLIED_ID_NAME = "ptf-id";
    private static final String S_MAINTENANCE_ID_FILE_EXT = "ptf";
    private static final String S_MAINTENANCE_ID_ELEMENT_NAME = "ptf";
    private static final String S_WAS_LIB_DIR_NAME = "lib";
    private static final String S_WAS_PRODUCT_FILENAME = "wasproduct.jar";
    private static final String S_WAS_PLUGIN_DIR_NAME = "plugins";
    private static final String S_RUNTIME_BUNDLE_FILENAME = "com.ibm.ws.runtime_6.1.0.jar";
    private static final String S_MAINTENANCE_HISTORY_XML_FILENAME = "maintenanceHistory.xml";
    private static final String S_TEMP_FILENAME = "temp";
    private static final String S_TEMP_DRIVER_XML_FILENAME = "temp.ptfDriver";
    private static final String S_TEMP_APPLIED_XML_FILENAME = "temp.ptfApplied";
    private static final String S_TEMP_ID_XML_FILENAME = "temp.ptf";
    private static final String S_WAS_INSTALL_ROOT = "was.install.root";
    private static final String S_NIF_HISTORY_XML_FILENAME = "NIFHistory.xml";
    private static final String S_UPDATE_DIR_NAME = "update";
    private static final String S_CLONE_NIFHISTORY_FILE_NAME = "NIFHistory.xml.clone.xml";
    private static final String S_WAS_INSTALLED_AS_MAINTENANCE_ATTRIBUTE_VALUE = "wasinstalledasmaintenance";
    private static final String S_NAME_ATTRIBUTE = "name";
    private static final String S_VALUE_ATTRIBUTE = "value";
    private static Document m_documentSingleton = null;

    public static void transformHistoryXmls(String string, String string2, String string3, String string4) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        int n;
        if ("true".equals(System.getProperty("wasproduct.skipXslTransformOnce"))) {
            System.setProperty("wasproduct.skipXslTransformOnce", "false");
            return;
        }
        if ("true".equals(System.getProperty("wasproduct.skipXslTransformAll"))) {
            return;
        }
        S_BACKUP_DIR_PATH = string;
        S_UPDATE_LOG_DIR_PATH = string2 + File.separator + S_UPDATE_DIR_NAME;
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>(4);
        Integer n2 = new Integer(0);
        String string5 = string3 + File.separator + "event.history";
        File file = new File(string5);
        if (file.exists()) {
            file.delete();
        }
        File[] fileArray = new File(string3).listFiles(new PTFDriverFilenameFilter());
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].delete();
        }
        fileArray = new File(string3).listFiles(new PTFAppliedFilenameFilter());
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].delete();
        }
        fileArray = new File(string4).listFiles(new PTFFilenameFilter());
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].delete();
        }
        fileArray = null;
        String string6 = null;
        String string7 = string + File.separator + S_NIF_HISTORY_XML_FILENAME;
        if (string.endsWith("nif" + File.separator + "backup")) {
            string6 = string7;
        } else if (string.endsWith(S_UPDATE_DIR_NAME + File.separator + "backup") && !new File(string6 = string + File.separator + S_MAINTENANCE_HISTORY_XML_FILENAME).exists()) {
            string6 = string7;
        }
        if (!new File(string6).exists()) {
            return;
        }
        File file2 = null;
        File file3 = null;
        if (string6.equals(string7)) {
            string6 = string3 + File.separator + S_CLONE_NIFHISTORY_FILE_NAME;
            try {
                file2 = new File(string7);
                file3 = new File(string6);
                m_documentSingleton = new SimpleXMLParser(file2).getDocument();
                if (m_documentSingleton.getDocumentElement().hasChildNodes()) {
                    HistoryInfoGenerator.removeFullInstallPakInfoFromDocument();
                    HistoryInfoGenerator.saveDocument(m_documentSingleton, file3);
                }
                m_documentSingleton = null;
            }
            catch (Exception exception) {
                System.err.println("The history xml file is not in xml format.");
                return;
            }
        }
        linkedHashMap.put(new Integer(10), string5);
        String string8 = string3 + File.separator + S_TEMP_DRIVER_XML_FILENAME;
        linkedHashMap.put(new Integer(20), string8);
        String string9 = string3 + File.separator + S_TEMP_APPLIED_XML_FILENAME;
        linkedHashMap.put(new Integer(30), string9);
        String string10 = string4 + File.separator + S_TEMP_ID_XML_FILENAME;
        linkedHashMap.put(new Integer(40), string10);
        String string11 = S_EMPTY;
        int n3 = 0;
        Iterator iterator = linkedHashMap.keySet().iterator();
        EventHistoryInfo eventHistoryInfo = null;
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n3 = n2;
            string11 = (String)linkedHashMap.get(n2);
            try {
                HistoryInfoGenerator.transformXML(string6, string11, n3);
            }
            catch (TransformerException transformerException) {
                String string12 = string6 + ", " + string11;
                throw new TransformerException(string12, transformerException);
            }
            catch (IOException iOException) {
                String string13 = string11;
                throw new IOException(string13);
            }
            if (n3 != 10) {
                HistoryInfoGenerator.breakFilesAccordingToElementName((String)linkedHashMap.get(n2), n3, eventHistoryInfo.getInstalledMaintenanceSet(), string4);
                new File(string11).delete();
                continue;
            }
            eventHistoryInfo = new EventHistoryInfo(new File(string11), string4);
        }
        if (file3 != null) {
            file3.delete();
        }
    }

    private static void transformXML(String string, String string2, int n) throws TransformerException, FileNotFoundException, IOException {
        URL[] uRLArray;
        Object object;
        Object object2;
        String string3 = S_EMPTY;
        switch (n) {
            case 10: {
                string3 = "xsl_lib/MAINTENANCE_HISTORY.xsl";
                break;
            }
            case 20: {
                string3 = "xsl_lib/MAINTENANCE_DRIVER.xsl";
                break;
            }
            case 30: {
                string3 = "xsl_lib/MAINTENANCE_APPLIED.xsl";
                break;
            }
            case 40: {
                string3 = "xsl_lib/MAINTENANCE_ID.xsl";
            }
        }
        ClassLoader classLoader = HistoryInfoGenerator.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string3);
        if (inputStream == null) {
            object2 = System.getProperty(S_WAS_INSTALL_ROOT) + File.separator + S_WAS_LIB_DIR_NAME + File.separator + S_WAS_PRODUCT_FILENAME;
            object = System.getProperty(S_WAS_INSTALL_ROOT) + File.separator + S_WAS_PLUGIN_DIR_NAME + File.separator + S_RUNTIME_BUNDLE_FILENAME;
            if (!new File((String)object2).exists() && !new File((String)(object2 = object)).exists()) {
                System.err.println("Runtime.jar doesn't exist under plugin dir.");
                return;
            }
            uRLArray = new URL[]{new File((String)object2).toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            inputStream = uRLClassLoader.getResourceAsStream(string3);
            if (inputStream == null) {
                System.err.println("Cannot load XSL files from " + (String)object2);
                return;
            }
        }
        object2 = TransformerFactory.newInstance();
        object = ((TransformerFactory)object2).newTransformer(new StreamSource(inputStream));
        ((Transformer)object).setOutputProperty("indent", S_YES);
        ((Transformer)object).setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
        ((Transformer)object).setParameter("fileseparator", File.separator);
        ((Transformer)object).setParameter("logdirpath", S_UPDATE_LOG_DIR_PATH);
        ((Transformer)object).setParameter("backupdirpath", S_BACKUP_DIR_PATH);
        uRLArray = new FileOutputStream(string2);
        ((Transformer)object).transform(new StreamSource(string), new StreamResult((OutputStream)uRLArray));
        uRLArray.close();
    }

    private static void breakFilesAccordingToElementName(String string, int n, HashSet hashSet, String string2) throws ParserConfigurationException, SAXException, IOException {
        File file;
        String string3 = S_EMPTY;
        String string4 = S_EMPTY;
        String string5 = S_EMPTY;
        switch (n) {
            case 20: {
                string3 = S_MAINTENANCE_DRIVER_FILE_EXT;
                string4 = S_MAINTENANCE_ID_NAME;
                string5 = S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME;
                break;
            }
            case 30: {
                string3 = S_MAINTENANCE_APPLIED_FILE_EXT;
                string4 = S_MAINTENANCE_APPLIED_ID_NAME;
                string5 = S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME;
                break;
            }
            case 40: {
                string3 = "ptf";
                string4 = S_MAINTENANCE_ID_NAME;
                string5 = S_MAINTENANCE_ID_DTD_FILENAME;
            }
        }
        if (n != 10 && (file = new File(string)) != null && file.exists()) {
            String string6;
            Node node;
            String string7 = WASProduct.getDTDDirName(string2);
            HistoryInfoEntityResolver historyInfoEntityResolver = new HistoryInfoEntityResolver(string7);
            SimpleXMLParser simpleXMLParser = null;
            try {
                simpleXMLParser = new SimpleXMLParser(file, true, (EntityResolver)historyInfoEntityResolver);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                String string8 = string;
                throw new ParserConfigurationException(string8);
            }
            catch (SAXException sAXException) {
                String string9 = string;
                throw new SAXException(string9);
            }
            catch (IOException iOException) {
                String string10 = string;
                throw new IOException(string10);
            }
            Element element = simpleXMLParser.getDocument().getDocumentElement();
            Vector vector = SimpleXMLParser.getChildElements(element);
            LinkedHashMap<String, Node> linkedHashMap = new LinkedHashMap<String, Node>();
            for (int i = 0; i < vector.size(); ++i) {
                node = (Node)vector.get(i);
                string6 = SimpleXMLParser.getNodeAttributeValue(node, string4);
                if (hashSet == null || hashSet.isEmpty() || !hashSet.contains(string6) || !node.hasChildNodes()) continue;
                linkedHashMap.put(string6, node);
            }
            Iterator iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                node = (Node)iterator.next().getValue();
                string6 = SimpleXMLParser.getNodeAttributeValue(node, string4);
                Document document = simpleXMLParser.getDocument();
                DOMImplementation dOMImplementation = document.getImplementation();
                DocumentType documentType = document.getDoctype();
                String string11 = node.getNodeName();
                String string12 = documentType.getPublicId();
                String string13 = documentType.getSystemId();
                DocumentType documentType2 = dOMImplementation.createDocumentType(string11, string12, string13);
                Document document2 = dOMImplementation.createDocument(documentType2.getNamespaceURI(), string11, documentType2);
                Element element2 = document2.getDocumentElement();
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    object2 = namedNodeMap.item(i).getNodeName();
                    object = namedNodeMap.item(i).getNodeValue();
                    element2.setAttribute((String)object2, (String)object);
                }
                DocumentFragment documentFragment = document.createDocumentFragment();
                object2 = SimpleXMLParser.getChildElements(node);
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    documentFragment.appendChild((Node)((Vector)object2).get(i));
                }
                object = (DocumentFragment)document2.importNode(documentFragment, true);
                element2.appendChild((Node)object);
                String string14 = new File(string).getParent() + File.separator + string6 + S_DOT + string3;
                File file2 = new File(string14);
                try {
                    HistoryInfoGenerator.saveDocument(document2, file2, string5, true, "UTF-8");
                }
                catch (IOException iOException) {
                    String string15 = string14;
                    throw new IOException(string15);
                }
            }
        }
    }

    private static void removeFullInstallPakInfoFromDocument() {
        Vector vector = new Vector();
        Vector<Node> vector2 = new Vector<Node>();
        Element element = m_documentSingleton.getDocumentElement();
        vector.addAll(SimpleXMLParser.getChildElements(element));
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Vector vector3 = new Vector();
            Node node = (Node)iterator.next();
            vector3.addAll(SimpleXMLParser.getChildElements(node));
            Iterator iterator2 = vector3.iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                Node node2 = (Node)iterator2.next();
                String string = SimpleXMLParser.getNodeAttributeValue(node2, S_NAME_ATTRIBUTE);
                if (!string.equals(S_WAS_INSTALLED_AS_MAINTENANCE_ATTRIBUTE_VALUE)) continue;
                String string2 = SimpleXMLParser.getNodeAttributeValue(node2, S_VALUE_ATTRIBUTE);
                if (!string2.equalsIgnoreCase("true")) break;
                bl = false;
                break;
            }
            if (bl) {
                vector2.add(node);
                continue;
            }
            bl = false;
        }
        SimpleXMLParser.deleteChildNodes(element, vector2);
    }

    private static void saveDocument(Document document, File file) throws IOException {
        HistoryInfoGenerator.saveDocument(document, file, null, false, null);
    }

    private static void saveDocument(Document document, File file, String string, boolean bl, String string2) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            if (string != null) {
                transformer.setOutputProperty("doctype-system", string);
            }
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", S_YES);
            }
            if (string2 != null) {
                transformer.setOutputProperty("encoding", string2);
            }
            transformer.transform(dOMSource, streamResult);
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }
}

