/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import com.ibm.websphere.product.xml.BaseHandlerException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseHandler
extends DefaultHandler {
    public static final String pgmVersion = "1.2";
    public static final String pgmUpdate = "9/4/02";
    protected ArrayList rootElements;
    protected ArrayList elementNameTrain;
    protected ArrayList elementTrain;
    protected ArrayList captureFlagTrain;
    protected ArrayList captureTrain;
    protected String currentElementName;
    protected Object currentElement;
    protected boolean currentCaptureFlag;
    protected StringBuffer currentCaptureBuffer;
    protected Locator locator;

    public Object getObject() {
        return this.rootElements;
    }

    public void startDocument() throws SAXException {
        this.initializeElements();
    }

    public void endDocument() throws SAXException {
        if (this.elementNameTrain.size() != 0) {
            throw new SAXException(BaseHandler.getString("WVER0203E", new Object[0]));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        Object object;
        try {
            object = this.createElement(string2, this.currentElementName, this.currentElement, attributes2);
        }
        catch (Throwable throwable) {
            System.out.println("Throwable: " + throwable);
            throwable.printStackTrace(System.out);
            object = null;
        }
        this.pushElement(string2, object);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.popElement(string2);
    }

    protected void startCapturing() {
        this.currentCaptureFlag = true;
    }

    protected String stopCapturing() {
        String string;
        if (!this.currentCaptureFlag) {
            string = "";
        } else {
            this.currentCaptureFlag = false;
            if (this.currentCaptureBuffer == null) {
                string = "";
            } else {
                string = this.currentCaptureBuffer.toString();
                this.currentCaptureBuffer.setLength(0);
            }
        }
        return string;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.currentCaptureFlag) {
            return;
        }
        if (this.currentCaptureBuffer == null) {
            this.currentCaptureBuffer = new StringBuffer();
            this.captureTrain.set(this.captureTrain.size() - 1, this.currentCaptureBuffer);
        }
        this.currentCaptureBuffer.append(cArray, n, n2);
    }

    protected abstract Object createElement(String var1, String var2, Object var3, Attributes var4) throws SAXParseException;

    protected String getAttribute(Attributes attributes2, String string, String string2, String string3) throws SAXParseException {
        String string4 = attributes2.getValue(string);
        if (string4 == null) {
            if (string3 == null) {
                throw this.newException("WVER0201E", new Object[]{string, string2});
            }
            return string3;
        }
        return string4;
    }

    protected String getCurrentElementName() {
        return this.currentElementName;
    }

    protected Object getCurrentElement() {
        return this.currentElement;
    }

    protected void initializeElements() {
        this.rootElements = new ArrayList();
        this.elementNameTrain = new ArrayList();
        this.elementTrain = new ArrayList();
        this.captureFlagTrain = new ArrayList();
        this.captureTrain = new ArrayList();
        this.currentElementName = null;
        this.currentElement = null;
        this.currentCaptureFlag = false;
        this.currentCaptureBuffer = null;
    }

    protected void pushElement(String string, Object object) {
        if (this.elementTrain.size() == 0) {
            this.rootElements.add(object);
        }
        this.elementNameTrain.add(string);
        this.elementTrain.add(object);
        this.captureFlagTrain.add(new Boolean(false));
        this.captureTrain.add(this.currentCaptureBuffer);
        this.currentElementName = string;
        this.currentElement = object;
        this.currentCaptureFlag = false;
        this.currentCaptureBuffer = null;
    }

    protected Object popElement(String string) throws SAXParseException {
        int n = this.elementTrain.size();
        if (n == 0) {
            throw this.newException("WVER0202E", new Object[0]);
        }
        int n2 = n - 1;
        Object e2 = this.elementTrain.get(n2);
        String string2 = (String)this.elementNameTrain.get(n2);
        if (!string2.equals(string)) {
            throw this.newException("WVER0206E", new Object[]{string, string2});
        }
        this.elementNameTrain.remove(n2);
        this.elementTrain.remove(n2);
        if (n2 == 0) {
            this.currentElementName = null;
            this.currentElement = null;
            this.currentCaptureFlag = false;
            this.currentCaptureBuffer = null;
        } else {
            this.currentElementName = (String)this.elementNameTrain.get(--n2);
            this.currentElement = this.elementTrain.get(n2);
            this.currentCaptureFlag = (Boolean)this.captureFlagTrain.get(n2);
            this.currentCaptureBuffer = (StringBuffer)this.captureTrain.get(n2);
        }
        return e2;
    }

    protected SAXParseException newInvalidElementException(String string, String string2) {
        if (string == null) {
            return this.newException("WVER0204E", new Object[]{string2});
        }
        return this.newException("WVER0205E", new Object[]{string2, string});
    }

    protected SAXParseException newException(String string, Object[] objectArray) {
        return new SAXParseException(BaseHandler.getString(string, objectArray), this.getDocumentLocator());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    protected static String getString(String string) {
        return BaseHandlerException.getString(string);
    }

    protected static String getString(String string, Object[] objectArray) {
        return BaseHandlerException.getString(string, objectArray);
    }
}

