/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.rastools.collector.ExecCmd;
import com.ibm.websphere.rastools.collector.Helper1;
import com.ibm.websphere.rastools.collector.Logger;
import com.ibm.websphere.rastools.collector.PODef;
import com.ibm.websphere.rastools.collector.POProcessor;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.websphere.rsadapter.DerbyDataStoreHelper;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.websphere.rsadapter.InformixDataStoreHelper;
import com.ibm.websphere.rsadapter.MSSQLDataStoreHelper;
import com.ibm.websphere.rsadapter.OracleDataStoreHelper;
import com.ibm.websphere.rsadapter.SybaseDataStoreHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class Collector {
    static int verbosity;
    static boolean debug;
    static boolean prompt;
    static boolean showDBLocks;
    static boolean showOnlyDBLocks;
    static String installDirectory;
    static String configDirectory;
    static String wasNode;
    static String cellName;
    static String serverName;
    static String logRoot;
    static String mQRoot;
    static String wasPropsDir;
    static String appInstallRoot;
    static String serviceLogName;
    static String traceLogName;
    static String userInstallRoot;
    static Repository repository;
    static String logFileName;
    static boolean summary;
    static boolean noSamples;
    static boolean includeInstalledApps;
    static Helper1 HC1;
    static Logger Log;
    static POProcessor po;
    static int exitRC;
    static final boolean abend = true;
    static final boolean noAbend = false;
    static final boolean leftJustify = true;
    static final boolean noLeftJustify = false;
    static final int padV1 = 18;
    static final int k_InError = 0;
    static final int k_getFile = 1;
    static final int k_getFiles = 2;
    static final int k_getFiles_R = 3;
    static final int k_getFile_P = 4;
    static final int k_getDir = 5;
    static final int k_getDir_R = 6;
    static final int k_execCmd = 7;
    static final int k_addObMarker = 8;
    static final int k_excludeFile = 9;
    static final String defaultInventoryName = "com/ibm/websphere/rastools/collector/default.inventory";
    static final String defaultInstallDir = "badInstallDir";
    static final String defaultJavaHome = "badJavaHome";
    static final String defaultJarName = "WASenv.jar";
    static Hashtable macros;
    static int action;
    static String vData;
    static String sExecFile;
    static boolean recursive;
    static int objectsGathered;
    static JarOutputStream jos;
    static File jarFile;
    static String currentDirectoryPath;
    static String absoluteDirectoryPath;
    static String hostNameDir;
    static String hostName;
    static String serverType;
    static String jarName;
    static String bundle;
    static String fileSep;
    static Vector obfuscationMarkers;
    static final int OBFUSCATION_NUMBER_OF_MARKERS = 6;
    static final int OBFUSCATION_FILE_EXTENSION = 0;
    static final int OBFUSCATION_MARKER = 1;
    static final int OBFUSCATION_STRING_MARKER_START = 4;
    static final int OBFUSCATION_STRING_MARKER_END = 5;
    static final int OBFUSCATION_SUPER_MARKER_START = 2;
    static final int OBFUSCATION_SUPER_MARKER_END = 3;
    static final String OBFUSCATION_MARKERS_DELIMITER = ",";
    static final String OBFUSCATION_DEFAULT_MARKERS = "\"";
    static final int OBFUSCATION_OUTPUT_BUFFER_SIZE = 1024;
    static Vector filesToSecure;
    static Vector fileLines;
    static Vector fileLineNumbers;
    static HashMap outputLines;
    static int lastOutputLine;
    static int outputLinesLength;
    static Vector excludedFileNames;
    static JarFile jf;
    static InputStream is;
    static JarInputStream jis;
    static boolean correctPlatform;
    static int[] lineCount;
    static final String k_Version = "Version";
    static final String k_Debug = "Debug";
    static final String k_Help = "?";
    static final String k_LogFileName = "Logfile";
    static final String k_Verbosity = "Verbosity";
    static final String k_PropertyFile = "PropertyFile";
    static final String k_ScratchFile = "ScratchFile";
    static final String k_Compression = "Compression";
    static final String k_Inventory = "Inventory";
    static final String k_Comment = "comment";
    static final String k_JarOutName = "JarOutName";
    static final String k_CaseSensitive = "CaseSensitive";
    static final String k_AutoCollect = "AutoCollect";
    static final String k_ManifestFile = "ManifestFile";
    static final String k_mfMainClass = "mfMainClass";
    static final String k_mfVersion = "mfVersion";
    static final String k_AidInventory = "AidInventory";
    static final String k_Test = "Test";
    static final String k_Prompt = "Prompt";
    static final String k_InstallDir = "InstallRoot";
    static final String k_ShowDBLocks = "ShowDBLocks";
    static final String k_ShowOnlyDBLocks = "ShowOnlyDBLocks";
    static final String k_JavaHome = "JavaHome";
    static final String k_ConfigRoot = "ConfigRoot";
    static final String k_WasNode = "WasNode";
    static final String k_CellName = "CellName";
    static final String k_ServerName = "ServerName";
    static final String k_Summary = "Summary";
    static final String k_NoSamples = "NoSamples";
    static final String k_IncludeInstalledApps = "IncludeInstalledApps";
    static final String k_ProfileRoot = "ProfileRoot";

    public static void main(String[] stringArray) {
        Log = new Logger(null, false, verbosity);
        Log.Open();
        HC1 = new Helper1(Log, verbosity);
        if (!Collector.curDirOK()) {
            return;
        }
        if (!Collector.ProcessOptions(stringArray)) {
            Log.Close();
            return;
        }
        if (!Collector.jarDirOK()) {
            return;
        }
        Collector.processVariablesMap();
        long l = System.currentTimeMillis();
        Collector.collect();
        if (!summary) {
            Collector.processServerXml();
            Object[] objectArray = new Object[1];
            objectArray[0] = HC1.FmtNum(Logger.errorCount, 0, 12, 0);
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_NUM_POSSIBLE_ERRORS", objectArray, "WSST_MSG_COL_NUM_POSSIBLE_ERRORS"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_LOGFILE", new Object[]{po.getFile(k_LogFileName).getAbsolutePath()}, "WSST_MSG_COL_LOGFILE"));
            if (jarFile.isAbsolute()) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OUTPUT_JAR", new Object[]{jarName}, "WSST_MSG_COL_OUTPUT_JAR"));
            } else {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OUTPUT_JAR", new Object[]{absoluteDirectoryPath + jarName}, "WSST_MSG_COL_OUTPUT_JAR"));
            }
            Collector.includeLogFile();
            Collector.closeJarStream();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_RETURN_CODE", new Object[]{Integer.toString(exitRC), HC1.CalcET(l)}, "WSST_MSG_COL_RETURN_CODE"));
            Log.Close();
        }
        if (exitRC > 0) {
            System.exit(exitRC);
        }
    }

    static boolean curDirOK() {
        String string = "TempCollectorTest";
        File file = new File(string);
        try {
            File file2;
            if (file.createNewFile()) {
                file2 = new File(".");
                currentDirectoryPath = file2.getCanonicalPath();
                absoluteDirectoryPath = file2.getAbsolutePath();
                absoluteDirectoryPath = absoluteDirectoryPath.substring(0, absoluteDirectoryPath.length() - 1);
                File file3 = new File("WAS");
                File file4 = new File("OS");
                if (file3.exists()) {
                    throw new IOException("Current directory contains WAS subDirectory, run collector from different directory or manually remove WAS subDirectory");
                }
                if (file4.exists()) {
                    throw new IOException("Current directory contains OS subDirectory, run collector from different directory or manually remove OS subDirectory");
                }
            } else {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CURRENT_DIR_NOT_WRITABLE", new Object[]{string}, "WSST_ERR_COL_CURRENT_DIR_NOT_WRITABLE"));
                return false;
            }
            file2.delete();
            file.delete();
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_IN_CURRENT_DIR", "WSST_ERR_COL_IOEXCEPTION_IN_CURRENT_DIR"), iOException, false);
            if (debug) {
                Log.Log(iOException);
            }
            return false;
        }
        return true;
    }

    static boolean jarDirOK() {
        if (currentDirectoryPath.regionMatches(true, 0, installDirectory, 0, installDirectory.length())) {
            Log.Both(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME", "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME2", new Object[]{installDirectory}, "WSST_ERR_COL_CURRENT_DIR_IS_WAS_HOME2"));
            return false;
        }
        return true;
    }

    static void processVariablesMap() {
        block21: {
            boolean bl = false;
            try {
                VariableMap variableMap;
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
                                String string = null;
                                repository = RepositoryFactory.createRepository(configDirectory, cellName, wasNode, string);
                                variableMap = VariableMapFactory.createVariableMap(repository);
                                beanContextServicesSupport.addService(Repository.class, (BeanContextServiceProvider)((Object)repository));
                                beanContextServicesSupport.add(variableMap);
                                try {
                                    variableMap.initialize(configDirectory);
                                    bl = true;
                                }
                                catch (Exception exception) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Configuration error on node level VariableMap.xml, map.initialize() failed "));
                                    String string2 = exception.getMessage();
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error - exception msg: " + string2));
                                    if (debug) {
                                        Log.Log(exception);
                                    }
                                    Collector.setDefaultVariables();
                                }
                                if (!bl) break block21;
                                try {
                                    userInstallRoot = variableMap.expand("${USER_INSTALL_ROOT}");
                                    if (userInstallRoot == null | userInstallRoot.trim().equals("")) {
                                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank USER_INSTALL_ROOT: " + userInstallRoot));
                                        userInstallRoot = installDirectory;
                                    }
                                }
                                catch (Exception exception) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad USER_INSTALL_ROOT: " + userInstallRoot + ", exception: " + exception.getMessage()));
                                    userInstallRoot = installDirectory;
                                    if (!debug) break block22;
                                    Log.Log(exception);
                                }
                            }
                            try {
                                logRoot = variableMap.expand("${LOG_ROOT}");
                                if (logRoot == null | logRoot.trim().equals("")) {
                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank LOG_ROOT: " + logRoot));
                                    logRoot = userInstallRoot + "/logs";
                                }
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad LOG_ROOT: " + logRoot + ", exception: " + exception.getMessage()));
                                logRoot = userInstallRoot + "/logs";
                                if (!debug) break block23;
                                Log.Log(exception);
                            }
                        }
                        try {
                            mQRoot = variableMap.expand("${MQ_INSTALL_ROOT}");
                            if (mQRoot == null | mQRoot.trim().equals("")) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank MQ_INSTALL_ROOT: " + mQRoot));
                                mQRoot = userInstallRoot + "/logs";
                            }
                        }
                        catch (Exception exception) {
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad MQ_INSTALL_ROOT: " + mQRoot + ", exception: " + exception.getMessage()));
                            mQRoot = installDirectory + "/../../WebSphere MQ";
                            if (!debug) break block24;
                            Log.Log(exception);
                        }
                    }
                    try {
                        appInstallRoot = variableMap.expand("${APP_INSTALL_ROOT}");
                        if (appInstallRoot == null | appInstallRoot.trim().equals("")) {
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank APP_INSTALL_ROOT: " + appInstallRoot));
                            appInstallRoot = userInstallRoot + "/installedApps";
                        }
                    }
                    catch (Exception exception) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad APP_INSTALL_ROOT: " + appInstallRoot + ", exception: " + exception.getMessage()));
                        appInstallRoot = userInstallRoot + "/installedApps";
                        if (!debug) break block25;
                        Log.Log(exception);
                    }
                }
                try {
                    wasPropsDir = variableMap.expand("${WAS_PROPS_DIR}");
                    if (wasPropsDir == null | wasPropsDir.trim().equals("")) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Null or blank WAS_PROPS_DIR: " + wasPropsDir));
                        wasPropsDir = userInstallRoot + "/properties";
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad WAS_PROPS_DIR: " + wasPropsDir + ", exception: " + exception.getMessage()));
                    wasPropsDir = userInstallRoot + "/properties";
                    if (debug) {
                        Log.Log(exception);
                    }
                }
            }
            catch (Exception exception) {
                Log.Log("Error: Problem setting up BeanContext or Repository, exception: " + exception.getMessage());
                Collector.setDefaultVariables();
                if (!debug) break block21;
                Log.Log(exception);
            }
        }
    }

    static void setDefaultVariables() {
        userInstallRoot = installDirectory;
        logRoot = userInstallRoot + "/logs";
        appInstallRoot = userInstallRoot + "/installedApps";
        mQRoot = installDirectory + "/../../WebSphere MQ";
        wasPropsDir = userInstallRoot + "/properties";
    }

    static void processServerXml() {
        block44: {
            try {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                Resource resource = repository.getConfigRoot().getResource(3, "serverindex.xml");
                Repository repository2 = null;
                String string = null;
                try {
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    EList eList = serverIndex.getServerEntries();
                    for (int i = 0; i < eList.size(); ++i) {
                        VariableMap variableMap;
                        Server server2;
                        Resource resource2;
                        block39: {
                            ServerEntry serverEntry = (ServerEntry)eList.get(i);
                            string = serverEntry.getServerName();
                            bl2 = serverName == null ? true : string.equalsIgnoreCase(serverName);
                            if (!bl2) continue;
                            bl3 = true;
                            repository2 = RepositoryFactory.createRepository(configDirectory, cellName, wasNode, string);
                            resource2 = null;
                            server2 = null;
                            Object var12_14 = null;
                            BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
                            variableMap = VariableMapFactory.createVariableMap(repository2);
                            beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? Collector.class$("com.ibm.ws.runtime.service.Repository") : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)((Object)repository2));
                            beanContextServicesSupport.add(variableMap);
                            bl = false;
                            try {
                                variableMap.initialize(configDirectory);
                                bl = true;
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad serverMap Init, exception: " + exception.getMessage()));
                                if (!debug) break block39;
                                Log.Log(exception);
                            }
                        }
                        if (!bl) continue;
                        try {
                            resource2 = repository2.getConfigRoot().getResource(4, "server.xml");
                            try {
                                String string2;
                                String string3;
                                OutputRedirect outputRedirect;
                                Object object;
                                Iterator iterator;
                                StreamRedirect streamRedirect;
                                block42: {
                                    block41: {
                                        block40: {
                                            server2 = (Server)resource2.getContents().get(0);
                                            try {
                                                streamRedirect = server2.getOutputStreamRedirect();
                                                iterator = streamRedirect.getFileName();
                                                if (iterator != null && !((String)((Object)iterator)).trim().equals("")) {
                                                    vData = variableMap.expand((String)((Object)iterator));
                                                    Collector.getFile(null, true);
                                                }
                                            }
                                            catch (Exception exception) {
                                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad System.out, exception: " + exception.getMessage()));
                                                if (!debug) break block40;
                                                Log.Log(exception);
                                            }
                                        }
                                        try {
                                            streamRedirect = server2.getErrorStreamRedirect();
                                            iterator = streamRedirect.getFileName();
                                            if (iterator != null && !((String)((Object)iterator)).trim().equals("")) {
                                                vData = variableMap.expand((String)((Object)iterator));
                                                Collector.getFile(null, true);
                                            }
                                        }
                                        catch (Exception exception) {
                                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Bad System.err, exception: " + exception.getMessage()));
                                            if (!debug) break block41;
                                            Log.Log(exception);
                                        }
                                    }
                                    try {
                                        streamRedirect = server2.getProcessDefinitions();
                                        if (streamRedirect != null) {
                                            iterator = streamRedirect.iterator();
                                            if (iterator.hasNext()) {
                                                object = (ProcessDef)iterator.next();
                                                outputRedirect = object.getIoRedirect();
                                                string3 = outputRedirect.getStdoutFilename();
                                                string2 = outputRedirect.getStderrFilename();
                                                try {
                                                    if (string3 != null && !string3.trim().equals("")) {
                                                        vData = variableMap.expand(string3);
                                                        Collector.getFile(null, true);
                                                    }
                                                    if (string2 != null && !string2.trim().equals("")) {
                                                        vData = variableMap.expand(string2);
                                                        Collector.getFile(null, true);
                                                    }
                                                    break block42;
                                                }
                                                catch (Exception exception) {
                                                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand Stdout or Stderr, exception: " + exception.getMessage()));
                                                    if (debug) {
                                                        Log.Log(exception);
                                                    }
                                                    break block42;
                                                }
                                            }
                                            Log.Log("Got empty list from getProcessDefinitions()");
                                            break block42;
                                        }
                                        Log.Log("Got null from getProcessDefinitions()");
                                    }
                                    catch (Exception exception) {
                                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get ProcessDef for wccmServer, exception: " + exception.getMessage()));
                                        if (!debug) break block42;
                                        Log.Log(exception);
                                    }
                                }
                                streamRedirect = server2.getServices();
                                for (int j = 0; j < streamRedirect.size(); ++j) {
                                    block43: {
                                        object = (Service)streamRedirect.get(j);
                                        if (object instanceof RASLoggingService) {
                                            outputRedirect = (RASLoggingService)object;
                                            string3 = outputRedirect.getServiceLog();
                                            try {
                                                serviceLogName = variableMap.expand(string3.getName());
                                                if (serviceLogName != null && !serviceLogName.trim().equals("")) {
                                                    vData = serviceLogName;
                                                    Collector.getFile(null, true);
                                                }
                                            }
                                            catch (Exception exception) {
                                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand serviceLogName, exception: " + exception.getMessage()));
                                                if (!debug) break block43;
                                                Log.Log(exception);
                                            }
                                        }
                                    }
                                    if (!(object instanceof TraceService)) continue;
                                    outputRedirect = (TraceService)object;
                                    string3 = outputRedirect.getTraceLog();
                                    try {
                                        traceLogName = variableMap.expand(string3.getFileName());
                                        if (traceLogName == null || traceLogName.trim().equals("")) continue;
                                        vData = traceLogName;
                                        Collector.getFile(null, true);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't expand traceLogName, exception: " + exception.getMessage()));
                                        if (!debug) continue;
                                        Log.Log(exception);
                                    }
                                }
                                iterator = server2.getComponents();
                                object = null;
                                for (int j = 0; j < iterator.size(); ++j) {
                                    try {
                                        string3 = (ServerComponent)iterator.get(j);
                                        if (!(string3 instanceof ApplicationServer)) continue;
                                        string2 = (ApplicationServer)string3;
                                        EList eList2 = string2.getServices();
                                        for (int k = 0; k < eList2.size(); ++k) {
                                            TransactionService transactionService;
                                            Service service = (Service)eList2.get(k);
                                            if (!(service instanceof TransactionService) || (object = (transactionService = (TransactionService)service).getTransactionLogDirectory()) == null || ((String)object).trim().equals("")) continue;
                                            vData = object;
                                            Collector.getDir();
                                        }
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Transaction Log Directory from Transaction Service, exception: " + exception.getMessage()));
                                        if (!debug) continue;
                                        Log.Log(exception);
                                    }
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't Load WCCM Server, exception: " + exception.getMessage()));
                                if (!debug) continue;
                                Log.Log(exception);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Server Resource, exception: " + exception.getMessage()));
                            if (!debug) continue;
                            Log.Log(exception);
                        }
                    }
                    if (!bl3) {
                        Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Server not found: " + serverName));
                    }
                }
                catch (Exception exception) {
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Server Index, exception: " + exception.getMessage()));
                    if (debug) {
                        Log.Log(exception);
                    }
                }
            }
            catch (Exception exception) {
                Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_UNKNOWN_MSG", new Object[0], "Error: Can't get Node resource, exception: " + exception.getMessage()));
                if (!debug) break block44;
                Log.Log(exception);
            }
        }
    }

    static void collect() {
        if (!summary) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COMPRESSION", new Object[]{po.getString(k_Compression)}, "WSST_MSG_COL_COMPRESSION"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USERID", new Object[]{po.getString(System.getProperty("user.name"))}, "WSST_MSG_COL_USERID"));
        }
        block13: while (Collector.moreRequests()) {
            recursive = false;
            if (summary) {
                Collector.getSummary();
                break;
            }
            switch (action) {
                case 1: {
                    Collector.getFile(null, false);
                    continue block13;
                }
                case 3: {
                    recursive = true;
                }
                case 2: {
                    Collector.getFiles();
                    continue block13;
                }
                case 4: {
                    Collector.getFileP();
                    continue block13;
                }
                case 6: {
                    recursive = true;
                }
                case 5: {
                    Collector.getDir();
                    continue block13;
                }
                case 7: {
                    Collector.execCmd();
                    continue block13;
                }
                case 8: {
                    Collector.addObfuscationMarker();
                    continue block13;
                }
                case 9: {
                    Collector.resolveExcludedFiles();
                    continue block13;
                }
            }
            String string = Integer.toString(action);
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_UNHANDLED_INV_REQUEST", new Object[]{string, vData}, "WSST_ERR_COL_UNHANDLED_INV_REQUEST"), true);
        }
        if (!summary && includeInstalledApps) {
            action = 6;
            vData = appInstallRoot;
            recursive = true;
            Collector.getDir();
        }
        if (is != null) {
            block20: {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{iOException.getMessage()}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"));
                    if (!debug) break block20;
                    Log.Log(iOException);
                }
            }
            is = null;
        }
        if (!summary) {
            Collector.includeProps();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OBJS_GATHERED", new Object[]{HC1.FmtNum(objectsGathered, 0, 12, 0)}, "WSST_MSG_COL_OBJS_GATHERED"));
            if (null != po.getString(k_Comment)) {
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_COMMENT", new Object[]{po.getString(k_Comment)}, "WSST_MSG_COL_COMMENT"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void getFile(String string, boolean bl) {
        if (string == null) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_FILE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_FILE"));
        } else {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_FILE", new Object[]{string}, "WSST_MSG_COL_INCLUDING_FILE"));
        }
        File file = new File(vData);
        if (!file.exists()) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_FILE_DOES_NOT_EXIST", new Object[]{vData}, "WSST_ERR_COL_FILE_DOES_NOT_EXIST"));
            return;
        }
        boolean bl2 = file.isDirectory();
        if (!file.canRead() || bl2) {
            if (bl2) {
                System.out.println("File can not be read since the path \"" + vData + "\" is a Directory");
            }
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANNOT_READ_FILE", new Object[]{vData}, "WSST_ERR_COL_CANNOT_READ_FILE"));
            return;
        }
        try {
            if (excludedFileNames != null && excludedFileNames.size() > 0 && excludedFileNames.contains(file.getCanonicalPath())) {
                Log.Both("File excluded.");
                return;
            }
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR"), iOException, false);
        }
        int n = Collector.scanAndObfuscateFile();
        if (n == 1) {
            ++objectsGathered;
            return;
        }
        if (n == 0) {
            block25: {
                int n2;
                FileInputStream fileInputStream = Collector.OpenInputStream(file);
                if (fileInputStream == null) {
                    return;
                }
                if (string == null ? !Collector.createJarEntry(vData, bl, file.lastModified()) : !Collector.createJarEntry(string, bl, file.lastModified())) {
                    return;
                }
                byte[] byArray = new byte[4096];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    jos.write(byArray, 0, n2);
                }
                try {
                    fileInputStream.close();
                    jos.closeEntry();
                }
                catch (IOException iOException) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException, false);
                    if (debug) {
                        Log.Log(iOException);
                    }
                    break block25;
                }
                catch (IOException iOException) {
                    block26: {
                        try {
                            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR"), iOException, false);
                            if (!debug) break block26;
                            Log.Log(iOException);
                        }
                        catch (Throwable throwable) {
                            block27: {
                                try {
                                    fileInputStream.close();
                                    jos.closeEntry();
                                }
                                catch (IOException iOException2) {
                                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException2, false);
                                    if (!debug) break block27;
                                    Log.Log(iOException2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        fileInputStream.close();
                        jos.closeEntry();
                    }
                    catch (IOException iOException3) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR", new Object[]{file.toString()}, "WSST_ERR_COL_ERROR_CLOSING_FILE_OR_JAR"), iOException3, false);
                        if (debug) {
                            Log.Log(iOException3);
                        }
                    }
                }
            }
            ++objectsGathered;
            return;
        }
    }

    static void getFiles() {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (recursive) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_DIR_RECURSE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_DIR_RECURSE"));
        } else {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INCLUDING_DIR_NON_RECURSE", new Object[]{vData}, "WSST_MSG_COL_INCLUDING_DIR_NON_RECURSE"));
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n = HC1.FindFiles(vData, recursive, hashtable2, hashtable, po.getBool(k_CaseSensitive), stringBuffer, debug);
        int n2 = Math.max(vData.lastIndexOf("/"), vData.lastIndexOf("\\"));
        if (n2 != -1) {
            string2 = "";
            string = vData.substring(0, n2).concat(fileSep);
        } else {
            string2 = "." + fileSep;
            string = "";
        }
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_NUM_OBJECTS_IN_DIR", new Object[]{HC1.FmtNum(n, 0, 0, 0), string2 + string}, "WSST_MSG_COL_NUM_OBJECTS_IN_DIR"));
        Enumeration enumeration = hashtable2.elements();
        int n3 = stringBuffer.length() + 1;
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            vData = file.getAbsolutePath();
            String string3 = string.concat(vData.substring(n3));
            if (!includeInstalledApps && vData.substring(n3).endsWith(".ear") || noSamples && vData.substring(n3).endsWith("AccountManagement.ear") || vData.substring(n3).endsWith("activitysession.ear") || vData.substring(n3).endsWith("adminconsole.ear") || vData.substring(n3).endsWith("BRBeansSample.ear") || vData.substring(n3).endsWith("CompanyContext.ear") || vData.substring(n3).endsWith("DynamicQuery.ear") || vData.substring(n3).endsWith("EMSSamples.ear") || vData.substring(n3).endsWith("ivtApp.ear") || vData.substring(n3).endsWith("JTAExtensionsSamples.ear") || vData.substring(n3).endsWith("MDBSamples.ear") || vData.substring(n3).endsWith("petstore.ear") || vData.substring(n3).endsWith("PlantsByWebSphere.ear") || vData.substring(n3).endsWith("query.ear") || vData.substring(n3).endsWith("SamplesGallery.ear") || vData.substring(n3).endsWith("TechnologySamples.ear") || vData.substring(n3).endsWith("TravelBooking.ear") || excludedFileNames != null && excludedFileNames.size() > 0 && excludedFileNames.contains(vData) || vData.substring(n3).endsWith("Collector.log")) continue;
            Collector.getFile(string3, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void getFileP() {
        block54: {
            block50: {
                var0 = "";
                var1_1 = 0;
                var2_2 = new StringTokenizer(Collector.vData, " \t\n\r\f", true);
                var0 = var0.concat(var2_2.nextToken());
                Collector.vData = var2_2.nextToken("\t\n\r\f").trim();
                if ('\"' != (var0 = var0.trim()).charAt(0)) ** GOTO lbl12
                if ('\"' == var0.charAt(var0.length() - 1)) {
                    var0 = var0.substring(1, var0.length() - 1);
                } else {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_LABEL_MISSING_QUOTES", new Object[]{var0}, "WSST_ERR_COL_PW_LABEL_MISSING_QUOTES"));
                    return;
lbl12:
                    // 1 sources

                    if ('\'' == var0.charAt(0)) {
                        if ('\'' == var0.charAt(var0.length() - 1)) {
                            var0 = var0.substring(1, var0.length() - 1);
                        } else {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_LABEL_MISSING_SINGLE_QUOTE", new Object[]{var0}, "WSST_ERR_COL_PW_LABEL_MISSING_SINGLE_QUOTE"));
                            return;
                        }
                    }
                }
                var1_1 = var0.length();
                var3_3 = Collector.vData + ".P";
                var4_4 = new File(Collector.vData);
                var5_5 = var4_4.getName();
                var6_6 = Collector.absoluteDirectoryPath + var5_5 + ".P";
                Collector.Log.Both(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_MSG_COL_INCLUDING_PW_FILE", new Object[]{var6_6}, "WSST_MSG_COL_INCLUDING_PW_FILE"));
                if (!var4_4.exists()) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_FILE_DOES_NOT_EXIST", new Object[]{Collector.vData}, "WSST_ERR_COL_PW_FILE_DOES_NOT_EXIST"));
                    return;
                }
                if (!var4_4.canRead()) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_PW_CANNOT_READ_FILE", new Object[]{Collector.vData}, "WSST_ERR_COL_PW_CANNOT_READ_FILE"));
                    return;
                }
                var7_7 = new File(var6_6);
                var8_8 = new byte[4096];
                try {
                    if (var7_7.createNewFile()) {
                        block49: {
                            var10_9 = new BufferedReader(new FileReader(var4_4));
                            var11_11 = new BufferedWriter(new FileWriter(var7_7));
                            var16_15 = 0;
                            while (null != (var12_16 = var10_9.readLine())) {
                                var13_18 = var12_16.toLowerCase();
                                var17_21 = 0;
                                var18_22 = true;
                                while (var18_22) {
                                    var20_24 = var1_1 + var13_18.indexOf(var0.toLowerCase(), var17_21);
                                    if (var1_1 <= var20_24) {
                                        var21_25 = new StringBuffer(var12_16);
                                        var14_19 = var20_24;
                                        var16_15 = var21_25.substring(var20_24).length();
                                        var19_23 = 0;
                                        if (var16_15 > 0) {
                                            if (var12_16.charAt(var14_19) == '\"') {
                                                var15_20 = var12_16.indexOf(34, var14_19 + 1);
                                                if (var15_20 > 0) {
                                                    var16_15 = var15_20 - var14_19 + 1 - 2;
                                                    var19_23 = 1;
                                                }
                                            } else {
                                                var15_20 = var12_16.indexOf(32, var14_19);
                                                if (var15_20 > 0) {
                                                    var16_15 = var15_20 - var14_19;
                                                }
                                                var19_23 = 0;
                                            }
                                            if (var16_15 > 0) {
                                                var22_26 = new char[var16_15];
                                                Arrays.fill(var22_26, '*');
                                                var21_25.replace(var14_19 + var19_23, var14_19 + var16_15 + var19_23, new String(var22_26));
                                                var12_16 = var21_25.toString();
                                            }
                                        }
                                        var17_21 = var20_24 + var16_15 + 1 * var19_23;
                                        continue;
                                    }
                                    var18_22 = false;
                                }
                                var11_11.write(var12_16, 0, var12_16.length());
                                var11_11.newLine();
                            }
                            var24_27 = null;
                            try {
                                var10_9.close();
                            }
                            catch (IOException var25_29) {
                                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_29, false);
                                if (!Collector.debug) break block49;
                                Collector.Log.Log(var25_29);
                            }
                        }
                        try {
                            var11_11.close();
                        }
                        catch (IOException var25_29) {
                            Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_29, false);
                            if (Collector.debug) {
                                Collector.Log.Log(var25_29);
                            }
                            break block50;
                        }
                        {
                            catch (IOException var12_17) {
                                block51: {
                                    var7_7.delete();
                                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_READING_PW_FILE_OR_WRITING_TEMP", "WSST_ERR_COL_ERROR_READING_PW_FILE_OR_WRITING_TEMP"), var12_17, false);
                                    if (Collector.debug) {
                                        Collector.Log.Log(var12_17);
                                    }
                                    var24_27 = null;
                                    try {
                                        var10_9.close();
                                    }
                                    catch (IOException var25_29) {
                                        Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_29, false);
                                        if (!Collector.debug) break block51;
                                        Collector.Log.Log(var25_29);
                                    }
                                }
                                try {
                                    var11_11.close();
                                }
                                catch (IOException var25_29) {
                                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_29, false);
                                    if (Collector.debug) {
                                        Collector.Log.Log(var25_29);
                                    }
                                    break block50;
                                }
                            }
                        }
                        catch (Throwable var23_31) {
                            block53: {
                                block52: {
                                    var24_28 = null;
                                    try {
                                        var10_9.close();
                                    }
                                    catch (IOException var25_30) {
                                        Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE", new Object[]{var4_4.toString()}, "WSST_ERR_COL_ERROR_CLOSING_PW_FILE"), var25_30, false);
                                        if (!Collector.debug) break block52;
                                        Collector.Log.Log(var25_30);
                                    }
                                }
                                try {
                                    var11_11.close();
                                }
                                catch (IOException var25_30) {
                                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_ERROR_CLOSING_TEMP_FILE"), var25_30, false);
                                    if (!Collector.debug) break block53;
                                    Collector.Log.Log(var25_30);
                                }
                            }
                            throw var23_31;
                        }
                    }
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CREATING_TEMP_FILE", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CREATING_TEMP_FILE"));
                    return;
                }
                catch (IOException var10_10) {
                    Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_OPENING_TEMP_FILE", "WSST_ERR_COL_ERROR_OPENING_TEMP_FILE"), var10_10, false);
                    if (!Collector.debug) break block50;
                    Collector.Log.Log(var10_10);
                }
            }
            if ((var10_9 = Collector.OpenInputStream(var7_7)) == null) {
                return;
            }
            if (!Collector.createJarEntry(var3_3, false, var4_4.lastModified())) {
                return;
            }
            while ((var9_32 = var10_9.read(var8_8)) != -1) {
                Collector.jos.write(var8_8, 0, var9_32);
            }
            try {
                var10_9.close();
                var7_7.delete();
                Collector.jos.closeEntry();
            }
            catch (IOException var11_12) {
                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
                if (Collector.debug) {
                    Collector.Log.Log(var11_12);
                }
                break block54;
            }
            catch (IOException var11_13) {
                block55: {
                    try {
                        Collector.Log.Err(TraceNLS.getStringFromBundle(Collector.bundle, "WSST_ERR_COL_ERROR_READING_TEMP_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_TEMP_FILE_OR_WRITING_JAR"), var11_13, false);
                        if (!Collector.debug) break block55;
                        Collector.Log.Log(var11_13);
                    }
                    catch (Throwable var26_33) {
                        block56: {
                            try {
                                var10_9.close();
                                var7_7.delete();
                                Collector.jos.closeEntry();
                            }
                            catch (IOException var27_34) {
                                Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
                                if (!Collector.debug) break block56;
                                Collector.Log.Log(var27_34);
                            }
                        }
                        throw var26_33;
                    }
                }
                try {
                    var10_9.close();
                    var7_7.delete();
                    Collector.jos.closeEntry();
                }
                catch (IOException var11_14) {
                    Collector.Log.Err(TraceNLS.getFormattedMessage(Collector.bundle, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR", new Object[]{var7_7.toString()}, "WSST_ERR_COL_CLOSING_TEMP_FILE_OR_JAR"));
                    if (Collector.debug) {
                        Collector.Log.Log(var11_14);
                    }
                }
            }
        }
        ++Collector.objectsGathered;
    }

    static void getDir() {
        if (!vData.endsWith(fileSep) & !vData.endsWith("/")) {
            vData = vData.concat(fileSep);
        }
        Collector.getFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execCmd() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        ExecCmd execCmd = new ExecCmd(bl);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        if (!sExecFile.equals(po.getString(k_ScratchFile)) && !Collector.createJarEntry(sExecFile, false, -1L)) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(vData, OBFUSCATION_MARKERS_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                Object object;
                String string = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string);
                String string2 = stringTokenizer2.nextToken().trim();
                if (string2.equals("QUIET")) {
                    string = stringTokenizer2.nextToken(OBFUSCATION_MARKERS_DELIMITER).trim();
                }
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_EXECUTE", new Object[]{string}, "WSST_MSG_COL_EXECUTE"));
                if (!string2.equals("QUIET")) {
                    vector.add("Execute: " + string);
                }
                StringTokenizer stringTokenizer3 = new StringTokenizer(string, OBFUSCATION_MARKERS_DELIMITER);
                String[] stringArray = new String[20];
                int n2 = 0;
                while (stringTokenizer3.hasMoreTokens()) {
                    object = stringTokenizer3.nextToken(OBFUSCATION_DEFAULT_MARKERS).trim();
                    if (((String)object).equals("")) continue;
                    stringArray[n2] = object;
                    ++n2;
                }
                object = new String[n2];
                for (n = 0; n < n2; ++n) {
                    object[n] = stringArray[n];
                }
                n = execCmd.Execute((String[])object, bl2, bl3, stringBuffer, vector);
                if (888 == n || 1 == n) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_EXECUTE_ERROR", new Object[]{stringBuffer.toString()}, "WSST_ERR_COL_EXECUTE_ERROR"));
                    stringBuffer.delete(0, stringBuffer.length());
                }
                Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_EXECUTE_RC", new Object[]{Integer.toString(n)}, "WSST_MSG_COL_EXECUTE_RC"));
                if (!sExecFile.equals(po.getString(k_ScratchFile))) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement() + System.getProperty("line.separator");
                        byte[] byArray = string3.getBytes();
                        jos.write(byArray, 0, byArray.length);
                    }
                }
                vector.clear();
            }
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_EXECUTE_IOEXCEPTION", "WSST_ERR_COL_EXECUTE_IOEXCEPTION"), iOException, false);
            if (debug) {
                Log.Log(iOException);
            }
        }
        finally {
            block24: {
                if (!sExecFile.equals(po.getString(k_ScratchFile))) {
                    try {
                        jos.closeEntry();
                    }
                    catch (IOException iOException) {
                        Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_EXECUTE_CLOSING_JAR", "WSST_ERR_COL_EXECUTE_CLOSING_JAR"), iOException, false);
                        if (!debug) break block24;
                        Log.Log(iOException);
                    }
                }
            }
        }
        if (!sExecFile.equals(po.getString(k_ScratchFile))) {
            ++objectsGathered;
        }
    }

    static void includeLogFile() {
        block3: {
            if (!po.getBool(k_AutoCollect)) {
                return;
            }
            vData = po.getString(k_LogFileName);
            Log.Close();
            Collector.getFile(vData, false);
            try {
                File file = new File(vData);
                file.delete();
            }
            catch (Exception exception) {
                if (!debug) break block3;
                Log.Log(exception);
            }
        }
        ++objectsGathered;
    }

    static void includeProps() {
        block12: {
            if (!po.getBool(k_AutoCollect)) {
                return;
            }
            Log.Both(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_JAVA_PROPS", "WSST_MSG_COL_JAVA_PROPS"));
            if (!Collector.createJarEntry("Java/Properties", false, -1L)) {
                return;
            }
            Properties properties = System.getProperties();
            int n = 30;
            String string = " = ";
            int n2 = 47;
            String string2 = "";
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = System.getProperty(string3);
                if (string3.equals("line.separator")) {
                    string4 = Helper1.Hex(string4, false, 2);
                }
                while (string4.length() > 0) {
                    block11: {
                        if (string4.length() < n2) {
                            string2 = string4;
                            string4 = "";
                        } else {
                            string2 = string4.substring(0, n2);
                            string4 = string4.substring(n2);
                        }
                        String string5 = string3.length() > 0 ? HC1.Padit(string3, n, false, ' ') + string + string2 + System.getProperty("line.separator") : HC1.Padit(" ", n, false, ' ') + "   " + string2 + System.getProperty("line.separator");
                        byte[] byArray = string5.getBytes();
                        try {
                            jos.write(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS", "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS"), iOException, false);
                            if (!debug) break block11;
                            Log.Log(iOException);
                        }
                    }
                    string3 = "";
                }
            }
            try {
                jos.closeEntry();
            }
            catch (IOException iOException) {
                Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS_JAR_CLOSE", "WSST_ERR_COL_IOEXCEPTION_JAVA_PROPS_JAR_CLOSE"), iOException, false);
                if (!debug) break block12;
                Log.Log(iOException);
            }
        }
        ++objectsGathered;
    }

    static boolean moreRequests() {
        String string;
        String string2;
        block72: {
            string2 = "\u0013";
            string = po.getString(k_Inventory);
            if (is == null) {
                if (string.endsWith(".jar")) {
                    try {
                        jf = new JarFile(string);
                        ZipEntry zipEntry = jf.getEntry(defaultInventoryName);
                        if (zipEntry == null) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{string, defaultInventoryName}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"));
                            break block72;
                        }
                        is = jf.getInputStream(zipEntry);
                    }
                    catch (IOException iOException) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_IOEXCEPTION_OPEN", new Object[]{string}, "WSST_ERR_COL_INV_FILE_IOEXCEPTION_OPEN"), iOException, true);
                        if (debug) {
                            Log.Log(iOException);
                        }
                        break block72;
                    }
                }
                try {
                    is = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_FILE_NOT_FOUND", new Object[]{string}, "WSST_ERR_COL_INV_FILE_NOT_FOUND"), fileNotFoundException, true);
                    if (!debug) break block72;
                    Log.Log(fileNotFoundException);
                }
            }
        }
        boolean bl = true;
        while (bl) {
            String string3 = "";
            vData = "";
            sExecFile = "";
            string3 = HC1.getNextLogicalLine(lineCount, string, is);
            if (string3 == null) {
                return false;
            }
            if (debug) {
                Log.Both("Debug -- line #" + lineCount[0] + "  (" + string3 + ")");
            }
            if (string3.startsWith("[")) {
                Collector.checkPlatform(string3);
                continue;
            }
            if (!correctPlatform) continue;
            action = 0;
            String string4 = string3.toLowerCase();
            if (string4.startsWith("getfile ")) {
                action = 1;
                vData = Collector.resolveMacro(string3.substring("getfile ".length()).trim());
            } else {
                Object object;
                if (string4.startsWith(k_AutoCollect.toLowerCase())) {
                    vData = Collector.resolveMacro(string3.substring(k_AutoCollect.length()).trim());
                    if (vData.equalsIgnoreCase("yes") || vData.equalsIgnoreCase("no")) {
                        po.setDefault(k_AutoCollect, vData);
                        continue;
                    }
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_AUTOCOLL_SPEC", new Object[]{k_AutoCollect, vData, Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_AUTOCOLL_SPEC"));
                    continue;
                }
                if (string4.startsWith("getfiles ")) {
                    action = 2;
                    vData = Collector.resolveMacro(string3.substring("getfiles ".length()).trim());
                } else if (string4.startsWith("getfiles-r ")) {
                    action = 3;
                    vData = Collector.resolveMacro(string3.substring("getfiles-r ".length()).trim());
                } else if (string4.startsWith("getfile-p ")) {
                    object = new StringTokenizer(Collector.resolveMacro(string3));
                    if (((StringTokenizer)object).countTokens() < 3) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_GETFILE_PW_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_GETFILE_PW_SPEC"));
                        continue;
                    }
                    action = 4;
                    vData = Collector.resolveMacro(string3.substring("getfile-p ".length()).trim());
                } else if (string4.startsWith("getdir ")) {
                    action = 5;
                    vData = Collector.resolveMacro(string3.substring("getdir ".length()).trim());
                } else if (string4.startsWith("getdir-r ")) {
                    action = 6;
                    vData = Collector.resolveMacro(string3.substring("getdir-r ".length()).trim());
                } else if (string4.startsWith("exec ")) {
                    action = 7;
                    object = new StringTokenizer(Collector.resolveMacro(string3), " ");
                    if (((StringTokenizer)object).countTokens() < 3) {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_EXEC_REQ", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_EXEC_REQ"));
                        continue;
                    }
                    ((StringTokenizer)object).nextToken();
                    sExecFile = ((StringTokenizer)object).nextToken().trim();
                    vData = ((StringTokenizer)object).nextToken(string2).trim();
                } else {
                    int n;
                    String string5;
                    String string6;
                    String string7;
                    Object object2;
                    if (string4.startsWith("macro ")) {
                        object = new StringTokenizer(string3, " ");
                        if (((StringTokenizer)object).countTokens() < 3) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_MACRO_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_MACRO_SPEC"));
                            continue;
                        }
                        ((StringTokenizer)object).nextToken();
                        object2 = ((StringTokenizer)object).nextToken().trim().toLowerCase();
                        string7 = ((StringTokenizer)object).nextToken(string2).trim();
                        if (string7.startsWith("{")) {
                            Log.Log(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_USER_QUESTION", "WSST_MSG_COL_USER_QUESTION"));
                            System.out.println();
                            string6 = string7.substring(1);
                            boolean bl2 = true;
                            string5 = null;
                            do {
                                if ((n = string6.indexOf("}")) > -1) {
                                    bl2 = false;
                                    string6 = string6.replace('}', ' ').trim();
                                }
                                if (prompt) {
                                    string5 = TraceNLS.getStringFromBundle(bundle, string6, string6);
                                    System.out.println(string5);
                                    Log.LogRaw(string5);
                                }
                                if (!bl2) continue;
                                string6 = HC1.getNextLogicalLine(lineCount, string, is);
                                if (string6 == null) {
                                    return false;
                                }
                                string6 = string6.trim();
                            } while (bl2);
                            if (prompt) {
                                string7 = po.getKeyBoard(true);
                            } else if (((String)object2).equalsIgnoreCase(k_InstallDir)) {
                                string7 = installDirectory;
                            } else if (((String)object2).equalsIgnoreCase(k_JavaHome)) {
                                string7 = po.getString(k_JavaHome);
                            } else if (((String)object2).equalsIgnoreCase("logroot")) {
                                string7 = logRoot;
                            } else if (((String)object2).equalsIgnoreCase("mqinstallroot")) {
                                string7 = mQRoot;
                            } else if (((String)object2).equalsIgnoreCase("appinstallroot")) {
                                string7 = appInstallRoot;
                            } else if (((String)object2).equalsIgnoreCase("waspropsdir")) {
                                string7 = wasPropsDir;
                            } else if (((String)object2).equalsIgnoreCase("configroot")) {
                                string7 = po.getString(k_ConfigRoot);
                            } else if (((String)object2).equalsIgnoreCase(k_ProfileRoot)) {
                                string7 = po.getString(k_ProfileRoot);
                            }
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USER_REPLY", new Object[]{string7}, "WSST_MSG_COL_USER_REPLY"));
                        }
                        macros.put(object2, string7);
                        continue;
                    }
                    if (string4.startsWith("checkuserid ")) {
                        int n2;
                        object = System.getProperty("user.name");
                        object2 = new StringTokenizer(string3, " ");
                        string7 = null;
                        if (((StringTokenizer)object2).countTokens() < 3) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_SPEC", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_SPEC"));
                            continue;
                        }
                        ((StringTokenizer)object2).nextToken();
                        string6 = ((StringTokenizer)object2).nextToken().trim();
                        if (((String)object).equals(string6)) {
                            String string8 = ((StringTokenizer)object2).nextToken(string2).trim();
                            if (string8.startsWith("{")) {
                                string5 = string8.substring(1);
                                n = 1;
                                do {
                                    if ((n2 = string5.indexOf("}")) > -1) {
                                        n = 0;
                                    }
                                    if (n == 0 || (string5 = HC1.getNextLogicalLine(lineCount, string, is)) != null) continue;
                                    return false;
                                } while (n != 0);
                                continue;
                            }
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT"));
                            continue;
                        }
                        String string9 = ((StringTokenizer)object2).nextToken(string2).trim();
                        if (string9.startsWith("{")) {
                            Log.Log(TraceNLS.getStringFromBundle(bundle, "WSST_MSG_COL_USER_QUESTION", "WSST_MSG_COL_USER_QUESTION"));
                            System.out.println();
                            string5 = string9.substring(1);
                            n = 1;
                            do {
                                if ((n2 = string5.indexOf("}")) > -1) {
                                    n = 0;
                                    string5 = string5.replace('}', ' ').trim();
                                }
                                String string10 = TraceNLS.getStringFromBundle(bundle, string5, string5);
                                System.out.println(string10);
                                Log.LogRaw(string10);
                                if (n == 0) continue;
                                string5 = HC1.getNextLogicalLine(lineCount, string, is);
                                if (string5 == null) {
                                    return false;
                                }
                                string5 = string5.trim();
                            } while (n != 0);
                            String string11 = null;
                            if (!prompt) continue;
                            string11 = po.getKeyBoard(true);
                            Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_USER_REPLY", new Object[]{string11}, "WSST_MSG_COL_USER_REPLY"));
                            continue;
                        }
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT", new Object[]{Integer.toString(lineCount[0]), po.getString(k_Inventory)}, "WSST_ERR_COL_INV_CHK_USER_ID_TEXT"));
                        continue;
                    }
                    if (string4.startsWith("jaroutname ")) {
                        po.setDefault(k_JarOutName, Collector.resolveMacro(string3.substring(11).trim()));
                        continue;
                    }
                    if (string4.startsWith("dblocks")) {
                        if (showOnlyDBLocks & prompt) {
                            Collector.showLockInfo();
                            return false;
                        }
                        if (!(showDBLocks & prompt)) continue;
                        Collector.showLockInfo();
                        continue;
                    }
                    if (string4.startsWith(k_Comment.toLowerCase() + " ")) {
                        po.setDefault(k_Comment, Collector.resolveMacro(string3.substring(1 + k_Comment.length()).trim()));
                        continue;
                    }
                    if (string4.startsWith("obfuscationMarkers ".toLowerCase())) {
                        action = 8;
                        vData = Collector.resolveMacro(string3.substring("obfuscationMarkers ".length()).trim());
                    } else if (string4.startsWith("excludeFiles".toLowerCase())) {
                        action = 9;
                        vData = Collector.resolveMacro(string3.substring("excludeFiles".length()).trim());
                    } else {
                        Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_INV_INV_REQ", new Object[]{po.getString(k_Inventory), Integer.toString(lineCount[0])}, "WSST_ERR_COL_INV_INV_REQ"), false);
                        continue;
                    }
                }
            }
            if (action == 0) continue;
            bl = false;
        }
        return true;
    }

    static boolean checkPlatform(String string) {
        String string2 = string.replace('[', ' ');
        string2 = string2.replace(']', ' ');
        if ((string2 = string2.trim()).length() == 0) {
            correctPlatform = true;
        } else {
            String string3 = System.getProperty("os.name");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, OBFUSCATION_MARKERS_DELIMITER);
            correctPlatform = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!string4.equalsIgnoreCase(string3)) continue;
                correctPlatform = true;
                break;
            }
        }
        return correctPlatform;
    }

    static String resolveMacro(String string) {
        String string2 = null;
        int n = string.indexOf("$(");
        while (n > -1) {
            int n2 = string.indexOf(")", n);
            if (n2 > -1) {
                String string3 = string.substring(n + 2, n2).toLowerCase();
                string2 = (String)macros.get(string3);
                if (string2 == null) {
                    string2 = System.getProperty(string3);
                }
                if (string2 != null) {
                    string = string.substring(0, n) + string2 + string.substring(n2 + 1);
                    string2 = null;
                }
            }
            if (n2 > 0) {
                n = string.indexOf("$(", n + 1);
                continue;
            }
            n = -2;
        }
        return string;
    }

    static boolean createJarEntry(String string, boolean bl, long l) {
        Object object;
        if (!debug) {
            bl = true;
        }
        if (jos == null) {
            block18: {
                jarName = po.getString(k_JarOutName);
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    hostName = wasNode.trim();
                    if (!debug) break block18;
                    Log.Log(exception);
                }
            }
            if (hostName == null || hostName.length() == 0) {
                hostName = "UnknownHost";
            }
            if (jarName == null || jarName.length() == 0 || jarName.equals(defaultJarName)) {
                block19: {
                    object = null;
                    if (userInstallRoot != null && !userInstallRoot.equals(installDirectory) && userInstallRoot.length() > 0) {
                        try {
                            object = new File(userInstallRoot).getName();
                        }
                        catch (Exception exception) {
                            object = null;
                            if (!debug) break block19;
                            Log.Log(exception);
                        }
                    }
                }
                jarName = hostName;
                jarName = jarName.concat("-");
                jarName = jarName.concat(cellName);
                jarName = jarName.concat("-");
                jarName = jarName.concat(wasNode);
                if (object != null) {
                    jarName = jarName.concat("-");
                    jarName = jarName.concat((String)object);
                }
                jarName = jarName.concat("-");
                jarName = jarName.concat(defaultJarName);
            }
            object = Collector.buildManifest();
            jos = Collector.CreateJarStream(jarName, (Manifest)object);
            jos.setLevel(po.getInt(k_Compression));
        }
        if (((String)(object = string.replace('\\', '/').trim())).substring(1, 2).equals(":")) {
            object = "Drive_" + ((String)object).substring(0, 1).toUpperCase() + "/" + ((String)object).substring(3);
        } else if (((String)object).startsWith("/")) {
            object = "root" + ((String)object).substring(0);
        }
        hostNameDir = hostName + "/";
        JarEntry jarEntry = new JarEntry(hostNameDir + (String)object);
        if (l > 0L) {
            jarEntry.setTime(l);
        }
        try {
            jos.putNextEntry(jarEntry);
        }
        catch (IOException iOException) {
            if (!bl) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANT_ADD_JAR_ENTRY", new Object[]{object}, "WSST_ERR_COL_CANT_ADD_JAR_ENTRY"), iOException, false);
            }
            if (debug) {
                Log.Log(iOException);
            }
            return false;
        }
        return true;
    }

    static JarOutputStream CreateJarStream(String string, Manifest manifest) {
        block5: {
            try {
                jarFile = new File(string);
                if (!jarFile.exists()) {
                    jarFile.createNewFile();
                }
                return new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_JAR_NOT_FOUND", new Object[]{string}, "WSST_ERR_COL_JAR_NOT_FOUND"), fileNotFoundException, true);
                if (debug) {
                    Log.Log(fileNotFoundException);
                }
            }
            catch (IOException iOException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_JAR_IOEXCEPT", new Object[]{string}, "WSST_ERR_COL_JAR_IOEXCEPT"), iOException, true);
                if (!debug) break block5;
                Log.Log(iOException);
            }
        }
        return null;
    }

    static void closeJarStream() {
        block3: {
            if (jos == null) {
                return;
            }
            try {
                jos.close();
            }
            catch (IOException iOException) {
                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CLOSING_JAR", new Object[]{absoluteDirectoryPath + jarName}, "WSST_ERR_COL_CLOSING_JAR"), iOException, true);
                if (!debug) break block3;
                Log.Log(iOException);
            }
        }
        jos = null;
    }

    static FileInputStream OpenInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_CANT_OPEN_FILE", new Object[]{file.toString()}, "WSST_ERR_COL_CANT_OPEN_FILE"), iOException, true);
            if (debug) {
                Log.Log(iOException);
            }
            return null;
        }
    }

    static Manifest buildManifest() {
        Object object;
        Manifest manifest;
        block7: {
            manifest = null;
            if (po.getString(k_ManifestFile) != null) {
                try {
                    object = new FileInputStream(po.getString(k_ManifestFile));
                    manifest = new Manifest((InputStream)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_NO_INPUT_MANIFEST_FILE", new Object[]{po.getString(k_ManifestFile)}, "WSST_ERR_COL_NO_INPUT_MANIFEST_FILE"), fileNotFoundException, true);
                    if (debug) {
                        Log.Log(fileNotFoundException);
                    }
                    break block7;
                }
                catch (IOException iOException) {
                    Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_IOEXCEPTION_MANIFEST_FILE", new Object[]{po.getString(k_ManifestFile)}, "WSST_ERR_COL_IOEXCEPTION_MANIFEST_FILE"), iOException, true);
                    if (debug) {
                        Log.Log(iOException);
                    }
                    break block7;
                }
            }
            manifest = new Manifest();
        }
        object = manifest.getMainAttributes();
        ((Attributes)object).putValue(Attributes.Name.MANIFEST_VERSION.toString(), po.getString(k_mfVersion));
        ((Attributes)object).putValue("Created-By", "Collector");
        ((Attributes)object).putValue("TimeStamp", Log.CurrentTimeStamp());
        if (po.getString(k_mfMainClass) != null) {
            ((Attributes)object).putValue(Attributes.Name.MAIN_CLASS.toString(), po.getString(k_mfMainClass));
        }
        return manifest;
    }

    static boolean ProcessOptions(String[] stringArray) {
        String string = "true";
        String string2 = Collector.determineSourcePath();
        String[] stringArray2 = new String[]{TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_OUT_JAR1", "WSST_ERR_COL_NO_OUT_JAR1"), TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_OUT_JAR1", "WSST_ERR_COL_NO_OUT_JAR2")};
        String[] stringArray3 = new String[]{TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_INV_FILE1", "WSST_ERR_COL_NO_INV_FILE1"), TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_NO_INV_FILE2", "WSST_ERR_COL_NO_INV_FILE2")};
        logFileName = currentDirectoryPath.endsWith(fileSep) || currentDirectoryPath.endsWith("/") ? currentDirectoryPath + "Collector.log" : currentDirectoryPath + fileSep + "Collector.log";
        PODef[] pODefArray = new PODef[]{new PODef(k_Version, "Boolean", "false"), new PODef(k_Debug, "Boolean", "false"), new PODef(k_Help, "BuiltInHelp", "false"), new PODef(k_LogFileName, "OutFileAny", logFileName), new PODef(k_Verbosity, "Int", "3"), new PODef(k_PropertyFile, "Validating", null), new PODef(k_ScratchFile, "String", "SCRATCH"), new PODef(k_Compression, "int", "9"), new PODef(k_Inventory, "InFile", string2, stringArray3), new PODef(k_JarOutName, "OutFileAny", null, stringArray2), new PODef(k_Comment, "String", null), new PODef(k_CaseSensitive, "Boolean", string), new PODef(k_AutoCollect, "Boolean", "true"), new PODef(k_ManifestFile, "InFile", null), new PODef(k_mfMainClass, "String", null), new PODef(k_mfVersion, "String", "1.0"), new PODef(k_AidInventory, "Boolean", "false"), new PODef(k_Test, "Boolean", "false"), new PODef(k_Prompt, "Boolean", "false"), new PODef(k_InstallDir, "String", defaultInstallDir), new PODef(k_ShowDBLocks, "Boolean", "false"), new PODef(k_ShowOnlyDBLocks, "Boolean", "false"), new PODef(k_JavaHome, "String", defaultJavaHome), new PODef(k_ConfigRoot, "String", null), new PODef(k_WasNode, "String", "NoNodeName"), new PODef(k_CellName, "String", "NoCellName"), new PODef(k_ServerName, "String", null), new PODef(k_Summary, "Boolean", "false"), new PODef(k_NoSamples, "Boolean", "false"), new PODef(k_IncludeInstalledApps, "Boolean", "false"), new PODef(k_ProfileRoot, "String", defaultInstallDir)};
        po = new POProcessor(pODefArray, stringArray, null);
        debug = po.getBool(k_Debug);
        verbosity = po.getInt(k_Verbosity);
        prompt = po.getBool(k_Prompt);
        showDBLocks = po.getBool(k_ShowDBLocks);
        showOnlyDBLocks = po.getBool(k_ShowOnlyDBLocks);
        wasNode = po.getString(k_WasNode);
        cellName = po.getString(k_CellName);
        summary = po.getBool(k_Summary);
        noSamples = po.getBool(k_NoSamples);
        includeInstalledApps = po.getBool(k_IncludeInstalledApps);
        if (po.getBool(k_Help)) {
            Collector.OnLineHelp();
            return false;
        }
        if (po.getBool(k_Version)) {
            Collector.DisplayVersion(po);
            return false;
        }
        if (po.getBool(k_AidInventory)) {
            return false;
        }
        if (po.getString(k_LogFileName) != null) {
            Collector.RecycleLog();
        }
        if (Collector.po.errorCount > 0) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_COL_COMMAND_OPTIONS", new Object[]{Integer.toString(Collector.po.errorCount)}, "WSST_ERR_COL_COMMAND_OPTIONS"));
            Log.Close();
            System.exit(8);
        }
        installDirectory = po.getString(k_InstallDir);
        configDirectory = po.getString(k_ConfigRoot);
        serverName = po.getString(k_ServerName);
        if (!summary) {
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_LOG_FILE", new Object[]{po.getString(k_LogFileName)}, "WSST_MSG_COL_LOG_FILE"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_CASE_SENSITIVE", new Object[]{po.getString(k_CaseSensitive)}, "WSST_MSG_COL_CASE_SENSITIVE"));
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_INVENTORY_FILE", new Object[]{po.getString(k_Inventory)}, "WSST_MSG_COL_INVENTORY_FILE"));
        }
        return true;
    }

    static String determineSourcePath() {
        String string = null;
        Class<?> clazz = new Collector().getClass();
        String string2 = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = classLoader.getResource((string2 = string2.replace('.', '/')) + ".class");
        if (uRL == null) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_CANT_FIND_URL", "WSST_ERR_COL_CANT_FIND_URL"));
        } else {
            int n;
            String string3 = uRL.toString();
            Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_URL", new Object[]{string3}, "WSST_MSG_COL_URL"));
            if (string3.startsWith("jar:") && (n = string3.indexOf("!")) > 0) {
                int n2 = 9;
                if (System.getProperty("os.arch").equals("x86") && (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 || System.getProperty("os.name").toLowerCase().indexOf("microsoft") > -1)) {
                    n2 = 10;
                }
                string = string3.substring(n2, n);
            }
        }
        return string;
    }

    static void RecycleLog() {
        Log.Close();
        Log = new Logger(po.getString(k_LogFileName), true, verbosity);
        Log.Open();
        HC1 = new Helper1(Log, verbosity);
    }

    static void DisplayVersion(POProcessor pOProcessor) {
        ExecCmd execCmd = new ExecCmd();
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_SYS_ARCH", new Object[]{System.getProperties().getProperty("os.arch")}, "WSST_MSG_COL_SYS_ARCH"));
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_OS_NAME", new Object[]{System.getProperties().getProperty("os.name")}, "WSST_MSG_COL_OS_NAME"));
        Log.Both(TraceNLS.getFormattedMessage(bundle, "WSST_MSG_COL_JAVA_VERSION", new Object[]{System.getProperties().getProperty("java.version")}, "WSST_MSG_COL_JAVA_VERSION"));
    }

    private static void getSummary() {
        block18: {
            Locale locale = Locale.getDefault();
            Locale.setDefault(Locale.ENGLISH);
            String string = "Collector_Summary.txt";
            PrintWriter printWriter = null;
            boolean bl = System.getProperty("os.name").equals("OS/400");
            try {
                block17: {
                    VersionInfo versionInfo;
                    block16: {
                        block15: {
                            printWriter = new PrintWriter(new FileWriter(string, false));
                            try {
                                hostName = InetAddress.getLocalHost().getHostName();
                            }
                            catch (UnknownHostException unknownHostException) {
                                hostName = wasNode.trim();
                                if (debug) {
                                    Log.Log(unknownHostException);
                                }
                            }
                            catch (SecurityException securityException) {
                                hostName = wasNode.trim();
                                if (!debug) break block15;
                                Log.Log(securityException);
                            }
                        }
                        if (!bl) {
                            System.setProperty("was.install.root", installDirectory);
                        }
                        String string2 = System.getProperty("was.install.root");
                        System.out.println("Hostname: " + hostName + "   Nodename: " + wasNode);
                        printWriter.println("Hostname: " + hostName + "   Nodename: " + wasNode);
                        versionInfo = new VersionInfo();
                        String string3 = null;
                        try {
                            versionInfo.runReport("TEXT", string3);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (debug) {
                                Log.Log(fileNotFoundException);
                            }
                        }
                        catch (IOException iOException) {
                            if (!debug) break block16;
                            Log.Log(iOException);
                        }
                    }
                    try {
                        versionInfo.runReport("TEXT", string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (debug) {
                            Log.Log(fileNotFoundException);
                        }
                    }
                    catch (IOException iOException) {
                        if (!debug) break block17;
                        Log.Log(iOException);
                    }
                }
                printWriter.flush();
                printWriter.close();
                printWriter = new PrintWriter(new FileWriter(string, true));
                System.out.println(" ");
                printWriter.println(" ");
                String string4 = bl ? System.getProperty("java.version") : System.getProperty("java.fullversion");
                System.out.println("Java Full Version: ");
                System.out.println(string4);
                printWriter.println("Java Full Version: ");
                printWriter.println(string4);
                System.out.println(" ");
                printWriter.println(" ");
                String string5 = System.getProperty("os.name");
                String string6 = System.getProperty("os.version");
                printWriter.println("Operating System: " + string5 + ", " + string6);
                System.out.println("Operating System: " + string5 + ", " + string6);
                boolean bl2 = true;
                boolean bl3 = false;
                boolean bl4 = false;
                ExecCmd execCmd = new ExecCmd(bl2);
                Vector vector = new Vector();
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = new String[1];
                System.out.println(" ");
                printWriter.println(" ");
                Locale.setDefault(locale);
                printWriter.close();
            }
            catch (IOException iOException) {
                System.out.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_LOG_FILE_CANT_OPEN", new Object[]{string, iOException.getMessage()}, "WSST_ERR_LOG_FILE_CANT_OPEN"));
                printWriter.close();
                if (!debug) break block18;
                Log.Log(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void showLockInfo() {
        block80: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            Object var8_8 = null;
            String string9 = null;
            try {
                Object object;
                Comparable<File> comparable;
                InformixDataStoreHelper informixDataStoreHelper = null;
                if (!prompt) break block80;
                System.out.println("\n");
                System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_MSG001", ">At any prompt for database information, hit enter to stop collecting database lock information."));
                System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DBTYPE", "Enter the type of the database."));
                System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_TYPES", "Valid database types are: DB2, Oracle, Sybase, Informix, Derby, SQLServer, SQLServer3, SQLServer4."));
                string = po.getKeyBoard(false);
                if (string == null || string.equals("")) {
                    return;
                }
                Properties properties = new Properties();
                if (string.equalsIgnoreCase("Db2")) {
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DB2DIR", ">Enter the directory where db2cmd.exe is installed (for example, C:\\SQLLIB\\bin\\."));
                    string2 = po.getKeyBoard(false);
                    if (string2 == null || string2.equals("")) {
                        return;
                    }
                    properties.setProperty("db2Install", string2);
                    string4 = "db2lockinfo.txt";
                    comparable = new File(string4);
                    try {
                        boolean bl = ((File)comparable).createNewFile();
                    }
                    catch (IOException iOException) {
                        Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_IO_ERROR", "Input or output error creating db2 temporary file"), iOException, false);
                        if (debug) {
                            Log.Log(iOException);
                        }
                        return;
                    }
                    properties.setProperty("outputFile", string4);
                    object = System.getProperty("user.dir");
                    properties.setProperty("workingDir", (String)object);
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                    string3 = po.getKeyBoard(false);
                    if (string3 == null || string3.equals("")) {
                        return;
                    }
                    properties.setProperty("databaseName", string3);
                    Log.Log(TraceNLS.getFormattedMessage(bundle, "WSST_DB_LOCK_INFO_PROPS", new Object[]{properties}, "DB Lock Info Helper Properties: "));
                    try {
                        informixDataStoreHelper = new DB2DataStoreHelper(properties);
                        string9 = ((DB2DataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                    }
                    catch (Exception exception) {
                        Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DSH_FAILURE", "DataStore Helper create failure"), exception, false);
                        if (debug) {
                            Log.Log(exception);
                        }
                        return;
                    }
                }
                if (string.equalsIgnoreCase("oracle")) {
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_ORACLE_DRIVER", ">For Oracle, thin driver type is assumed."));
                    if (!Collector.getDBConnectInfo(properties, string5, string6, string7, string8)) {
                        return;
                    }
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                    string3 = po.getKeyBoard(false);
                    if (string3 == null || string3.equals("")) {
                        return;
                    }
                    properties.setProperty("databaseName", string3);
                    properties.setProperty("driverType", "thin");
                    informixDataStoreHelper = new OracleDataStoreHelper(null);
                    string9 = ((OracleDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else if (string.equalsIgnoreCase("sybase")) {
                    if (!Collector.getDBConnectInfo(properties, string5, string6, string7, string8)) {
                        return;
                    }
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                    string3 = po.getKeyBoard(false);
                    if (string3 == null || string3.equals("")) {
                        return;
                    }
                    properties.setProperty("databaseName", string3);
                    informixDataStoreHelper = new SybaseDataStoreHelper(properties);
                    string9 = ((SybaseDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else if (string.equalsIgnoreCase("informix")) {
                    informixDataStoreHelper = new InformixDataStoreHelper(properties);
                    string9 = informixDataStoreHelper.showLockInfo(properties);
                } else if (string.equalsIgnoreCase("derby")) {
                    System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_DBNAME", "Enter the database name."));
                    string3 = po.getKeyBoard(false);
                    if (string3 == null || string3.equals("")) {
                        return;
                    }
                    properties.setProperty("databaseName", string3);
                    informixDataStoreHelper = new DerbyDataStoreHelper(properties);
                    string9 = ((DerbyDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else if (string.equalsIgnoreCase("sqlserver")) {
                    if (!Collector.getDBConnectInfo(properties, string5, string6, string7, string8)) {
                        return;
                    }
                    informixDataStoreHelper = new MSSQLDataStoreHelper(properties);
                    string9 = ((MSSQLDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else if (string.equalsIgnoreCase("sqlserver3")) {
                    if (!Collector.getDBConnectInfo(properties, string5, string6, string7, string8)) {
                        return;
                    }
                    properties.setProperty("driverType", "3");
                    System.out.println("       SqlServer type3:  The props are: " + properties);
                    informixDataStoreHelper = new MSSQLDataStoreHelper(properties);
                    string9 = ((MSSQLDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else if (string.equalsIgnoreCase("sqlserver4")) {
                    if (!Collector.getDBConnectInfo(properties, string5, string6, string7, string8)) {
                        return;
                    }
                    properties.setProperty("driverType", "4");
                    informixDataStoreHelper = new MSSQLDataStoreHelper(properties);
                    string9 = ((MSSQLDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                } else {
                    System.out.println("* Generic *");
                    informixDataStoreHelper = new GenericDataStoreHelper(properties);
                    string9 = ((GenericDataStoreHelper)informixDataStoreHelper).showLockInfo(properties);
                }
                try {
                    if (!Collector.createJarEntry("dblockinfo/" + string + "/" + string3, false, -1L)) {
                        return;
                    }
                    comparable = new StringBuffer(string + " " + "\n");
                    if (string.equalsIgnoreCase("db2")) {
                        int n;
                        object = new File(string4);
                        FileInputStream fileInputStream = Collector.OpenInputStream((File)object);
                        if (fileInputStream == null) {
                            return;
                        }
                        byte[] byArray = new byte[4096];
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            jos.write(byArray, 0, n);
                        }
                        try {
                            fileInputStream.close();
                            jos.closeEntry();
                        }
                        catch (IOException iOException) {
                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{((File)object).toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), iOException, true);
                            if (debug) {
                                Log.Log(iOException);
                            }
                            break block80;
                        }
                        catch (IOException iOException) {
                            block81: {
                                try {
                                    Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_LOCK_INFO_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_LOCK_INFO_ERROR_READING_FILE_OR_WRITING_JAR"), iOException, true);
                                    if (!debug) break block81;
                                    Log.Log(iOException);
                                }
                                catch (Throwable throwable) {
                                    block82: {
                                        try {
                                            fileInputStream.close();
                                            jos.closeEntry();
                                        }
                                        catch (IOException iOException2) {
                                            Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{((File)object).toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), iOException2, true);
                                            if (!debug) break block82;
                                            Log.Log(iOException2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                fileInputStream.close();
                                jos.closeEntry();
                            }
                            catch (IOException iOException3) {
                                Log.Err(TraceNLS.getFormattedMessage(bundle, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR", new Object[]{((File)object).toString()}, "WSST_LOCK_INFO_ERROR_CLOSING_FILE_OR_JAR"), iOException3, true);
                                if (debug) {
                                    Log.Log(iOException3);
                                }
                                break block80;
                            }
                        }
                    }
                    object = ((StringBuffer)comparable).toString().getBytes();
                    try {
                        jos.write((byte[])object, 0, ((Object)object).length);
                    }
                    catch (IOException iOException) {
                        Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_LOCK_INFO_WRITE_JAR_ERROR", "Error trying to write lock info to jar"), iOException, true);
                        if (debug) {
                            Log.Log(iOException);
                        }
                    }
                    finally {
                        block83: {
                            try {
                                jos.closeEntry();
                            }
                            catch (IOException iOException) {
                                Log.Err(TraceNLS.getStringFromBundle(bundle, ""), iOException, true);
                                if (!debug) break block83;
                                Log.Log(iOException);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_LOCK_INFO_OBTAIN_ERROR", "Error trying to obtain lock info"), exception, false);
                    if (debug) {
                        Log.Log(exception);
                    }
                    return;
                }
                finally {
                    block84: {
                        try {
                            jos.closeEntry();
                        }
                        catch (IOException iOException) {
                            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_LOCK_INFO_JAR_CLOSE", "Error trying to close jar for show db locks"), iOException, false);
                            if (!debug) break block84;
                            Log.Log(iOException);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_THROWABLE", "Error trying to get lock information, make sure the Collector tool is running on a server image."), throwable);
                if (!debug) break block80;
                Log.Log(throwable);
            }
        }
    }

    private static boolean getDBConnectInfo(Properties properties, String string, String string2, String string3, String string4) {
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_USERID", "Enter a user id that has permission to access the database."));
        string = po.getKeyBoard(false);
        if (string == null || string.equals("")) {
            return false;
        }
        properties.setProperty("user", string);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_USERPW", "Enter a password for the user id."));
        string2 = po.getKeyBoard(false);
        if (string2 == null || string2.equals("")) {
            return false;
        }
        properties.setProperty("password", string2);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_SERVER_NAME", "Enter server name on which the database is installed (for example, testsrv1.site1.company.com."));
        string3 = po.getKeyBoard(false);
        if (string3 == null || string3.equals("")) {
            return false;
        }
        properties.setProperty("serverName", string3);
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_DB_LOCK_INFO_PORT_NUMBER", "Enter port number to access the database (for example, 1521."));
        string4 = po.getKeyBoard(false);
        if (string4 == null || string4.equals("")) {
            return false;
        }
        properties.setProperty("portNumber", string4);
        return true;
    }

    private static void OnLineHelp() {
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG001", ">This program is intended to collect selected data from the computer"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG002", "upon which it is executed.  Control parameters consist of command line"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG003", "arguments and an Inventory file which specifies which data is to be"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG004", "collected.  Several items are automatically included which include:"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG005", "this program's log file and all the Java system properties.  When the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG006", "same parameter may appear in both the command line and the inventory"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG007", "file, the command line takes precedence."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG008", "Command line syntax is:"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0086", "collector (simple) "));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0017", "Options are:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0018", "-Inventory  <file-spec>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0019", "Where <file-spec> is a file specifying the data to collect."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0020", "If being executed as an executable jar then the default"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0021", "inventory file will be searched within the jar file with"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0022", "the name of \"default.inventory\".  If being executed as a"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0023", "class file then the default is to prompt the user."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0024", "An inventory file is required for operation."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0026", "Default: <WAS_HOME>/bin/default.inventory"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0027", "-JarOutName  <file-spec>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0028", "Where <file-spec> is the output jar file."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0029", "Default: <working directory>/WASenv.jar"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0030", "-Compression  <n>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0031", "Where <n> is the value 0-9.  <n> controls the amount of"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0032", "compression during output jar file creation."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0033", "Default: 9"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0034", "-CaseSensitive"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0035", "Option to process <file-spec> with case sensitivity."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0036", "Default: System Dependent"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0037", "-AutoCollect yes/no"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0038", "Controls if the automatically collected functions are to be included"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0039", "such as the JVM properties and the collector log."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0040", "Default: yes"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0041", "-ManifestFile  <file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0042", "Where <file-spec> is the manifest file to use in creating the manifest."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0043", "Manifest options specified on the command line or in property"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0044", "files will override manifest file entries."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0045", "Default: None"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0046", "-mfVersion  <v>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0047", "Where <v> is the manifest version value to be entered."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0048", "Default: 1.0"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0049", "-mfMainClass  <class-name>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0050", "Where <class-name> is the MAIN_CLASS entry of the manifest."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0051", "Default: None"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0052", "-LogFile  <file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0053", "Where <file-spec> is the output log file."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0054", "Default: <WAS_HOME>/logs/Collector.log"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0055", "-PropertyFile  <file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0056", "Where <file-spec> is a property file that may contain any or all of"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0057", "the options for this program.  Options specified on the command"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0058", "line override values in the property file"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0059", "Default: none"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0060", "-ScratchFile  <file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0061", "In the use of the Exec request in the inventory file, a file-spec"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0062", "name is given which specifies where the output of the command is"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0063", "to be written in the output jar file.  If the file-spec has the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0064", "value of SCRATCH, the output of the command is not written in the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0065", "output jar file.  The ScratchFile option allows a file-spec other"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0066", "than SCRATCH to be the scratch file name, i.e., the name that"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0067", "prevents saving the Exec command stdin and stderr"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0068", "Default: SCRATCH"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0069", "-Version"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0070", "Display the version of this program and helpers."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0071", "-Debug"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0072", "Debug option."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0073", "-Help"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0074", "Displays this help."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0077", "-Verbosity  <n>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0078", "Where <n> is the value 0-5.  <n> controls the amount of"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0079", "text output."));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0080", "Default: 3"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0081", "Note: All options are case insensitive and may be abbreviated to their least"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0082", "number of uniquely identifying characters for command line input.  Within"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0083", "the property file, the full keyword must be specified."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0084", "Sample syntax:"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_HELP_MSG0085", "java Collector  -Inventory Apar1.inventory  -JarOutPut test.jar  -Log Oak.Log"));
    }

    private static void InventoryHelp() {
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0001", ">The inventory file describes what data to collect and insert into the output"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0002", "jar file.  Data items include files, directories and the results of commands"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0003", "executed.  Entries within the inventory file consist of two groups, options and"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0004", "requests.  The options must precede the requests.  The entries specified in the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0005", "inventory file may be limited by platform.  Only one entry may be made per"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0006", "line.  Macros may be defined and used throughout."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0007", "A comment identifier may be specified by inclusion of a # or ! or * or // as"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0008", "the first non-white space data on the first line.  Thereafter, any line starting"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0009", "with the comment identifier or the apperance of a blank followed by the comment"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0010", "identifier will cause all data starting with the comment identifier to the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0011", "end-of-line to be discarded."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0012", "Any non-comment line may be continued at any place.  There are two types of"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0013", "continuations: A comma as the last non-white space character will cause the"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0014", "next line to be concatenated and the comma to be preserved.  A hyphen will cause"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0015", "the next line to be appended and the hyphen to be replaced by the first non-white"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0016", "character of the next line."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0017", "The format of entries varies with the specific entry being made.  All entries are"));
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0018", "case insensitive."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0019", "Options:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0020", "JarOutName  <jarName>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0021", "Where <jarName> is the output jar file name."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0022", "Comment  <comment>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0023", "Where <comment> is text that will be printed in the log.  This is useful"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0024", "for example, for relating a particular inventory file to a Collector"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0025", "output jar file."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0026", "AutoCollect yes/no"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0027", "Whether to collect the BuildIn items which include the JVM properties and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE__INVHELP_MSG0028", "the collector log."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0029", "Macro  <macroName>  <macroValue>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0030", "Macros may be used throughout the inventory file.  To"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0031", "invoke the macro, code the macro name inside the parenthesis"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0032", "in \"$()\", for example, $(macroName).  Macro resolution will"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0033", "first inspect if a local definition has been given.  If it"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0034", "hasn't, then an attempt will be made to extract the information"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0035", "from the environment.  If the macro value starts with a \"{\","));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0036", "then this will indicate a question to be asked of the user"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0037", "and the reply will be assigned to the macroName.  Once a \"{\""));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0038", "has been recognized, the inventory file will be scanned until"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0039", "the closing \"}\" is found.  Everything in between will be taken as"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0040", "the question."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0041", "CheckUserId  <user-id>  {<text>}"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0042", "Specifies that the user id executing Collector should be <user-id>."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0043", "If it is, execution continues.  If it's not, <text> is displayed"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0044", "and the user is given the option to continue or exit."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0045", "[ <platform_list> ]"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0046", "The square bracket indicates the following options or requests"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0047", "are only to be included if the current operating system matches"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0048", "the specification within the brackets.  The <platform_List> is"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0049", "a comma delimited list and the entries must match"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0050", "(case sensitive) to the value return by the java getSystem"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0051", "property(os.name).  No blanks are allowed within the list except"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0052", "as part of the OS name.  To determine the current OS name, execute"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0053", "this program with the -Version option to reveal this value."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0054", "Entering \"[]\" will reset the platform restriction.  This option"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0055", "may appear throughout the inventory file."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0056", "Requests:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0057", "GetFile  <file-spec>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0058", "Include this file where <file-spec> is a directory path and file"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0059", "name."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0060", "GetFiles  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0061", "Where <directory> is the full path name of a directory and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0062", "<file-spec> is a file specification that may include the wild"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0063", "card \"*\".  For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0064", "$(InstallDir)/logs/trace*"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0065", "will collect all files that begin with \"trace\" in the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0066", "$(InstallDir)/logs directory."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0067", "GetFiles-R  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0068", "Same as the GetFiles request with the exception that this"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0069", "request is recursive.  For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0070", "$(InstallDir)/logs/trace*"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0071", "will collect all files that begin with \"trace\" in the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0072", "$(InstallDir)/logs directory and all directories under logs."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0073", "GetFile-P  <string>  <directory>/<file-spec>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0074", "Same as the GetFile request except that the file is copied"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0075", "to <file-spec>.P, any passwords in the file (identified by"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0076", "<string> are changed to \"*\", For example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0077", "Password=abc -> Password=***"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0078", "and the <file-spec>.P file is collected.  The <string>"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0079", "specifies the a string of characters that preceeds the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0080", "password.  The <string> may contain blanks in which case"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0081", "it should be surrounded by single or double quotes.  For"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0082", "example:"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0083", "GetFile-P  Password=      foo.config"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0084", "GetFile-P  \"pass word =\"  bar.config"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0085", "All characters on the line following the <string> are"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0086", "considered to be part of the password and each will be"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0087", "changed to an asterisk."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0088", "GetDir  <directory>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0089", "Where <directory> is the full path name of a directory."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0090", "GetDir is just a special case of GetFiles, for example, the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0091", "following are equivalent:"));
        System.out.println("\n");
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0092", "GetDir    $(InstallDir)/logs"));
        System.out.println("\t\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0093", "GetFiles  $(InstallDir)/logs/*"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0094", "GetDir-R  <directory>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0095", "Same as the GetDir request with the exception that this"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0096", "request is recursive."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0097", "Exec  <file-spec>  <[QUIET] command...>"));
        System.out.println("\n");
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0098", "Where <command...> is a comma delimited list of commands to execute"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0099", "and <file-spec> is the directory path and file name in the output jar file"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0100", "in which to put the output of the command.  The default behavior is"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0101", "to write the command to the output stream followed by its stdout and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0102", "stderr output.  If the command is preceeded by the word QUIET, only"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0103", "the command output will be written to the output stream.  In addition,"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0104", "all the output of the Exec request, the command and its stdout and"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0105", "stderr, can be surpressed if the <file-spec> has the value SCRATCH."));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0106", "This value can be changed with the -ScratchFile option of the"));
        System.out.println("\t" + TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0107", "Collector program."));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0108", "Sample File:"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0109", "Macro InstallDir  { }"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0111", "Macro Name Value"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0112", "JarOutName Test3.jar"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0113", "[Windows 2000,Windows NT, Windows XP]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0114", "GetFile      C:/Temp$$1.Bat"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0115", "GetFiles-R   F:/Temp/*.tmp"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0116", "GetFile-P    D:/Temp/server.properties"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0117", "Exec   /Drive_C/$(Frog)      dir C:/Temp"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0118", "Exec   /Drive_D/DirOfDTemp   dir D:/Temp, dir G:/"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0119", "[AIX,Solaris,Sun OS,HP-UX]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0120", "GetFile    /usr/special/Downloads/jikes/Debug.Zip"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0121", "Exec   OS/name               uname -a"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0122", "[]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0123", "GetDir       $(InstallDir)/logs"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0124", "[AIX]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0125", "Exec   /usr/system/          ls -r /usr/applications"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0126", "[]"));
        System.out.println("\n");
        System.out.println(TraceNLS.getStringFromBundle(bundle, "WSST_ONLINE_INV_HELP_MSG0127", "GetFiles     $(InstallDir)/bin/*.config"));
        System.out.println("\n");
    }

    static void addObfuscationMarker() {
        if (obfuscationMarkers == null) {
            obfuscationMarkers = new Vector();
        }
        if (vData != null && vData.length() > 0) {
            String[] stringArray = new String[6];
            StringTokenizer stringTokenizer = new StringTokenizer(vData.toLowerCase(), OBFUSCATION_MARKERS_DELIMITER, true);
            if (stringTokenizer.countTokens() > 1) {
                int n = 0;
                String string = null;
                while (n < stringArray.length && stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.equals(OBFUSCATION_MARKERS_DELIMITER)) {
                        string = null;
                    } else if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                    }
                    stringArray[n++] = string;
                }
                if (stringTokenizer.hasMoreTokens() && debug) {
                    Log.Both("Found extra string in the list of obfuscation markers.");
                }
            } else {
                stringArray[0] = vData.toLowerCase();
                stringArray[1] = null;
                stringArray[2] = null;
                stringArray[3] = OBFUSCATION_DEFAULT_MARKERS;
                stringArray[4] = OBFUSCATION_DEFAULT_MARKERS;
                if (debug) {
                    Log.Both("Received a request to single string to list of obfuscation markers - using default substring markers");
                }
            }
            if (stringArray[1] != null && (stringArray[2] == null && stringArray[3] == null || stringArray[2] != null && stringArray[3] != null)) {
                obfuscationMarkers.add(stringArray);
                if (debug) {
                    Log.Both("Added obfuscation markers: " + vData);
                }
            } else {
                Log.Both("Received a request to add invalid string to list of obfuscation markers: " + vData);
            }
        } else if (debug) {
            Log.Both("Received a request to add empty string to list of obfuscation markers.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int scanAndObfuscateFile() {
        void var4_8;
        Object object;
        if (vData == null) return -1;
        if (vData.length() <= 0) return -1;
        File file = new File(vData);
        if (!file.exists()) return -1;
        if (!file.isFile()) return -1;
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return 0;
        }
        Vector<String[]> vector = null;
        if (string != null) {
            object = obfuscationMarkers.iterator();
            while (object.hasNext()) {
                String[] stringArray = (String[])object.next();
                if (stringArray[0] != null && !stringArray[0].equals("*") && !stringArray[0].equals(".*") && !stringArray[0].equals("*.*") && !string.endsWith(stringArray[0])) continue;
                if (vector == null) {
                    vector = new Vector<String[]>();
                }
                vector.add(stringArray);
            }
        }
        if (vector == null) return 0;
        object = null;
        Object var4_6 = null;
        try {
            object = new BufferedReader(new FileReader(vData), 0x100000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return -1;
        }
        if (object != null && Collector.createJarEntry(string, false, file.lastModified())) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(jos));
        }
        if (object == null) return -1;
        if (var4_8 == null) return -1;
        try {
            int n = -1;
            int[] nArray = null;
            if (debug) {
                Log.Both("Started scanning and obfuscating file: " + vData);
            }
            Collector.clearFileScanBuffer();
            String string2 = ((BufferedReader)object).readLine();
            while (string2 != null) {
                ++n;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    nArray = null;
                    String[] stringArray = (String[])iterator.next();
                    if (stringArray[2] != null && stringArray[3] != null) {
                        String string3 = null;
                        int n2 = 0;
                        int n3 = string2.indexOf(stringArray[1]);
                        if (n3 == -1) {
                            n3 = string2.toLowerCase().indexOf(stringArray[1]);
                        }
                        if (n3 >= 0) {
                            int n4;
                            int n5 = n4 = fileLines != null ? fileLines.size() : 0;
                            for (int i = 0; i < n4 + 1; ++i) {
                                if (i < n4) {
                                    string3 = (String)fileLines.elementAt(i);
                                    n2 = (Integer)fileLineNumbers.elementAt(i);
                                } else {
                                    string3 = string2;
                                    n2 = n;
                                }
                                nArray = Collector.findStringMarkersAfterOrAroundMarker(string3, i < n4 ? 0 : n3, i < n4 ? 0 : stringArray[1].length(), stringArray[4], stringArray[5]);
                                if (nArray != null) {
                                    Collector.addLineToOutputBuffer(Collector.obfuscateSubString(string3, nArray[0] + stringArray[4].length(), nArray[1]), n2, true, 0);
                                    continue;
                                }
                                Collector.addLineToOutputBuffer(string3, n2, false, 0);
                            }
                        }
                        String string4 = Collector.addLineToFileScanBuffer(string2, n, stringArray[2], stringArray[3]);
                        if (nArray != null || string4 == null) continue;
                        Collector.addLineToOutputBuffer(string4, n, false, 0);
                        continue;
                    }
                    int n6 = string2.indexOf(stringArray[1]);
                    if (n6 == -1) {
                        n6 = string2.toLowerCase().indexOf(stringArray[1]);
                    }
                    if (n6 >= 0) {
                        nArray = Collector.findStringMarkersAfterOrAroundMarker(string2, n6, stringArray[1].length(), stringArray[4], stringArray[5]);
                        if (nArray != null) {
                            if (stringArray[4] == null) {
                                Collector.addLineToOutputBuffer(Collector.obfuscateSubString(string2, nArray[0]), n, true, 0);
                                continue;
                            }
                            Collector.addLineToOutputBuffer(Collector.obfuscateSubString(string2, nArray[0] + stringArray[4].length(), nArray[1]), n, true, 0);
                            continue;
                        }
                        Collector.addLineToOutputBuffer(string2, n, false, 0);
                        continue;
                    }
                    Collector.addLineToOutputBuffer(string2, n, false, 0);
                }
                string2 = ((BufferedReader)object).readLine();
            }
            Collector.flushOutputBuffer(true, (BufferedWriter)var4_8);
            jos.closeEntry();
            if (!debug) return 1;
            Log.Both("Finished scanning and obfuscating file: " + vData);
            return 1;
        }
        catch (IOException iOException) {
            Log.Err(TraceNLS.getStringFromBundle(bundle, "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR", "WSST_ERR_COL_ERROR_READING_FILE_OR_WRITING_JAR"), iOException, false);
            Collector.clearFileScanBuffer();
            try {
                ((BufferedReader)object).close();
                Collector.flushOutputBuffer(true, (BufferedWriter)var4_8);
                jos.closeEntry();
                return 1;
            }
            catch (IOException iOException2) {}
        }
        return 1;
    }

    static int[] findStringMarkersAfterOrAroundMarker(String string, int n, int n2, String string2, String string3) {
        int[] nArray = null;
        String string4 = string.toLowerCase();
        int n3 = 0;
        int n4 = 0;
        if (string2 == null && string3 == null) {
            n3 = n + n2;
            n4 = string4.length();
        } else if (string2 != null && string3 == null) {
            n3 = string4.indexOf(string2, n + n2);
            if (n3 == -1 && n > 0) {
                n3 = string4.lastIndexOf(string2, n - 1);
            }
            n4 = string4.length();
        } else {
            int n5;
            n3 = string4.indexOf(string2, n + n2);
            if (n3 == -1 && n > 0) {
                n3 = string4.lastIndexOf(string2, n - 1);
            }
            if (n3 >= 0 && n3 + string2.length() < string4.length() && (n4 = string4.indexOf(string3, n3 + string2.length())) == -1 && n > 0 && string3.equals(string2) && (n5 = string4.lastIndexOf(string2, n - 1)) >= 0) {
                n4 = n3;
                n3 = n5;
            }
        }
        if (n3 >= 0 && n4 > n3 + 1) {
            nArray = new int[]{n3, n4};
        }
        return nArray;
    }

    static String addLineToFileScanBuffer(String string, int n, String string2, String string3) throws NullPointerException {
        int n2 = string2.length();
        int n3 = string3.length();
        String string4 = null;
        if (n2 > 0 && n3 > 0) {
            boolean bl = true;
            String string5 = string.trim();
            if (string5.length() == 0) {
                bl = false;
            } else if (string5.startsWith(string2) && string5.endsWith(string3)) {
                boolean bl2 = bl = !Collector.isMarkerOrderCorrect(string5, string2, string3);
            }
            if (bl) {
                if (fileLines == null) {
                    fileLines = new Vector();
                    fileLineNumbers = new Vector();
                }
                fileLines.add(string);
                fileLineNumbers.add(new Integer(n));
                if (string5.endsWith(string3)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator iterator = fileLines.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append((String)iterator.next());
                    }
                    if (Collector.isMarkerOrderCorrect(stringBuffer.toString(), string2, string3)) {
                        fileLines.clear();
                        fileLineNumbers.clear();
                    }
                }
            } else {
                string4 = string;
            }
        }
        return string4;
    }

    static void addLineToOutputBuffer(String string, int n, boolean bl, int n2) {
        if (string != null) {
            Integer n3;
            if (n2 == 0) {
                n2 = string.length();
            }
            if (outputLines == null) {
                outputLines = new HashMap();
                lastOutputLine = -1;
            }
            if (outputLines.containsKey(n3 = new Integer(n))) {
                Object[] objectArray = (Object[])outputLines.get(n3);
                if (objectArray != null) {
                    String string2 = (String)objectArray[0];
                    boolean bl2 = (Boolean)objectArray[1];
                    if (bl) {
                        if (!bl2) {
                            outputLines.put(n3, new Object[]{string, new Boolean(bl)});
                            outputLinesLength += n2 - string2.length();
                        } else if (string.lastIndexOf(42) - string.indexOf(42) > string2.lastIndexOf(42) - string2.indexOf(42)) {
                            outputLines.put(n3, new Object[]{string, new Boolean(bl)});
                            outputLinesLength += n2 - string2.length();
                        }
                    }
                }
            } else {
                outputLines.put(n3, new Object[]{string, new Boolean(bl)});
                if (n > lastOutputLine) {
                    lastOutputLine = n;
                }
                if (lastOutputLine != outputLines.size() - 1) {
                    Log.Both("TZ: Added line out of order. Added line " + n + ", total lines is " + outputLines.size());
                }
                outputLinesLength += n2;
            }
        }
    }

    static void clearFileScanBuffer() {
        if (fileLines != null) {
            fileLines.clear();
        }
        if (fileLineNumbers != null) {
            fileLineNumbers.clear();
        }
    }

    static void flushOutputBuffer(boolean bl, BufferedWriter bufferedWriter) {
        if (outputLines == null || outputLines.size() == 0) {
            return;
        }
        if (bl || outputLinesLength >= 1024 && (fileLines == null || fileLines.size() == 0)) {
            if (outputLines == null && lastOutputLine != -1 || lastOutputLine + 1 != outputLines.size()) {
                Log.Both("TZ: The size of buffer and last line don't match: " + lastOutputLine + " : " + (outputLines != null ? outputLines.size() : 0));
            }
            int n = 0;
            for (int i = 0; i <= lastOutputLine; ++i) {
                Object v = outputLines.get(i);
                if (v != null) {
                    try {
                        bufferedWriter.write((String)((Object[])v)[0]);
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        Log.Both("An exception caught while writing the output buffer to jar file.");
                        iOException.printStackTrace();
                    }
                    n += (Boolean)((Object[])v)[1] != false ? 1 : 0;
                    continue;
                }
                Log.Both("The output buffer is missing line " + i);
            }
            if (debug) {
                Log.Both(vData + " : obfuscated lines: " + n);
            }
            try {
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                Log.Both("An exception caught while flushing output buffer stream.");
                iOException.printStackTrace();
            }
            outputLines.clear();
            lastOutputLine = -1;
            outputLinesLength = 0;
        }
    }

    static boolean isMarkerOrderCorrect(String string, String string2, String string3) {
        boolean bl = false;
        int n = string.length();
        int n2 = string2.length();
        int n3 = string3.length();
        if (n == 0) {
            bl = true;
        } else if (n2 != 0 && n3 != 0) {
            int n4;
            int[] nArray = new int[n];
            int n5 = 0;
            while ((n5 = string.indexOf(string2, n5)) >= 0) {
                nArray[n5] = 1;
                if ((n5 += n2) < n) continue;
            }
            n5 = 0;
            while ((n5 = string.indexOf(string3, n5)) >= 0) {
                nArray[n5] = -1;
                if ((n5 += n3) < n) continue;
            }
            n5 = 0;
            for (n4 = 0; n4 >= 0 && n5 < nArray.length; n4 += nArray[n5++]) {
            }
            bl = n4 == 0;
        }
        return bl;
    }

    static String obfuscateSubString(String string, int n) {
        try {
            return Collector.obfuscateSubString(string, n, string.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (debug) {
                System.out.println("StringIndexOutOfBoundsException");
                System.out.println("line.length: " + string.length() + " line: " + string);
                System.out.println("x: " + n + " y: " + string.length());
            }
            throw stringIndexOutOfBoundsException;
        }
    }

    static String obfuscateSubString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        for (int i = 0; i < n2 - n; ++i) {
            stringBuffer.append('*');
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    static void resolveExcludedFiles() {
        if (vData != null && vData.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(vData, ";");
            int n = stringTokenizer.countTokens();
            if (n >= 4) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                stringTokenizer = new StringTokenizer(string3, OBFUSCATION_MARKERS_DELIMITER);
                String[] stringArray = new String[stringTokenizer.countTokens()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
                stringTokenizer = new StringTokenizer(string4, OBFUSCATION_MARKERS_DELIMITER);
                String[] stringArray2 = new String[2];
                stringArray2[0] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                String string5 = stringArray2[1] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                if (stringArray.length == 0 || stringArray2[0] == null) {
                    Log.Both("No keywords and no markers set for excluded files lookup in request: " + vData);
                    return;
                }
                Vector vector = Collector.findFilesUnderDirectory(string, string2);
                if (vector != null && vector.size() > 0) {
                    BufferedReader bufferedReader = null;
                    String string6 = null;
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        string6 = (String)iterator.next();
                        try {
                            bufferedReader = new BufferedReader(new FileReader(string6), 0x100000);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Log.Both("Can not open file " + string6);
                            bufferedReader = null;
                        }
                        if (bufferedReader == null) continue;
                        try {
                            String string7 = null;
                            String string8 = null;
                            String string9 = bufferedReader.readLine();
                            while (string9 != null) {
                                int[] nArray;
                                int n2;
                                string7 = string9.toLowerCase();
                                string8 = null;
                                int n3 = 0;
                                for (n2 = 0; n2 < stringArray.length; ++n2) {
                                    n3 += string7.contains(stringArray[n2].toLowerCase()) ? 1 : 0;
                                }
                                if (n3 == stringArray.length && (n2 = string7.indexOf(stringArray2[0].toLowerCase())) != -1 && (nArray = Collector.findStringMarkersAfterOrAroundMarker(string9, 0, 0, stringArray2[0], stringArray2[1])) != null) {
                                    Comparable<StringBuffer> comparable;
                                    string8 = string9.substring(nArray[0] + stringArray2[0].length(), nArray[1]);
                                    if (string8.contains("${USER_INSTALL_ROOT}")) {
                                        comparable = new StringBuffer(string8);
                                        ((StringBuffer)comparable).replace(0, "${USER_INSTALL_ROOT}".length(), userInstallRoot);
                                        string8 = ((StringBuffer)comparable).toString();
                                    } else if (string8.contains("${WAS_INSTALL_ROOT}")) {
                                        comparable = new StringBuffer(string8);
                                        ((StringBuffer)comparable).replace(0, "${WAS_INSTALL_ROOT}".length(), installDirectory);
                                        string8 = ((StringBuffer)comparable).toString();
                                    } else if (string8.contains("${CONFIG_ROOT}")) {
                                        comparable = new StringBuffer(string8);
                                        ((StringBuffer)comparable).replace(0, "${CONFIG_ROOT}".length(), configDirectory);
                                        string8 = ((StringBuffer)comparable).toString();
                                    } else if (string8.contains("${APP_INSTALL_ROOT}")) {
                                        comparable = new StringBuffer(string8);
                                        ((StringBuffer)comparable).replace(0, "${APP_INSTALL_ROOT}".length(), appInstallRoot);
                                        string8 = ((StringBuffer)comparable).toString();
                                    } else if (string8.contains("${WAS_PROPS_DIR}")) {
                                        comparable = new StringBuffer(string8);
                                        ((StringBuffer)comparable).replace(0, "${WAS_PROPS_DIR}".length(), wasPropsDir);
                                        string8 = ((StringBuffer)comparable).toString();
                                    }
                                    comparable = new File(string8);
                                    if (((File)comparable).exists()) {
                                        if (excludedFileNames == null) {
                                            excludedFileNames = new Vector();
                                        }
                                        excludedFileNames.add(((File)comparable).getCanonicalPath());
                                    }
                                }
                                string9 = bufferedReader.readLine();
                            }
                        }
                        catch (IOException iOException) {
                            Log.Both("Can not read file" + string6);
                            iOException.printStackTrace();
                        }
                    }
                }
            } else {
                Log.Both("Invalid request received, wrong number of elements: " + vData);
            }
        }
    }

    static Vector findFilesUnderDirectory(String string, String string2) {
        Vector vector = null;
        File file = null;
        if (string != null && string.length() > 0) {
            file = new File(string);
        }
        if (file.exists() && file.isDirectory()) {
            try {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string3 = fileArray[i].getCanonicalPath();
                    if (fileArray[i].isDirectory()) {
                        Vector vector2 = Collector.findFilesUnderDirectory(string3, string2);
                        if (vector2 == null || vector2.size() <= 0) continue;
                        if (vector == null) {
                            vector = new Vector();
                        }
                        Iterator iterator = vector2.iterator();
                        while (iterator.hasNext()) {
                            vector.add(iterator.next());
                        }
                        continue;
                    }
                    if (!fileArray[i].exists() || !fileArray[i].isFile() || !string3.endsWith(string2)) continue;
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(string3);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return vector;
    }

    static {
        logRoot = null;
        mQRoot = null;
        wasPropsDir = null;
        appInstallRoot = null;
        serviceLogName = null;
        traceLogName = null;
        userInstallRoot = null;
        repository = null;
        logFileName = null;
        summary = false;
        noSamples = false;
        includeInstalledApps = false;
        exitRC = 0;
        macros = new Hashtable();
        objectsGathered = 0;
        jos = null;
        jarFile = null;
        hostName = null;
        serverType = null;
        jarName = null;
        bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";
        fileSep = System.getProperty("file.separator");
        obfuscationMarkers = null;
        filesToSecure = null;
        fileLines = null;
        fileLineNumbers = null;
        outputLines = null;
        lastOutputLine = -1;
        outputLinesLength = 0;
        is = null;
        correctPlatform = true;
        lineCount = new int[]{0};
    }
}

