/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

class ExecCmd
extends Thread {
    final String errPrefix = "Error in ExecCmd.class -- ";
    BufferedReader stdxxx;
    Vector vLines;
    boolean fPrintLine;
    String linePf;
    boolean adjustCmd;
    static String bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";

    ExecCmd() {
        this.adjustCmd = false;
    }

    ExecCmd(boolean bl) {
        this.adjustCmd = bl;
    }

    ExecCmd(BufferedReader bufferedReader, boolean bl, String string, Vector vector) {
        this.stdxxx = bufferedReader;
        this.vLines = vector;
        this.fPrintLine = bl;
        this.linePf = string;
    }

    int Execute(String string, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        return this.launch(string, null, bl, bl2, stringBuffer, vector);
    }

    int Execute(String[] stringArray, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        return this.launch(null, stringArray, bl, bl2, stringBuffer, vector);
    }

    protected int launch(String string, String[] stringArray, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        return this.launchCommand(string, stringArray, bl, bl2, stringBuffer, vector);
    }

    protected boolean isCaseSensitive() {
        String string = System.getProperty("os.name");
        if (string.equals("Windows NT")) {
            return false;
        }
        if (string.equals("Windows 2000")) {
            return false;
        }
        if (string.equals("Windows XP")) {
            return false;
        }
        if (string.startsWith("Windows ")) {
            return false;
        }
        if (string.equals("OS/400")) {
            return false;
        }
        if (string.equals("OS/2")) {
            return false;
        }
        if (string.equals("Linux")) {
            return true;
        }
        if (string.equals("Solaris")) {
            return true;
        }
        if (string.equals("SunOS")) {
            return true;
        }
        if (string.equals("AIX")) {
            return true;
        }
        if (string.equals("HP-UX")) {
            return true;
        }
        System.err.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_EXC_WEIRD_OS_NAME", new Object[]{"ExecCmd.class", " ", string}, "WSST_ERR_EXC_WEIRD_OS_NAME"));
        return true;
    }

    public void run() {
        try {
            String string;
            while ((string = this.stdxxx.readLine()) != null) {
                if (this.linePf != null) {
                    string = this.linePf.concat(string);
                }
                if (this.vLines != null) {
                    this.vLines.addElement(string);
                }
                if (!this.fPrintLine) continue;
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error in ExecCmd.class -- IOException reading Stdxxx " + iOException.getMessage());
        }
    }

    protected int launchCommand(String string, String[] stringArray, boolean bl, boolean bl2, StringBuffer stringBuffer, Vector vector) {
        Object object;
        if (!System.getProperty("os.name").equals("OS/400") && this.adjustCmd && !this.isCaseSensitive()) {
            int n;
            String[] stringArray2;
            if (string != null) {
                stringArray2 = new StringTokenizer(string);
                stringArray = new String[stringArray2.countTokens()];
                n = 0;
                while (stringArray2.hasMoreTokens()) {
                    stringArray[n++] = stringArray2.nextToken();
                }
            }
            stringArray2 = new String[stringArray.length + 2];
            stringArray2[0] = "CMD.EXE";
            stringArray2[1] = "/C";
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n + 2] = stringArray[n];
            }
            stringArray = stringArray2;
        }
        int n = 0;
        ListenerThread listenerThread = null;
        ListenerThread listenerThread2 = null;
        try {
            object = Runtime.getRuntime().exec(stringArray);
            listenerThread = new ListenerThread(((Process)object).getInputStream(), "");
            listenerThread2 = new ListenerThread(((Process)object).getErrorStream(), "StdErr: ");
            listenerThread.start();
            listenerThread2.start();
            n = ((Process)object).waitFor();
        }
        catch (Exception exception) {
            stringBuffer.append(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_EXC_RUNTIME_CREATE_IOEXCEPTION", new Object[]{"ExecCmd.class", "RunTime()", exception.getMessage()}, "WSST_ERR_EXC_RUNTIME_CREATE_IOEXCEPTION"));
        }
        object = System.getProperty("char.encoding");
        String string2 = null;
        if (listenerThread != null) {
            string2 = listenerThread.toString((String)object);
        }
        if (string2 != null) {
            if (bl) {
                System.out.println(string2);
            }
            vector.add(string2);
        }
        string2 = null;
        if (listenerThread2 != null) {
            string2 = listenerThread2.toString((String)object);
        }
        if (string2 != null) {
            if (bl2) {
                System.out.println(string2);
            }
            vector.add(string2);
        }
        return n;
    }

    private static class ListenerThread
    extends Thread {
        private final int buffer_size = 2048;
        private final InputStream is;
        private final String prefix;
        private final ByteArrayOutputStream os = new ByteArrayOutputStream(2048);

        ListenerThread(InputStream inputStream, String string) {
            this.is = inputStream;
            this.prefix = string;
        }

        public void run() {
            try {
                int n = 0;
                byte[] byArray = new byte[2048];
                while ((n = this.is.read(byArray)) > 0) {
                    this.os.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString(String string) {
            String string2 = null;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            if (this.os.size() > 0) {
                string2 = this.prefix;
                if (string == null) {
                    string2.concat(this.os.toString());
                } else {
                    try {
                        string2.concat(this.os.toString(string));
                    }
                    catch (Exception exception) {
                        string2.concat(this.os.toString());
                    }
                }
            }
            return string2;
        }
    }
}

