/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rastools.collector;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.rastools.collector.Collector;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

class Logger {
    static final String crlf = System.getProperty("line.separator");
    protected static final int v0 = 0;
    protected static final int v1 = 1;
    protected static final int v2 = 2;
    protected static final int v3 = 3;
    protected static final int v4 = 4;
    protected static final int v5 = 5;
    static int errorCount = 0;
    protected String logFileName;
    protected boolean appendFlag;
    protected PrintWriter logWriter;
    protected PrintStream systemWriter;
    protected int verbosity;
    static String bundle = "com.ibm.websphere.rastools.collector.CollectorMessages";

    Logger(String string, boolean bl) {
        this.logFileName = string;
        this.appendFlag = bl;
        this.verbosity = 9;
        this.logWriter = null;
        this.systemWriter = System.out;
    }

    Logger(String string, boolean bl, int n) {
        this.logFileName = string;
        this.appendFlag = bl;
        this.verbosity = n;
        this.logWriter = null;
        this.systemWriter = System.out;
    }

    boolean Open() {
        if (this.logFileName == null) {
            return false;
        }
        if (this.logWriter != null) {
            this.systemWriter.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_LOG_FILE_DOUBLE_OPEN", new Object[]{this.CurrentTimeStamp(), this.logFileName}, "WSST_ERR_LOG_FILE_DOUBLE_OPEN"));
            return true;
        }
        try {
            this.logWriter = new PrintWriter(new FileWriter(this.logFileName, this.appendFlag));
        }
        catch (IOException iOException) {
            this.systemWriter.println(TraceNLS.getFormattedMessage(bundle, "WSST_ERR_LOG_FILE_CANT_OPEN", new Object[]{this.CurrentTimeStamp(), this.logFileName, iOException.getMessage()}, "WSST_ERR_LOG_FILE_CANT_OPEN"));
            return false;
        }
        return true;
    }

    void Close() {
        if (this.logWriter != null) {
            this.logWriter.close();
            this.logWriter = null;
        }
    }

    void Err(String string) {
        this.Both(string);
        ++errorCount;
    }

    void Err(String string, boolean bl) {
        this.Both(string);
        ++errorCount;
        if (!bl) {
            return;
        }
        this.Close();
        Collector.closeJarStream();
        System.exit(8);
    }

    void Err(String string, Exception exception) {
        this.Both(string + " : " + exception.getMessage());
        ++errorCount;
    }

    void Err(String string, Throwable throwable) {
        this.Both(string + " : " + throwable.getMessage());
        ++errorCount;
    }

    void Err(String string, Exception exception, boolean bl) {
        this.Both(string + " : " + exception.getMessage());
        ++errorCount;
        if (!bl) {
            return;
        }
        this.Close();
        Collector.closeJarStream();
        System.exit(8);
    }

    void Log(String string) {
        if (this.logWriter != null) {
            this.logWriter.write(this.CurrentTimeStamp() + string + crlf);
        }
    }

    void LogRaw(String string) {
        if (this.logWriter != null) {
            this.logWriter.write(string + crlf);
        }
    }

    void Log(int n, String string) {
        if (this.logWriter != null && n <= this.verbosity) {
            this.logWriter.write(this.CurrentTimeStamp() + string + crlf);
        }
    }

    void Log(String string, DataOutputStream dataOutputStream) {
        if (this.logWriter != null) {
            this.logWriter.write(this.CurrentTimeStamp() + string + crlf);
        }
        this.SomeWhere(string, dataOutputStream);
    }

    void Both(String string) {
        String string2 = this.CurrentTimeStamp();
        this.systemWriter.println(string2 + string);
        if (this.logWriter != null) {
            this.logWriter.write(string2 + string + crlf);
        }
    }

    void BothRaw(String string) {
        this.systemWriter.println(string);
        if (this.logWriter != null) {
            this.logWriter.write(string + crlf);
        }
    }

    void Both(int n, String string) {
        if (n <= this.verbosity) {
            String string2 = this.CurrentTimeStamp();
            this.systemWriter.println(string2 + string);
            if (this.logWriter != null) {
                this.logWriter.write(string2 + string + crlf);
            }
        }
    }

    void Both(String string, DataOutputStream dataOutputStream) {
        String string2 = this.CurrentTimeStamp();
        this.systemWriter.println(string2 + string);
        if (this.logWriter != null) {
            this.logWriter.write(string2 + string + crlf);
        }
        this.SomeWhere(string, dataOutputStream);
    }

    void Screen(String string) {
        this.systemWriter.println(this.CurrentTimeStamp() + string);
    }

    void ScreenRaw(String string) {
        this.systemWriter.println(string);
    }

    void Screen(int n, String string) {
        if (n <= this.verbosity) {
            this.systemWriter.println(this.CurrentTimeStamp() + string);
        }
    }

    void Screen(String string, DataOutputStream dataOutputStream) {
        this.systemWriter.println(this.CurrentTimeStamp() + string);
        this.SomeWhere(string, dataOutputStream);
    }

    String CurrentTimeStamp() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(date) + " ";
    }

    void SomeWhere(String string, DataOutputStream dataOutputStream) {
        block3: {
            if (dataOutputStream == null) {
                return;
            }
            try {
                dataOutputStream.writeUTF(string);
            }
            catch (IOException iOException) {
                String string2 = TraceNLS.getFormattedMessage(bundle, "WSST_ERR_LOG_FILE_IOEXCEPTION", new Object[]{this.CurrentTimeStamp(), iOException.getMessage()}, "WSST_ERR_LOG_FILE_IOEXCEPTION");
                this.systemWriter.println(string2);
                if (this.logWriter == null) break block3;
                this.logWriter.write(string2 + crlf);
            }
        }
    }

    void Log(Throwable throwable) {
        throwable.printStackTrace(this.logWriter);
    }
}

