/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.scripting.launcherHelper;

import com.ibm.websphere.scripting.launcherHelper.ScriptingLauncherHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ScriptingLauncherHelperFactory {
    private static final String PROPERTY_WS_EXT_DIRS = "com.ibm.websphere.scripting.launcher.extDirs";
    private static final String PROPERTY_CLASSPATH = "com.ibm.websphere.scripting.launcher.classPath";
    private static final String PROPERTY_JAVA_LIBRARY_PATH = "com.ibm.websphere.scripting.launcher.javalibrarypath";
    private static final String PROPERTY_OTHERS = "com.ibm.websphere.scripting.launcher.others";
    private static final String PROPERTY_JYTHON_PATH = "com.ibm.websphere.scripting.launcher.jythonPath";
    private static final String VARIABLE_WASHOME = "\\$\\{WAS_ROOT\\}";
    private static final String VARIABLE_USERHOME = "\\$\\{USER_ROOT\\}";

    private static void trace(String string) {
        System.out.println("ScriptingLauncherHelperFactory - " + string);
    }

    static void getPropertiesFromFile(String string, Properties properties) throws IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        InputStream inputStream = null;
        if (uRL != null) {
            try {
                inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            String string2 = "File not found: " + string;
            ScriptingLauncherHelperFactory.trace(string2);
            throw new RuntimeException(string2);
        }
    }

    private static List getProperties(String string, String string2, Properties properties) {
        String string3;
        String string4 = string2 + ".";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string3 = (String)properties.get(string4 + n)) != null) {
            if (!(string3 = string3.replace('\\', '/')).startsWith("/")) {
                string3 = "/" + string3;
            }
            string3 = string + string3;
            arrayList.add(string3.replace('/', File.separatorChar));
            ++n;
        }
        return arrayList;
    }

    private static String getProperty(String string, String string2, Properties properties) {
        String string3;
        String string4 = string2 + ".";
        String string5 = null;
        int n = 1;
        while (true) {
            string3 = (String)properties.get(string4 + n);
            if (!(string3 = string3.replace('\\', '/')).startsWith("/")) {
                string3 = "/" + string3;
            }
            string3 = string + string3;
            boolean bl = new File(string3 = string3.replace('/', File.separatorChar)).exists();
            if (bl) break;
            ++n;
        }
        string5 = string3;
        return string5;
    }

    public static String doSubstitutions(String string, String string2) {
        return ScriptingLauncherHelperFactory.doSubstitutions(string, string, string2);
    }

    public static String doSubstitutions(String string, String string2, String string3) {
        string3 = string3.replaceAll(VARIABLE_WASHOME, string);
        string3 = string3.replaceAll(VARIABLE_USERHOME, string2);
        return string3;
    }

    private static List getOthersProperties(String string, String string2, String string3, Properties properties) {
        String string4;
        String string5 = string3 + ".";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string4 = (String)properties.get(string5 + n)) != null) {
            string4 = ScriptingLauncherHelperFactory.doSubstitutions(string, string2, string4);
            arrayList.add(string4);
            ++n;
        }
        return arrayList;
    }

    public static ScriptingLauncherHelper getScriptingLauncherHelper(String string, String string2) throws FileNotFoundException, IOException {
        return new ScriptingLauncherHelperImpl(string, string2);
    }

    public static class ScriptingLauncherHelperImpl
    implements ScriptingLauncherHelper {
        private String _wasHome;
        private String _profileHome;
        private String _fileName;
        private Properties _properties = new Properties();
        private static final String MAIN_CLASS_NAME = "com.ibm.wsspi.bootstrap.WSPreLauncher";
        private static final String[] PROGRAM_ARGUMENTS = new String[]{"-nosplash", "-application", "com.ibm.ws.bootstrap.WSLauncher", "com.ibm.ws.runtime.WsAdmin"};
        private static final String DEFAULT_PROPERTIES_FILE_NAME = "com/ibm/websphere/scripting/launcherHelper/ScriptingLauncherHelper.properties";

        ScriptingLauncherHelperImpl(String string, String string2) throws FileNotFoundException, IOException {
            this._wasHome = string.replace('\\', '/');
            this._profileHome = string2.replace('\\', '/');
            ScriptingLauncherHelperFactory.getPropertiesFromFile(DEFAULT_PROPERTIES_FILE_NAME, this._properties);
        }

        public String[] getWSExtDirs() {
            List list = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_WS_EXT_DIRS, this._properties);
            return list.toArray(new String[list.size()]);
        }

        public String getJavaLibraryPath() {
            List list = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_JAVA_LIBRARY_PATH, this._properties);
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (!list.isEmpty()) {
                stringBuffer.append(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    stringBuffer.append(File.pathSeparatorChar).append(string2);
                }
                if (System.getProperty("java.library.path") != null) {
                    stringBuffer.append(File.pathSeparatorChar).append(System.getProperty("java.library.path").replaceAll("\"", ""));
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public String getMainClassName() {
            return MAIN_CLASS_NAME;
        }

        public String[] getProgramArguments() {
            return PROGRAM_ARGUMENTS;
        }

        public String[] getOthers() {
            List list = ScriptingLauncherHelperFactory.getOthersProperties(this._wasHome, this._profileHome, ScriptingLauncherHelperFactory.PROPERTY_OTHERS, this._properties);
            return list.toArray(new String[list.size()]);
        }

        public String getJythonPath() {
            String string = ScriptingLauncherHelperFactory.getProperty(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_JYTHON_PATH, this._properties);
            return string;
        }

        public String[] getClasspath() {
            String string;
            List list = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_CLASSPATH, this._properties);
            if (!this._wasHome.equals(this._profileHome)) {
                string = this._profileHome.replace('/', File.separatorChar) + File.separatorChar + "properties";
                list.add(0, string);
            }
            if ((string = this.getJythonPath()) != null) {
                list.add(0, string);
            }
            return list.toArray(new String[list.size()]);
        }

        public String getWasInstallRoot() {
            return this._wasHome;
        }

        public String getUserInstallRoot() {
            return this._profileHome;
        }

        public String getWasRepositoryRoot() {
            String string = this._profileHome + File.separatorChar + "config";
            return string;
        }

        public String getOSGIInstall() {
            return this._wasHome;
        }

        public String getOSGIConfig() {
            String string = this._profileHome + File.separatorChar + "configuration";
            return string;
        }

        public String getIbmItpLocation() {
            String string = this._wasHome + File.separatorChar + "bin";
            return string;
        }

        public String getClientSOAPPath() {
            String string = "file:" + this._profileHome + "properties" + File.separatorChar + "soap.client.props";
            return string;
        }

        public String getClientSASPath() {
            String string = "file:" + this._profileHome + "properties" + File.separatorChar + "sas.client.props";
            return string;
        }

        public String getJythonLibPath() {
            String string = this._wasHome + File.separatorChar + "optionalLibraries" + File.separatorChar + "jython" + File.separatorChar + "Lib";
            return string;
        }

        public String getWsadminLibraryPath() {
            String string = new String();
            String string2 = System.getProperty("wsadmin.library");
            if (string2 == "" || string2 == null) {
                String string3 = System.getenv("WAS_WSADMIN_LIBRARY");
                if (string3 == "" || string3 == null) {
                    String string4 = this._wasHome + File.separatorChar + "optionalLibraries" + File.separatorChar + "scriptLibraries";
                    boolean bl = new File(string4).exists();
                    if (bl) {
                        string = string4;
                    }
                } else {
                    string = string3;
                }
            } else {
                string = string2;
            }
            return string;
        }

        public String getWsadminLibVMArg() {
            String string = new String();
            String string2 = this.getWsadminLibraryPath();
            if (string2 != "") {
                string = "-Dwsadmin.library=" + string2;
            }
            return string;
        }
    }
}

