/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.cache.Cache;
import com.ibm.websphere.servlet.cache.InvalidationMessage;
import com.ibm.websphere.servlet.cache.RemoteInvalidatorHelper;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class InvalidationDaemon
implements AlarmListener {
    Map queuedInvalidations = new HashMap();
    private static TraceComponent tc = Tr.register(InvalidationDaemon.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    long invalidationProcessingDelay = this.getInvalidationProcessingDelay();
    private boolean isProcessAllCacheInstances;
    private boolean isInitialized = false;

    public InvalidationDaemon() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidationProcessingDelay: " + this.invalidationProcessingDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(boolean bl) {
        Map map = this.queuedInvalidations;
        synchronized (map) {
            if (!this.isInitialized) {
                this.isProcessAllCacheInstances = bl;
                this.isInitialized = true;
                this.createInvalidationProcessingAlarm();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "initialized successfully");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "already initialized");
            }
        }
    }

    private long getInvalidationProcessingDelay() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.invProcessingDelay", System.getProperties());
        long l = 20000L;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "inv processing delay val=" + string);
            }
            try {
                l = Long.parseLong(string) * 1000L;
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.invProcessingDelay", String.valueOf(l)});
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error processing delay val=" + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)new IllegalArgumentException("invalid invalidation processing delay value: " + string), this.getClass().getName() + ".getInvalidationProcessingDelay()", "777", this);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeInvalidations(InvalidationMessage invalidationMessage) {
        Map map = this.queuedInvalidations;
        synchronized (map) {
            HashSet hashSet = (HashSet)this.queuedInvalidations.get(invalidationMessage.getCacheInstanceName());
            if (hashSet == null) {
                hashSet = new HashSet();
                this.queuedInvalidations.put(invalidationMessage.getCacheInstanceName(), hashSet);
            }
            hashSet.addAll(invalidationMessage.getInvalidationIDs());
            if (tc.isDebugEnabled()) {
                for (String string : hashSet) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "stored id: " + string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        block7: {
            HashMap hashMap = null;
            try {
                Map map = this.queuedInvalidations;
                synchronized (map) {
                    if (!this.queuedInvalidations.isEmpty()) {
                        hashMap = new HashMap(this.queuedInvalidations);
                        this.queuedInvalidations.clear();
                    }
                }
                if (hashMap != null) {
                    this.processQueuedInvalidations(hashMap);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".alarm()", "454", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Problems processing invalidations: " + exception.getMessage());
            }
        }
        this.createInvalidationProcessingAlarm();
    }

    private void createInvalidationProcessingAlarm() {
        AlarmManager.createNonDeferrable(this.invalidationProcessingDelay, this);
    }

    private void processQueuedInvalidations(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processQueuedInvalidations");
        }
        if (this.isProcessAllCacheInstances) {
            Set set = this.combineInvalidations(map);
            HashSet<String> hashSet = new HashSet<String>(ServerCache.getServletCacheInstanceNames());
            hashSet.add("baseCache");
            for (String string : hashSet) {
                DCache dCache;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cache instance: " + string);
                }
                if ((dCache = ServerCache.getConfiguredCache(string)) == null) continue;
                this.processInvalidations(dCache, set);
            }
        } else {
            for (String string : map.keySet()) {
                DCache dCache = ServerCache.getConfiguredCache(string);
                if (dCache != null) {
                    this.processInvalidations(dCache, (Set)map.get(string));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "no cache instance exists for: " + dCache);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processQueuedInvalidations");
        }
    }

    private void processInvalidations(Cache cache, Set set) {
        block4: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidating " + set.size() + " invalidations");
            }
            try {
                for (String string : set) {
                    cache.invalidateById(string, false);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "invalidated id: " + string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "problems invalidating cache instance: " + exception.getMessage());
            }
        }
    }

    private Set combineInvalidations(Map map) {
        HashSet hashSet = new HashSet();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Collection)iterator.next());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Map map = this.queuedInvalidations;
        synchronized (map) {
            return this.isInitialized;
        }
    }
}

