/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.GenericMessage;
import com.ibm.websphere.servlet.cache.InvalidationDaemon;
import com.ibm.websphere.servlet.cache.InvalidationMessage;
import com.ibm.websphere.servlet.cache.RemoteInvalidator;
import com.ibm.websphere.servlet.cache.RemoteInvalidatorHelper;
import com.ibm.websphere.servlet.cache.TemplateInvalidationMessage;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashSet;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

public class JMSMessageProcessor
implements MessageDrivenBean,
MessageListener {
    private static TraceComponent tc = Tr.register(JMSMessageProcessor.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final long serialVersionUID = -6699831982060907655L;
    private transient MessageDrivenContext mdContext;
    private static boolean isProcessAllCacheInstances;
    private static InvalidationDaemon invalidationDaemon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSMessageProcessor() {
        RemoteInvalidator.setEJBMessageProcessorActive();
        InvalidationDaemon invalidationDaemon = JMSMessageProcessor.invalidationDaemon;
        synchronized (invalidationDaemon) {
            if (!JMSMessageProcessor.invalidationDaemon.isInitialized()) {
                isProcessAllCacheInstances = this.isProcessAllCacheInstancesVal();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isProcessAllCacheInstances: " + isProcessAllCacheInstances);
                }
                JMSMessageProcessor.invalidationDaemon.initialize(isProcessAllCacheInstances);
            }
        }
    }

    private boolean isProcessAllCacheInstancesVal() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.cacheInstance", System.getProperties());
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cache instances val=" + string);
            }
            if (string.equalsIgnoreCase("*")) {
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.cacheInstance", string});
                }
                return true;
            }
            if (tc.isInfoEnabled()) {
                Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.cacheInstance", string});
            }
        }
        return false;
    }

    public MessageDrivenContext getMessageDrivenContext() {
        return this.mdContext;
    }

    public void ejbCreate() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbCreate");
        }
    }

    public void ejbRemove() throws EJBException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbRemove");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.mdContext = messageDrivenContext;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMessageDrivenContext");
        }
    }

    public void onMessage(Message message) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onMessage");
        }
        if (message instanceof ObjectMessage) {
            try {
                GenericMessage genericMessage;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received msg id: " + ((ObjectMessage)message).getJMSMessageID());
                }
                if ((genericMessage = (GenericMessage)((ObjectMessage)message).getObject()).getMsgType().equals(RemoteInvalidatorHelper.INVALIDATIONS)) {
                    InvalidationMessage invalidationMessage = (InvalidationMessage)genericMessage;
                    invalidationDaemon.storeInvalidations(invalidationMessage);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, invalidationMessage.getCacheInstanceName() + ": num invalidations stored: " + invalidationMessage.getInvalidationIDs().size());
                    }
                } else if (genericMessage.getMsgType().equals(RemoteInvalidatorHelper.CLEAR)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "received clear msg");
                    }
                    this.processGroupInvalidations(true, genericMessage);
                } else if (genericMessage.getMsgType().equals(RemoteInvalidatorHelper.TEMPLATE_INVALIDATION)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "received template invalidation msg");
                    }
                    this.processGroupInvalidations(false, genericMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unknown msg type: " + genericMessage.getMsgType());
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problems processing JMS msg: " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".omMessage()", "455", this);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received wrong JMS msg type");
        }
    }

    private void processGroupInvalidations(boolean bl, GenericMessage genericMessage) {
        if (isProcessAllCacheInstances) {
            HashSet<String> hashSet = new HashSet<String>(ServerCache.getServletCacheInstanceNames());
            hashSet.add("baseCache");
            for (String string : hashSet) {
                DCache dCache;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cache instance: " + string);
                }
                if ((dCache = ServerCache.getConfiguredCache(string)) == null) continue;
                if (bl) {
                    dCache.clear();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "cleared cache instance: " + string);
                    continue;
                }
                dCache.invalidateByTemplate(((TemplateInvalidationMessage)genericMessage).getTemplateName(), false);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "invalidated template: " + ((TemplateInvalidationMessage)genericMessage).getTemplateName());
            }
        } else {
            DCache dCache = ServerCache.getConfiguredCache("baseCache");
            if (dCache != null) {
                if (bl) {
                    dCache.clear();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cleared base cache");
                    }
                } else {
                    dCache.invalidateByTemplate(((TemplateInvalidationMessage)genericMessage).getTemplateName(), false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invalidated template: " + ((TemplateInvalidationMessage)genericMessage).getTemplateName());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "base cache instance is null");
            }
        }
    }

    static {
        invalidationDaemon = new InvalidationDaemon();
    }
}

