/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.servlet.cache.ClearMessage;
import com.ibm.websphere.servlet.cache.ExternalCacheAdapter;
import com.ibm.websphere.servlet.cache.GenericMessage;
import com.ibm.websphere.servlet.cache.InvalidationMessage;
import com.ibm.websphere.servlet.cache.RemoteInvalidatorHelper;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.websphere.servlet.cache.TemplateInvalidationMessage;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletResponse;

public class RemoteInvalidator
implements ExternalCacheAdapter,
AlarmListener {
    public static long MESSAGE_TIME_TO_LIVE = 300000L;
    public static boolean isJMSMessageProcessorActive;
    public static boolean isRemoteInvalidatorActive;
    public static Object activityLock;
    static final Object ALARM_ACTION_SEND_MESSAGES;
    static final Object ALARM_ACTION_RECONNECT;
    static final ClearMessage SINGLETON_CLEAR_MSG;
    private static TraceComponent tc;
    String connFactoryJNDIName;
    String queueJNDIName;
    boolean isConnectionActive = false;
    Session session;
    MessageProducer producer;
    Destination destination;
    Connection connection;
    List unSentMessagesQueue = new LinkedList();
    int maxNumberOfStoredMessages = this.getMaxAllowedStoredMessages();
    int numStoredInvalidations = 0;
    boolean isClearEnabled;
    long connRetryInterval;
    long msgSendDelay;

    public RemoteInvalidator() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Max stored messages set to: " + this.maxNumberOfStoredMessages);
        }
        this.isClearEnabled = this.isClearEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isClearEnabled set to: " + this.isClearEnabled);
        }
        this.connRetryInterval = this.getConnectionRetryInterval();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "connRetryInterval set to: " + this.connRetryInterval);
        }
        this.msgSendDelay = this.getMessageRetryInterval();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "msgSendDelay: " + this.msgSendDelay);
        }
        RemoteInvalidator.setRemoteInvalidatorActive();
        this.createMessageRetryAlarm();
    }

    private long getMessageRetryInterval() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.sendDelay", System.getProperties());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "msgretryval= " + string);
        }
        long l = RemoteInvalidatorHelper.DEFAULT_MESSAGE_SEND_DELAY;
        if (string != null) {
            try {
                l = Long.parseLong(string) * 1000L;
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.sendDelay", String.valueOf(l)});
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error w/ msgretryval: " + string + " " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)new WsException("invalid connretryval " + string + " specified for custom prop: " + "dynacache.jms.sendDelay", exception), this.getClass().getName() + ".getMessageRetryInterval()", "777", this);
            }
        }
        return l;
    }

    private long getConnectionRetryInterval() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.connRetryInterval", System.getProperties());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "connretryval= " + string);
        }
        long l = RemoteInvalidatorHelper.DEFAULT_CONNECTION_FAILURE_RETRY_INTERVAL;
        if (string != null) {
            try {
                l = Long.parseLong(string) * 1000L;
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.connRetryInterval", String.valueOf(l)});
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error w/ connretryval: " + string + " " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)new WsException("invalid connretryval " + string + " specified for custom prop: " + "dynacache.jms.connRetryInterval", exception), this.getClass().getName() + ".getConnectionRetryInterval()", "411", this);
            }
        }
        return l;
    }

    private boolean isClearEnabled() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.clearEnabled", System.getProperties());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isClear val= " + string);
        }
        boolean bl = true;
        if (string != null) {
            if (string.equalsIgnoreCase(Boolean.FALSE.toString())) {
                bl = false;
            }
            if (tc.isInfoEnabled()) {
                Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.clearEnabled", String.valueOf(string)});
            }
        }
        return bl;
    }

    private int getMaxAllowedStoredMessages() {
        String string = RemoteInvalidatorHelper.getCaseInsensitiveCustomProperty("dynacache.jms.numStoredInvalidations", System.getProperties());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "max stored msg val: " + string);
        }
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "DYNA1077I", new Object[]{"dynacache.jms.numStoredInvalidations", String.valueOf(n)});
                }
                return n;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error w/ custom prop val: " + string + " " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)new WsException("invalid val " + string + " specified for custom prop: " + "dynacache.jms.numStoredInvalidations", exception), this.getClass().getName() + ".getMaxAllowedStoredMessages()", "491", this);
                return 10000;
            }
        }
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMessage(GenericMessage genericMessage) {
        List list = this.unSentMessagesQueue;
        synchronized (list) {
            GenericMessage genericMessage2;
            if (genericMessage.getMsgType().equals(RemoteInvalidatorHelper.INVALIDATIONS)) {
                genericMessage2 = (InvalidationMessage)genericMessage;
                this.numStoredInvalidations += ((InvalidationMessage)genericMessage2).getInvalidationIDs().size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.numStoredInvalidations + ": Added invalidations: Following # of invalidations stored: " + ((InvalidationMessage)genericMessage2).getInvalidationIDs().size());
                }
            } else {
                ++this.numStoredInvalidations;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.numStoredInvalidations + " :Stored msg: " + genericMessage);
                }
            }
            this.unSentMessagesQueue.add(genericMessage);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "# of msgs stored=" + this.unSentMessagesQueue.size());
            }
            while (this.numStoredInvalidations > this.maxNumberOfStoredMessages) {
                genericMessage2 = (GenericMessage)this.unSentMessagesQueue.remove(0);
                if (genericMessage2.getMsgType().equals(RemoteInvalidatorHelper.INVALIDATIONS)) {
                    this.numStoredInvalidations -= ((InvalidationMessage)genericMessage2).getInvalidationIDs().size();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, this.numStoredInvalidations + " :Removed invalidations: Following # of invalidations removed: " + ((InvalidationMessage)genericMessage2).getInvalidationIDs().size());
                    continue;
                }
                --this.numStoredInvalidations;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, this.numStoredInvalidations + " :Removed msg: " + genericMessage2);
            }
        }
    }

    private void createMessageRetryAlarm() {
        AlarmManager.createNonDeferrable(this.msgSendDelay, this, ALARM_ACTION_SEND_MESSAGES);
    }

    public void invalidateTemplate(InvalidateByTemplateEvent invalidateByTemplateEvent) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidate by template: " + invalidateByTemplateEvent.getTemplate() + ", source=" + invalidateByTemplateEvent.source);
        }
        if (invalidateByTemplateEvent.source == 5) {
            this.storeMessage(new TemplateInvalidationMessage(invalidateByTemplateEvent.getTemplate()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template msg sent");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "source not local: only send template msg for local events.");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clear(InvalidateByTemplateEvent invalidateByTemplateEvent) {
        if (!this.isClearEnabled) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "clear not enabled");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clear source=" + invalidateByTemplateEvent.source);
        }
        if (invalidateByTemplateEvent.source == 5) {
            this.storeMessage(SINGLETON_CLEAR_MSG);
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "clear msg sent");
            return;
        }
        if (!tc.isDebugEnabled()) return;
        Tr.debug(tc, "source not local: only send clear for local events.");
    }

    public void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no op - clear");
        }
    }

    public void invalidateIds(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateIds");
        }
        Iterator iterator = hashMap.values().iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)iterator.next();
            if (invalidateByIdEvent.source == 5) {
                hashSet.add(invalidateByIdEvent.getId());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "processing local id: " + invalidateByIdEvent.getId());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "disregarding non-local id: " + invalidateByIdEvent.getId());
        }
        if (hashSet.size() > 0) {
            InvalidationMessage invalidationMessage = new InvalidationMessage(hashSet, "baseCache");
            this.storeMessage(invalidationMessage);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "# of ids invalidated: " + hashSet.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidateIds");
        }
    }

    public void invalidateIds(Iterator iterator) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalidateIds-template - no op");
        }
    }

    public void invalidatePages(Iterator iterator) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no op - invalidatePages");
        }
    }

    public void postInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RI postInvoke");
        }
    }

    public void preInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RI preInvoke");
        }
    }

    public void setAddress(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RI setAddress=" + string);
        }
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else {
            String[] stringArray = string.split(",");
            if (stringArray.length >= 2) {
                this.connFactoryJNDIName = stringArray[0].trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "short conn Factory name=" + this.connFactoryJNDIName);
                }
                this.queueJNDIName = stringArray[1].trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "short queue name=" + this.queueJNDIName);
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.setConnectionActive(false);
            FFDCFilter.processException((Throwable)new IllegalArgumentException("invalid address specified"), this.getClass().getName() + ".setAddress()", "777", this);
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "DYNA1073E", string);
            }
        } else if (!this.createConnection()) {
            this.createConnectionRetryAlarm();
        }
    }

    public void writePages(Iterator iterator) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RI writePages=" + iterator);
        }
    }

    private synchronized void sendMessage(GenericMessage genericMessage) {
        block7: {
            if (this.isConnectionActive()) {
                try {
                    ObjectMessage objectMessage = this.session.createObjectMessage((Serializable)genericMessage);
                    objectMessage.setJMSDestination(this.destination);
                    this.producer.send((Message)objectMessage);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sent jms message id: " + objectMessage.getJMSMessageID());
                    }
                    break block7;
                }
                catch (JMSException jMSException) {
                    this.storeMessage(genericMessage);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error=" + jMSException.getMessage());
                    }
                    this.setConnectionActive(false);
                    this.resetConnection();
                    this.createConnectionRetryAlarm();
                    if (tc.isWarningEnabled()) {
                        Tr.warning(tc, "DYNA1074W", new Object[]{this.queueJNDIName, this.connFactoryJNDIName});
                    }
                    break block7;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RemoteInvalidator for " + this.queueJNDIName + " is not active");
            }
            this.storeMessage(genericMessage);
        }
    }

    private void createConnectionRetryAlarm() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating connection retry alarm ");
        }
        AlarmManager.createNonDeferrable(this.connRetryInterval, this, ALARM_ACTION_RECONNECT);
    }

    private boolean createConnection() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnection");
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "starting name in namespace: " + initialContext.getNameInNamespace());
            }
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(this.connFactoryJNDIName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connFactory=" + connectionFactory);
            }
            this.connection = connectionFactory.createConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connection=" + this.connection);
            }
            this.session = this.connection.createSession(false, 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session=" + this.session);
            }
            this.destination = this.session.createQueue(this.queueJNDIName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destination=" + this.destination);
            }
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.setTimeToLive(MESSAGE_TIME_TO_LIVE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "producer=" + this.producer);
            }
            if (tc.isInfoEnabled()) {
                Tr.info(tc, "DYNA1075I", new Object[]{this.queueJNDIName, this.connFactoryJNDIName});
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "problems setting up connection: " + exception.getMessage());
                try {
                    if (initialContext != null) {
                        Tr.debug(tc, "name in namespace: " + initialContext.getNameInNamespace());
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            this.setConnectionActive(false);
            this.resetConnection();
            if (tc.isWarningEnabled()) {
                Tr.warning(tc, "DYNA1076W", new Object[]{this.queueJNDIName, this.connFactoryJNDIName});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConnection-false");
            }
            return false;
        }
        this.setConnectionActive(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnection-true");
        }
        return true;
    }

    private synchronized void resetConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resetting connection");
        }
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (object == ALARM_ACTION_RECONNECT) {
            if (!this.createConnection()) {
                this.createConnectionRetryAlarm();
            }
        } else if (object == ALARM_ACTION_SEND_MESSAGES) {
            try {
                LinkedList linkedList = null;
                boolean bl = false;
                List list = this.unSentMessagesQueue;
                synchronized (list) {
                    if (this.unSentMessagesQueue.size() > 0) {
                        linkedList = new LinkedList(this.unSentMessagesQueue);
                        this.unSentMessagesQueue.clear();
                        this.numStoredInvalidations = 0;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Stored messages cleared. Following # of messages stored: 0");
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sending messages: " + linkedList.size());
                    }
                    for (GenericMessage genericMessage : linkedList) {
                        this.sendMessage(genericMessage);
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem sending messages: " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".alarm()", "605", this);
            }
            this.createMessageRetryAlarm();
        }
    }

    boolean isConnectionActive() {
        return this.isConnectionActive;
    }

    void setConnectionActive(boolean bl) {
        this.isConnectionActive = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RemoteInvalidator isActive =" + bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEJBMessageProcessorActive() {
        Object object = activityLock;
        synchronized (object) {
            isJMSMessageProcessorActive = true;
            if (isRemoteInvalidatorActive) {
                Tr.error(tc, "RemoteJMSInvalidator can not run on same server hosting DynacacheMessageHandler.ear");
                throw new RuntimeException("RemoteJMSInvalidator can not run on same server hosting DynacacheMessageHandler.ear");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRemoteInvalidatorActive() {
        Object object = activityLock;
        synchronized (object) {
            isRemoteInvalidatorActive = true;
            if (isJMSMessageProcessorActive) {
                Tr.error(tc, "RemoteJMSInvalidator can not run on same server hosting DynacacheMessageHandler.ear");
                throw new RuntimeException("RemoteJMSInvalidator can not run on same server hosting DynacacheMessageHandler.ear");
            }
        }
    }

    static {
        activityLock = new Object();
        ALARM_ACTION_SEND_MESSAGES = "Send Messages";
        ALARM_ACTION_RECONNECT = "Rebuild Connection";
        SINGLETON_CLEAR_MSG = new ClearMessage();
        tc = Tr.register(RemoteInvalidator.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    }
}

