/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.applicationbnd;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class ApplicationBindingValidator
extends J2EEValidator {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
            return;
        }
        try {
            String string = stringArray[0];
            EARFile eARFile = CommonarchiveFactoryImpl.getActiveFactory().openEARFile(string);
            ApplicationBinding applicationBinding = eARFile.getBindings();
            ApplicationBindingValidator applicationBindingValidator = new ApplicationBindingValidator();
            PassthruHelper passthruHelper = new PassthruHelper(applicationBinding);
            FullReporter fullReporter = new FullReporter();
            applicationBindingValidator.validate(passthruHelper, fullReporter);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.applicationbnd.applicationbndvalidation";
    }

    public ISchedulingRule getSchedulingRule(IValidationContext iValidationContext) {
        return null;
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        if (iReporter == null || iValidationContext == null) {
            return;
        }
        this._reporter = iReporter;
        try {
            Object object = iValidationContext.loadModel("ApplicationBinding");
            if (object == null) {
                return;
            }
            this.validate((ApplicationBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_APPLICATIONBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public void validate(ApplicationBinding applicationBinding) {
        Application application = applicationBinding.getApplication();
        if (application == null) {
            this.addError("NULL_APPLICATION_REFERENCE");
            return;
        }
        if (application.getDisplayName() == null) {
            this.addError("MISSING_APPLICATION_REFERENCE");
        }
        if (applicationBinding.getRunAsMap() != null) {
            this.validateRunAsBindings(applicationBinding);
        }
        if (applicationBinding.getAuthorizationTable() != null) {
            this.validateAuthorizations(applicationBinding);
        }
    }

    public void validateAuthorizations(ApplicationBinding applicationBinding) {
        Object object;
        RoleAssignment roleAssignment;
        Object object2;
        SecurityRole securityRole;
        EList eList = applicationBinding.getApplication().getSecurityRoles();
        AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
        EList eList2 = authorizationTable.getAuthorizations();
        HashMap<Object, SecurityRole> hashMap = new HashMap<Object, SecurityRole>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            securityRole = (SecurityRole)iterator.next();
            if (securityRole == null || (object2 = securityRole.getRoleName()) == null || ((String)object2).length() <= 0) continue;
            hashMap.put(object2, securityRole);
        }
        securityRole = hashMap.keySet();
        object2 = new HashSet();
        Iterator iterator2 = eList2.iterator();
        while (iterator2.hasNext()) {
            String string;
            roleAssignment = (RoleAssignment)iterator2.next();
            object = roleAssignment.getRole();
            if (object == null || (string = object.getRoleName()) == null || string.length() <= 0) continue;
            if (!object2.contains(string)) {
                object2.add(string);
                continue;
            }
            this.addError("MULTIPLE_ROLEASSIGNMENTS_FOR_SECURITY_ROLE", new String[]{string});
        }
        roleAssignment = securityRole.iterator();
        while (roleAssignment.hasNext()) {
            object = (String)roleAssignment.next();
            if (object2.contains(object) || ((String)object).toUpperCase().equals("DENYALLROLE")) continue;
            this.addWarning("UNASSIGNED_SECURITY_ROLE", new String[]{object});
        }
    }

    public void validateRunAsBindings(ApplicationBinding applicationBinding) {
        EList eList = applicationBinding.getRunAsMap().getRunAsBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            RunAsBinding runAsBinding = (RunAsBinding)iterator.next();
            SecurityRole securityRole = runAsBinding.getSecurityRole();
            if (securityRole != null) continue;
            this.addError("MISSING_SECURITY_ROLE");
        }
    }
}

