/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.ejbbnd;

import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class EJBJarBindingValidator
extends J2EEValidator {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
            return;
        }
        try {
            String string = stringArray[0];
            EJBJarFile eJBJarFile = CommonarchiveFactoryImpl.getActiveFactory().openEJBJarFile(string);
            EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
            PassthruHelper passthruHelper = new PassthruHelper(eJBJarBinding);
            FullReporter fullReporter = new FullReporter();
            EJBJarBindingValidator eJBJarBindingValidator = new EJBJarBindingValidator();
            eJBJarBindingValidator.validate(passthruHelper, fullReporter);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.ejbbnd.ejbbndvalidation";
    }

    public ISchedulingRule getSchedulingRule(IValidationContext iValidationContext) {
        return null;
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        if (iReporter == null || iValidationContext == null) {
            return;
        }
        this._reporter = iReporter;
        try {
            Object object = iValidationContext.loadModel("EJBJarBinding");
            if (object == null) {
                return;
            }
            this.validate((EJBJarBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_EJBBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    protected void validate(EJBJarBinding eJBJarBinding) {
        boolean bl;
        String string;
        String string2;
        Object object;
        EJBJar eJBJar = eJBJarBinding.getEjbJar();
        if (eJBJar == null) {
            this.addError("NULL_EJBJAR_REFERENCE");
            return;
        }
        int n = 0;
        int n2 = 0;
        HashMap<EnterpriseBean, EnterpriseBeanBinding> hashMap = new HashMap<EnterpriseBean, EnterpriseBeanBinding>();
        EList eList = eJBJarBinding.getEjbBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            EjbRef ejbRef;
            Object object2;
            EnterpriseBeanBinding enterpriseBeanBinding = (EnterpriseBeanBinding)iterator.next();
            object = enterpriseBeanBinding.getEnterpriseBean();
            if (object == null) {
                this.addError("NULL_EJB_REFERENCE");
                return;
            }
            hashMap.put((EnterpriseBean)object, enterpriseBeanBinding);
            string2 = object.getDisplayName();
            if (string2 == null) {
                string2 = "?";
            }
            if ((string = enterpriseBeanBinding.getJndiName()) == null || string.length() == 0) {
                this.addWarning("NO_JNDINAME_FOR_EJB", new String[]{string});
            }
            Iterator iterator2 = enterpriseBeanBinding.getEjbRefBindings().iterator();
            while (iterator2.hasNext()) {
                object2 = (EjbRefBinding)iterator2.next();
                ejbRef = object2.getBindingEjbRef();
                if (ejbRef == null) {
                    this.addError("NULL_EJBREF_REFERENCE", new String[]{string2});
                    continue;
                }
                string4 = ejbRef.getHome();
                if (string4 == null || string4.length() == 0) {
                    string4 = "?";
                }
                if ((string3 = object2.getJndiName()) != null && string3.length() != 0) continue;
                this.addWarning("NO_JNDINAME_FOR_EJBREF", new String[]{string4, string2});
            }
            object2 = enterpriseBeanBinding.getResRefBindings().iterator();
            while (object2.hasNext()) {
                String string5;
                String string6;
                ejbRef = (ResourceRefBinding)object2.next();
                string4 = ejbRef.getBindingResourceRef();
                if (string4 == null) {
                    this.addError("NULL_RESOURCEREF_REFERENCE", new String[]{string2});
                    continue;
                }
                string3 = string4.getType();
                if (string3 == null || string3.length() == 0) {
                    string3 = "?";
                }
                if ((string6 = string4.getName()) == null || string6.length() == 0) {
                    string6 = "?";
                }
                if ((string5 = ejbRef.getJndiName()) != null && string5.length() != 0) continue;
                this.addWarning("NO_JNDINAME_FOR_RESOURCEREF", new String[]{string6, string3, string2});
            }
            if (!object.isEntity() || !((ejbRef = (Entity)object) instanceof ContainerManagedEntity)) continue;
            ++n;
            if (enterpriseBeanBinding.getDatasource() == null) {
                this.addWarning("NO_DATASOURCE_FOR_CMPBEAN", new String[]{string2});
                continue;
            }
            if (enterpriseBeanBinding.getDatasource().getJndiName() == null || enterpriseBeanBinding.getDatasource().getJndiName().length() == 0) {
                this.addWarning("NO_DATASOURCE_JNDINAME_FOR_CMPBEAN", new String[]{string2});
                continue;
            }
            ++n2;
        }
        boolean bl2 = bl = eJBJarBinding.getDefaultDatasource() == null || eJBJarBinding.getDefaultDatasource().getJndiName() == null || eJBJarBinding.getDefaultDatasource().getJndiName().length() == 0;
        if (bl && n != n2) {
            this.addWarning("REQUIRES_DEFAULT_CMP_DATASOURCE");
        }
        object = eJBJar.getEnterpriseBeans().iterator();
        while (object.hasNext()) {
            string2 = (EnterpriseBean)object.next();
            if (hashMap.containsKey(string2)) continue;
            string = string2.getDisplayName();
            if (!(string != null && string.length() != 0 || (string = string2.getName()) != null && string.length() != 0)) {
                string = "---";
            }
            this.addError("NO_BINDING_FOR_EJB", new String[]{string});
        }
    }
}

