/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.webappbnd;

import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.Iterator;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class WebAppBindingValidator
extends J2EEValidator {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to WAR file.");
            return;
        }
        try {
            String string = stringArray[0];
            WARFile wARFile = CommonarchiveFactoryImpl.getActiveFactory().openWARFile(string);
            WebAppBinding webAppBinding = wARFile.getBindings();
            WebAppBindingValidator webAppBindingValidator = new WebAppBindingValidator();
            PassthruHelper passthruHelper = new PassthruHelper(webAppBinding);
            FullReporter fullReporter = new FullReporter();
            webAppBindingValidator.validate(passthruHelper, fullReporter);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.webappbnd.webappbndvalidation";
    }

    public ISchedulingRule getSchedulingRule(IValidationContext iValidationContext) {
        return null;
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        if (iReporter == null || iValidationContext == null) {
            return;
        }
        this._reporter = iReporter;
        try {
            Object object = this._helper.loadModel("WebAppBinding");
            if (object == null) {
                return;
            }
            this.validate((WebAppBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_WEBAPPBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public void validate(WebAppBinding webAppBinding) {
        String string;
        String string2;
        EjbRef ejbRef;
        Object object;
        String string3;
        WebApp webApp = webAppBinding.getWebapp();
        if (webApp == null) {
            this.addError("NULL_WEBAPP_REFERENCE");
            return;
        }
        String string4 = webApp.getDisplayName();
        if (string4 == null || string4.length() == 0) {
            string4 = "?";
        }
        if ((string3 = webAppBinding.getVirtualHostName()) == null || string3.length() == 0) {
            string3 = "?";
        }
        Iterator iterator = webAppBinding.getEjbRefBindings().iterator();
        while (iterator.hasNext()) {
            object = (EjbRefBinding)iterator.next();
            ejbRef = object.getBindingEjbRef();
            if (ejbRef == null) {
                this.addError("NULL_EJBREF_REFERENCE", new String[]{string4});
                continue;
            }
            string2 = ejbRef.getHome();
            if (string2 == null || string2.length() == 0) {
                string2 = "?";
            }
            if ((string = object.getJndiName()) != null && string.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_EJBREF", new String[]{string2, string4});
        }
        object = webAppBinding.getResRefBindings().iterator();
        while (object.hasNext()) {
            String string5;
            String string6;
            ejbRef = (ResourceRefBinding)object.next();
            string2 = ejbRef.getBindingResourceRef();
            if (string2 == null) {
                this.addError("NULL_RESOURCEREF_REFERENCE", new String[]{string4});
                continue;
            }
            string = string2.getType();
            if (string == null || string.length() == 0) {
                string = "?";
            }
            if ((string6 = string2.getName()) == null || string6.length() == 0) {
                string6 = "?";
            }
            if ((string5 = ejbRef.getJndiName()) != null && string5.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_RESOURCEREF", new String[]{string6, string, string4});
        }
    }
}

