/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.websphere.validation.base.config.MOFValidationConstants;
import com.ibm.websphere.validation.base.config.OutputSupport;
import com.ibm.websphere.validation.bundling.ValidationMessage;
import com.ibm.ws.bootstrap.ExtClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class MOFValidator
implements IValidator,
MOFValidationConstants {
    public static final String pgmVersion = "1.5";
    public static final String pgmUpdate = "8/29/05";
    public static final String DEBUG_PROPERTY_NAME = "com.ibm.websphere.validation.debug";
    protected OutputSupport _trace;
    protected IValidationContext _helper;
    protected static boolean ALLOW_EMPTY_COLLECTION = true;
    protected static boolean FORBID_EMPTY_COLLECTION = false;
    protected IReporter _reporter;
    protected int _currentFileNo;
    protected String[] _fileNames;
    protected HashSet _parents;

    public MOFValidator() {
        this.maybeEnableTrace();
    }

    protected void maybeEnableTrace() {
        if (Boolean.getBoolean(DEBUG_PROPERTY_NAME)) {
            this.enableTrace();
        }
    }

    public String getTraceName() {
        return this.getClass().getName();
    }

    public void setTrace(OutputSupport outputSupport) {
        this._trace = outputSupport;
    }

    public OutputSupport getTrace() {
        return this._trace;
    }

    public boolean isTraceEnabled() {
        return this._trace != null;
    }

    public void enableTrace() {
        if (this._trace == null) {
            this._trace = new OutputSupport(System.out);
            this.trace("Enabled trace");
        }
    }

    public void disableTrace() {
        if (this._trace != null) {
            this.trace("Disabling trace");
            this._trace = null;
        }
    }

    public void trace(Object object) {
        if (this._trace != null) {
            this._trace.printlnBeginning(object);
        }
    }

    public void trace(Object object, Object object2) {
        if (this._trace != null) {
            this._trace.printlnBeginning(object, object2);
        }
    }

    public void traceBegin(String string) {
        if (this._trace != null) {
            this._trace.begin(this.getTraceName(), string);
        }
    }

    public void traceBegin(String string, Object object) {
        if (this._trace != null) {
            this._trace.begin(this.getTraceName(), string, object);
        }
    }

    public void traceEnd() {
        if (this._trace != null) {
            this._trace.end();
        }
    }

    public void traceEnd(Object object) {
        if (this._trace != null) {
            this._trace.end(object);
        }
    }

    public void traceEnd(boolean bl) {
        if (this._trace != null) {
            this._trace.end(bl);
        }
    }

    public void traceStub(Object object) {
        if (this._trace != null) {
            this._trace.printlnBeginning("Stubbed: " + object);
        }
    }

    public void traceStub(Object object, Object object2) {
        if (this._trace != null) {
            this._trace.printlnBeginning("Stubbed: " + object + object2);
        }
    }

    public void traceException(String string, Throwable throwable) {
        if (this._trace != null) {
            this._trace.displayException(string, throwable);
        }
    }

    protected IValidationContext getHelper() {
        return this._helper;
    }

    protected void setHelper(IValidationContext iValidationContext) {
        this._helper = iValidationContext;
    }

    protected Object loadModel(String string) {
        return this.loadModel(string, ALLOW_EMPTY_COLLECTION);
    }

    protected Object loadModel(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        this.trace("Loading: ", string);
        Object[] objectArray = null;
        Object object = this.getHelper().loadModel(string, objectArray);
        if (object == null) {
            this.handleNullLoad(string);
        } else if (object instanceof Throwable) {
            this.handleLoadException((Throwable)object, string);
            object = null;
        } else {
            this.trace("Loaded model: ", object.getClass().getName());
            if (object instanceof ArrayList) {
                this.trace("Load size: ", new Integer(((ArrayList)object).size()));
            }
            if (object instanceof Collection && ((Collection)object).isEmpty() && !bl) {
                this.handleEmptyLoad(string);
                object = null;
            }
        }
        return object;
    }

    protected Object loadModel(String string, Class clazz) {
        return this.loadModel(string, clazz, ALLOW_EMPTY_COLLECTION);
    }

    protected Object loadModel(String string, Class clazz, boolean bl) {
        Object object = this.loadModel(string, bl);
        if (object == null) {
            return null;
        }
        Iterator iterator = ((List)object).iterator();
        Object var6_6 = null;
        while (var6_6 == null && iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            Class<?> clazz2 = e2.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                var6_6 = e2;
                continue;
            }
            this.handleMisstypedLoad(string, clazz2.getName(), clazz.getName());
        }
        if (var6_6 == null) {
            this.handleNullLoad(string);
        }
        return var6_6;
    }

    protected Object loadSiblingModel(String string, String string2, Class clazz) {
        return this.loadRelativeModel(string, 1, string2, clazz);
    }

    protected Object loadSiblingModel(String string, Class clazz) {
        return this.loadRelativeModel(this.getCurrentFileName(), 1, string, clazz);
    }

    protected Object loadRelativeModel(int n, Class clazz) {
        return this.loadRelativeModel(this.getCurrentFileName(), n, null, clazz);
    }

    protected Object loadRelativeModel(int n, String string, Class clazz) {
        return this.loadRelativeModel(this.getCurrentFileName(), n, string, clazz);
    }

    protected Object loadSiblingModel(String string, String string2) {
        return this.loadRelativeModel(string, 1, string2);
    }

    protected Object loadSiblingModel(String string) {
        return this.loadRelativeModel(this.getCurrentFileName(), 1, string);
    }

    protected Object loadRelativeModel(int n) {
        return this.loadRelativeModel(this.getCurrentFileName(), n, null);
    }

    protected Object loadRelativeModel(int n, String string) {
        return this.loadRelativeModel(this.getCurrentFileName(), n, string);
    }

    protected Object loadRelativeModel(String string, int n, String string2) {
        return this.loadRelativeModel(string, n, string2, null);
    }

    protected Object loadRelativeModel(String string, int n, String string2, Class clazz) {
        String string3 = this.getRelativePath(string, n, string2);
        if (clazz == null) {
            return this.loadModel(string3);
        }
        return this.loadModel(string3, clazz);
    }

    protected String getSiblingPath(String string) {
        return this.getRelativePath(this.getCurrentFileName(), 1, string);
    }

    protected String getRelativePath(String string, int n, String string2) {
        this.trace("Compute path relative to: ", string);
        this.trace("Take off: ", new Integer(n));
        this.trace("Loading target: ", string2);
        String string3 = string;
        while (n > 0 && string3.length() > 0) {
            --n;
            string3 = this.trimLeadingChainOf(string3);
        }
        if (n > 0) {
            this.trace("Too many parents");
            return null;
        }
        if (string2 != null) {
            string3 = string3 + "/" + string2;
        }
        this.trace("Final path: ", string3);
        return string3;
    }

    protected IReporter getReporter() {
        return this._reporter;
    }

    protected void setReporter(IReporter iReporter) {
        this._reporter = iReporter;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.mofvalidationNLS";
    }

    public void addError(String string, String[] stringArray, Object object) {
        this.addError(this.getBundleId(), string, stringArray, object);
    }

    public void addError(String string, Object object) {
        this.addError(this.getBundleId(), string, new String[0], object);
    }

    public void addError(String string, String string2, String[] stringArray, Object object) {
        ValidationMessage validationMessage = new ValidationMessage(string, 1, string2, stringArray, object);
        this.addMessage(validationMessage);
    }

    public void addInfo(String string, String[] stringArray, Object object) {
        this.addInfo(this.getBundleId(), string, stringArray, object);
    }

    public void addInfo(String string, Object object) {
        this.addInfo(this.getBundleId(), string, null, object);
    }

    public void addInfo(String string, String string2, String[] stringArray, Object object) {
        ValidationMessage validationMessage = new ValidationMessage(string, 4, string2, stringArray, object);
        this.addMessage(validationMessage);
    }

    public void addWarning(String string, String[] stringArray, Object object) {
        this.addWarning(this.getBundleId(), string, stringArray, object);
    }

    public void addWarning(String string, Object object) {
        this.addWarning(this.getBundleId(), string, null, object);
    }

    public void addWarning(String string, String string2, String[] stringArray, Object object) {
        ValidationMessage validationMessage = new ValidationMessage(string, 2, string2, stringArray, object);
        this.addMessage(validationMessage);
    }

    public void addMessage(IMessage iMessage) {
        this.getReporter().addMessage((IValidator)this, iMessage);
    }

    protected void moveToFirstFile() {
        this.initParents();
        this._currentFileNo = 0;
        this._fileNames = this.getHelper().getURIs();
    }

    protected void moveToNextFile() {
        this.initParents();
        ++this._currentFileNo;
    }

    protected String getCurrentFileName() {
        return this._fileNames[this._currentFileNo];
    }

    protected boolean hasAnotherFile() {
        return this._currentFileNo < this._fileNames.length;
    }

    protected void initParents() {
        this._parents = new HashSet();
    }

    protected boolean wasVisited(Object object) {
        return this._parents.contains(object);
    }

    protected void recordVisit(Object object) {
        this._parents.add(object);
    }

    protected void forgetVisit(Object object) {
        this._parents.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        this.traceBegin("validate");
        try {
            this.setHelper(iValidationContext);
            this.setReporter(iReporter);
            this.moveToFirstFile();
            while (this.hasAnotherFile()) {
                this.validateFile(this.getCurrentFileName());
                this.moveToNextFile();
            }
        }
        catch (Throwable throwable) {
            this.handleRunException(throwable);
        }
        finally {
            this.traceEnd();
        }
    }

    public void validateFile(String string) throws ValidationException {
        Object object = this.loadModel(string);
        if (object != null) {
            this.visit(object);
        }
    }

    public void cleanup(IReporter iReporter) {
        this.trace("MOFValidator().cleanup() [deprecated]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        this.traceBegin("visit(Object)");
        try {
            if (object instanceof List) {
                this.trace("Visiting list object.");
                this.visitList((List)object);
            } else if (object instanceof EObject) {
                if (!(object instanceof EEnumLiteral)) {
                    this.trace("Visiting non-enum EMF object.");
                    this.visitNonList(object);
                } else {
                    this.trace("Visiting EnumLiteral EMF object: Skipping");
                }
            } else {
                this.trace("Visiting non list, non-EMF object: Skipping.");
            }
        }
        finally {
            this.traceEnd();
        }
    }

    protected void visitNonList(Object object) throws ValidationException {
        this.visitTraversing(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitTraversing(Object object) throws ValidationException {
        if (this.wasVisited(object)) {
            this.trace("Object already visited; skipping");
            return;
        }
        this.recordVisit(object);
        try {
            this.basicVisit(object);
            this.visitList(this.getChildren(object));
        }
        finally {
            this.forgetVisit(object);
        }
    }

    protected void visitNonTraversing(Object object) throws ValidationException {
        this.basicVisit(object);
    }

    protected void visitList(List list) throws ValidationException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getChildren(Object object) {
        Object object2;
        this.traceBegin("getChildren");
        try {
            object2 = object instanceof EObject ? ((EObject)object).eContents() : new ArrayList();
        }
        finally {
            this.traceEnd();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicVisit(Object object) throws ValidationException {
        this.traceBegin("basicVisit", object.getClass().getName());
        try {
            boolean bl = this.basicValidate(object);
        }
        finally {
            this.traceEnd();
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (this.isTraceEnabled()) {
            String string = object.getClass().getName();
            this.trace("Unrecognized object type; skipping: ", string);
            this.addError(this.getRecognitionFailureCode(), new String[]{string}, object);
        }
        return false;
    }

    protected String getValidationFailureCode() {
        return "ERROR_VALIDATION_FAILED";
    }

    protected String getNullLoadCode() {
        return "ERROR_NULL_LOAD";
    }

    protected String getLoadTypeFailureCode() {
        return "ERROR_MISSTYPED_LOAD";
    }

    protected String getEmptyLoadFailureCode() {
        return "ERROR_EMPTY_LOAD";
    }

    protected String getRecognitionFailureCode() {
        return "WARNING_RECOGNITION_FAILED";
    }

    protected String getExecutionFailureCode() {
        return "ERROR_VALIDATION_RUN_FAILED";
    }

    protected void handleLoadException(Throwable throwable, String string) {
        this.addError("com.ibm.websphere.validation.base.config.mofvalidationNLS", this.getValidationFailureCode(), new String[]{string, throwable.getClass().getName()}, null);
        this.traceException("Exception loading " + string + ": ", throwable);
    }

    protected void handleNullLoad(String string) {
        this.addError("com.ibm.websphere.validation.base.config.mofvalidationNLS", this.getNullLoadCode(), new String[]{string}, null);
        this.trace("Loaded null: ", string);
    }

    protected void handleEmptyLoad(String string) {
        this.addError("com.ibm.websphere.validation.base.config.mofvalidationNLS", this.getEmptyLoadFailureCode(), new String[]{string}, null);
        this.trace("Empty load: ", string);
    }

    protected void handleMisstypedLoad(String string, String string2, String string3) {
        this.addError("com.ibm.websphere.validation.base.config.mofvalidationNLS", this.getLoadTypeFailureCode(), new String[]{string, string2, string3}, null);
        this.trace("Loaded null: ", string);
    }

    protected void handleRunException(Throwable throwable) {
        String string = this.getCurrentFileName();
        this.addError("com.ibm.websphere.validation.base.config.mofvalidationNLS", this.getExecutionFailureCode(), new String[]{string, throwable.getClass().getName()}, null);
        this.traceException("Exception validating " + string + ": ", throwable);
    }

    protected String trimLeadingChainOf(String string) {
        int n = string.lastIndexOf("/");
        string = n == -1 ? "" : string.substring(0, n);
        return string;
    }

    protected String nabHeadOf(String string) {
        int n = string.indexOf("/");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected String nabTailOf(String string) {
        int n = string.indexOf("/");
        return n == -1 ? null : string.substring(n + 1);
    }

    protected String nabEndOf(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(n);
        }
        return string;
    }

    protected String nabEndOfNoSlash(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public boolean isEnumValueValid(int n, EEnum eEnum) {
        boolean bl = false;
        EList eList = eEnum.getELiterals();
        int n2 = eList.size();
        for (int i = 0; !bl && i < n2; ++i) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)eList.get(i);
            int n3 = eEnumLiteral.getValue();
            bl = n == n3;
        }
        return bl;
    }

    public boolean isEnumValueValid(Integer n, EEnum eEnum) {
        return this.isEnumValueValid((int)n, eEnum);
    }

    public String getExceptionText(Throwable throwable) {
        String string;
        try {
            string = throwable.getMessage();
        }
        catch (Throwable throwable2) {
            string = throwable2.getClass().getName();
        }
        return string;
    }

    public Class getExtendedClass(String string) throws ClassNotFoundException {
        ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
        Class<?> clazz = extClassLoader == null ? Class.forName(string) : Class.forName(string, true, (ClassLoader)extClassLoader);
        return clazz;
    }
}

