/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import java.io.PrintStream;

public class OutputSupport {
    public static final String pgmVersion = "5/9/05";
    public static final String pgmUpdate = "1.1";
    public static final String beginMethod = "Begin ";
    public static final String endMethod = "End ";
    public static final String delimiter = ": ";
    protected String currentCallClass;
    protected String currentCallMethod;
    protected int currentCallDepth;
    protected CallStackEntry[] callStack;
    protected static final int callStackInitialSize = 100;
    protected static final int callStackChunking = 50;
    public final String timeMarker = " | ";
    protected int indentLevel;
    public static final String indentation = "  ";
    public static final int relativeTimeWidth = 6;
    public static final String relativeTimeGap;
    public static final int systemTimeWidth = 12;
    public static final String systemTimeGap;
    protected boolean displaySystemTime;
    protected long referenceTime;
    public final String exceptionPrefix = "Exception: ";
    protected final StringBuffer lineBuffer = new StringBuffer();
    public final PrintStream output;
    public boolean isEnabled = true;
    public final StringBuffer tmpBuffer = new StringBuffer();
    public static final boolean DISPLAY_RELATIVE_TIME = true;
    public static final boolean DISPLAY_SYSTEM_TIME = false;
    public static final boolean FLUSH_LEFT = true;
    public static final boolean FLUSH_RIGHT = false;

    public OutputSupport(PrintStream printStream) {
        this(printStream, false);
    }

    public OutputSupport(PrintStream printStream, boolean bl) {
        this.output = printStream;
        this.initialize(bl);
    }

    public void basicBeginLine() {
        if (!this.isEnabled) {
            return;
        }
        for (int i = 0; i < this.indentLevel; ++i) {
            this.basicPrint(indentation);
        }
    }

    protected void basicPrint(char c) {
        this.lineBuffer.append(c);
    }

    protected void basicPrint(Object object) {
        String string = object == null ? "null" : object.toString();
        this.lineBuffer.append(string);
    }

    protected void basicPrint(String string) {
        this.lineBuffer.append(string);
    }

    protected void basicPrintln() {
        String string = this.lineBuffer.toString();
        this.lineBuffer.setLength(0);
        this.output.println(string);
    }

    protected void basicPrintln(Object object) {
        String string = object == null ? "null" : object.toString();
        this.lineBuffer.append(string);
        String string2 = this.lineBuffer.toString();
        this.lineBuffer.setLength(0);
        this.output.println(string2);
    }

    protected void basicPrintln(String string) {
        this.lineBuffer.append(string);
        String string2 = this.lineBuffer.toString();
        this.lineBuffer.setLength(0);
        this.output.println(string2);
    }

    public long getSystemTime() {
        return System.currentTimeMillis();
    }

    public long basicShowTime() {
        if (!this.isEnabled) {
            return 0L;
        }
        boolean bl = this.displayRelativeTime();
        long l = this.getSystemTime();
        if (bl) {
            l -= this.referenceTime;
        }
        this.basicShowTime(l, bl);
        return l;
    }

    public void basicShowTime(long l, boolean bl) {
        if (!this.isEnabled) {
            return;
        }
        String string = Long.toString(l);
        int n = bl ? 6 : 12;
        for (int i = string.length(); i < n; ++i) {
            this.basicPrint(' ');
        }
        this.basicPrint(string);
    }

    public void begin(String string, String string2) {
        if (!this.isEnabled) {
            return;
        }
        long l = this.beginLine();
        this.print(beginMethod);
        this.print(string, delimiter);
        this.println(string2);
        this.upOutputLevel();
        this.pushCall(string, string2, l);
    }

    public void begin(String string, String string2, Object object) {
        if (!this.isEnabled) {
            return;
        }
        long l = this.beginLine();
        this.print(beginMethod);
        this.print(string, delimiter);
        this.print(string2, delimiter);
        this.println(object);
        this.pushCall(string, string2, l);
        this.upOutputLevel();
    }

    public void beginAgain(String string) {
        if (!this.isEnabled) {
            return;
        }
        this.begin(this.callClass(), string);
    }

    public void beginAgain(String string, Object object) {
        if (!this.isEnabled) {
            return;
        }
        this.begin(this.callClass(), string, object);
    }

    public long beginLine() {
        if (!this.isEnabled) {
            return 0L;
        }
        this.basicPrint(" | ");
        long l = this.basicShowTime();
        this.basicPrint(" | ");
        this.basicPrint(relativeTimeGap);
        this.basicPrint(" | ");
        this.basicBeginLine();
        return l;
    }

    public long beginLine(long l) {
        if (!this.isEnabled) {
            return 0L;
        }
        this.basicPrint(" | ");
        long l2 = this.basicShowTime();
        this.basicPrint(" | ");
        this.basicShowTime(l2 - l, true);
        this.basicPrint(" | ");
        this.basicBeginLine();
        return l2;
    }

    public String callClass() {
        return this.currentCallClass;
    }

    public String callMethod() {
        return this.currentCallMethod;
    }

    public void disable() {
        this.isEnabled = false;
    }

    public void displayException(String string, Throwable throwable) {
        String string2;
        if (!this.isEnabled) {
            return;
        }
        this.basicPrintln(string);
        this.basicPrint("Throwable: ");
        try {
            string2 = throwable.getMessage();
        }
        catch (Throwable throwable2) {
            string2 = throwable.getClass().getName();
        }
        this.basicPrintln(string2);
        throwable.printStackTrace(this.output);
    }

    public void downOutputLevel() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    public long downOutputLevel(Object object) {
        if (!this.isEnabled) {
            return 0L;
        }
        this.downOutputLevel();
        return this.printlnBeginning(object);
    }

    public long downOutputLevel(Object object, Object object2) {
        if (!this.isEnabled) {
            return 0L;
        }
        this.downOutputLevel();
        return this.printlnBeginning(object, object2);
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void end() {
        if (!this.isEnabled) {
            return;
        }
        CallStackEntry callStackEntry = this.popCall();
        if (callStackEntry == null) {
            return;
        }
        this.downOutputLevel();
        long l = this.beginLine(callStackEntry.entryTime);
        this.print(endMethod);
        this.print(callStackEntry.className, delimiter);
        this.println(callStackEntry.methodName);
    }

    public void end(Object object) {
        if (!this.isEnabled) {
            return;
        }
        CallStackEntry callStackEntry = this.popCall();
        if (callStackEntry == null) {
            return;
        }
        this.downOutputLevel();
        long l = this.beginLine(callStackEntry.entryTime);
        this.print(endMethod);
        this.print(callStackEntry.className, delimiter);
        this.print(callStackEntry.methodName, delimiter);
        this.println(object);
    }

    public void end(boolean bl) {
        if (!this.isEnabled) {
            return;
        }
        this.end(new Boolean(bl));
    }

    public String fillNumber(int n, int n2) {
        return this.fillString(Integer.toString(n), n2, false);
    }

    public String fillString(String string, int n) {
        return this.fillString(string, n, true);
    }

    public String fillString(String string, int n, boolean bl) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        if (bl) {
            this.tmpBuffer.append(string);
        }
        for (int i = n - n2; i > 0; --i) {
            this.tmpBuffer.append(' ');
        }
        if (!bl) {
            this.tmpBuffer.append(string);
        }
        String string2 = this.tmpBuffer.toString();
        this.tmpBuffer.setLength(0);
        return string2;
    }

    protected void growCallStack() {
        int n;
        int n2 = this.currentCallDepth + 50;
        CallStackEntry[] callStackEntryArray = new CallStackEntry[n2];
        for (n = 0; n < this.currentCallDepth; ++n) {
            callStackEntryArray[n] = this.callStack[n];
        }
        while (n < n2) {
            callStackEntryArray[n] = new CallStackEntry();
            ++n;
        }
        this.callStack = callStackEntryArray;
    }

    public int indentationLevel() {
        return this.indentLevel;
    }

    public void initialize(boolean bl) {
        this.isEnabled = !bl;
        this.initializeIndentation();
        this.initializeTiming();
        this.initializeCallStack();
    }

    protected void initializeCallStack() {
        this.callStack = new CallStackEntry[100];
        for (int i = 0; i < 100; ++i) {
            this.callStack[i] = new CallStackEntry();
        }
        this.currentCallDepth = 0;
        this.currentCallClass = null;
        this.currentCallMethod = null;
    }

    protected void initializeIndentation() {
        this.indentLevel = 0;
    }

    protected void initializeTiming() {
        this.setRelativeTiming();
        this.resetReferenceTime();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean displaySystemTime() {
        return this.displaySystemTime;
    }

    public boolean displayRelativeTime() {
        return !this.displaySystemTime;
    }

    protected CallStackEntry popCall() {
        if (this.currentCallDepth == 0) {
            return null;
        }
        CallStackEntry callStackEntry = this.callStack[--this.currentCallDepth];
        if (this.currentCallDepth == 0) {
            this.currentCallClass = null;
            this.currentCallMethod = null;
        } else {
            CallStackEntry callStackEntry2 = this.callStack[this.currentCallDepth];
            this.currentCallClass = callStackEntry2.className;
            this.currentCallMethod = callStackEntry2.methodName;
        }
        return callStackEntry;
    }

    public void print(Object object) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
    }

    public void print(Object object, Object object2) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrint(object2);
    }

    public void print(Object object, Object object2, Object object3) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrint(object2);
        this.basicPrint(object3);
    }

    public void print(Object object, Object object2, Object object3, Object object4) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrint(object2);
        this.basicPrint(object3);
        this.basicPrint(object4);
    }

    public long printBeginning() {
        return this.beginLine();
    }

    public long printBeginning(Object object) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.beginLine();
        this.print(object);
        return l;
    }

    public long printBeginning(Object object, Object object2) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.beginLine();
        this.print(object, object2);
        return l;
    }

    public void println() {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrintln();
    }

    public void println(Object object) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrintln(object);
    }

    public void println(Object object, Object object2) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrintln(object2);
    }

    public void println(Object object, Object object2, Object object3) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrint(object2);
        this.basicPrintln(object3);
    }

    public void println(Object object, Object object2, Object object3, Object object4) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(object);
        this.basicPrint(object2);
        this.basicPrint(object3);
        this.basicPrintln(object4);
    }

    public long printlnBeginning() {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.beginLine();
        this.println();
        return l;
    }

    public long printlnBeginning(Object object) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.beginLine();
        this.println(object);
        return l;
    }

    public long printlnBeginning(Object object, Object object2) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.beginLine();
        this.println(object, object2);
        return l;
    }

    public void printNumber(int n, int n2) {
        if (!this.isEnabled) {
            return;
        }
        this.basicPrint(this.fillNumber(n, n2));
    }

    protected CallStackEntry pushCall() {
        if (this.currentCallDepth == this.callStack.length) {
            this.growCallStack();
        }
        return this.callStack[this.currentCallDepth++];
    }

    protected void pushCall(String string, String string2, long l) {
        CallStackEntry callStackEntry = this.pushCall();
        callStackEntry.set(string, string2, l);
        this.currentCallClass = string;
        this.currentCallMethod = string2;
    }

    public void reportError(String string, String string2, Throwable throwable) {
        String string3;
        if (!this.isEnabled) {
            return;
        }
        this.printBeginning(string, delimiter);
        this.print(string2, delimiter);
        try {
            string3 = throwable.getMessage();
        }
        catch (Throwable throwable2) {
            string3 = throwable.getClass().getName();
        }
        if (string3 == null) {
            this.println(throwable);
        } else {
            this.print(throwable);
            this.print(delimiter);
            this.println(string3);
        }
    }

    public void reportErrorAgain(Exception exception) {
        if (!this.isEnabled) {
            return;
        }
        this.reportErrorAgain(this.callMethod(), exception);
    }

    public void reportErrorAgain(String string, Exception exception) {
        if (!this.isEnabled) {
            return;
        }
        this.reportError(this.callClass(), string, exception);
    }

    public void resetReferenceTime() {
        this.referenceTime = this.getSystemTime();
    }

    public void upOutputLevel() {
        ++this.indentLevel;
    }

    public long upOutputLevel(Object object) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.printlnBeginning(object);
        this.upOutputLevel();
        return l;
    }

    public long upOutputLevel(Object object, Object object2) {
        if (!this.isEnabled) {
            return 0L;
        }
        long l = this.printlnBeginning(object, object2);
        this.upOutputLevel();
        return l;
    }

    public void setSystemTiming() {
        this.displaySystemTime = true;
    }

    public void setRelativeTiming() {
        this.displaySystemTime = false;
    }

    static {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 6; ++n) {
            stringBuffer.append(" ");
        }
        relativeTimeGap = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(" ");
        }
        systemTimeGap = stringBuffer.toString();
    }

    class CallStackEntry {
        public String className = null;
        public String methodName = null;
        public long entryTime = 0L;

        CallStackEntry() {
        }

        public void set(String string, String string2, long l) {
            this.className = string;
            this.methodName = string2;
            this.entryTime = l;
        }
    }
}

