/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level502;

import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.level502.NodeServersValidationConstants_502;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class NodeServersCrossValidator_502
extends WebSphereLevelCrossValidator
implements NodeServersValidationConstants_502 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";

    public NodeServersCrossValidator_502(WebSphereLevelCrossValidator webSphereLevelCrossValidator) {
        super(webSphereLevelCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level502.nodeserversvalidation_502_NLS";
    }

    public String getTraceName() {
        return "NodeServersCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ServerIndex) {
            this.validateAcross((ServerIndex)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcross(ServerIndex serverIndex) {
        this.validateServerNames(serverIndex);
        this.validateDeployedApplications(serverIndex);
        this.traceStub("Matching of configured ports with ports in other documents.");
    }

    protected void validateServerNames(ServerIndex serverIndex) {
        String string = this.getNodeUri();
        String string2 = this.getNodeName();
        HashMap hashMap = this.getNodeServerNames();
        HashSet hashSet = (HashSet)hashMap.get(string);
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string3 = serverEntry.getServerName();
            if (hashSet.contains(string3)) continue;
            this.addError("ERROR_SERVER_ENTRY_MISSING_SERVER", new String[]{string3, string2, this.getCurrentFileName()}, serverEntry);
        }
        this.traceStub("Ensure that all configured servers have a member.");
    }

    protected void validateDeployedApplications(ServerIndex serverIndex) {
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            this.validateDeployedApplications(serverEntry);
        }
    }

    protected void validateDeployedApplications(ServerEntry serverEntry) {
        EList eList = serverEntry.getDeployedApplications();
        if (eList == null) {
            return;
        }
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)eList.get(i);
            int n2 = string.indexOf("/");
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if (this.isDeployed(string)) continue;
            this.addError("ERROR_DEPLOYED_APPLICATION_NOT_FOUND", new String[]{string}, serverEntry);
        }
    }
}

