/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level502;

import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.MimeEntry;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level502.VirtualHostsValidationConstants_502;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class VirtualHostsValidator_502
extends WebSphereLevelValidator
implements VirtualHostsValidationConstants_502 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    protected boolean _pastTopList = false;
    protected VirtualHost _boundHost = null;

    public VirtualHostsValidator_502(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundHost = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundHost = null;
    }

    protected void bindHost(VirtualHost virtualHost) {
        this._boundHost = virtualHost;
    }

    protected VirtualHost getBoundHost() {
        return this._boundHost;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level502.virtualhostsvalidation_502_NLS";
    }

    public String getTraceName() {
        return "VirtualHostsValidator";
    }

    protected void visitList(List list) throws ValidationException {
        boolean bl;
        if (!this._pastTopList) {
            bl = true;
            this._pastTopList = true;
        } else {
            bl = false;
        }
        super.visitList(list);
        if (bl) {
            this.validateVirtualHostNames(list);
            this.validateAliases(list);
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof VirtualHost) {
            this.trace("Object recognized as a virtual host; validating");
            this.bindHost((VirtualHost)object);
            this.validateLocal((VirtualHost)object);
            this.validateAcross((VirtualHost)object);
        } else if (object instanceof HostAlias) {
            this.trace("Object recognized as a host alias; validating");
            this.validateLocal((HostAlias)object);
            this.validateAcross((HostAlias)object);
        } else if (object instanceof MimeEntry) {
            this.trace("Object recognized as a mime entry; validating");
            this.validateLocal((MimeEntry)object);
            this.validateAcross((MimeEntry)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(VirtualHost virtualHost) {
        this.traceBegin("validateAcross(VirtualHost)");
        this.validateHostAliases(virtualHost);
        this.traceEnd();
    }

    protected void validateHostAliases(VirtualHost virtualHost) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.fillHostMaps(virtualHost, hashMap, hashMap2);
        this.testHostMaps(virtualHost, hashMap, hashMap2);
    }

    protected void fillHostMaps(VirtualHost virtualHost, HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = virtualHost.getAliases().iterator();
        while (iterator.hasNext()) {
            Object object;
            HostAlias hostAlias = (HostAlias)iterator.next();
            String string = hostAlias.getHostname();
            String string2 = hostAlias.getPort();
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            if (!string.equals("*")) {
                object = string + " " + string2;
                HashSet<HostAlias> hashSet = (HashSet<HostAlias>)hashMap.get(object);
                if (hashSet == null) {
                    hashSet = new HashSet<HostAlias>();
                    hashMap.put(object, hashSet);
                }
                hashSet.add(hostAlias);
            }
            if ((object = (HashSet)hashMap2.get(string2)) == null) {
                object = new HashSet();
                hashMap2.put(string2, object);
            }
            ((HashSet)object).add(hostAlias);
        }
    }

    protected void testHostMaps(VirtualHost virtualHost, HashMap hashMap, HashMap hashMap2) {
        Object object;
        Object object2;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (HashSet)hashMap.get(object2);
            if (((HashSet)object).size() <= 1) continue;
            this.addError("ERROR_DUPLICATED_VIRTUAL_HOST_ALIAS", new String[]{object2, virtualHost.getName()}, virtualHost);
        }
        object2 = new HashSet();
        object = virtualHost.getAliases().iterator();
        while (object.hasNext()) {
            HashSet hashSet;
            HostAlias hostAlias = (HostAlias)object.next();
            String string = hostAlias.getHostname();
            String string2 = hostAlias.getPort();
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0 || !string.equals("*") || (hashSet = (HashSet)hashMap2.get(string2)).size() <= 1) continue;
            this.addError("ERROR_DUPLICATED_VIRTUAL_HOST_ALIAS_PORT", new String[]{string2, virtualHost.getName()}, virtualHost);
        }
    }

    public void validateAcross(HostAlias hostAlias) {
        this.traceStub("validateAcross(HostAlias)");
    }

    public void validateAcross(MimeEntry mimeEntry) {
        EList eList = mimeEntry.getExtensions();
        if (eList.size() == 0) {
            this.addError("ERROR_MIME_ENTRY_NO_EXTENSIONS", new String[]{mimeEntry.getType()}, mimeEntry);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.validateExtension(mimeEntry, string);
        }
    }

    protected boolean validateExtension(MimeEntry mimeEntry, String string) {
        boolean bl;
        this.traceBegin("validateExtension", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_EXTENSION_EMPTY", new String[]{mimeEntry.getType()}, mimeEntry);
            bl = false;
        } else if (!this.testMimeExtension(string)) {
            this.addError("ERROR_EXTENSION_INVALID", new String[]{string, mimeEntry.getType()}, mimeEntry);
            bl = false;
        } else {
            bl = true;
        }
        this.traceEnd(bl);
        return bl;
    }

    public void validateLocal(VirtualHost virtualHost) {
        String string = virtualHost.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_VIRTUAL_HOST_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, virtualHost);
        }
    }

    public void validateLocal(HostAlias hostAlias) {
        String string = hostAlias.getHostname();
        this.traceBegin("validateLocal(HostAlias)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_HOST_ALIAS_NAME_REQUIRED", new String[]{this.getBoundHost().getName()}, hostAlias);
        } else if (!this.testHostname(string)) {
            this.addError("ERROR_HOST_ALIAS_NAME_INVALID", new String[]{string, this.getBoundHost().getName()}, hostAlias);
        }
        String string2 = hostAlias.getPort();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_HOST_ALIAS_PORT_REQUIRED", new String[]{string}, hostAlias);
        } else if (!string2.equals("*")) {
            this.testIntegerMin(string2, -1, "ERROR_HOST_ALIAS_PORT_INVALID", "ERROR_HOST_ALIAS_PORT_OUT_OF_RANGE", (Object)hostAlias);
        }
    }

    public void validateLocal(MimeEntry mimeEntry) {
        String string = mimeEntry.getType();
        this.traceBegin("validateLocal(MimeEntry)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MIME_ENTRY_TYPE_REQUIRED", new String[]{this.getBoundHost().getName()}, mimeEntry);
        } else if (!this.testMimeType(string)) {
            this.addError("ERROR_MIME_ENTRY_TYPE_INVALID", new String[]{string, this.getBoundHost().getName()}, mimeEntry);
        }
        this.traceEnd();
    }

    protected void validateVirtualHostNames(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((VirtualHost)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return "ERROR_VIRTUAL_HOST_REQUIRED";
            }

            protected String getDuplicateMessage() {
                return "ERROR_VIRTUAL_HOST_NAME_DUPLICATION";
            }
        };
        duplicationTester.test(list, true, this, null);
    }

    protected boolean testMimeExtension(String string) {
        this.traceStub("Syntax test of MIME extension: ", string);
        return true;
    }

    public boolean testHostnamePort(String string) {
        this.traceStub("Syntax test of host name plus optional port: ", string);
        return true;
    }

    protected boolean testHostname(String string) {
        this.traceStub("Syntax test of host name: ", string);
        return true;
    }

    public boolean testMimeType(String string) {
        this.traceStub("Syntax test of mime type: ", string);
        return true;
    }

    public void validateAliases(List list) {
        this.traceBegin("validateAliases");
        HashMap hashMap = new HashMap();
        this.fillAliasMap(list, hashMap);
        this.testAliasMap(list, hashMap);
        this.traceEnd();
    }

    protected void fillAliasMap(List list, HashMap hashMap) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VirtualHost virtualHost = (VirtualHost)iterator.next();
            Iterator iterator2 = virtualHost.getAliases().iterator();
            while (iterator2.hasNext()) {
                HostAlias hostAlias = (HostAlias)iterator2.next();
                this.fillNameMap(hostAlias, virtualHost, hashMap);
            }
        }
    }

    protected void fillNameMap(HostAlias hostAlias, VirtualHost virtualHost, HashMap hashMap) {
        String string = hostAlias.getHostname();
        String string2 = hostAlias.getPort();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null && string2.length() == 0) {
            return;
        }
        if (string.equals("*")) {
            return;
        }
        String string3 = string + " " + string2;
        HashSet<VirtualHost> hashSet = (HashSet<VirtualHost>)hashMap.get(string3);
        if (hashSet == null) {
            hashSet = new HashSet<VirtualHost>();
            hashMap.put(string3, hashSet);
        }
        hashSet.add(virtualHost);
    }

    protected void testAliasMap(List list, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashSet hashSet = (HashSet)hashMap.get(string);
            if (hashSet.size() <= 1) continue;
            this.addError("ERROR_DUPLICATED_CELL_CONTEXT_ALIAS", new String[]{string, this.getCurrentFileName()}, null);
        }
    }
}

