/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level51.ClusterValidationConstants_51;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class ClusterCrossValidator_51
extends WebSphereLevelCrossValidator
implements ClusterValidationConstants_51 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";

    public ClusterCrossValidator_51(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.clustervalidation_51_NLS";
    }

    public String getTraceName() {
        return "ClusterCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ServerCluster) {
            this.trace("Object recognized as an server cluster; validating");
            this.validateAcross((ServerCluster)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(ServerCluster serverCluster) {
        this.traceBegin("validateAcross(ServerCluster) [Document]");
        HashMap hashMap = this.getNodeServerNames();
        Iterator iterator = serverCluster.getMembers().iterator();
        while (iterator.hasNext()) {
            ClusterMember clusterMember = (ClusterMember)iterator.next();
            this.validateClusterMemberLinkage(hashMap, clusterMember);
        }
        this.traceEnd();
    }

    protected void validateClusterMemberLinkage(HashMap hashMap, ClusterMember clusterMember) {
        String string = clusterMember.getMemberName();
        this.traceBegin("validateClusterMemberLinkage(ClusterMember)", string);
        Iterator iterator = hashMap.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            HashSet hashSet = (HashSet)hashMap.get(string3);
            if (!hashSet.contains(string)) continue;
            String string4 = this.nabEndOf(string3);
            if (string2 == null) {
                this.trace("First matching node: ", string4);
                string2 = string4;
                continue;
            }
            this.trace("Additional matching node: ", string4);
            this.addError("ERROR_MULTIPLE_MATCHING_MEMBER_SERVERS", new String[]{string, string2, string4}, clusterMember);
        }
        if (string2 == null) {
            this.trace("No matching nodes");
            this.addError("ERROR_NO_MATCHING_MEMBER_SERVERS", new String[]{string}, clusterMember);
        }
        this.traceEnd();
    }
}

