/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level51.MultiBrokerValidationConstants_51;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class MultiBrokerCrossValidator_51
extends WebSphereLevelCrossValidator
implements MultiBrokerValidationConstants_51 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    protected boolean _pastTopList = false;
    protected MultibrokerDomain _boundDomain = null;

    public MultiBrokerCrossValidator_51(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void bindDomain(MultibrokerDomain multibrokerDomain) {
        this._boundDomain = multibrokerDomain;
    }

    protected MultibrokerDomain getBoundDomain() {
        return this._boundDomain;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.multibrokervalidation_51_NLS";
    }

    public String getTraceName() {
        return "MultiBrokerCrossValidator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        block10: {
            this.traceBegin("visit(Object)");
            try {
                if (object instanceof List) {
                    this.visitList((List)object);
                    break block10;
                }
                if (object instanceof EObject && !(object instanceof EEnumLiteral)) {
                    if (!this._parents.contains(object)) {
                        this._parents.add(object);
                        try {
                            this.basicVisit(object);
                            this.visitList(this.getChildren(object));
                            break block10;
                        }
                        finally {
                            this._parents.remove(object);
                        }
                    }
                    this.trace("Object already visited; skipping");
                    break block10;
                }
                if (this.isTraceEnabled()) {
                    this.trace("Not a Ref Object; skipping");
                }
            }
            finally {
                this.traceEnd();
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof MultibrokerDomain) {
            this.bindDomain((MultibrokerDomain)object);
        } else if (object instanceof MultiBrokerRoutingEntry) {
            this.trace("Entry recognized as a multi-broker routing entry; validating");
            this.validateAcross((MultiBrokerRoutingEntry)object);
        }
        return bl;
    }

    public void validateAcross(MultiBrokerRoutingEntry multiBrokerRoutingEntry) {
        String string = multiBrokerRoutingEntry.getBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getWorkSpaceHelper().fillMessageServers(arrayList, arrayList2, string);
        int n = arrayList.size();
        int n2 = arrayList2.size();
        if (n == 0 && n2 == 0) {
            this.addWarning("WARNING_ROUTING_ENTRY_NO_MATCHING_SYSTEM_MESSAGE_SERVER", new String[]{string, this.getBoundDomain().getName()}, multiBrokerRoutingEntry);
        } else if (n > 1) {
            this.addError("ERROR_ROUTING_ENTRY_MULTIPLE_STARTING_SYSTEM_MESSAGE_SERVERS", new String[]{string, this.getBoundDomain().getName()}, multiBrokerRoutingEntry);
        }
    }
}

