/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.EndPointRef;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level51.NodeServersValidationConstants_51;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class NodeServersNDValidator_51
extends WebSphereLevelValidator
implements NodeServersValidationConstants_51 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    protected static final HashSet _validEntryTypes = new HashSet();
    protected static final HashSet _validEndPointNames;

    public NodeServersNDValidator_51(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.nodeserversvalidation_51_NLS";
    }

    public String getTraceName() {
        return "NodeServersNDValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof EndPointRef) {
            this.trace("Object recognized as an end point reference; validating");
            this.validateLocal((EndPointRef)object);
            this.validateAcross((EndPointRef)object);
        } else if (object instanceof NamedEndPoint) {
            this.trace("Object recognized as a named end point; validating");
            this.validateLocal((NamedEndPoint)object);
            this.validateAcross((NamedEndPoint)object);
        } else if (object instanceof ServerEntry) {
            this.trace("Object recognized as a server entry container; validating");
            this.validateLocal((ServerEntry)object);
            this.validateAcross((ServerEntry)object);
        } else if (object instanceof ServerIndex) {
            this.trace("Object recognized as a server index; validating");
            this.validateLocal((ServerIndex)object);
            this.validateAcross((ServerIndex)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(EndPointRef endPointRef) {
        this.traceStub("validateAcross(EndPointRef)");
    }

    public void validateAcross(NamedEndPoint namedEndPoint) {
        if (namedEndPoint.getEndPoint() == null) {
            this.addError("ERROR_NAMED_END_POINT_END_POINT_REQUIRED", new String[]{namedEndPoint.getEndPointName()}, namedEndPoint);
        }
    }

    public void validateAcross(ServerEntry serverEntry) {
        this.validateServerEntryEndPointNames(serverEntry);
    }

    protected void validateServerEntryEndPointNames(ServerEntry serverEntry) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((NamedEndPoint)eObject).getEndPointName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SERVER_ENTRY_END_POINT_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)serverEntry.getSpecialEndpoints(), false, this, serverEntry);
    }

    public void validateAcross(ServerIndex serverIndex) {
        this.validateServerEntryNames(serverIndex);
        this.validateServerEndPointRefNames(serverIndex);
        this.validatePortDuplication(serverIndex);
        EList eList = serverIndex.getServerEntries();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string = serverEntry.getServerType();
            if (!string.equals("DEPLOYMENT_MANAGER")) continue;
            this.validateSingletonNamedEndPoint(serverEntry, "CELL_DISCOVERY_ADDRESS");
        }
    }

    private void validateSingletonNamedEndPoint(ServerEntry serverEntry, String string) {
        int n = 0;
        EList eList = serverEntry.getSpecialEndpoints();
        int n2 = eList.size();
        for (int i = 0; i < n2; ++i) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)eList.get(i);
            String string2 = namedEndPoint.getEndPointName();
            if (string2 == null || !string2.equals(string)) continue;
            ++n;
        }
        if (n == 0) {
            this.addError("ERROR_SERVER_INDEX_MISSING_NAMED_END_POINT", new String[]{string}, serverEntry);
        } else if (n > 1) {
            this.addError("ERROR_SERVER_INDEX_TOO_MANY_NAMED_END_POINTS", new String[]{string}, serverEntry);
        }
    }

    protected void validateServerEntryNames(ServerIndex serverIndex) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((ServerEntry)eObject).getServerName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SERVER_INDEX_ENTRY_SERVER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)serverIndex.getServerEntries(), false, this, serverIndex);
    }

    protected void validateServerEndPointRefNames(ServerIndex serverIndex) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((NamedEndPoint)eObject).getEndPointName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SERVER_INDEX_END_POINT_REF_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)serverIndex.getEndPointRefs(), false, this, serverIndex);
    }

    protected void validateSingletonEntry(ServerIndex serverIndex, String string) {
        int n = 0;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string2 = serverEntry.getServerType();
            if (string2 == null || !string.equals(string2)) continue;
            ++n;
        }
        if (n == 0) {
            this.addError("ERROR_SERVER_INDEX_MISSING_ENTRY", new String[]{string}, serverIndex);
        } else if (n > 1) {
            this.addError("ERROR_SERVER_INDEX_TOO_MANY_ENTRIES", new String[]{string}, serverIndex);
        }
    }

    protected void validateSingletonNamedPort(ServerIndex serverIndex, String string) {
        int n = 0;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                String string2 = namedEndPoint.getEndPointName();
                if (string2 == null || !string.equals(string2)) continue;
                ++n;
            }
        }
        if (n == 0) {
            this.addError("ERROR_SERVER_INDEX_MISSING_NAMED_END_POINT", new String[]{string}, serverIndex);
        } else if (n > 1) {
            this.addError("ERROR_SERVER_INDEX_TOO_MANY_NAMED_END_POINTS", new String[]{string}, serverIndex);
        }
    }

    public void validateLocal(EndPointRef endPointRef) {
    }

    public void validateLocal(NamedEndPoint namedEndPoint) {
        String string = namedEndPoint.getEndPointName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_NAMED_END_POINT_NAME_REQUIRED", namedEndPoint);
        } else if (!this.getValidEndPointNames().contains(string)) {
            this.addWarning("WARNING_NAMED_END_POINT_UNRECOGNIZED_NAME", new String[]{string}, namedEndPoint);
        }
    }

    public void validateLocal(ServerEntry serverEntry) {
        Iterator iterator;
        String string;
        String string2 = serverEntry.getServerName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_SERVER_ENTRY_SERVER_NAME_REQUIRED", serverEntry);
        }
        if ((string = serverEntry.getServerType()) == null || string.length() == 0) {
            this.addError("ERROR_SERVER_ENTRY_SERVER_TYPE_REQUIRED", new String[]{string2}, serverEntry);
        } else if (!this.getValidEntryTypes().contains(string)) {
            this.addWarning("WARNING_SERVER_ENTRY_UNRECOGNIZED_TYPE", new String[]{string, string2}, serverEntry);
        } else if (string.equals("APPLICATION_SERVER") && !(iterator = serverEntry.getDeployedApplications().iterator()).hasNext()) {
            this.addWarning("WARNING_SERVER_ENTRY_LISTS_NO_APPLICATIONS", new String[]{string2}, serverEntry);
        }
    }

    public void validateLocal(ServerIndex serverIndex) {
        String string = serverIndex.getHostName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SERVER_INDEX_HOST_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, serverIndex);
        }
    }

    public void validatePortDuplication(ServerIndex serverIndex) {
        this.traceBegin("validatePortDuplication(ServerIndex)");
        HashMap hashMap = new HashMap();
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string = serverEntry.getServerName();
            if (string == null || string.length() == 0) {
                string = "(null)";
            }
            Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
            while (iterator2.hasNext()) {
                EndPoint endPoint;
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                String string2 = namedEndPoint.getEndPointName();
                if (string2 == null || string2.length() == 0) {
                    string2 = "(null)";
                }
                if ((endPoint = namedEndPoint.getEndPoint()) == null || endPoint.getHost() == null) continue;
                this.checkPort(hashMap, endPoint, string2, string);
            }
        }
        this.traceEnd();
    }

    protected void checkPort(HashMap hashMap, EndPoint endPoint, String string, String string2) {
        String string3 = endPoint.getHost();
        int n = endPoint.getPort();
        if (n == 0) {
            return;
        }
        this.traceBegin("checkPort(Hashtable, EndPoint)");
        this.trace("Host: ", string3);
        this.trace("Port: ", String.valueOf(n));
        Hashtable<String, EndPoint> hashtable = (Hashtable<String, EndPoint>)hashMap.get(String.valueOf(n));
        if (hashtable == null) {
            this.trace("First host using port");
            hashtable = new Hashtable<String, EndPoint>();
            hashtable.put(string3, endPoint);
            hashMap.put(String.valueOf(n), hashtable);
        } else {
            String string4;
            if (string3.equals("*")) {
                this.trace("Conflict of global host with existing host");
                string4 = "ERROR_SERVER_INDEX_GLOBAL_PORT_CONFLICT";
            } else if (hashtable.containsKey("*")) {
                this.trace("Conflict of host with existing global host");
                string4 = "ERROR_SERVER_INDEX_CONFLICT_WITH_GLOBAL_PORT";
            } else if (hashtable.containsKey(string3)) {
                this.trace("Conflict of host with existing host");
                string4 = "ERROR_SERVER_INDEX_PORT_CONFLICT";
            } else {
                this.trace("New occurrance of host");
                string4 = null;
            }
            if (string4 != null) {
                this.addError(string4, new String[]{string3, String.valueOf(n), string, string2}, endPoint);
            } else {
                hashtable.put(string3, endPoint);
            }
        }
        this.traceEnd();
    }

    protected HashSet getValidEntryTypes() {
        return _validEntryTypes;
    }

    protected HashSet getValidEndPointNames() {
        return _validEndPointNames;
    }

    static {
        _validEntryTypes.add("DEPLOYMENT_MANAGER");
        _validEntryTypes.add("MESSAGE_BROKER");
        _validEntryTypes.add("APPLICATION_SERVER");
        _validEntryTypes.add("NODE_AGENT");
        _validEntryTypes.add("DEPLOYMENT_MANAGER");
        _validEndPointNames = new HashSet();
        _validEndPointNames.add("DRS_CLIENT_ADDRESS");
        _validEndPointNames.add("JMSSERVER_DIRECT_ADDRESS");
        _validEndPointNames.add("JMSSERVER_QUEUED_ADDRESS");
        _validEndPointNames.add("BOOTSTRAP_ADDRESS");
        _validEndPointNames.add("NODE_DISCOVERY_ADDRESS");
        _validEndPointNames.add("CELL_DISCOVERY_ADDRESS");
        _validEndPointNames.add("CELL_MULTICAST_DISCOVERY_ADDRESS");
        _validEndPointNames.add("NODE_MULTICAST_DISCOVERY_ADDRESS");
        _validEndPointNames.add("ORB_LISTENER_ADDRESS");
        _validEndPointNames.add("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
        _validEndPointNames.add("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
        _validEndPointNames.add("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS");
        _validEndPointNames.add("SOAP_CONNECTOR_ADDRESS");
    }
}

