/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level51.VariablesValidationConstants_51;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class VariablesValidator_51
extends WebSphereLevelValidator
implements VariablesValidationConstants_51 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";

    public VariablesValidator_51(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.variablesvalidation_51_NLS";
    }

    public String getTraceName() {
        return "VariablesValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof VariableMap) {
            this.trace("Object recognized as a variable map; validating");
            this.validateLocal((VariableMap)object);
            this.validateAcross((VariableMap)object);
        } else if (object instanceof VariableSubstitutionEntry) {
            this.trace("Object recognized as a variable substitution entry; validating");
            this.validateLocal((VariableSubstitutionEntry)object);
            this.validateAcross((VariableSubstitutionEntry)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public boolean testVariableMapSymbolicName(String string) {
        this.traceStub("Syntax test of path map symbolic name: ", string);
        return true;
    }

    public void validateAcross(VariableMap variableMap) {
        this.validateVariableMapEntriesDuplication(variableMap);
    }

    public void validateAcross(VariableSubstitutionEntry variableSubstitutionEntry) {
    }

    public void validateLocal(VariableMap variableMap) {
        this.traceBegin("validateLocal(VariableMap)");
        this.traceEnd();
    }

    public void validateLocal(VariableSubstitutionEntry variableSubstitutionEntry) {
        String string = variableSubstitutionEntry.getSymbolicName();
        this.traceBegin("validateLocal(VariableSubstitutionEntry)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_VARIABLE_MAP_SYMBOLIC_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, variableSubstitutionEntry);
        } else if (!this.testVariableMapSymbolicName(string)) {
            this.addError("ERROR_VARIABLE_MAP_SYMBOLIC_NAME_INVALID", new String[]{string, this.getCurrentFileName()}, variableSubstitutionEntry);
        }
        String string2 = variableSubstitutionEntry.getValue();
        if (string2 == null || string2.length() == 0) {
            // empty if block
        }
        this.traceEnd();
    }

    public void validateVariableMapEntriesDuplication(VariableMap variableMap) {
        this.traceStub("Don't know if the case of a variable map entry symbolic name matters;");
        this.traceStub("Assuming that it does not.");
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((VariableSubstitutionEntry)eObject).getSymbolicName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_VARIABLE_MAP_ENTRY_DUPLICATION";
            }
        };
        duplicationTester.test((List)variableMap.getEntries(), false, this, variableMap);
    }
}

