/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.DCSInboundChannel;
import com.ibm.websphere.models.config.coregroupbridgeservice.AccessPointGroup;
import com.ibm.websphere.models.config.coregroupbridgeservice.BridgeInterface;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupAccessPoint;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeSettings;
import com.ibm.websphere.models.config.coregroupbridgeservice.PeerAccessPoint;
import com.ibm.websphere.models.config.coregroupbridgeservice.WLMCoreGroupBridgePlugin;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.CoreGroupBridgeValidationConstants_60;
import com.ibm.websphere.validation.base.config.level60.CoreGroupBridgeValidatorUtil_60;
import com.ibm.websphere.validation.base.config.level60.ServerContextCrossValidator_60;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class CoreGroupBridgeCrossValidator_60_Default
extends ServerContextCrossValidator_60
implements CoreGroupBridgeValidationConstants_60 {
    public static final String pgmVersion = "1.0";
    public static final String pgmUpdate = "3/03/04";
    protected boolean _pastTopList = false;
    protected CoreGroupBridgeSettings _boundCGBridgeSettings = null;

    public CoreGroupBridgeCrossValidator_60_Default(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundCGBridgeSettings = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundCGBridgeSettings = null;
    }

    protected void bindDomain(CoreGroupBridgeSettings coreGroupBridgeSettings) {
        this._boundCGBridgeSettings = coreGroupBridgeSettings;
    }

    protected CoreGroupBridgeSettings getBoundDomain() {
        return this._boundCGBridgeSettings;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.coregroupbridgevalidation_60_NLS";
    }

    public String getTraceName() {
        return "CoreGroupBridgeCrossValidator";
    }

    public void visitNonList(Object object) throws ValidationException {
        this.visitTraversing(object);
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof CoreGroupBridgeSettings) {
            this.bindDomain((CoreGroupBridgeSettings)object);
            this.validateAcross((CoreGroupBridgeSettings)object);
        } else if (object instanceof WLMCoreGroupBridgePlugin) {
            this.trace("Object recognized as a WLMCoreGroupBridgePlugin; validating");
            this.validateAcross((WLMCoreGroupBridgePlugin)object);
        } else if (object instanceof AccessPointGroup) {
            this.trace("Object recognized as a AccessPointGroup; validating");
            this.validateAcross((AccessPointGroup)object);
        } else if (object instanceof PeerAccessPoint) {
            this.trace("Object recognized as a PeerAccessPoint; validating");
            this.validateAcross((PeerAccessPoint)object);
        } else if (object instanceof CoreGroupAccessPoint) {
            this.trace("Object recognized as a CoreGroupAccessPoint; validating");
            this.validateAcross((CoreGroupAccessPoint)object);
        } else if (object instanceof BridgeInterface) {
            this.trace("Object recognized as a BridgeInterface; validating");
            this.validateAcross((BridgeInterface)object);
        } else if (object instanceof Property) {
            this.trace("Object recognized as a Property; validating");
            this.validateAcross((Property)object);
        } else if (object instanceof EndPoint) {
            this.trace("Object recognized as a EndPoint; validating");
            this.validateAcross((EndPoint)object);
        } else {
            return false;
        }
        return true;
    }

    public void validateAcross(CoreGroupBridgeSettings coreGroupBridgeSettings) {
    }

    public void validateAcross(WLMCoreGroupBridgePlugin wLMCoreGroupBridgePlugin) {
        this.traceStub("validateAcross(WLMCoreGroupBridgePlugin)");
        if (!this.getCoreGroupNames().contains(wLMCoreGroupBridgePlugin.getCoreGroup())) {
            this.addError("ERROR_WLMCGBRIDGEPLUGIN_COREGROUP_INVALID", new String[]{wLMCoreGroupBridgePlugin.getCoreGroup()}, wLMCoreGroupBridgePlugin);
        }
    }

    public void validateAcross(AccessPointGroup accessPointGroup) {
        this.traceStub("validateAcross(AccessPointGroup)");
        EList eList = accessPointGroup.getCoreGroupAccessPointRefs();
        if (eList == null) {
            return;
        }
        int n = eList.size();
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>(1);
        for (int i = 0; i < n; ++i) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)eList.get(i);
            EList eList2 = coreGroupAccessPoint.getBridgeInterfaces();
            int n2 = eList2.size();
            for (int j = 0; j < n2; ++j) {
                BridgeInterface bridgeInterface = (BridgeInterface)eList2.get(j);
                String string = bridgeInterface.getNode() + ":" + bridgeInterface.getServer() + bridgeInterface.getChain();
                String string2 = (String)hashMap.get(string);
                if (string2 == null) {
                    string2 = CoreGroupBridgeValidatorUtil_60.getChainEndPoint(this.getWorkSpaceHelper(), bridgeInterface.getNode(), bridgeInterface.getServer(), bridgeInterface.getChain());
                }
                if (string2 == null) {
                    return;
                }
                hashSet.add(string2);
            }
        }
        if (hashSet.size() == 0) {
            return;
        }
        if (hashSet.size() != 1) {
            this.addError("ERROR_ACCESSPOINTGROUP_COMMON_ENDPOINT_NAME_REQUIRED", new String[]{accessPointGroup.getName()}, accessPointGroup);
        }
    }

    public void validateAcross(PeerAccessPoint peerAccessPoint) {
    }

    public void validateAcross(CoreGroupAccessPoint coreGroupAccessPoint) {
        this.traceStub("validateAcross(CoreGroupAccessPoint)");
        if (!this.getCoreGroupNames().contains(coreGroupAccessPoint.getCoreGroup())) {
            this.addError("ERROR_COREGROUPACCESSPOINT_COREGROUP_INVALID", new String[]{coreGroupAccessPoint.getCoreGroup(), coreGroupAccessPoint.getName()}, coreGroupAccessPoint);
        }
        EList eList = coreGroupAccessPoint.getBridgeInterfaces();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            BridgeInterface bridgeInterface = (BridgeInterface)eList.get(i);
            if (CoreGroupBridgeValidatorUtil_60.isBridgeServiceEnabled(this.getWorkSpaceHelper(), bridgeInterface)) continue;
            this.addError("ERROR_BRIDGEINTERFACE_CGBRIDGE_SERVICE_DISABLED", new String[]{bridgeInterface.getServer(), bridgeInterface.getNode()}, coreGroupAccessPoint);
        }
    }

    public void validateAcross(Property property) {
    }

    public void validateAcross(EndPoint endPoint) {
    }

    public void validateAcross(BridgeInterface bridgeInterface) {
        this.traceStub("validateAcross(BridgeInterface)");
        String string = bridgeInterface.getNode();
        String string2 = bridgeInterface.getServer();
        String string3 = bridgeInterface.getChain();
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        String string4 = CoreGroupBridgeValidatorUtil_60.getPathToServerConfig(this.getCellName(), string, string2);
        EList eList = (EList)this.loadModel(string4);
        Server server2 = (Server)eList.get(0);
        EList eList2 = server2.getServices();
        int n = eList2.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = eList2.get(i);
            if (!(object instanceof TransportChannelService)) continue;
            TransportChannelService transportChannelService = (TransportChannelService)object;
            EList eList3 = transportChannelService.getChains();
            int n2 = eList3.size();
            for (int j = 0; j < n2; ++j) {
                Chain chain = (Chain)eList3.get(j);
                if (!chain.getName().equalsIgnoreCase(string3)) continue;
                bl = true;
                EList eList4 = chain.getTransportChannels();
                int n3 = eList4.size();
                for (int k = 0; k < n3; ++k) {
                    if (!(eList4.get(k) instanceof DCSInboundChannel)) continue;
                    return;
                }
                this.addError("ERROR_BRIDGEINTERFACE_DCS_CHAIN_REQUIRED", new String[]{chain.getName(), string2, string}, bridgeInterface);
            }
            if (bl) continue;
            this.addError("ERROR_BRIDGEINTERFACE_CHAIN_UNDEFINED_FOR_SERVER", new String[]{string3, ((CoreGroupAccessPoint)bridgeInterface.eContainer()).getName(), string2, string}, bridgeInterface);
        }
    }
}

