/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.MultiBrokerValidationConstants_60;
import java.util.ArrayList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class MultiBrokerCrossValidator_60
extends WebSphereLevelCrossValidator
implements MultiBrokerValidationConstants_60 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    protected boolean _pastTopList = false;
    protected MultibrokerDomain _boundDomain = null;

    public MultiBrokerCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void bindDomain(MultibrokerDomain multibrokerDomain) {
        this._boundDomain = multibrokerDomain;
    }

    protected MultibrokerDomain getBoundDomain() {
        return this._boundDomain;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.multibrokervalidation_60_NLS";
    }

    public String getTraceName() {
        return "MultiBrokerCrossValidator";
    }

    public void visitNonList(Object object) throws ValidationException {
        this.visitTraversing(object);
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof MultibrokerDomain) {
            this.bindDomain((MultibrokerDomain)object);
        } else if (object instanceof MultiBrokerRoutingEntry) {
            this.trace("Entry recognized as a multi-broker routing entry; validating");
            this.validateAcross((MultiBrokerRoutingEntry)object);
        }
        return bl;
    }

    public void validateAcross(MultiBrokerRoutingEntry multiBrokerRoutingEntry) {
        String string = multiBrokerRoutingEntry.getBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getWorkSpaceHelper().fillMessageServers(arrayList, arrayList2, string);
        int n = arrayList.size();
        int n2 = arrayList2.size();
        if (n == 0 && n2 == 0) {
            this.addWarning("WARNING_ROUTING_ENTRY_NO_MATCHING_SYSTEM_MESSAGE_SERVER", new String[]{string, this.getBoundDomain().getName()}, multiBrokerRoutingEntry);
        } else if (n > 1) {
            this.addError("ERROR_ROUTING_ENTRY_MULTIPLE_STARTING_SYSTEM_MESSAGE_SERVERS", new String[]{string, this.getBoundDomain().getName()}, multiBrokerRoutingEntry);
        }
    }
}

