/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.multibroker.DataReplicationDomain;
import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSConnectionPool;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSPartition;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSSerialization;
import com.ibm.websphere.models.config.multibroker.drsclient.DataReplication;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.MultiBrokerValidationConstants_60;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class MultiBrokerValidator_60
extends WebSphereLevelValidator
implements MultiBrokerValidationConstants_60 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "6/24/04";
    protected boolean _pastTopList = false;
    protected MultibrokerDomain _boundDomain = null;

    public MultiBrokerValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundDomain = null;
    }

    protected void bindDomain(MultibrokerDomain multibrokerDomain) {
        this._boundDomain = multibrokerDomain;
    }

    protected MultibrokerDomain getBoundDomain() {
        return this._boundDomain;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.multibrokervalidation_60_NLS";
    }

    public String getTraceName() {
        return "MultiBrokerValidator_60";
    }

    protected void visitList(List list) throws ValidationException {
        boolean bl;
        if (!this._pastTopList) {
            bl = true;
            this._pastTopList = true;
        } else {
            bl = false;
        }
        super.visitList(list);
        if (bl) {
            this.validateMultibrokers(list);
        }
    }

    protected void validateMultibrokers(List list) {
        this.validateMultibrokerDomainNames(list);
        this.validateMultiBrokerEntryNames(list);
    }

    protected void validateMultibrokerDomainNames(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                MultiBrokerValidator_60.this.trace("Returning name of rep domain: ", eObject);
                String string = eObject instanceof MultibrokerDomain ? ((MultibrokerDomain)eObject).getName() : (eObject instanceof DataReplicationDomain ? ((DataReplicationDomain)eObject).getName() : null);
                MultiBrokerValidator_60.this.trace("Found name: ", string);
                if (string != null) {
                    return string.toUpperCase();
                }
                return "";
            }

            protected String getEmptyMessage() {
                return "ERROR_MULTIBROKER_DOMAIN_NAME_REQUIRED";
            }

            protected String getDuplicateMessage() {
                return "ERROR_MULTIBROKER_DOMAIN_NAME_DUPLICATION";
            }
        };
        duplicationTester.test(list, false, this, null);
    }

    protected void validateMultiBrokerEntryNames(List list) {
        Hashtable<String, MultiBrokerRoutingEntry> hashtable = new Hashtable<String, MultiBrokerRoutingEntry>();
        Hashtable<String, MultiBrokerRoutingEntry> hashtable2 = new Hashtable<String, MultiBrokerRoutingEntry>();
        Iterator iterator = list.iterator();
        Object var5_5 = null;
        while (iterator.hasNext()) {
            var5_5 = iterator.next();
            if (var5_5 instanceof DataReplicationDomain) continue;
            MultibrokerDomain multibrokerDomain = var5_5;
            Iterator iterator2 = multibrokerDomain.getEntries().iterator();
            while (iterator2.hasNext()) {
                MultiBrokerRoutingEntry multiBrokerRoutingEntry = (MultiBrokerRoutingEntry)iterator2.next();
                String string = multiBrokerRoutingEntry.getBrokerName();
                if (string == null || string.length() == 0 || hashtable.put(string, multiBrokerRoutingEntry) == null || hashtable2.put(string, multiBrokerRoutingEntry) != null) continue;
                this.addError("ERROR_MULTIBROKER_ENTRY_DUPLICATION", new String[]{string}, multiBrokerRoutingEntry);
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof MultiBrokerRoutingEntry) {
            this.trace("Object recognized as a multi broker routing entry; validating");
            this.validateLocal((MultiBrokerRoutingEntry)object);
            this.validateAcross((MultiBrokerRoutingEntry)object);
        } else if (object instanceof MultibrokerDomain) {
            this.trace("Object recognized as a multi broker domain; validating");
            this.bindDomain((MultibrokerDomain)object);
            this.validateLocal((MultibrokerDomain)object);
            this.validateAcross((MultibrokerDomain)object);
        } else if (object instanceof DataReplicationDomain) {
            this.trace("Object recognized as a dataReplicationDomain; validating");
            this.validateLocal((DataReplicationDomain)object);
            this.validateAcross((DataReplicationDomain)object);
        } else if (object instanceof DRSConnectionPool) {
            this.trace("Object recognized as a DRS connection pool; validating");
            this.validateLocal((DRSConnectionPool)object);
            this.validateAcross((DRSConnectionPool)object);
        } else if (object instanceof DRSPartition) {
            this.trace("Object recognized as a DRS partition; validating");
            this.validateLocal((DRSPartition)object);
            this.validateAcross((DRSPartition)object);
        } else if (object instanceof DRSSerialization) {
            this.trace("Object recognized as a DRS serialization; validating");
            this.validateLocal((DRSSerialization)object);
            this.validateAcross((DRSSerialization)object);
        } else if (object instanceof DataReplication) {
            this.trace("Object recognized as a data replication; validating");
            this.validateLocal((DataReplication)object);
            this.validateAcross((DataReplication)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(MultiBrokerRoutingEntry multiBrokerRoutingEntry) {
        if (multiBrokerRoutingEntry.getBrokerEndPoint() == null) {
            this.addError("ERROR_MULTIBROKER_ROUTING_ENTRY_BROKER_REQUIRED", new String[]{this.getBoundDomain().getName(), multiBrokerRoutingEntry.getBrokerName()}, multiBrokerRoutingEntry);
        }
        if (multiBrokerRoutingEntry.getClientEndPoint() == null) {
            this.addError("ERROR_MULTIBROKER_ROUTING_ENTRY_CLIENT_REQUIRED", new String[]{this.getBoundDomain().getName(), multiBrokerRoutingEntry.getBrokerName()}, multiBrokerRoutingEntry);
        }
    }

    public void validateAcross(MultibrokerDomain multibrokerDomain) {
        String string = multibrokerDomain.getName();
        this.trace("Check use of deprecated attributes for domain: ", string);
        DataReplication dataReplication = multibrokerDomain.getDefaultDataReplicationSettings();
        if (dataReplication == null) {
            this.addError("ERROR_MULTIBROKER_DOMAIN_REPLICATION_SETTINGS_REQUIRED", new String[]{string}, multibrokerDomain);
            return;
        }
        DataReplication dataReplication2 = multibrokerDomain.getDefaultDataReplicationSettings();
        int n = dataReplication2.getNumberOfReplicas();
        if (n != 1) {
            this.addWarning("WARNING_USE_OF_INCORRECT_ATTRIBUTE", new String[]{Integer.toString(n), string}, multibrokerDomain);
        }
        String string2 = dataReplication2.getUserId();
        this.trace("Check use of deprecated attribute: UserID: ", string2);
        if (string2 != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.userId", string}, multibrokerDomain);
        }
        String string3 = dataReplication.getPassword();
        this.trace("Check use of deprecated attribute: Password: ", string3);
        if (string3 != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.password", string}, multibrokerDomain);
        }
        boolean bl = dataReplication.isUseSSL();
        this.trace("Check use of deprecated attribute: useSSL: ", new Boolean(bl));
        if (bl) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.ssl", string}, multibrokerDomain);
        }
        SecureSocketLayer secureSocketLayer = dataReplication.getSsl();
        this.trace("Check use of deprecated attribute: SSL: ", secureSocketLayer);
        if (secureSocketLayer != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.ssl", string}, multibrokerDomain);
        }
    }

    public void validateAcross(DataReplicationDomain dataReplicationDomain) {
        int n;
        String string = dataReplicationDomain.getName();
        this.trace("Check use of deprecated attributes for domain: ", string);
        if (dataReplicationDomain.getDefaultDataReplicationSettings() == null) {
            this.addError("ERROR_MULTIBROKER_DOMAIN_REPLICATION_SETTINGS_REQUIRED", new String[]{string}, dataReplicationDomain);
            return;
        }
        DataReplication dataReplication = dataReplicationDomain.getDefaultDataReplicationSettings();
        if (dataReplication.getMessageBrokerName() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.messageBrokerName", string}, dataReplicationDomain);
        }
        if (dataReplication.getUserId() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.userId", string}, dataReplicationDomain);
        }
        if (dataReplication.getPassword() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.password", string}, dataReplicationDomain);
        }
        if (dataReplication.getPartition() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.partition", string}, dataReplicationDomain);
        }
        if (dataReplication.getSerialization() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.getSerialization", string}, dataReplicationDomain);
        }
        if (dataReplication.getPooling() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.pooling", string}, dataReplicationDomain);
        }
        if (dataReplication.isUseSSL()) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.ssl", string}, dataReplicationDomain);
        }
        if (dataReplication.getSsl() != null) {
            this.addWarning("WARNING_DEPRECATED_ATTRIBUTE_USED", new String[]{"DataReplication.ssl", string}, dataReplicationDomain);
        }
        if ((n = dataReplication.getNumberOfReplicas()) < -1 || n > 15) {
            this.addError("ERROR_INVALID_NUMBER_OF_REPLICAS", new String[]{Integer.toString(n), string}, dataReplicationDomain);
        }
    }

    public void validateAcross(DRSConnectionPool dRSConnectionPool) {
        this.traceStub("validateAcross(DRSConnectionPool)");
    }

    public void validateAcross(DRSPartition dRSPartition) {
        this.traceStub("validateAcross(DRSPartition)");
    }

    public void validateAcross(DRSSerialization dRSSerialization) {
        this.traceStub("validateAcross(DRSSerialization)");
    }

    public void validateAcross(DataReplication dataReplication) {
    }

    public void validateLocal(MultiBrokerRoutingEntry multiBrokerRoutingEntry) {
        String string = multiBrokerRoutingEntry.getBrokerName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MULTIBROKER_ROUTING_ENTRY_BROKER_NAME_REQUIRED", new String[]{this.getBoundDomain().getName()}, multiBrokerRoutingEntry);
        }
    }

    public void validateLocal(MultibrokerDomain multibrokerDomain) {
        String string = multibrokerDomain.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MULTIBROKER_DOMAIN_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, multibrokerDomain);
        }
    }

    public void validateLocal(DataReplicationDomain dataReplicationDomain) {
        String string = dataReplicationDomain.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MULTIBROKER_DOMAIN_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, dataReplicationDomain);
        }
    }

    public void validateLocal(DRSConnectionPool dRSConnectionPool) {
        this.traceStub("validateLocal(DRSConnectionPool)");
    }

    public void validateLocal(DRSPartition dRSPartition) {
        this.traceStub("validateLocal(DRSPartition)");
    }

    public void validateLocal(DRSSerialization dRSSerialization) {
        this.traceStub("validateLocal(DRSSerialization)");
    }

    public void validateLocal(DataReplication dataReplication) {
    }
}

