/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.NodeGroupValidationConstants_60;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class NodeGroupValidator_60
extends WebSphereLevelValidator
implements NodeGroupValidationConstants_60 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    NodeGroup _boundNodeGroup = null;

    public NodeGroupValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._boundNodeGroup = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._boundNodeGroup = null;
    }

    protected void bindNodeGroup(NodeGroup nodeGroup) {
        this._boundNodeGroup = nodeGroup;
    }

    protected NodeGroup getboundNodeGroup() {
        return this._boundNodeGroup;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.nodegroupvalidation_60_NLS";
    }

    public String getTraceName() {
        return "NodeGroupValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof NodeGroup) {
            this.trace("Object recognized as an Node Group; validating");
            this.bindNodeGroup((NodeGroup)object);
            this.validateLocal((NodeGroup)object);
            this.validateAcross((NodeGroup)object);
        } else if (object instanceof NodeGroupMember) {
            this.trace("Object recognized as a node group member; validating");
            this.validateLocal((NodeGroupMember)object);
            this.validateAcross((NodeGroupMember)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(NodeGroup nodeGroup) {
        this.validateNodeGroupMemberNames(nodeGroup);
    }

    protected void validateNodeGroupMemberNames(NodeGroup nodeGroup) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((NodeGroupMember)eObject).getNodeName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return "ERROR_NODEGROUP_MUST_HAVE_A_MEMBER";
            }

            protected String getDuplicateMessage() {
                return "ERROR_NODEGROUP_MEMBER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)nodeGroup.getMembers(), true, this, nodeGroup);
    }

    public void validateAcross(NodeGroupMember nodeGroupMember) {
        this.traceStub("validateAcross(NodeGroupMember)");
    }

    public void validateLocal(NodeGroupMember nodeGroupMember) {
        String string = nodeGroupMember.getNodeName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_NODEGROUP_MEMBER_NAME_REQUIRED", new String[]{this.getboundNodeGroup().getName()}, nodeGroupMember);
        }
    }

    public void validateLocal(NodeGroup nodeGroup) {
        String string = nodeGroup.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_NODEGROUP_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, nodeGroup);
        }
    }
}

