/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeService;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextCrossValidator_60;
import com.ibm.websphere.validation.base.config.level60.ServerValidationConstants_60;
import com.ibm.websphere.validation.bundling.ValidationMessage;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ServerCrossValidator_60_Default
extends ServerContextCrossValidator_60
implements ServerValidationConstants_60 {
    public static final String pgmVersion = "1.7";
    public static final String pgmUpdate = "10/24/06";
    protected WebSphereDelegateCrossValidator _channelCrossValidator;
    protected boolean _channelCrossValidatorLoaded = false;
    protected static final String type = "com.ibm.ws.channel.validation.ChannelFrameworkCrossValidator";
    protected static final String bundle = "com.ibm.ws.sm.validation.impl.ValidationManagerImplNLS";

    public ServerCrossValidator_60_Default(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.servervalidation_60_NLS";
    }

    public String getTraceName() {
        return "ServerCrossValidator60";
    }

    protected void visitNonList(Object object) throws ValidationException {
        this.visitTraversing(object);
    }

    protected WebSphereDelegateCrossValidator getChannelCrossValidator() {
        if (!this._channelCrossValidatorLoaded) {
            this._channelCrossValidatorLoaded = true;
            try {
                Class clazz = this.getExtendedClass(type);
                Constructor constructor = clazz.getConstructor(MOFValidator.class);
                this._channelCrossValidator = (WebSphereDelegateCrossValidator)constructor.newInstance(this);
            }
            catch (Exception exception) {
                this._channelCrossValidator = null;
                this.getReporter().addMessage((IValidator)this, (IMessage)new ValidationMessage(bundle, 4, "WSVM1002E", new String[]{type, exception.getMessage()}, null));
            }
        }
        return this._channelCrossValidator;
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof Server) {
            this.trace("Object recognized as a server; validating");
            this.validateAcross((Server)object);
        } else if (object instanceof WebContainer) {
            this.trace("Object recognized as a session manager; validating");
            this.validateAcross((WebContainer)object);
        } else if (object instanceof TransportChannelService) {
            this.trace("Object recognized as a channel framework service; validating.");
            this.validateAcross((TransportChannelService)object);
        } else if (object instanceof CoreGroupBridgeService) {
            this.trace("Object recognized as a core group bridge service; validating.");
            this.validateAcross((CoreGroupBridgeService)object);
        }
        return true;
    }

    public void validateAcross(TransportChannelService transportChannelService) throws ValidationException {
        WebSphereDelegateCrossValidator webSphereDelegateCrossValidator = this.getChannelCrossValidator();
        if (webSphereDelegateCrossValidator != null) {
            webSphereDelegateCrossValidator.visit(transportChannelService);
        }
    }

    public void validateAcross(Server server2) {
        this.validateServerClusterName(server2);
        this.validateProcessDefs(server2);
    }

    protected void validateServerClusterName(Server server2) {
        Object object;
        String string;
        String string2 = server2.getName();
        this.trace("Validating cluster name for server: ", string2);
        String string3 = server2.getClusterName();
        this.trace("Validating cluster name for server: ", string2);
        if (string3 == null || string3.length() == 0) {
            this.trace("No cluster name was specified; returning.");
            return;
        }
        this.trace("Cluster name of server: ", string3);
        Iterator iterator = this.getClusterNames().iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            string = (String)iterator.next();
            bl = string3.equals(string);
        }
        if (!bl) {
            this.addError("ERROR_SERVER_CLUSTER_NAME_MATCHES_NO_CLUSTER", new String[]{string2, string3}, server2);
            return;
        }
        string = this.getCellUri() + "/" + "clusters" + "/" + string3 + "/" + "cluster.xml";
        this.trace("Cluster URI: ", string);
        Object object2 = this.loadModel(string);
        if (object2 == null) {
            this.trace("Unable to load cluster.");
            object = null;
        } else if (!(object2 instanceof List)) {
            this.trace("Loaded cluster is not a list.");
            object = object2;
        } else {
            Iterator iterator2 = ((List)object2).iterator();
            if (!iterator2.hasNext()) {
                this.trace("Loaded cluster is an empty list.");
                object = null;
            } else {
                object = iterator2.next();
            }
        }
        boolean bl2 = false;
        if (object != null && !(object instanceof ServerCluster)) {
            this.trace("Loaded cluster is not a server cluster.");
            object = null;
        } else {
            ServerCluster serverCluster = (ServerCluster)object;
            Iterator iterator3 = serverCluster.getMembers().iterator();
            while (!bl2 && iterator3.hasNext()) {
                ClusterMember clusterMember = (ClusterMember)iterator3.next();
                String string4 = clusterMember.getMemberName();
                bl2 = string2.equals(string4);
            }
        }
        if (!bl2) {
            this.addError("ERROR_SERVER_NOT_PRESENT_IN_CLUSTER", new String[]{string2, string3}, server2);
        }
    }

    protected void validateProcessDefs(Server server2) {
        WebServer webServer = this.getWebServer(server2);
        if (webServer == null) {
            return;
        }
        int n = webServer.getWebserverType().getValue();
        Iterator iterator = server2.getProcessDefinitions().iterator();
        if (!iterator.hasNext()) {
            if ((n == 0 || n == 6) && this.isFederated()) {
                this.addError("ERROR_PROCESS_DEF_REQUIRED", new String[]{server2.getName()}, server2);
            }
        } else if (n == 0 && this.isFederated()) {
            while (iterator.hasNext()) {
                ProcessDef processDef = (ProcessDef)iterator.next();
                String string = processDef.getWorkingDirectory();
                if (string != null && string.length() != 0) continue;
                this.addError("ERROR_PROCESS_DEF_WORKING_DIRECTORY_REQUIRED", processDef);
            }
        }
    }

    public void validateAcross(SessionManager sessionManager) {
        Object object;
        String string;
        int n = sessionManager.getSessionPersistenceMode().getValue();
        if (n == 2) {
            return;
        }
        DRSSettings dRSSettings = sessionManager.getSessionDRSPersistence();
        if (dRSSettings == null) {
            return;
        }
        String string2 = dRSSettings.getMessageBrokerDomainName();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        Iterator iterator = this.getMultibrokerDomains().iterator();
        String string3 = null;
        while (string3 == null && iterator.hasNext()) {
            string = (MultibrokerDomain)iterator.next();
            object = string.getName();
            if (!string2.equals(object)) continue;
            string3 = string;
        }
        if (string3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_DOMAIN", new String[]{string2}, sessionManager);
            return;
        }
        string = dRSSettings.getPreferredLocalDRSBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        object = string3.getEntries().iterator();
        MultiBrokerRoutingEntry multiBrokerRoutingEntry = null;
        while (multiBrokerRoutingEntry == null && object.hasNext()) {
            MultiBrokerRoutingEntry multiBrokerRoutingEntry2 = (MultiBrokerRoutingEntry)object.next();
            String string4 = multiBrokerRoutingEntry2.getBrokerName();
            if (!string.equals(string4)) continue;
            multiBrokerRoutingEntry = multiBrokerRoutingEntry2;
        }
        if (string3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_ENTRY", new String[]{string2, string}, sessionManager);
        }
    }

    public void validateAcross(WebContainer webContainer) {
        Iterator iterator = webContainer.getTransports().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        HashSet hashSet = this.getCellSecurityAliasTable();
        while (iterator.hasNext()) {
            String string;
            Transport transport2 = (Transport)iterator.next();
            boolean bl = transport2.isSslEnabled();
            if (!bl || (string = transport2.getSslConfig()) == null && string.length() == 0 || hashSet.contains(string)) continue;
            EndPoint endPoint = transport2.getAddress();
            String string2 = endPoint != null ? endPoint.getHost() : null;
            int n = endPoint != null ? endPoint.getPort() : 0;
            String string3 = String.valueOf(n);
            this.addError("ERROR_TRANSPORT_ALIAS_NOT_FOUND", new String[]{webContainer.getName(), string2, string3, string}, transport2);
        }
    }

    public void validateAcross(CoreGroupBridgeService coreGroupBridgeService) {
        boolean bl = coreGroupBridgeService.isEnable();
        String string = this.getSiblingPath("hamanagerservice.xml");
        HAManagerService hAManagerService = (HAManagerService)this.loadModel(string, HAManagerService.class, MOFValidator.FORBID_EMPTY_COLLECTION);
        if (hAManagerService == null) {
            this.trace("Failed to load sibling HaManagerService: ", string);
            return;
        }
        boolean bl2 = hAManagerService.isEnable();
        if (bl2 && !bl) {
            this.addWarning("WARNING_CGBRIDGE_DISABLED_AND_HAMANAGER_ENABLED", coreGroupBridgeService);
        }
        if (bl && !bl2) {
            this.addWarning("ERROR_CGBRIDGE_HAMANAGER_DISABLED_AND_CGBRIDGE_ENABLED", coreGroupBridgeService);
        }
    }
}

