/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.ExtensionMBean;
import com.ibm.websphere.models.config.adminservice.ExtensionMBeanProvider;
import com.ibm.websphere.models.config.adminservice.HTTPConnector;
import com.ibm.websphere.models.config.adminservice.JMSConnector;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationContainer;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ApplicationserverPackage;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroup;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroupMember;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBCache;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.applicationserver.webcontainer.Cookie;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.InvalidationSchedule;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionDatabasePersistence;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.TuningParams;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebcontainerPackage;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.httpserver.ExternallyManagedHTTPServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.loggingservice.ras.RasPackage;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.messagingserver.JMSTransport;
import com.ibm.websphere.models.config.namebindings.CORBAObjectNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.EjbNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.IndirectLookupNameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.NameSpaceBinding;
import com.ibm.websphere.models.config.namebindings.StringNameSpaceBinding;
import com.ibm.websphere.models.config.namestore.NameBinding;
import com.ibm.websphere.models.config.namestore.NamingContext;
import com.ibm.websphere.models.config.namingserver.NameServer;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.FileTransferService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.LSDConnection;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.process.Agent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.CustomService;
import com.ibm.websphere.models.config.process.Extension;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.ServiceContext;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.MonitoringPolicy;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessExecution;
import com.ibm.websphere.models.config.processexec.ProcessexecPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.TypedProperty;
import com.ibm.websphere.models.config.traceservice.TraceLog;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.models.config.traceservice.TraceservicePackage;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.models.config.webserver.WebserverPackage;
import com.ibm.websphere.models.config.wlmserver.WorkloadManagementServer;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextValidator_60;
import com.ibm.websphere.validation.base.config.level60.ServerValidationConstants_60;
import com.ibm.websphere.validation.bundling.ValidationMessage;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ServerValidator_60_Default
extends ServerContextValidator_60
implements ServerValidationConstants_60 {
    public static final String pgmVersion = "1.8";
    public static final String pgmUpdate = "3/7/06";
    protected boolean _pastTopList = false;
    protected boolean _channelValidatorLoaded = false;
    protected WebSphereDelegateValidator _channelValidator = null;
    protected static final String type = "com.ibm.ws.channel.validation.ChannelFrameworkValidator";
    protected static final String bundle = "com.ibm.ws.sm.validation.impl.ValidationManagerImplNLS";
    public static final String QUEUE_NAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.%_/";

    public ServerValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.servervalidation_60_NLS";
    }

    public String getTraceName() {
        return "ServerValidator_60";
    }

    protected void visitList(List list) throws ValidationException {
        if (!this._pastTopList) {
            this._pastTopList = true;
            this.validateRootServer(list);
        }
        super.visitList(list);
    }

    protected void validateRootServer(List list) {
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            this.addError("ERROR_EMPTY_SERVER_DOCUMENT", new String[]{this.getCurrentFileName()}, null);
        } else {
            Object e2 = iterator.next();
            if (!(e2 instanceof Server)) {
                this.addError("ERROR_ROOT_OBJECT_NOT_A_SERVER", new String[]{this.getCurrentFileName(), e2.getClass().getName()}, e2);
            }
            if (iterator.hasNext()) {
                this.addError("ERROR_SERVER_DOCUMENT_HAS_MULTIPLE_ROOTS", new String[]{this.getCurrentFileName()}, null);
            }
        }
    }

    public void visitNonList(Object object) throws ValidationException {
        if (object instanceof JMSServer) {
            this.basicVisit(object);
            JMSServer jMSServer = (JMSServer)object;
            EndPoint endPoint = jMSServer.getSecurityPort();
            if (endPoint != null) {
                this.validateJMSServerEndPoint(endPoint);
            }
        } else if (object instanceof TransportChannelService) {
            this.basicVisit(object);
        } else {
            super.visitNonList(object);
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof AdminService) {
            this.trace("Object recognized as an admin service; validating");
            this.validateLocal((Service)((AdminService)object));
            this.validateAcross((AdminService)object);
        } else if (object instanceof ExtensionMBean) {
            this.trace("Object recognized as an extension MBean; validating");
            this.validateLocal((ExtensionMBean)object);
            this.validateAcross((ExtensionMBean)object);
        } else if (object instanceof ExtensionMBeanProvider) {
            this.trace("Object recognized as an extension MBean provider; validating");
            this.validateLocal((ExtensionMBeanProvider)object);
            this.validateAcross((ExtensionMBeanProvider)object);
        } else if (object instanceof HTTPConnector) {
            this.trace("Object recognized as an HTTP connector; validating");
            this.validateLocal((HTTPConnector)object);
            this.validateAcross((HTTPConnector)object);
        } else if (object instanceof JMSConnector) {
            this.trace("Object recognized as a JMS connector; validating");
            this.validateLocal((JMSConnector)object);
            this.validateAcross((JMSConnector)object);
        } else if (object instanceof RMIConnector) {
            this.trace("Object recognized as an RMI connector; validating");
            this.validateLocal((RMIConnector)object);
            this.validateAcross((JMXConnector)((RMIConnector)object));
        } else if (object instanceof RepositoryService) {
            this.trace("Object recognized as a repository service; validating");
            this.validateLocal((RepositoryService)object);
            this.validateAcross((RepositoryService)object);
        } else if (object instanceof SOAPConnector) {
            this.trace("Object recognized as a SOAP connector; validating");
            this.validateLocal((SOAPConnector)object);
            this.validateAcross((SOAPConnector)object);
        } else if (object instanceof SystemMessageServer) {
            this.trace("Object recognized as a system message server; validating");
            this.validateLocal((SystemMessageServer)object);
            this.validateAcross((SystemMessageServer)object);
        } else if (object instanceof ExternallyManagedHTTPServer) {
            this.trace("Object recognized as an externally managed HTTP server; validating");
            this.validateLocal((ExternallyManagedHTTPServer)object);
            this.validateAcross((ServerComponent)((ExternallyManagedHTTPServer)object));
        } else if (object instanceof JMSServer) {
            this.trace("Object recognized as a JMS server; validating");
            this.validateLocal((JMSServer)object);
            this.validateAcross((JMSServer)object);
        } else if (object instanceof JMSTransport) {
            this.trace("Object recognized as a JMS transport; validating");
            this.validateLocal((JMSTransport)object);
            this.validateAcross((JMSTransport)object);
        } else if (object instanceof NameBinding) {
            this.trace("Object recognized as a name binding; validating");
            this.validateLocal((NameBinding)object);
            this.validateAcross((NameBinding)object);
        } else if (object instanceof NamingContext) {
            this.trace("Object recognized as a naming context; validating");
            this.validateLocal((NamingContext)object);
            this.validateAcross((NamingContext)object);
        } else if (object instanceof NameServer) {
            this.trace("Object recognized as a name server; validating");
            this.validateLocal((NameServer)object);
            this.validateAcross((ServerComponent)((NameServer)object));
        } else if (object instanceof CORBAObjectNameSpaceBinding) {
            this.trace("Object recognized as a CORBA object name space binding; validating");
            this.validateLocal((CORBAObjectNameSpaceBinding)object);
            this.validateAcross((CORBAObjectNameSpaceBinding)object);
        } else if (object instanceof EjbNameSpaceBinding) {
            this.trace("Object recognized as an EJB name space binding; validating");
            this.validateLocal((EjbNameSpaceBinding)object);
            this.validateAcross((EjbNameSpaceBinding)object);
        } else if (object instanceof IndirectLookupNameSpaceBinding) {
            this.trace("Object recognized as an indirect lookup name space binding; validating");
            this.validateLocal((IndirectLookupNameSpaceBinding)object);
            this.validateAcross((IndirectLookupNameSpaceBinding)object);
        } else if (object instanceof StringNameSpaceBinding) {
            this.trace("Object recognized as a string name space binding; validating");
            this.validateLocal((StringNameSpaceBinding)object);
            this.validateAcross((StringNameSpaceBinding)object);
        } else if (object instanceof NameSpaceBinding) {
            this.trace("Object recognized as a name space binding; validating");
            this.validateLocal((NameSpaceBinding)object);
            this.validateAcross((NameSpaceBinding)object);
        } else if (object instanceof ConfigSynchronizationService) {
            this.trace("Object recognized as a config synchronization service; validating");
            this.validateLocal((ConfigSynchronizationService)object);
            this.validateAcross((ConfigSynchronizationService)object);
        } else if (object instanceof FileTransferService) {
            this.trace("Object recognized as a file transfer service; validating");
            this.validateLocal((FileTransferService)object);
            this.validateAcross((FileTransferService)object);
        } else if (object instanceof NodeAgent) {
            this.trace("Object recognized as a node agent; validating");
            this.validateLocal((NodeAgent)object);
            this.validateAcross((NodeAgent)object);
        } else if (object instanceof Interceptor) {
            this.trace("Object recognized as an interceptor; validating");
            this.validateLocal((Interceptor)object);
            this.validateAcross((Interceptor)object);
        } else if (object instanceof LSDConnection) {
            this.trace("Object recognized as an LSD connection; validating");
            this.validateLocal((LSDConnection)object);
            this.validateAcross((LSDConnection)object);
        } else if (object instanceof ORBPlugin) {
            this.trace("Object recognized as an ORB plugin; validating");
            this.validateLocal((ORBPlugin)object);
            this.validateAcross((ORBPlugin)object);
        } else if (object instanceof ObjectRequestBroker) {
            this.trace("Object recognized as an object request broker; validating");
            this.validateLocal((ObjectRequestBroker)object);
            this.validateAcross((Service)((ObjectRequestBroker)object));
        } else if (object instanceof JMXConnector) {
            this.trace("Object recognized as a JMX connector; validating");
            this.validateLocal((JMXConnector)object);
            this.validateAcross((JMXConnector)object);
        } else if (object instanceof ApplicationServer) {
            this.trace("Object recognized as an application server; validating");
            this.validateLocal((ApplicationServer)object);
            this.validateAcross((ApplicationServer)object);
        } else if (object instanceof WebServer) {
            this.trace("Object recognized as a Web Server; validating.");
            this.validateLocal((WebServer)object);
            this.validateAcross((WebServer)object);
        } else if (object instanceof DynamicCache) {
            this.trace("Object recognized as a dynamic cache; validating");
            this.validateLocal((DynamicCache)object);
            this.validateAcross((DynamicCache)object);
        } else if (object instanceof ExternalCacheGroup) {
            this.trace("Object recognized as an external cache group; validating");
            this.validateLocal((ExternalCacheGroup)object);
            this.validateAcross((ExternalCacheGroup)object);
        } else if (object instanceof ExternalCacheGroupMember) {
            this.trace("Object recognized as an external cache group member; validating");
            this.validateLocal((ExternalCacheGroupMember)object);
            this.validateAcross((ExternalCacheGroupMember)object);
        } else if (object instanceof TransactionService) {
            this.trace("Object recognized as a transaction service; validating");
            this.validateLocal((TransactionService)object);
            this.validateAcross((TransactionService)object);
        } else if (object instanceof EJBCache) {
            this.trace("Object recognized as an EJB cache; validating");
            this.validateLocal((EJBCache)object);
            this.validateAcross((EJBCache)object);
        } else if (object instanceof EJBContainer) {
            this.trace("Object recognized as an EJB container; validating");
            this.validateLocal((EJBContainer)object);
            this.validateAcross((EJBContainer)object);
        } else if (object instanceof ListenerPort) {
            this.trace("Object recognized as a listener port; validating");
            this.validateLocal((ListenerPort)object);
            this.validateAcross((ListenerPort)object);
        } else if (object instanceof MessageListenerService) {
            this.trace("Object recognized as a message listener service; validating");
            this.validateLocal((MessageListenerService)object);
            this.validateAcross((MessageListenerService)object);
        } else if (object instanceof Cookie) {
            this.trace("Object recognized as a cookie; validating");
            this.validateLocal((Cookie)object);
            this.validateAcross((Cookie)object);
        } else if (object instanceof DRSSettings) {
            this.trace("Object recognized as DRS settings; validating");
            this.validateLocal((DRSSettings)object);
            this.validateAcross((DRSSettings)object);
        } else if (object instanceof HTTPTransport) {
            this.trace("Object recognized as an HTTP transport; validating");
            this.validateLocal((HTTPTransport)object);
            this.validateAcross((HTTPTransport)object);
        } else if (object instanceof InvalidationSchedule) {
            this.trace("Object recognized as invalidation schedule; validating");
            this.validateLocal((InvalidationSchedule)object);
            this.validateAcross((InvalidationSchedule)object);
        } else if (object instanceof SessionDatabasePersistence) {
            this.trace("Object recognized as session database persistence; validating");
            this.validateLocal((SessionDatabasePersistence)object);
            this.validateAcross((SessionDatabasePersistence)object);
        } else if (object instanceof SessionManager) {
            this.trace("Object recognized as a session manager; validating");
            this.validateLocal((SessionManager)object);
            this.validateAcross((SessionManager)object);
        } else if (object instanceof TuningParams) {
            this.trace("Object recognized as tuning parameters; validating");
            this.validateLocal((TuningParams)object);
            this.validateAcross((TuningParams)object);
        } else if (object instanceof WebContainer) {
            this.trace("Object recognized as a web container; validating");
            this.validateLocal((WebContainer)object);
            this.validateAcross((WebContainer)object);
        } else if (object instanceof ApplicationContainer) {
            this.trace("Object recognized as an application container; validating");
            this.validateLocal((ApplicationContainer)object);
            this.validateAcross((ApplicationContainer)object);
        } else if (object instanceof CellManager) {
            this.trace("Object recognized as a cell manager; validating");
            this.validateLocal((CellManager)object);
            this.validateAcross((CellManager)object);
        } else if (object instanceof TraceLog) {
            this.trace("Object recognized as a trace log; validating");
            this.validateLocal((TraceLog)object);
            this.validateAcross((TraceLog)object);
        } else if (object instanceof TraceService) {
            this.trace("Object recognized as a trace service; validating");
            this.validateLocal((TraceService)object);
            this.validateAcross((TraceService)object);
        } else if (object instanceof RASLoggingService) {
            this.trace("Object recognized as a RAS logging service; validating");
            this.validateLocal((RASLoggingService)object);
            this.validateAcross((RASLoggingService)object);
        } else if (object instanceof ServiceLog) {
            this.trace("Object recognized as a service log; validating");
            this.validateLocal((ServiceLog)object);
            this.validateAcross((ServiceLog)object);
        } else if (object instanceof WorkloadManagementServer) {
            this.trace("Object recognized as a workload management server; validating");
            this.validateLocal((WorkloadManagementServer)object);
            this.validateAcross((WorkloadManagementServer)object);
        } else if (object instanceof Agent) {
            this.trace("Object recognized as an agent; validating");
            this.validateLocal((Agent)object);
            this.validateAcross((Agent)object);
        } else if (object instanceof ServerComponent) {
            this.trace("Object recognized as a server component; validating.");
            this.validateLocal((ServerComponent)object);
            this.validateAcross((ServerComponent)object);
        } else if (object instanceof Component) {
            this.trace("Object recognized as a component; validating");
            this.validateLocal((Component)object);
            this.validateAcross((Component)object);
        } else if (object instanceof Server) {
            this.trace("Object recognized as a server; validating");
            this.validateLocal((Server)object);
            this.validateAcross((Server)object);
        } else if (object instanceof ServiceContext) {
            this.trace("Object recognized as a service context; validating.");
            this.validateLocal((ServiceContext)object);
            this.validateAcross((ServiceContext)object);
        } else if (object instanceof TransportChannelService) {
            this.trace("Object recognized as a channel framework service; validating.");
            this.validate((TransportChannelService)object);
        } else if (object instanceof CustomService) {
            this.trace("Object recognized as a custom service; validating.");
            this.validateLocal((CustomService)object);
            this.validateAcross((CustomService)object);
        } else if (object instanceof Service) {
            this.trace("Object recognized as a service; validating.");
            this.validateLocal((Service)object);
            this.validateAcross((Service)object);
        } else if (object instanceof Extension) {
            this.trace("Object recognized as an extension; validating.");
            this.validateLocal((Extension)object);
            this.validateAcross((Extension)object);
        } else if (object instanceof StatisticsProvider) {
            this.trace("Object recognized as a statistics provider; validating.");
            this.validateLocal((StatisticsProvider)object);
            this.validateAcross((StatisticsProvider)object);
        } else if (object instanceof StreamRedirect) {
            this.trace("Object recognized as a stream redirect; validating.");
            this.validateLocal((StreamRedirect)object);
            this.validateAcross((StreamRedirect)object);
        } else if (object instanceof JavaProcessDef) {
            this.trace("Object recognized as a java process definition; validating.");
            this.validateLocal((JavaProcessDef)object);
            this.validateAcross((JavaProcessDef)object);
        } else if (object instanceof ProcessDef) {
            this.trace("Object recognized as a process definition; validating.");
            this.validateLocal((ProcessDef)object);
            this.validateAcross((ProcessDef)object);
        } else if (object instanceof ProcessExecution) {
            this.trace("Object recognized as a process execution; validating.");
            this.validateLocal((ProcessExecution)object);
            this.validateAcross((ProcessExecution)object);
        } else if (object instanceof JavaVirtualMachine) {
            this.trace("Object recognized as a java virtual machine; validating.");
            this.validateLocal((JavaVirtualMachine)object);
            this.validateAcross((JavaVirtualMachine)object);
        } else if (object instanceof OutputRedirect) {
            this.trace("Object recognized as an output redirect; validating.");
            this.validateLocal((OutputRedirect)object);
            this.validateAcross((OutputRedirect)object);
        } else if (object instanceof MonitoringPolicy) {
            this.trace("Object recognized as a monitoring policy; validating.");
            this.validateLocal((MonitoringPolicy)object);
            this.validateAcross((MonitoringPolicy)object);
        } else if (object instanceof TypedProperty) {
            this.trace("Object recognized as a typed property; validating.");
            this.validateLocal((TypedProperty)object);
            this.validateAcross((TypedProperty)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected WebSphereDelegateValidator getChannelValidator() {
        if (!this._channelValidatorLoaded) {
            this._channelValidatorLoaded = true;
            try {
                Class clazz = this.getExtendedClass(type);
                Constructor constructor = clazz.getConstructor(MOFValidator.class);
                this._channelValidator = (WebSphereDelegateValidator)constructor.newInstance(this);
            }
            catch (Exception exception) {
                this._channelValidator = null;
                this.getReporter().addMessage((IValidator)this, (IMessage)new ValidationMessage(bundle, 4, "WSVM1002E", new String[]{type, exception.getMessage()}, null));
            }
        }
        return this._channelValidator;
    }

    public void validate(TransportChannelService transportChannelService) throws ValidationException {
        WebSphereDelegateValidator webSphereDelegateValidator = this.getChannelValidator();
        if (webSphereDelegateValidator != null) {
            webSphereDelegateValidator.visit(transportChannelService);
        }
    }

    public void validateAcross(RepositoryService repositoryService) {
        this.traceStub("validateAcross(RepositoryService)");
    }

    public void validateAcross(SOAPConnector sOAPConnector) {
        this.validateAcross((JMXConnector)sOAPConnector);
    }

    public void validateAcross(SystemMessageServer systemMessageServer) {
    }

    public void validateAcross(JMSServer jMSServer) {
        this.validateAcross((ServerComponent)jMSServer);
    }

    public void validateAcross(JMSTransport jMSTransport) {
        this.traceStub("validateAcross(JMSTransport)");
        this.validateAcross((Component)jMSTransport);
    }

    public void validateAcross(NameBinding nameBinding) {
        this.traceStub("validateAcross(NameBinding)");
    }

    public void validateAcross(NamingContext namingContext) {
        this.traceStub("validateAcross(NamingContext)");
    }

    public void validateAcross(CORBAObjectNameSpaceBinding cORBAObjectNameSpaceBinding) {
        this.validateAcross((NameSpaceBinding)cORBAObjectNameSpaceBinding);
    }

    public void validateAcross(EjbNameSpaceBinding ejbNameSpaceBinding) {
        this.validateAcross((NameSpaceBinding)ejbNameSpaceBinding);
    }

    public void validateAcross(IndirectLookupNameSpaceBinding indirectLookupNameSpaceBinding) {
        this.validateAcross((NameSpaceBinding)indirectLookupNameSpaceBinding);
    }

    public void validateAcross(StringNameSpaceBinding stringNameSpaceBinding) {
        this.validateAcross((NameSpaceBinding)stringNameSpaceBinding);
    }

    public void validateAcross(NameSpaceBinding nameSpaceBinding) {
        this.traceStub("validateAcross(NameSpaceBinding)");
    }

    public void validateAcross(ConfigSynchronizationService configSynchronizationService) {
        this.traceStub("validateAcross(ConfigSynchronizationService)");
        this.validateAcross((Service)configSynchronizationService);
    }

    public void validateAcross(FileTransferService fileTransferService) {
        this.traceStub("validateAcross(FileTransferService)");
        this.validateAcross((Service)fileTransferService);
    }

    public void validateAcross(NodeAgent nodeAgent) {
        if (nodeAgent.getFileTransferService() == null) {
            this.addError("ERROR_NODE_AGENT_FILE_TRANSFER_SERVICE_REQUIRED", new String[]{nodeAgent.getName()}, nodeAgent);
        }
        if (nodeAgent.getFileSynchronizationService() == null) {
            this.addError("ERROR_NODE_AGENT_FILE_SYNCHRONIZATION_SERVICE_REQUIRED", new String[]{nodeAgent.getName()}, nodeAgent);
        }
        this.validateAcross((Agent)nodeAgent);
    }

    public void validateAcross(Interceptor interceptor) {
        this.traceStub("validateLocal(Interceptor)");
    }

    public void validateAcross(LSDConnection lSDConnection) {
        this.traceStub("validateAcross(LSDConnection)");
    }

    public void validateAcross(ORBPlugin oRBPlugin) {
        this.traceStub("validateAcross(ORBPlugin)");
    }

    public void validateAcross(ExtensionMBean extensionMBean) {
        this.traceStub("validateAcross(ExtensionMBean)");
    }

    public void validateAcross(ExtensionMBeanProvider extensionMBeanProvider) {
        this.traceStub("validateAcross(ExtensionMBeanProvider)");
    }

    public void validateAcross(HTTPConnector hTTPConnector) {
        this.traceStub("validateAcross(HTTPConnector)");
        this.validateAcross((JMXConnector)hTTPConnector);
    }

    public void validateAcross(JMSConnector jMSConnector) {
        this.traceStub("validateAcross(JMSConnector)");
        this.validateAcross((JMXConnector)jMSConnector);
    }

    public void validateAcross(JMXConnector jMXConnector) {
        this.traceStub("validateAcross(JMXConnector)");
    }

    public void validateAcross(ApplicationContainer applicationContainer) {
        this.validateAcross((Component)applicationContainer);
    }

    public void validateAcross(ListenerPort listenerPort) {
        this.traceStub("validateAcross(ListenerPort)");
        this.validateAcross((ManagedObject)listenerPort);
    }

    public void validateAcross(MessageListenerService messageListenerService) {
        this.traceStub("validateAcross(MessageListenerService)");
    }

    public void validateAcross(DRSSettings dRSSettings) {
        this.traceStub("validateAcross(DRSSettings)");
    }

    public void validateAcross(CellManager cellManager) {
        this.traceStub("validateAcross(CellManager)");
        this.validateAcross((Agent)cellManager);
    }

    public void validateAcross(TraceLog traceLog) {
    }

    public void validateAcross(TraceService traceService) {
        this.validateAcross((Service)traceService);
    }

    public void validateAcross(RASLoggingService rASLoggingService) {
        this.validateAcross((Service)rASLoggingService);
    }

    public void validateAcross(ServiceLog serviceLog) {
    }

    public void validateAcross(WorkloadManagementServer workloadManagementServer) {
        this.traceStub("validateAcross(WorkloadManagementServer)");
        this.validateAcross((ServerComponent)workloadManagementServer);
    }

    public void validateAcross(ApplicationServer applicationServer) {
        this.traceStub("Cross validation of application server");
        this.traceStub("Cross validation of application server cookie path's.");
        Iterator iterator = applicationServer.getServices().iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (!(service instanceof TransactionService)) continue;
            bl = this.isEnabled(service);
        }
        if (!bl) {
            this.addWarning("WARNING_SERVER_NO_TRANSACTION_SERVICE", new String[]{applicationServer.getName()}, applicationServer);
        }
        this.validateAcross((ServerComponent)applicationServer);
    }

    public void validateAcross(Cookie cookie) {
    }

    public void validateAcross(DynamicCache dynamicCache) {
        this.validateDynamicCacheBroker(dynamicCache);
        this.validateAcross((Service)dynamicCache);
    }

    protected void validateDynamicCacheBroker(DynamicCache dynamicCache) {
        int n = dynamicCache.getReplicationType().getValue();
        if ((n == 1 || n == 2 || n == 3) && dynamicCache.getCacheReplication() == null) {
            this.addError("ERROR_DYNAMIC_CACHE_CACHE_REPLICATION_REQUIRED", dynamicCache);
        }
    }

    public void validateAcross(EJBCache eJBCache) {
    }

    public void validateAcross(EJBContainer eJBContainer) {
        if (eJBContainer.getCacheSettings() == null) {
            this.addError("ERROR_EJB_CACHE_ABSENT", new String[]{eJBContainer.getName()}, eJBContainer);
        }
        super.validateAcross((ManagedObject)eJBContainer);
    }

    public void validateAcross(ExternalCacheGroup externalCacheGroup) {
        this.traceStub("Validation across external cache group.");
    }

    public void validateAcross(ExternalCacheGroupMember externalCacheGroupMember) {
    }

    public void validateAcross(HTTPTransport hTTPTransport) {
        this.validateAcross((Transport)hTTPTransport);
    }

    public void validateAcross(InvalidationSchedule invalidationSchedule) {
    }

    public void validateAcross(SessionManager sessionManager) {
        if (sessionManager.getDefaultCookieSettings() == null) {
            this.addError("ERROR_COOKIE_ABSENT", sessionManager);
        }
        if (sessionManager.getTuningParams() == null) {
            this.addError("ERROR_TUNING_PARAMS_ABSENT", sessionManager);
        }
        SessionDatabasePersistence sessionDatabasePersistence = sessionManager.getSessionDatabasePersistence();
        int n = sessionManager.getSessionPersistenceMode().getValue();
        if (n == 1) {
            String string = sessionDatabasePersistence.getDatasourceJNDIName();
            if (string == null || string.length() == 0) {
                this.addError("ERROR_SESSION_DATABASE_PERSISTENCE_JNDINAME_REQUIRED", sessionManager);
            }
        } else if (n == 2 && sessionManager.getSessionDRSPersistence() == null) {
            this.addError("ERROR_SESSION_MANAGER_SESSION_PERSISTENCE_ABSENT", sessionManager);
        }
        this.validateAcross((Service)sessionManager);
    }

    public void validateAcross(SessionDatabasePersistence sessionDatabasePersistence) {
    }

    public void validateAcross(TransactionService transactionService) {
        this.validateAcross((Service)transactionService);
    }

    public void validateAcross(TuningParams tuningParams) {
        this.traceStub("Validation across tuning parameters.");
    }

    public void validateAcross(WebContainer webContainer) {
        this.validateWebContainerTransportDuplication(webContainer);
        if (this.isZOS()) {
            this.validateZOSTransports(webContainer);
        }
        super.validateAcross((ManagedObject)webContainer);
    }

    public void validateZOSTransports(WebContainer webContainer) {
        String string = webContainer.getName();
        this.trace("validateZOSTransports", string);
        Iterator iterator = webContainer.getTransports().iterator();
        if (!iterator.hasNext()) {
            this.addError("ERROR_WEB_CONTAINER_NO_TRANSPORTS", new String[]{string}, webContainer);
        }
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Transport transport2 = (Transport)iterator.next();
            if (transport2.isSslEnabled()) {
                ++n;
                continue;
            }
            ++n2;
        }
        if (n > 1) {
            this.addError("ERROR_WEB_CONTAINER_MULTIPLE_SSL_TRANSPORTS", new String[]{string}, webContainer);
        }
        if (n2 > 1) {
            this.addError("ERROR_WEB_CONTAINER_MULTIPLE_NON_SSL_TRANSPORTS", new String[]{string}, webContainer);
        }
    }

    public void validateAcross(AdminService adminService) {
        Iterator iterator = adminService.getConnectors().iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (!(bl2 && bl || !iterator.hasNext())) {
            JMXConnector jMXConnector = (JMXConnector)iterator.next();
            bl = true;
            bl2 = jMXConnector instanceof HTTPConnector;
        }
        if (!bl) {
            this.addError("ERROR_ADMIN_SERVICE_NO_CONNECTORS", adminService);
        }
        if (bl2) {
            this.addWarning("WARNING_ADMIN_SERVICE_FOUND_HTTP_CONNECTOR", adminService);
        }
        this.validateAcross((Service)adminService);
    }

    public void validateAcross(CustomService customService) {
        this.traceStub("Cross validation of custom service.");
        this.validateAcross((Service)customService);
    }

    public void validateAcross(JavaProcessDef javaProcessDef) {
        this.traceStub("Cross validation of java process definition.");
        this.validateAcross((ProcessDef)javaProcessDef);
    }

    public void validateAcross(JavaVirtualMachine javaVirtualMachine) {
        this.validateProperties(javaVirtualMachine, null, (List)javaVirtualMachine.getSystemProperties(), "ERROR_JVM_SYSTEM_PROPERTY_DUPLICATION", "ERROR_JVM_SYSTEM_PROPERTY_NAME_ABSENT");
    }

    public void validateAcross(OutputRedirect outputRedirect) {
        this.traceStub("Cross validation of the output redirect.");
    }

    public void validateAcross(MonitoringPolicy monitoringPolicy) {
        this.traceStub("Cross validation of the monitoring policy.");
    }

    public void validateAcross(ProcessDef processDef) {
    }

    public void validateAcross(ProcessExecution processExecution) {
    }

    public void validateAcross(Agent agent) {
        this.traceBegin("validateAcross(Agent)");
        this.traceStub("validateAcross(Agent)");
        this.validateAcross((ServerComponent)agent);
        this.traceEnd();
    }

    public void validateAcross(Component component2) {
        this.traceBegin("validateAcross(Component)");
        this.validateProperties(component2, component2.getName(), (List)component2.getProperties(), "ERROR_COMPONENT_PROPERTY_NAME_DUPLICATION", "ERROR_COMPONENT_PROPERTY_NAME_ABSENT");
        this.validateAcross((ServiceContext)component2);
        this.traceEnd();
    }

    public void validateAcross(Service service) {
        this.traceBegin("validateAcross(Service)");
        this.validateProperties(service, null, (List)service.getProperties(), "ERROR_SERVICE_PROPERTY_NAME_DUPLICATION", "ERROR_SERVICE_PROPERTY_NAME_ABSENT");
        this.traceEnd();
    }

    public void validateAcross(ServiceContext serviceContext) {
        this.traceBegin("validateAcross(ServiceContext)");
        this.validateAcross((ManagedObject)serviceContext);
        this.traceEnd();
    }

    public void validateAcross(Extension extension2) {
        this.traceBegin("validateAcross(Extension)");
        this.traceStub("validateAcross(Extension)");
        this.traceEnd();
    }

    public void validateAcross(ServerComponent serverComponent) {
        this.traceBegin("validateAcross(ServerComponent)");
        this.traceStub("validateAcross(ServerComponent)");
        this.validateAcross((Component)serverComponent);
        this.traceEnd();
    }

    public void validateAcross(StatisticsProvider statisticsProvider) {
        this.traceBegin("validateAcross(StatisticsProvider)");
        this.traceStub("validateAcross(StatisticsProvider)");
        this.traceEnd();
    }

    public void validateAcross(StreamRedirect streamRedirect) {
        this.traceBegin("validateAcross(StreamRedirect)");
        this.traceStub("validateAcross(StreamRedirect)");
        this.traceEnd();
    }

    public void validateAcross(Server server2) {
        this.traceStub("Validation for cyclic service dependencies");
        Iterator iterator = server2.getComponents().iterator();
        Iterator iterator2 = server2.getServices().iterator();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (component2 instanceof ServerComponent && this.isSetToStart((ManagedObject)component2)) {
                bl = true;
            }
            if (component2 instanceof ApplicationServer) {
                if (this.isSetToStart((ManagedObject)component2)) {
                    bl2 = true;
                }
                this.validateAcross((ApplicationServer)component2);
            }
            if (component2 instanceof NameServer && this.isSetToStart((ManagedObject)component2)) {
                bl3 = true;
            }
            if (!(component2 instanceof SystemMessageServer)) continue;
            bl4 = true;
        }
        boolean bl5 = false;
        while (!bl5 && iterator2.hasNext()) {
            Service service = (Service)iterator2.next();
            if (!(service instanceof AdminService)) continue;
            bl5 = this.isEnabled(service);
        }
        if (bl && !bl5) {
            this.addError("ERROR_SERVER_NO_ADMIN_SERVICE", new String[]{server2.getName()}, server2);
        }
        if (bl2 && !bl3) {
            this.addError("ERROR_SERVER_NO_NAME_SERVER", new String[]{server2.getName()}, server2);
        }
        if (bl4) {
            this.addError("WARNING_SYSTEM_MESSAGE_SERVER_DEPRECATED", new String[]{server2.getName()}, server2);
        }
        this.validateProcessDefs(server2);
        this.validateAcross((ServiceContext)server2);
    }

    protected void validateProcessDefs(Server server2) {
        int n;
        WebServer webServer = this.getWebServer(server2);
        boolean bl = webServer == null ? false : (n = webServer.getWebserverType().getValue()) == 2 || n == 1 || n == 4 || n == 3;
        Iterator iterator = server2.getProcessDefinitions().iterator();
        if (!iterator.hasNext()) {
            if (bl) {
                this.addError("ERROR_PROCESS_DEF_REQUIRED", new String[]{server2.getName()}, server2);
            }
        } else if (webServer == null) {
            while (iterator.hasNext()) {
                ProcessDef processDef = (ProcessDef)iterator.next();
                String string = processDef.getWorkingDirectory();
                if (string != null && string.length() != 0) continue;
                this.addError("ERROR_PROCESS_DEF_WORKING_DIRECTORY_REQUIRED", processDef);
            }
        }
    }

    public void validateAcross(WebServer webServer) {
        this.validateAcross((ServerComponent)webServer);
    }

    public void validateAcross(TypedProperty typedProperty) {
    }

    public void validateLocal(ExtensionMBean extensionMBean) {
        this.traceStub("validateLocal(ExtensionMBean)");
    }

    public void validateLocal(ExtensionMBeanProvider extensionMBeanProvider) {
        this.traceStub("validateLocal(ExtensionMBeanProvider)");
    }

    public void validateLocal(HTTPConnector hTTPConnector) {
        this.traceStub("validateLocal(HTTPConnector)");
        this.validateLocal((JMXConnector)hTTPConnector);
    }

    public void validateLocal(JMSConnector jMSConnector) {
        this.traceStub("validateLocal(JMSConnector)");
        this.validateLocal((JMXConnector)jMSConnector);
    }

    public void validateLocal(JMXConnector jMXConnector) {
        this.traceStub("validateLocal(JMXConnector)");
    }

    public void validateLocal(RMIConnector rMIConnector) {
        this.traceStub("validateLocal(RMIConnector)");
        this.validateLocal((JMXConnector)rMIConnector);
    }

    public void validateLocal(RepositoryService repositoryService) {
        this.traceStub("validateLocal(RepositoryService)");
    }

    public void validateLocal(SOAPConnector sOAPConnector) {
        this.traceStub("validateLocal(SOAPConnector)");
        this.validateLocal((JMXConnector)sOAPConnector);
    }

    public void validateLocal(SystemMessageServer systemMessageServer) {
    }

    public void validateLocal(ExternallyManagedHTTPServer externallyManagedHTTPServer) {
        this.traceStub("validateLocal(ExternallyManagedHTTPServer)");
        this.validateLocal((ServerComponent)externallyManagedHTTPServer);
    }

    public void validateLocal(JMSServer jMSServer) {
        this.testIntegerMin(jMSServer.getNumThreads(), 1, "ERROR_JMSSERVER_NUM_THREADS_INVALID", jMSServer);
        Iterator iterator = jMSServer.getQueueNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() > this.MAX_WAS_QUEUE_LENGTH) {
                this.addError("ERROR_JMSSERVER_QUEUE_NAME_TOO_LONG", new String[]{string, String.valueOf(string.length()), String.valueOf(this.MAX_WAS_QUEUE_LENGTH)}, jMSServer);
            }
            if (this.testValidChars(string, QUEUE_NAME_CHARS)) continue;
            this.addError("ERROR_JMSSERVER_QUEUE_NAME_INVALID", new String[]{string, jMSServer.getName(), QUEUE_NAME_CHARS}, jMSServer);
        }
        this.validateLocal((ServerComponent)jMSServer);
    }

    protected void validateJMSServerEndPoint(EndPoint endPoint) {
    }

    public void validateLocal(JMSTransport jMSTransport) {
        this.traceStub("validateLocal(JMSTransport)");
        this.validateLocal((Component)jMSTransport);
    }

    public void validateLocal(NameBinding nameBinding) {
        this.traceStub("validateLocal(NameBinding)");
    }

    public void validateLocal(NamingContext namingContext) {
        this.traceStub("validateLocal(NamingContext)");
    }

    public void validateLocal(NameServer nameServer) {
        this.traceStub("validateLocal(NameServer)");
        this.validateLocal((ServerComponent)nameServer);
    }

    public void validateLocal(CORBAObjectNameSpaceBinding cORBAObjectNameSpaceBinding) {
        String string = cORBAObjectNameSpaceBinding.getCorbanameUrl();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_CORBA_NAME_SPACE_BINDING_NAME_URL_REQUIRED", new String[]{cORBAObjectNameSpaceBinding.getName()}, cORBAObjectNameSpaceBinding);
        }
        this.validateLocal((NameSpaceBinding)cORBAObjectNameSpaceBinding);
    }

    public void validateLocal(EjbNameSpaceBinding ejbNameSpaceBinding) {
        String string;
        String string2 = ejbNameSpaceBinding.getApplicationServerName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_EJB_NAME_SPACE_BINDING_SERVER_NAME_REQUIRED", new String[]{ejbNameSpaceBinding.getName()}, ejbNameSpaceBinding);
        }
        if ((string = ejbNameSpaceBinding.getEjbJndiName()) == null || string.length() == 0) {
            this.addError("ERROR_EJB_NAME_SPACE_BINDING_EJB_JNDI_NAME_REQUIRED", new String[]{ejbNameSpaceBinding.getName()}, ejbNameSpaceBinding);
        }
        this.validateLocal((NameSpaceBinding)ejbNameSpaceBinding);
    }

    public void validateLocal(IndirectLookupNameSpaceBinding indirectLookupNameSpaceBinding) {
        String string = indirectLookupNameSpaceBinding.getProviderURL();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_INDIRECT_LOOKUP_NAME_SPACE_BINDING_PROVIDER_URL_REQUIRED", new String[]{indirectLookupNameSpaceBinding.getName()}, indirectLookupNameSpaceBinding);
        }
        if (indirectLookupNameSpaceBinding.getJndiName() == null) {
            this.addError("ERROR_INDIRECT_LOOKUP_NAME_SPACE_BINDING_JNDI_NAME_REQUIRED", new String[]{indirectLookupNameSpaceBinding.getName()}, indirectLookupNameSpaceBinding);
        }
        this.validateLocal((NameSpaceBinding)indirectLookupNameSpaceBinding);
    }

    public void validateLocal(StringNameSpaceBinding stringNameSpaceBinding) {
        String string = stringNameSpaceBinding.getStringToBind();
        if (string == null) {
            this.addError("ERROR_STRING_NAME_SPACE_BINDING_STRING_REQUIRED", new String[]{stringNameSpaceBinding.getName()}, stringNameSpaceBinding);
        }
        this.validateLocal((NameSpaceBinding)stringNameSpaceBinding);
    }

    public void validateLocal(NameSpaceBinding nameSpaceBinding) {
        String string;
        String string2 = nameSpaceBinding.getName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_NAME_SPACE_BINDING_NAME_REQUIRED", nameSpaceBinding);
        }
        if ((string = nameSpaceBinding.getNameInNameSpace()) == null || string.length() == 0) {
            this.addError("ERROR_NAME_SPACE_BINDING_NAME_IN_NAME_SPACE_REQUIRED", new String[]{nameSpaceBinding.getName()}, nameSpaceBinding);
        }
    }

    public void validateLocal(ConfigSynchronizationService configSynchronizationService) {
        this.traceStub("validateLocal(ConfigSynchronizationService)");
        this.validateLocal((Service)configSynchronizationService);
    }

    public void validateLocal(FileTransferService fileTransferService) {
        this.traceStub("validateLocal(FileTransferService)");
        this.validateLocal((Service)fileTransferService);
    }

    public void validateLocal(NodeAgent nodeAgent) {
        this.traceStub("validateLocal(NodeAgent)");
        this.validateLocal((Agent)nodeAgent);
    }

    public void validateLocal(Interceptor interceptor) {
        this.traceStub("validateLocal(Interceptor)");
    }

    public void validateLocal(LSDConnection lSDConnection) {
        this.traceStub("validateLocal(LSDConnection)");
    }

    public void validateLocal(ORBPlugin oRBPlugin) {
        this.traceStub("validateLocal(ORBPlugin)");
    }

    public void validateLocal(ObjectRequestBroker objectRequestBroker) {
        this.traceStub("validateLocal(ObjectRequestBroker)");
        this.validateLocal((Service)objectRequestBroker);
    }

    public void validateLocal(ApplicationContainer applicationContainer) {
        this.traceStub("validateLocal(ApplicationContainer)");
        this.validateLocal((Component)applicationContainer);
    }

    public void validateLocal(ListenerPort listenerPort) {
        if (listenerPort.getConnectionFactoryJNDIName() == null) {
            this.addError("ERROR_LISTENER_PORT_NO_FACTORY_NAME", new String[]{listenerPort.getName()}, listenerPort);
        }
        if (listenerPort.getDestinationJNDIName() == null) {
            this.addError("ERROR_LISTENER_PORT_NO_DESTINATION_NAME", new String[]{listenerPort.getName()}, listenerPort);
        }
        this.testIntegerMin(listenerPort.getMaxSessions(), 1, "ERROR_LISTENER_PORT_MAX_SESSIONS_TOO_LOW", listenerPort);
        this.testIntegerMin(listenerPort.getMaxRetries(), 0, "ERROR_LISTENER_PORT_MAX_RETRIES_TOO_LOW", listenerPort);
        this.testIntegerMin(listenerPort.getMaxMessages(), 1, "ERROR_LISTENER_PORT_MAX_MESSAGES_TOO_LOW", listenerPort);
        this.validateLocal((ManagedObject)listenerPort);
    }

    public void validateLocal(MessageListenerService messageListenerService) {
        this.traceStub("validateLocal(MessageListenerService)");
    }

    public void validateLocal(DRSSettings dRSSettings) {
        String string = dRSSettings.getMessageBrokerDomainName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_DRS_SETTINGS_DOMAIN_NAME_REQUIRED", dRSSettings);
        }
        String string2 = dRSSettings.getPreferredLocalDRSBrokerName();
        this.trace("Check use of deprecated attribute: preferredLocalDRSBrokerName:", string2);
        if (string2 != null && string2.length() != 0) {
            this.addWarning("WARNING_DRS_SETTINGS_DEPRECATED_ATTRIBUTE", "DRSSettings.preferredLocalDRSBrokerName");
        }
        EList eList = dRSSettings.getIds();
        this.trace("Check use of deprecated attribute: ids:", eList);
        if (eList != null && !eList.isEmpty()) {
            this.addWarning("WARNING_DRS_SETTINGS_DEPRECATED_ATTRIBUTE", "DRSSettings.ids");
        }
        EList eList2 = dRSSettings.getOverrideHostConnectionPoints();
        this.trace("Check use of deprecated attribute: overrideHostConnectionPoints:", eList2);
        if (eList2 != null && !eList2.isEmpty()) {
            this.addWarning("WARNING_DRS_SETTINGS_DEPRECATED_ATTRIBUTE", "DRSSettings.overrideHostConnectionPoints");
        }
        String string3 = dRSSettings.getPreferredLocalDRSBrokerName();
        this.trace("Check use of deprecated attribute: preferredLocalDRSBrokerName:", string3);
        if (string3 != null) {
            this.addWarning("WARNING_DRS_SETTINGS_DEPRECATED_ATTRIBUTE", "DRSSettings.preferredLocalDRSBrokerName");
        }
    }

    public void validateLocal(CellManager cellManager) {
        if (!this.isSetToStart((ManagedObject)cellManager)) {
            this.addWarning("WARNING_CELL_MANAGER_NOT_SET_TO_START", new String[]{cellManager.getName()}, cellManager);
        }
        this.validateLocal((Agent)cellManager);
    }

    public void validateLocal(WorkloadManagementServer workloadManagementServer) {
        this.traceStub("validateLocal(WorkloadManagementServer)");
        this.validateLocal((ServerComponent)workloadManagementServer);
    }

    public void validateLocal(ApplicationServer applicationServer) {
        int n;
        String string = applicationServer.getName();
        this.traceBegin("validateLocal(ApplicationServer)", string);
        this.testLongMin(applicationServer.getId(), -1L, "ERROR_APPLICATION_SERVER_ID_OUT_OF_RANGE", applicationServer);
        ClassloaderPackage classloaderPackage = ClassloaderPackage.eINSTANCE;
        int n2 = applicationServer.getApplicationClassLoaderPolicy().getValue();
        EEnum eEnum = classloaderPackage.getClassLoaderPolicy();
        if (!this.isEnumValueValid(n2, eEnum)) {
            this.addError("ERROR_APPLICATION_SERVER_CLASSLOADERPOLICY_INVALID", new String[]{string, String.valueOf(n2)}, applicationServer);
        }
        if (n2 == 1 && !this.isEnumValueValid(n = applicationServer.getApplicationClassLoadingMode().getValue(), eEnum = classloaderPackage.getClassLoadingMode())) {
            this.addError("ERROR_APPLICATION_SERVER_CLASSLOADINGMODE_INVALID", new String[]{string, String.valueOf(n)}, applicationServer);
        }
        this.validateLocal((ServerComponent)applicationServer);
        this.traceEnd();
    }

    public void validateLocal(Cookie cookie) {
        String string = cookie.getName();
        this.traceBegin("validateLocal(Cookie)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_COOKIE_NAME_REQUIRED", cookie);
        } else if (!string.equals("JSESSIONID")) {
            this.addError("ERROR_COOKIE_NAME_INVALID", new String[]{string, "JSESSIONID"}, cookie);
        }
        String string2 = cookie.getDomain();
        if (string2 != null && string2.length() > 0 && !this.testTCPIPDomainName(string2)) {
            this.addError("ERROR_COOKIE_DOMAIN_INVALID", new String[]{string, string2}, cookie);
        }
        this.testIntegerMin(cookie.getMaximumAge(), -1, "ERROR_COOKIE_MAXIMUM_AGE_OUT_OF_RANGE", cookie);
        String string3 = cookie.getPath();
        if (string3 != null && string3.length() > 0 && !this.testWebPath(string3)) {
            this.addError("ERROR_COOKIE_PATH_INVALID", new String[]{string, string3}, cookie);
        }
        this.traceEnd();
    }

    public void validateLocal(DynamicCache dynamicCache) {
        this.traceBegin("validateLocal(DynamicCache)");
        this.testIntegerMin(dynamicCache.getCacheSize(), 0, "ERROR_DYNAMIC_CACHE_CACHE_SIZE_OUT_OF_RANGE", dynamicCache);
        this.testIntegerMin(dynamicCache.getDefaultPriority(), 0, "ERROR_DYNAMIC_CACHE_DEFAULT_PRIORITY_OUT_OF_RANGE", dynamicCache);
        int n = dynamicCache.getReplicationType().getValue();
        ApplicationserverPackage applicationserverPackage = ApplicationserverPackage.eINSTANCE;
        EEnum eEnum = applicationserverPackage.getDynamicCacheReplicationKind();
        if (!this.isEnumValueValid(n, eEnum)) {
            this.addError("ERROR_DYNAMIC_CACHE_REPLICATION_TYPE_INVALID", new String[]{String.valueOf(n)}, dynamicCache);
        }
        this.validateLocal((Service)dynamicCache);
        this.traceEnd();
    }

    public void validateLocal(EJBCache eJBCache) {
        this.traceBegin("validateLocal(EJBCache)");
        this.testLongMin(eJBCache.getCleanupInterval(), 1L, "ERROR_EJB_CACHE_CLEANUP_INTERVAL_OUT_OF_RANGE", eJBCache);
        this.testLongMin(eJBCache.getCacheSize(), 1L, "ERROR_EJB_CACHE_CACHE_SIZE_OUT_OF_RANGE", eJBCache);
        this.traceEnd();
    }

    public void validateLocal(EJBContainer eJBContainer) {
        this.traceBegin("validateLocal(EJBContainer)");
        String string = eJBContainer.getPassivationDirectory();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_EJB_CONTAINER_PASSIVATION_DIRECTORY_REQUIRED", new String[]{eJBContainer.getName()}, eJBContainer);
        } else if (!this.testPath(string)) {
            this.addError("ERROR_EJB_CONTAINER_PASSIVATION_DIRECTORY_INVALID", new String[]{eJBContainer.getName()}, eJBContainer);
        }
        this.testLongMin(eJBContainer.getInactivePoolCleanupInterval(), 1L, "ERROR_EJB_CONTAINER_CLEANUP_INTERVAL_OUT_OF_RANGE", eJBContainer);
        super.validateAcross((ManagedObject)eJBContainer);
        this.traceEnd();
    }

    public void validateLocal(ExternalCacheGroup externalCacheGroup) {
        String string = externalCacheGroup.getName();
        this.traceBegin("validateLocal(ExternalCacheGroup)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_NAME_REQUIRED", externalCacheGroup);
        } else if (!this.testCacheGroupName(string)) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_NAME_INVALID", new String[]{string}, externalCacheGroup);
        }
        int n = externalCacheGroup.getType().getValue();
        ApplicationserverPackage applicationserverPackage = ApplicationserverPackage.eINSTANCE;
        EEnum eEnum = applicationserverPackage.getExternalCacheGroupKind();
        if (!this.isEnumValueValid(n, eEnum)) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_TYPE_INVALID", new String[]{string, String.valueOf(n)}, externalCacheGroup);
        }
        this.traceEnd();
    }

    public void validateLocal(ExternalCacheGroupMember externalCacheGroupMember) {
        String string = externalCacheGroupMember.getAddress();
        this.traceBegin("validateLocal(ExternalCacheGroupMember)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_MEMBER_ADDRESS_REQUIRED", externalCacheGroupMember);
        } else if (!this.testHostnamePort(string)) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_MEMBER_ADDRESS_INVALID", new String[]{string}, externalCacheGroupMember);
        }
        String string2 = externalCacheGroupMember.getAdapterBeanName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_MEMBER_ADAPTER_BEAN_NAME_REQUIRED", externalCacheGroupMember);
        } else if (!this.testJavaClass(string2)) {
            this.addError("ERROR_EXTERNAL_CACHE_GROUP_MEMBER_ADAPTER_BEAN_NAME_INVALID", new String[]{string2}, externalCacheGroupMember);
        }
        this.traceEnd();
    }

    public void validateLocal(HTTPTransport hTTPTransport) {
        this.traceBegin("validateLocal(HTTPTransport)");
        this.validateLocal((Transport)hTTPTransport);
        this.traceEnd();
    }

    public void validateLocal(InvalidationSchedule invalidationSchedule) {
        this.traceBegin("validateLocal(InvalidationSchedule)");
        this.testInteger(invalidationSchedule.getFirstHour(), 0, 23, "ERROR_INVALIDATION_SCHEDULE_FIRST_HOUR_OUT_OF_RANGE", invalidationSchedule);
        this.testInteger(invalidationSchedule.getSecondHour(), 0, 23, "ERROR_INVALIDATION_SCHEDULE_SECOND_HOUR_OUT_OF_RANGE", invalidationSchedule);
        this.traceEnd();
    }

    public void validateLocal(SessionManager sessionManager) {
        boolean bl;
        this.traceBegin("validateLocal(SessionManager)");
        int n = sessionManager.getSessionPersistenceMode().getValue();
        WebcontainerPackage webcontainerPackage = WebcontainerPackage.eINSTANCE;
        EEnum eEnum = webcontainerPackage.getSessionPersistenceKind();
        if (!this.isEnumValueValid(n, eEnum)) {
            this.addError("ERROR_SESSION_MANAGER_PERSISTENCE_MODE_INVALID", new String[]{String.valueOf(n)}, sessionManager);
        }
        if (bl = sessionManager.isAllowSerializedSessionAccess()) {
            this.testIntegerMin(sessionManager.getMaxWaitTime(), 0, "ERROR_SESSION_MANAGER_MAX_WAIT_TIME_INVALID", sessionManager);
        }
        this.validateLocal((Service)sessionManager);
        this.traceEnd();
    }

    public void validateLocal(SessionDatabasePersistence sessionDatabasePersistence) {
        WebcontainerPackage webcontainerPackage;
        EEnum eEnum;
        int n;
        String string;
        this.traceBegin("validateLocal(SessionDatabasePersistence)");
        String string2 = sessionDatabasePersistence.getDatasourceJNDIName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_SESSION_PERSISTENCE_DATASOURCE_NAME_REQUIRED", sessionDatabasePersistence);
        }
        if ((string = sessionDatabasePersistence.getUserId()) == null || string.length() == 0) {
            this.addError("ERROR_SESSION_PERSISTENCE_USER_ID_REQUIRED", sessionDatabasePersistence);
        }
        if (this.isEnumValueValid(n = sessionDatabasePersistence.getDb2RowSize().getValue(), eEnum = (webcontainerPackage = WebcontainerPackage.eINSTANCE).getDB2RowSizeEnum())) {
            String string3;
            if (n != 0 && ((string3 = sessionDatabasePersistence.getTableSpaceName()) == null || string3.length() == 0)) {
                this.addError("ERROR_SESSION_PERSISTENCE_TABLE_SPACE_NAME_REQUIRED", sessionDatabasePersistence);
            }
        } else {
            this.addError("ERROR_SESSION_PERSISTENCE_DB2_ROW_SIZE_INVALID", new String[]{String.valueOf(n)}, sessionDatabasePersistence);
        }
        this.traceEnd();
    }

    public void validateLocal(TraceLog traceLog) {
        String string = traceLog.getFileName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_TRACE_LOG_FILE_NAME_REQUIRED", traceLog);
        }
        this.testIntegerMin(traceLog.getRolloverSize(), 1, "ERROR_TRACE_LOG_ROLLOVER_SIZE_INVALID", traceLog);
        this.testIntegerMin(traceLog.getMaxNumberOfBackupFiles(), 1, "ERROR_TRACE_LOG_MAX_BACKUP_FILES_INVALID", traceLog);
    }

    protected void validateTraceLog(TraceService traceService, TraceLog traceLog, int n) {
        String string = traceLog.getFileName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_TRACE_SERVICE_TRACE_OUTPUT_FILENAME_INVALID", new String[]{Integer.toString(n)}, traceService);
        }
        if (traceLog.getRolloverSize() < 1) {
            this.addError("ERROR_TRACE_SERVICE_TRACE_OUTPUT_ROLLOVERSIZE_INVALID", new String[]{Integer.toString(n)}, traceService);
        }
        if (traceLog.getMaxNumberOfBackupFiles() < 1) {
            this.addError("ERROR_TRACE_SERVICE_TRACE_OUTPUT_MAXBACKUPFILES_INVALID", new String[]{Integer.toString(n)}, traceService);
        }
    }

    public void validateLocal(TraceService traceService) {
        this.traceBegin("validateLocal(TraceService)");
        if (traceService.isEnable()) {
            TraceLog traceLog;
            String string = traceService.getStartupTraceSpecification();
            if (string != null && string.length() > 0 && !this.testTraceSpecification(string)) {
                this.addError("ERROR_TRACE_SERVICE_CONFIG_TRACE_SPECIFICATION_INVALID", new String[]{string}, traceService);
            }
            TraceservicePackage traceservicePackage = TraceservicePackage.eINSTANCE;
            EEnum eEnum = traceservicePackage.getTraceFormatKind();
            int n = traceService.getTraceFormat().getValue();
            if (!this.isEnumValueValid(n, eEnum)) {
                this.addError("ERROR_TRACE_SERVICE_TRACE_FORMAT_INVALID", new String[]{String.valueOf(n)}, traceService);
            }
            eEnum = traceservicePackage.getTraceOutputKind();
            int n2 = traceService.getTraceOutputType().getValue();
            if (!this.isEnumValueValid(n2, eEnum)) {
                this.addError("ERROR_TRACE_SERVICE_TRACE_OUTPUT_TYPE_INVALID", new String[]{String.valueOf(n2)}, traceService);
            } else if (n2 == 0) {
                this.testIntegerMin(traceService.getMemoryBufferSize(), 1, "ERROR_TRACE_SERVICE_MEMORY_BUFFER_SIZE_INVALID", traceService);
            } else if (n2 == 1 && (traceLog = traceService.getTraceLog()) != null) {
                this.validateTraceLog(traceService, traceLog, n2);
            }
        }
        this.validateLocal((Service)traceService);
        this.traceEnd();
    }

    public void validateLocal(RASLoggingService rASLoggingService) {
        RasPackage rasPackage;
        EEnum eEnum;
        boolean bl = rASLoggingService.isEnableCorrelationId();
        int n = rASLoggingService.getMessageFilterLevel().getValue();
        if (!this.isEnumValueValid(n, eEnum = (rasPackage = RasPackage.eINSTANCE).getMessageFilterLevelKind())) {
            this.addError("ERROR_RAS_LOGGING_SERVICE_MESSAGE_FILTER_LEVEL_INVALID", new String[]{String.valueOf(n)}, rASLoggingService);
        }
        this.validateLocal((Service)rASLoggingService);
    }

    public void validateLocal(ServiceLog serviceLog) {
        if (serviceLog.isEnabled()) {
            String string = serviceLog.getName();
            if (string == null || string.length() == 0) {
                this.addError("ERROR_SERVICE_LOG_NAME_REQUIRED", serviceLog);
            }
            this.testIntegerMin(serviceLog.getSize(), 1, "ERROR_SERVICE_LOG_SIZE_INVALID", serviceLog);
        }
    }

    public void validateLocal(TransactionService transactionService) {
        this.traceBegin("validateLocal(TransactionService)");
        String string = transactionService.getTransactionLogDirectory();
        this.validateTransactionServiceLogDirectory(string);
        this.traceStub("Validation of transaction service lifetime timeout (partial).");
        this.testIntegerMin(transactionService.getTotalTranLifetimeTimeout(), -1, "ERROR_TRANSACTION_SERVICE_LIFETIME_TIMEOUT_OUT_OF_RANGE", transactionService);
        this.traceStub("Validation of transaction service inactivity timeout (partial).");
        this.testIntegerMin(transactionService.getClientInactivityTimeout(), -1, "ERROR_TRANSACTION_SERVICE_INACTIVITY_TIMEOUT_OUT_OF_RANGE", transactionService);
        this.validateLocal((Service)transactionService);
        this.traceEnd();
    }

    public void validateTransactionServiceLogDirectory(String string) {
        this.traceStub("Validation of transaction service log directory: ", string);
    }

    public void validateLocal(TuningParams tuningParams) {
        int n;
        this.traceBegin("validateLocal(TuningParams)");
        this.testIntegerMin(tuningParams.getMaxInMemorySessionCount(), 0, "ERROR_TUNING_PARAMS_SESSION_COUNT_OUT_OF_RANGE", tuningParams);
        int n2 = tuningParams.getWriteFrequency().getValue();
        WebcontainerPackage webcontainerPackage = WebcontainerPackage.eINSTANCE;
        EEnum eEnum = webcontainerPackage.getWriteFrequencyEnum();
        boolean bl = this.isEnumValueValid(n2, eEnum);
        if (!bl) {
            this.addError("ERROR_TUNING_PARAMS_WRITE_FREQUENCY_INVALID", new String[]{String.valueOf(n2)}, tuningParams);
        }
        int n3 = tuningParams.getWriteInterval();
        boolean bl2 = this.testInteger(n3, 5, 9999, "ERROR_TUNING_PARAMS_WRITE_INTERVAL_OUT_OF_RANGE", tuningParams);
        int n4 = tuningParams.getWriteContents().getValue();
        if (!this.isEnumValueValid(n4, eEnum = webcontainerPackage.getWriteContentsEnum())) {
            this.addError("ERROR_TUNING_PARAMS_WRITE_CONTENTS_INVALID", new String[]{String.valueOf(n4)}, tuningParams);
        }
        if ((n = tuningParams.getInvalidationTimeout()) < -1 || n == 0) {
            this.addError("ERROR_TUNING_PARAMS_INVALIDATION_TIMEOUT_OUT_OF_RANGE", new String[]{String.valueOf(n), Integer.toString(-1), Integer.toString(0)}, tuningParams);
        } else if (bl && n2 == 3 && bl2 && n < 2 * n3) {
            this.addWarning("WARNING_TUNING_PARAMS_INTERVAL_TIMEOUT_MISMATCH", new String[]{String.valueOf(n), String.valueOf(n3)}, tuningParams);
        }
        this.traceEnd();
    }

    public void validateLocal(WebContainer webContainer) {
        this.traceBegin("validateLocal(WebContainer)");
        super.validateLocal((ManagedObject)webContainer);
        this.traceEnd();
    }

    public void validateLocal(CustomService customService) {
        String string;
        String string2 = customService.getDisplayName();
        this.traceBegin("validateLocal(CustomService)", string2);
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_CUSTOM_SERVICE_DISPLAYNAME_REQUIRED", customService);
        }
        if ((string = customService.getClassname()) == null || string.length() == 0) {
            this.addError("ERROR_CUSTOM_SERVICE_CLASSNAME_REQUIRED", new String[]{string2}, customService);
        } else if (!this.testJavaClass(string)) {
            this.addError("ERROR_CUSTOM_SERVICE_CLASSNAME_INVALID", new String[]{string2, string}, customService);
        }
        this.validateLocal((Service)customService);
        this.traceEnd();
    }

    public void validateLocal(JavaProcessDef javaProcessDef) {
        String string;
        this.traceBegin("validateLocal(JavaProcessDef)");
        int n = javaProcessDef.getExecutableTargetKind().getValue();
        ProcessexecPackage processexecPackage = ProcessexecPackage.eINSTANCE;
        EEnum eEnum = processexecPackage.getExecutableTargetKind();
        boolean bl = this.isEnumValueValid(n, eEnum);
        if (!bl) {
            this.addError("ERROR_INVALID_EXECUTABLE_TARGET_KIND", new String[]{String.valueOf(n)}, javaProcessDef);
        }
        if ((string = javaProcessDef.getExecutableTarget()) != null && string.length() != 0 && bl) {
            if (n == 0) {
                if (!this.testJavaClass(string)) {
                    this.addError("ERROR_EXECUTABLE_TARGET_INVALID_AS_CLASS", new String[]{String.valueOf(string)}, javaProcessDef);
                }
            } else if (n == 1 && !this.testJarPath(string)) {
                this.addError("ERROR_EXECUTABLE_TARGET_INVALID_AS_JAR", new String[]{String.valueOf(string)}, javaProcessDef);
            }
        }
        this.validateLocal((ProcessDef)javaProcessDef);
        this.traceEnd();
    }

    public void validateLocal(JavaVirtualMachine javaVirtualMachine) {
        String string;
        Object object;
        this.traceBegin("validateLocal(JavaVirtualMachine)");
        int n = javaVirtualMachine.getInitialHeapSize();
        int n2 = javaVirtualMachine.getMaximumHeapSize();
        if (n2 > 0 && n2 < n) {
            this.addError("ERROR_JVM_MAXIMUM_HEAP_SIZE_BELOW_MINIMUM", new String[]{String.valueOf(n), String.valueOf(n2)}, javaVirtualMachine);
        }
        if (javaVirtualMachine.isRunHProf() && (object = javaVirtualMachine.getHprofArguments()) != null && !this.testJVMHProfArguments((String)object)) {
            this.addError("ERROR_JVM_HPROF_ARGUMENTS_INVALID", new String[]{object}, javaVirtualMachine);
        }
        if (javaVirtualMachine.isDebugMode() && (object = javaVirtualMachine.getDebugArgs()) != null && !this.testJVMDebugArgs((String)object)) {
            this.addError("ERROR_JVM_DEBUG_ARGUMENTS_INVALID", new String[]{object}, javaVirtualMachine);
        }
        object = javaVirtualMachine.getSystemProperties().iterator();
        String string2 = null;
        while (string2 == null && object.hasNext()) {
            string = (Property)object.next();
            String string3 = string.getName();
            if (string3 == null || !string3.equals("HotSpotOption")) continue;
            string2 = string;
        }
        if (string2 != null) {
            string = string2.getValue();
            if (string != null) {
                if (!(string.equals("client") || string.equals("server") || string.equals("none"))) {
                    this.addError("ERROR_JVM_HOTSPOTOPTION_VALUE_INVALID", new String[]{string}, javaVirtualMachine);
                }
            } else {
                this.addError("ERROR_JVM_HOTSPOTOPTION_PROPERTY_VALUE_REQUIRED", javaVirtualMachine);
            }
        }
        this.traceEnd();
    }

    public void validateLocal(OutputRedirect outputRedirect) {
        String string;
        this.traceBegin("validateLocal(OutputRedirect)");
        String string2 = outputRedirect.getStdoutFilename();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_OUTPUT_REDIRECT_STDOUT_FILENAME_REQUIRED", outputRedirect);
        }
        if ((string = outputRedirect.getStderrFilename()) == null || string.length() == 0) {
            this.addError("ERROR_OUTPUT_REDIRECT_STDERR_FILENAME_REQUIRED", outputRedirect);
        }
        this.traceEnd();
    }

    public void validateLocal(MonitoringPolicy monitoringPolicy) {
        this.traceBegin("validateLocal(MonitoringPolicy)");
        this.traceBegin("validateLocal(MonitoringPolicy)");
        this.traceEnd();
    }

    public void validateLocal(ProcessDef processDef) {
        String string = processDef.getExecutableName();
        this.traceBegin("validateLocal(ProcessDef)", string);
        String string2 = processDef.getWorkingDirectory();
        if (!(string2 == null && string2.length() <= 0 || this.testPath(string2))) {
            this.addError("ERROR_PROCESS_DEF_WORKING_DIRECTORY_INVALID", new String[]{string2}, processDef);
        }
        this.traceEnd();
    }

    public void validateLocal(ProcessExecution processExecution) {
        this.traceBegin("validateLocal(ProcessExecution)");
        this.testIntegerMin(processExecution.getProcessPriority(), 0, "ERROR_PROCESS_EXECUTION_PROCESS_PRIORITY_OUT_OF_RANGE", processExecution);
        String string = processExecution.getUmask();
        if (string != null && string.length() != 0) {
            int n = string.length();
            if (n != 3) {
                this.addError("ERROR_PROCESS_EXECUTION_UMASK_BAD_LENGTH", new String[]{string}, processExecution);
            }
            boolean bl = true;
            while (bl && n > 0) {
                char c;
                bl = Character.isDigit(c = string.charAt(--n)) && c != '8' && c != '9';
            }
            if (!bl) {
                this.addError("ERROR_PROCESS_EXECUTION_UMASK_NOT_OCTAL", new String[]{string}, processExecution);
            }
        }
        this.traceEnd();
    }

    public void validateLocal(Agent agent) {
        this.traceBegin("validateLocal(Agent)");
        this.traceStub("validateLocal(Agent)");
        this.validateLocal((ServerComponent)agent);
        this.traceEnd();
    }

    public void validateLocal(Component component2) {
        this.traceBegin("validateLocal(Component)");
        this.validateLocal((ServiceContext)component2);
        this.traceEnd();
    }

    public void validateLocal(Service service) {
        this.traceBegin("validateLocal(Service)");
        this.traceEnd();
    }

    protected boolean isEnabled(Service service) {
        return service.isEnable();
    }

    public void validateLocal(ServiceContext serviceContext) {
        this.traceBegin("validateLocal(ServiceContext)");
        this.validateLocal((ManagedObject)serviceContext);
        this.traceStub("validateLocal(ServiceContext)");
        this.traceEnd();
    }

    public void validateLocal(Extension extension2) {
        this.traceBegin("validateLocal(Extension)");
        this.traceStub("validateLocal(Extension)");
        this.traceEnd();
    }

    public void validateLocal(ServerComponent serverComponent) {
        this.traceBegin("validateLocal(ServerComponent)");
        this.traceStub("validateLocal(ServerComponent)");
        this.validateLocal((Component)serverComponent);
        this.traceEnd();
    }

    public void validateLocal(StatisticsProvider statisticsProvider) {
        this.traceBegin("validateLocal(StatisticsProvider)");
        this.traceStub("validateLocal(StatisticsProvider)");
        this.traceEnd();
    }

    public void validateLocal(WebServer webServer) {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        String string5 = webServer.getName();
        this.traceBegin("validateLocal(WebServer)", string5);
        WebserverPackage webserverPackage = WebserverPackage.eINSTANCE;
        EEnum eEnum = webserverPackage.getWebserverProtocolKind();
        int n2 = webServer.getWebserverProtocol().getValue();
        if (!this.isEnumValueValid(n2, eEnum)) {
            this.addError("ERROR_WEBSERVER_PROTOCOL_INVALID", new String[]{string5}, webServer);
        }
        if (!this.isEnumValueValid(n2 = webServer.getWebserverAdminProtocol().getValue(), eEnum)) {
            this.addError("ERROR_WEBSERVER_ADMIN_PROTOCOL_INVALID", new String[]{string5}, webServer);
        }
        if (!this.isEnumValueValid(n = webServer.getWebserverType().getValue(), eEnum = webserverPackage.getWebserverTypeKind())) {
            this.addError("ERROR_WEBSERVER_TYPE_INVALID", new String[]{string5}, webServer);
        }
        if ((string4 = webServer.getWebserverInstallRoot()) != null && string4.length() > 0 && !this.testPath(string4)) {
            this.addError("ERROR_WEBSERVER_INSTALLROOT_INVALID", new String[]{string4, string5}, webServer);
        }
        if ((string3 = webServer.getConfigurationFilename()) != null && string3.length() > 0 && !this.testFile(string3)) {
            this.addError("ERROR_WEBSERVER_CONFIGFILE_INVALID", new String[]{string3, string5}, webServer);
        }
        if ((string2 = webServer.getLogFilenameAccess()) != null && string2.length() > 0 && !this.testFile(string2)) {
            this.addError("ERROR_WEBSERVER_ACCESSLOG_INVALID", new String[]{string2, string5}, webServer);
        }
        if ((string = webServer.getLogFilenameError()) != null && string.length() > 0 && !this.testFile(string)) {
            this.addError("ERROR_WEBSERVER_ERRORLOG_INVALID", new String[]{string, string5}, webServer);
        }
        this.validateLocal((ServerComponent)webServer);
        this.traceEnd();
    }

    public void validateLocal(StreamRedirect streamRedirect) {
    }

    public void validateLocal(Server server2) {
        String string = server2.getName();
        this.traceBegin("validateLocal(Server)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SERVER_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, server2);
        } else if (!this.testServerName(string)) {
            this.addError("ERROR_SERVER_NAME_INVALID", new String[]{this.getCurrentFileName(), string}, server2);
        }
        this.validateLocal((ServiceContext)server2);
        this.traceEnd();
    }

    public void validateLocal(TypedProperty typedProperty) throws ValidationException {
        String string = typedProperty.getType();
        this.traceBegin("validateLocal(TypedProperty)", typedProperty.getName());
        if (string == null || string.length() == 0) {
            this.addError("ERROR_PROPERTY_TYPE_REQUIRED", new String[]{typedProperty.getName()}, typedProperty);
        }
        super.basicValidate(typedProperty);
        this.traceEnd();
    }

    public void validateWebContainerTransportDuplication(WebContainer webContainer) {
        EList eList = webContainer.getTransports();
        Iterator iterator = eList.iterator();
        Hashtable<String, Transport> hashtable = new Hashtable<String, Transport>();
        Hashtable<String, Transport> hashtable2 = new Hashtable<String, Transport>();
        while (iterator.hasNext()) {
            String string;
            Transport transport2 = (Transport)iterator.next();
            EndPoint endPoint = transport2.getAddress();
            if (endPoint == null || (string = endPoint.getHost()) == null || string.length() == 0) continue;
            int n = endPoint.getPort();
            String string2 = Integer.toString(n);
            String string3 = string + ":" + string2;
            Transport transport3 = hashtable.put(string3, transport2);
            if (transport3 == null || hashtable2.put(string3, transport2) != null) continue;
            this.addError("ERROR_WEB_CONTAINER_TRANSPORT_DUPLICATION", new String[]{webContainer.getName(), string, string2}, transport2);
        }
    }

    public boolean testJVMDebugArgs(String string) {
        this.traceStub("Syntax test of JVM debug arguments: ", string);
        return true;
    }

    public boolean testJVMHProfArguments(String string) {
        this.traceStub("Syntax test of JVM heap profile arguments: ", string);
        return true;
    }

    public boolean testVariableMapSymbolicName(String string) {
        this.traceStub("Syntax test of path map symbolic name: ", string);
        return true;
    }

    public boolean testServerName(String string) {
        this.traceStub("Syntax test of server name: ", string);
        return true;
    }

    public boolean testCacheGroupName(String string) {
        this.traceStub("Syntax test of cache group name: ", string);
        return true;
    }

    protected boolean testHostname(String string) {
        this.traceStub("Syntax test of host name: ", string);
        return true;
    }

    public boolean testHostnamePort(String string) {
        this.traceStub("Syntax test of host name plus optional port: ", string);
        return true;
    }

    protected boolean testTCPIPDomainName(String string) {
        this.traceStub("Syntax test of TCP/IP domain name: ", string);
        return true;
    }

    protected boolean testTraceFile(String string) {
        this.traceStub("Syntax test of trace file", string);
        return true;
    }

    protected boolean testTraceSpecification(String string) {
        this.traceStub("Syntax test of trace specification", string);
        return true;
    }

    protected boolean testWebPath(String string) {
        this.traceStub("Syntax test of web path: ", string);
        return true;
    }

    public boolean testPerformanceSpecification(String string) {
        this.traceStub("Syntax test of performance specification: ", string);
        return true;
    }
}

