/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level602;

import com.ibm.websphere.models.config.proxy.GenericServerCluster;
import com.ibm.websphere.models.config.proxy.GenericServerEndpoint;
import com.ibm.websphere.models.config.proxy.RemoteCellOverrides;
import com.ibm.websphere.models.config.proxy.URIGroup;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level602.ProxyEnvironmentValidationConstants_602;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class ProxyEnvironmentValidator_602
extends WebSphereLevelValidator
implements ProxyEnvironmentValidationConstants_602 {
    public static final String pgmVersion = "1.3";
    public static final String pgmUpdate = "4/18/05";
    protected boolean _pastTopList = false;

    public ProxyEnvironmentValidator_602(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level602.proxyenvironmentvalidation_602_NLS";
    }

    public String getTraceName() {
        return "ProxyEnvironmentValidator";
    }

    protected void visitList(List list) throws ValidationException {
        boolean bl;
        if (!this._pastTopList) {
            bl = true;
            this._pastTopList = true;
        } else {
            bl = false;
        }
        super.visitList(list);
        if (bl) {
            // empty if block
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof GenericServerCluster) {
            this.trace("Object recognized as a GenericServerCluster; validating");
            this.validateLocal((GenericServerCluster)object);
            this.validateAcross((GenericServerCluster)object);
        } else if (object instanceof RemoteCellOverrides) {
            this.trace("Object recognized as a RemoteCellOverrides; validating");
            this.validateLocal((RemoteCellOverrides)object);
            this.validateAcross((RemoteCellOverrides)object);
        } else if (object instanceof URIGroup) {
            this.trace("Object recognized as a URIGroup; validating");
            this.validateLocal((URIGroup)object);
            this.validateAcross((URIGroup)object);
        } else if (object instanceof GenericServerEndpoint) {
            this.trace("Object recognized as a GenericServerEndpoint; validating");
            this.validateLocal((GenericServerEndpoint)object);
            this.validateAcross((GenericServerEndpoint)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(GenericServerCluster genericServerCluster) {
        this.traceStub("validateAcross(GenericServerCluster)");
    }

    public void validateAcross(RemoteCellOverrides remoteCellOverrides) {
        this.traceStub("validateAcross(RemoteCellOverrides)");
    }

    public void validateAcross(URIGroup uRIGroup) {
        EList eList = uRIGroup.getURIPattern();
        if (eList.size() == 0) {
            this.addError("ERROR_URI_GROUP_NO_PATTERNS", new String[]{uRIGroup.getName()}, uRIGroup);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.validatePattern(uRIGroup, string);
        }
    }

    public void validateAcross(GenericServerEndpoint genericServerEndpoint) {
        this.traceStub("validateAcross(GenericServerEndpoint)");
    }

    protected boolean validatePattern(URIGroup uRIGroup, String string) {
        boolean bl;
        this.traceBegin("validatePattern", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_PATTERN_EMPTY", new String[]{uRIGroup.getName()}, uRIGroup);
            bl = false;
        } else {
            bl = true;
        }
        this.traceEnd(bl);
        return bl;
    }

    public void validateLocal(GenericServerCluster genericServerCluster) {
        EList eList;
        String string = genericServerCluster.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_GENERIC_CONTENT_SERVER_GROUP_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, genericServerCluster);
        }
        if ((eList = genericServerCluster.getGenericServerEndpoints()) == null || eList.size() == 0) {
            this.addError("ERROR_GENERIC_SERVER_CLUSTER_EMPTY", new String[]{string}, genericServerCluster);
        }
    }

    public void validateLocal(RemoteCellOverrides remoteCellOverrides) {
        String string = remoteCellOverrides.getPeerAccessPointName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_PEER_ACCESS_POINT_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, remoteCellOverrides);
        }
    }

    public void validateLocal(URIGroup uRIGroup) {
        String string = uRIGroup.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_URI_GROUP_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, uRIGroup);
        }
    }

    public void validateLocal(GenericServerEndpoint genericServerEndpoint) {
        String string = genericServerEndpoint.getHost();
        if (string == null || string.length() == 0 || string.trim().equals("")) {
            this.addError("ERROR_CONTENT_SERVER_ENDPOINT_HOSTNAME_REQUIRED", new String[]{this.getCurrentFileName()}, genericServerEndpoint);
        }
        int n = genericServerEndpoint.getPort();
        this.testIntegerMin(n, 0, "ERROR_CONTENT_SERVER_ENDPOINT_PORT_OUT_OF_RANGE", genericServerEndpoint);
        int n2 = genericServerEndpoint.getWeight();
        this.testIntegerMin(n2, 0, "ERROR_CONTENT_SERVER_ENDPOINT_WEIGHT_TOO_LOW", genericServerEndpoint);
        this.testIntegerMax(n2, 20, "ERROR_CONTENT_SERVER_ENDPOINT_WEIGHT_TOO_HIGH", genericServerEndpoint);
    }

    protected void validateGenericServerClusters(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((GenericServerCluster)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_GENERIC_CONTENT_SERVER_GROUP_NAME_DUPLICATION";
            }
        };
        duplicationTester.test(list, false, this, null);
    }

    protected void validateRemoteCellOverridess(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((RemoteCellOverrides)eObject).getPeerAccessPointName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_WEBSPHERE_CONTENT_SERVER_GROUP_NAME_DUPLICATION";
            }
        };
        duplicationTester.test(list, false, this, null);
    }

    protected void validateURIGroups(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((URIGroup)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_URI_GROUP_NAME_DUPLICATION";
            }
        };
        duplicationTester.test(list, false, this, null);
    }
}

