/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level602;

import com.ibm.websphere.models.config.proxy.CellRoute;
import com.ibm.websphere.models.config.proxy.FailRoute;
import com.ibm.websphere.models.config.proxy.GenericClusterRoute;
import com.ibm.websphere.models.config.proxy.LocalRoute;
import com.ibm.websphere.models.config.proxy.PluginConfigPolicy;
import com.ibm.websphere.models.config.proxy.ProxySettings;
import com.ibm.websphere.models.config.proxy.RedirectRoute;
import com.ibm.websphere.models.config.proxy.Route;
import com.ibm.websphere.models.config.proxy.RoutingPolicy;
import com.ibm.websphere.models.config.proxy.RoutingRule;
import com.ibm.websphere.models.config.proxy.StaticCachePolicy;
import com.ibm.websphere.models.config.proxy.StaticCacheRule;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level602.ProxySettingsValidationConstants_602;
import java.util.List;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class ProxySettingsValidator_602
extends WebSphereLevelValidator
implements ProxySettingsValidationConstants_602 {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "4/18/05";
    protected boolean _pastTopList = false;

    public ProxySettingsValidator_602(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level602.proxysettingsvalidation_602_NLS";
    }

    public String getTraceName() {
        return "ProxySettingsValidator";
    }

    protected void visitList(List list) throws ValidationException {
        boolean bl;
        if (!this._pastTopList) {
            bl = true;
            this._pastTopList = true;
        } else {
            bl = false;
        }
        super.visitList(list);
        if (bl) {
            // empty if block
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ProxySettings) {
            this.trace("Object recognized as a ProxySettings; validating");
            this.validateLocal((ProxySettings)object);
            this.validateAcross((ProxySettings)object);
        } else if (object instanceof PluginConfigPolicy) {
            this.trace("Object recognized as a PluginConfigPolicy; validating");
            this.validateLocal((PluginConfigPolicy)object);
            this.validateAcross((PluginConfigPolicy)object);
        } else if (object instanceof RoutingPolicy) {
            this.trace("Object recognized as a RoutingPolicy; validating");
            this.validateLocal((RoutingPolicy)object);
            this.validateAcross((RoutingPolicy)object);
        } else if (object instanceof RoutingRule) {
            this.trace("Object recognized as a RoutingRule; validating");
            this.validateLocal((RoutingRule)object);
            this.validateAcross((RoutingRule)object);
        } else if (object instanceof CellRoute) {
            this.trace("Object recognized as a CellRoute; validating");
            this.validateLocal((CellRoute)object);
            this.validateAcross((CellRoute)object);
        } else if (object instanceof GenericClusterRoute) {
            this.trace("Object recognized as a GenericClusterRoute; validating");
            this.validateLocal((GenericClusterRoute)object);
            this.validateAcross((GenericClusterRoute)object);
        } else if (object instanceof RedirectRoute) {
            this.trace("Object recognized as a RedirectRoute; validating");
            this.validateLocal((RedirectRoute)object);
            this.validateAcross((RedirectRoute)object);
        } else if (object instanceof FailRoute) {
            this.trace("Object recognized as a FailRoute; validating");
            this.validateLocal((FailRoute)object);
            this.validateAcross((FailRoute)object);
        } else if (object instanceof LocalRoute) {
            this.trace("Object recognized as a LocalRoute; validating");
            this.validateLocal((LocalRoute)object);
            this.validateAcross((LocalRoute)object);
        } else if (object instanceof StaticCachePolicy) {
            this.trace("Object recognized as a StaticCachePolicy; validating");
            this.validateLocal((StaticCachePolicy)object);
            this.validateAcross((StaticCachePolicy)object);
        } else if (object instanceof StaticCacheRule) {
            this.trace("Object recognized as a StaticCacheRule; validating");
            this.validateLocal((StaticCacheRule)object);
            this.validateAcross((StaticCacheRule)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(ProxySettings proxySettings) {
        this.traceStub("validateAcross(ProxySettings)");
    }

    public void validateAcross(PluginConfigPolicy pluginConfigPolicy) {
        this.traceStub("validateAcross(PluginConfigPolicy)");
    }

    public void validateAcross(RoutingPolicy routingPolicy) {
        this.traceStub("validateAcross(RoutingPolicy)");
    }

    public void validateAcross(RoutingRule routingRule) {
        this.traceStub("validateAcross(RoutingRule)");
    }

    public void validateAcross(CellRoute cellRoute) {
        this.traceStub("validateAcross(CellRoute)");
    }

    public void validateAcross(GenericClusterRoute genericClusterRoute) {
        this.traceStub("validateAcross(GenericClusterRoute)");
    }

    public void validateAcross(RedirectRoute redirectRoute) {
        this.traceStub("validateAcross(RedirectRoute)");
    }

    public void validateAcross(FailRoute failRoute) {
        this.traceStub("validateAcross(FailRoute)");
    }

    public void validateAcross(LocalRoute localRoute) {
        this.traceStub("validateAcross(LocalRoute)");
    }

    public void validateAcross(StaticCachePolicy staticCachePolicy) {
        this.traceStub("validateAcross(StaticCachePolicy)");
    }

    public void validateAcross(StaticCacheRule staticCacheRule) {
        this.traceStub("validateAcross(StaticCacheRule)");
    }

    public void validateLocal(ProxySettings proxySettings) {
        this.traceStub("validateLocal(ProxySettings)");
    }

    public void validateLocal(PluginConfigPolicy pluginConfigPolicy) {
        this.traceStub("validateLocal(PluginConfigPolicy)");
    }

    public void validateLocal(RoutingPolicy routingPolicy) {
        this.traceStub("validateLocal(RoutingPolicy)");
    }

    public void validateLocal(RoutingRule routingRule) {
        Route route;
        String string = routingRule.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_ROUTING_RULE_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, routingRule);
        }
        if ((route = routingRule.getRoutingAction()) == null) {
            this.addError("ERROR_ROUTE_ACTION_REQUIRED", new String[]{routingRule.getName()}, routingRule);
        }
    }

    public void validateLocal(CellRoute cellRoute) {
        String string = cellRoute.getPeerAccessPointName();
        if (string == null || string.length() == 0 || string.trim().equals("")) {
            this.addError("ERROR_CELL_ROUTE_ACTION_CONTENT_SERVER_GROUP_REQUIRED", new String[]{this.getCurrentFileName()}, cellRoute);
        }
    }

    public void validateLocal(GenericClusterRoute genericClusterRoute) {
        String string = genericClusterRoute.getGenericServerClusterName();
        if (string == null || string.length() == 0 || string.trim().equals("")) {
            this.addError("ERROR_GENERIC_CLUSTER_ROUTE_ACTION_CONTENT_SERVER_GROUP_REQUIRED", new String[]{this.getCurrentFileName()}, genericClusterRoute);
        }
    }

    public void validateLocal(RedirectRoute redirectRoute) {
        String string = redirectRoute.getRedirectURL();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_REDIRECT_ROUTE_ACTION_URL_REQUIRED", new String[]{this.getCurrentFileName()}, redirectRoute);
        }
    }

    public void validateLocal(FailRoute failRoute) {
        int n = failRoute.getFailStatusCode();
        this.traceStub("validateLocal(FailRoute)");
    }

    public void validateLocal(LocalRoute localRoute) {
        this.traceStub("validateLocal(LocalRoute)");
    }

    public void validateLocal(StaticCachePolicy staticCachePolicy) {
        this.traceStub("validateLocal(StaticCachePolicy)");
    }

    public void validateLocal(StaticCacheRule staticCacheRule) {
        String string = staticCacheRule.getUriGroup();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_STATIC_CACHE_RULE_URI_GROUP_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, staticCacheRule);
        }
    }
}

