/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level70;

import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoadingMode;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level70.DeploymentValidationConstants_70;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class DeploymentValidator_70
extends WebSphereLevelValidator
implements DeploymentValidationConstants_70 {
    public static final String pgmVersion = "1.2";
    public static final String pgmUpdate = "9/23/05";

    public DeploymentValidator_70(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level70.deploymentvalidation_70_NLS";
    }

    public String getTraceName() {
        return "DeploymentValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ApplicationDeployment) {
            this.trace("Object recognized as a ApplicationDeployment; validating");
            this.validateLocal((ApplicationDeployment)object);
            this.validateAcross((ApplicationDeployment)object);
        } else if (object instanceof WebModuleDeployment) {
            this.trace("Object recognized as a WebModuleDeployment; validating");
            this.validateLocal((WebModuleDeployment)object);
            this.validateAcross((WebModuleDeployment)object);
        } else if (object instanceof EJBModuleDeployment) {
            this.trace("Object recognized as a EJBModuleDeployment; validating");
            this.validateLocal((EJBModuleDeployment)object);
            this.validateAcross((EJBModuleDeployment)object);
        } else if (object instanceof ConnectorModuleDeployment) {
            this.trace("Object recognized as a ConnectorModuleDeployment; validating");
            this.validateLocal((ConnectorModuleDeployment)object);
            this.validateAcross((ConnectorModuleDeployment)object);
        }
        return bl;
    }

    public void validateAcross(ApplicationDeployment applicationDeployment) {
    }

    public void validateLocal(ApplicationDeployment applicationDeployment) {
        String string;
        String string2 = applicationDeployment.getBinariesURL();
        if (string2.indexOf(string = "\\") != -1) {
            this.addWarning("WARNING_APPDEP_BINARIESURL_INVALID_CHAR", new String[]{string}, applicationDeployment);
        }
    }

    public void validateAcross(WebModuleDeployment webModuleDeployment) {
        ClassLoadingMode classLoadingMode;
        ClassLoadingMode classLoadingMode2 = webModuleDeployment.getClassloaderMode();
        Classloader classloader = webModuleDeployment.getClassloader();
        if (classloader != null && (classLoadingMode = classloader.getMode()).getValue() != classLoadingMode2.getValue()) {
            this.addWarning("WARNING_WEBMODULEDEP_INCONSISTENT_CLMODE", new String[]{this.getCLModeString(classLoadingMode), this.getCLModeString(classLoadingMode2), webModuleDeployment.getUri()}, webModuleDeployment);
        }
    }

    private String getCLModeString(ClassLoadingMode classLoadingMode) {
        return classLoadingMode.getValue() == 0 ? "PARENT-FIRST" : "PARENT-LAST";
    }

    public void validateLocal(WebModuleDeployment webModuleDeployment) {
    }

    public void validateAcross(EJBModuleDeployment eJBModuleDeployment) {
    }

    public void validateLocal(EJBModuleDeployment eJBModuleDeployment) {
        if (eJBModuleDeployment.getClassloader() != null) {
            this.addInfo("WARNING_NONWEBMODULEDEP_CL_UNSUPPORTED", new String[]{eJBModuleDeployment.getUri()}, eJBModuleDeployment);
        }
    }

    public void validateAcross(ConnectorModuleDeployment connectorModuleDeployment) {
    }

    public void validateLocal(ConnectorModuleDeployment connectorModuleDeployment) {
        if (connectorModuleDeployment.getClassloader() != null) {
            this.addInfo("WARNING_NONWEBMODULEDEP_CL_UNSUPPORTED", new String[]{connectorModuleDeployment.getUri()}, connectorModuleDeployment);
        }
    }
}

